/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class UnresolvedReferenceBinding
extends ReferenceBinding {
    ReferenceBinding resolvedType;
    TypeBinding[] wrappers;
    UnresolvedReferenceBinding prototype;

    UnresolvedReferenceBinding(char[][] cArray, PackageBinding packageBinding) {
        this.compoundName = cArray;
        this.sourceName = cArray[cArray.length - 1];
        this.fPackage = packageBinding;
        this.wrappers = null;
        this.prototype = this;
        this.computeId();
    }

    public UnresolvedReferenceBinding(UnresolvedReferenceBinding unresolvedReferenceBinding) {
        super(unresolvedReferenceBinding);
        this.resolvedType = unresolvedReferenceBinding.resolvedType;
        this.wrappers = null;
        this.prototype = unresolvedReferenceBinding.prototype;
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        if (this.resolvedType != null) {
            return this.resolvedType.clone(typeBinding);
        }
        UnresolvedReferenceBinding unresolvedReferenceBinding = new UnresolvedReferenceBinding(this);
        this.addWrapper(unresolvedReferenceBinding, null);
        return unresolvedReferenceBinding;
    }

    void addWrapper(TypeBinding typeBinding, LookupEnvironment lookupEnvironment) {
        if (this.resolvedType != null) {
            typeBinding.swapUnresolved(this, this.resolvedType, lookupEnvironment);
            return;
        }
        if (this.wrappers == null) {
            this.wrappers = new TypeBinding[]{typeBinding};
        } else {
            int n = this.wrappers.length;
            this.wrappers = new TypeBinding[n + 1];
            System.arraycopy(this.wrappers, 0, this.wrappers, 0, n);
            this.wrappers[n] = typeBinding;
        }
    }

    @Override
    public boolean isUnresolvedType() {
        return true;
    }

    @Override
    public String debugName() {
        return this.toString();
    }

    @Override
    public int depth() {
        int n = this.compoundName.length - 1;
        return CharOperation.occurencesOf('$', this.compoundName[n], 1);
    }

    @Override
    public boolean hasTypeBit(int n) {
        return false;
    }

    @Override
    public TypeBinding prototype() {
        return this.prototype;
    }

    ReferenceBinding resolve(LookupEnvironment lookupEnvironment, boolean bl) {
        if (this != this.prototype) {
            ReferenceBinding referenceBinding = this.prototype.resolve(lookupEnvironment, bl);
            referenceBinding = bl && referenceBinding != null && referenceBinding.isRawType() ? (ReferenceBinding)lookupEnvironment.createAnnotatedType((TypeBinding)referenceBinding, this.typeAnnotations) : this.resolvedType;
            return referenceBinding;
        }
        ReferenceBinding referenceBinding = this.resolvedType;
        if (referenceBinding == null) {
            char[] cArray = this.compoundName[this.compoundName.length - 1];
            referenceBinding = this.fPackage.getType0(cArray);
            if (referenceBinding == this || referenceBinding == null) {
                if (this.fPackage instanceof SplitPackageBinding) {
                    referenceBinding = lookupEnvironment.askForType(this.fPackage, cArray, this.fPackage.enclosingModule);
                } else if (referenceBinding == this) {
                    referenceBinding = lookupEnvironment.askForType(this.compoundName, this.fPackage.enclosingModule);
                }
            }
            if ((referenceBinding == null || referenceBinding == this) && CharOperation.contains('.', cArray)) {
                referenceBinding = lookupEnvironment.askForType(this.fPackage, CharOperation.replaceOnCopy(cArray, '.', '$'), this.fPackage.enclosingModule);
            }
            if (referenceBinding == null || referenceBinding == this) {
                if ((this.tagBits & 0x80L) == 0L && !lookupEnvironment.mayTolerateMissingType) {
                    lookupEnvironment.problemReporter.isClassPathCorrect(this.compoundName, lookupEnvironment.root.unitBeingCompleted, lookupEnvironment.missingClassFileLocation, false);
                }
                referenceBinding = lookupEnvironment.createMissingType(null, this.compoundName);
            }
            this.setResolvedType(referenceBinding, lookupEnvironment);
        }
        if (bl) {
            referenceBinding = (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    void setResolvedType(ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.resolvedType == referenceBinding) {
            return;
        }
        this.resolvedType = referenceBinding;
        lookupEnvironment.updateCaches(this, referenceBinding);
        if (this.wrappers != null) {
            int n = this.wrappers.length;
            for (int i = 0; i < n; ++i) {
                this.wrappers[i].swapUnresolved(this, referenceBinding, lookupEnvironment);
            }
        }
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding2;
        if (this.resolvedType != null) {
            return;
        }
        this.resolvedType = referenceBinding2 = (ReferenceBinding)referenceBinding.clone(null);
        referenceBinding2.setTypeAnnotations(this.getTypeAnnotations(), lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
        lookupEnvironment.updateCaches(this, referenceBinding2);
        if (this.wrappers != null) {
            int n = this.wrappers.length;
            for (int i = 0; i < n; ++i) {
                this.wrappers[i].swapUnresolved(this, referenceBinding2, lookupEnvironment);
            }
        }
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return super.annotatedDebugName() + "(unresolved)";
        }
        return "Unresolved type " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
    }
}

