/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression {
    public TypeReference type;
    public Expression[] dimensions;
    public Annotation[][] annotationsOnDimensions;
    public ArrayInitializer initializer;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        for (Expression expression : this.dimensions) {
            if (expression == null) continue;
            flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo);
            expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        }
        flowContext.recordAbruptExit();
        if (this.initializer != null) {
            return this.initializer.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.initializer != null) {
            this.initializer.generateCode(this.type, this, blockScope, codeStream, bl);
            return;
        }
        int n2 = 0;
        for (Expression expression : this.dimensions) {
            if (expression == null) break;
            expression.generateCode(blockScope, codeStream, true);
            ++n2;
        }
        if (n2 == 1) {
            codeStream.newArray(this.type, this, (ArrayBinding)this.resolvedType);
        } else {
            codeStream.multianewarray(this.type, this.resolvedType, n2, this);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append("new ");
        this.type.print(0, stringBuffer);
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i] != null) {
                stringBuffer.append(' ');
                ArrayAllocationExpression.printAnnotations(this.annotationsOnDimensions[i], stringBuffer);
                stringBuffer.append(' ');
            }
            if (this.dimensions[i] == null) {
                stringBuffer.append("[]");
                continue;
            }
            stringBuffer.append('[');
            this.dimensions[i].printExpression(0, stringBuffer);
            stringBuffer.append(']');
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.constant = Constant.NotAConstant;
        if (typeBinding == TypeBinding.VOID) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            typeBinding = null;
        }
        int n = -1;
        int n2 = this.dimensions.length;
        while (--n2 >= 0) {
            if (this.dimensions[n2] != null) {
                if (n >= 0) continue;
                n = n2;
                continue;
            }
            if (n <= 0) continue;
            blockScope.problemReporter().incorrectLocationForNonEmptyDimension(this, n);
            break;
        }
        if (this.initializer == null) {
            if (n < 0) {
                blockScope.problemReporter().mustDefineDimensionsOrInitializer(this);
            }
            if (typeBinding != null && !typeBinding.isReifiable()) {
                blockScope.problemReporter().illegalGenericArray(typeBinding, this);
            }
        } else if (n >= 0) {
            blockScope.problemReporter().cannotDefineDimensionsAndInitializer(this);
        }
        for (n2 = 0; n2 <= n; ++n2) {
            TypeBinding typeBinding2;
            Expression expression = this.dimensions[n2];
            if (expression == null || (typeBinding2 = expression.resolveTypeExpecting(blockScope, TypeBinding.INT)) == null) continue;
            this.dimensions[n2].computeConversion(blockScope, TypeBinding.INT, typeBinding2);
        }
        if (typeBinding != null) {
            if (this.dimensions.length > 255) {
                blockScope.problemReporter().tooManyDimensions(this);
            }
            if (this.type.annotations != null && (typeBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                blockScope.problemReporter().contradictoryNullAnnotations(this.type.annotations[this.type.annotations.length - 1]);
            }
            this.resolvedType = blockScope.createArrayType(typeBinding, this.dimensions.length);
            if (this.annotationsOnDimensions != null) {
                this.resolvedType = ArrayAllocationExpression.resolveAnnotations(blockScope, this.annotationsOnDimensions, this.resolvedType);
                long[] lArray = ((ArrayBinding)this.resolvedType).nullTagBitsPerDimension;
                if (lArray != null) {
                    for (int i = 0; i < this.annotationsOnDimensions.length; ++i) {
                        if ((lArray[i] & 0x180000000000000L) != 0x180000000000000L) continue;
                        blockScope.problemReporter().contradictoryNullAnnotations(this.annotationsOnDimensions[i]);
                        lArray[i] = 0L;
                    }
                }
            }
            if (this.initializer != null) {
                this.resolvedType = ArrayTypeReference.maybeMarkArrayContentsNonNull(blockScope, this.resolvedType, this.sourceStart, this.dimensions.length, null);
                if (this.initializer.resolveTypeExpecting(blockScope, this.resolvedType) != null) {
                    this.initializer.binding = (ArrayBinding)this.resolvedType;
                }
            }
            if ((typeBinding.tagBits & 0x80L) != 0L) {
                return null;
            }
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.dimensions.length;
            this.type.traverse(aSTVisitor, blockScope);
            for (int i = 0; i < n; ++i) {
                Annotation[] annotationArray = this.annotationsOnDimensions == null ? null : this.annotationsOnDimensions[i];
                int n2 = annotationArray == null ? 0 : annotationArray.length;
                for (int j = 0; j < n2; ++j) {
                    annotationArray[j].traverse(aSTVisitor, blockScope);
                }
                if (this.dimensions[i] == null) continue;
                this.dimensions[i].traverse(aSTVisitor, blockScope);
            }
            if (this.initializer != null) {
                this.initializer.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void getAllAnnotationContexts(int n, int n2, List<AnnotationContext> list) {
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this, n, n2, list);
        this.type.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
        if (this.annotationsOnDimensions != null) {
            int n3 = this.dimensions.length;
            for (int i = 0; i < n3; ++i) {
                Annotation[] annotationArray = this.annotationsOnDimensions[i];
                int n4 = annotationArray == null ? 0 : annotationArray.length;
                for (int j = 0; j < n4; ++j) {
                    annotationArray[j].traverse((ASTVisitor)annotationCollector, (BlockScope)null);
                }
            }
        }
    }

    public Annotation[][] getAnnotationsOnDimensions() {
        return this.annotationsOnDimensions;
    }
}

