
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "tabicon_data_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabIcon_Data_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabIcon::Data >()))
        return -1;

    ::TabIcon::Data *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.TabIcon.Data.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "Data", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Data::Data()
    // 1: Data::Data(TabIcon::Data)
    if (numArgs == 0) {
        overloadId = 0; // Data()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Data(TabIcon::Data)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_TabIcon_Data_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Data()
        {

            if (!PyErr_Occurred()) {
                // Data()
                cptr = new ::TabIcon::Data();
            }
            break;
        }
        case 1: // Data(const TabIcon::Data & Data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::TabIcon::Data cppArg0_local;
            ::TabIcon::Data *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Data(TabIcon::Data)
                cptr = new ::TabIcon::Data(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::TabIcon::Data >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_TabIcon_Data_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_TabIcon_Data_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_TabIcon_Data___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_TabIcon_Data_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabIcon_Data_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_TabIcon_Data___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_TabIcon_Data_get_framesCount(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->framesCount;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_TabIcon_Data_set_framesCount(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'framesCount' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'framesCount', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->framesCount;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->framesCount = cppOut_local;

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_animationInterval(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->animationInterval;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_TabIcon_Data_set_animationInterval(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'animationInterval' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'animationInterval', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->animationInterval;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->animationInterval = cppOut_local;

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_animationPixmap(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->animationPixmap)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->animationPixmap))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->animationPixmap)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &(cppSelf->animationPixmap), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_TabIcon_Data_set_animationPixmap(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'animationPixmap' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'animationPixmap', 'QPixmap' or convertible type expected");
        return -1;
    }

    ::QPixmap& cppOut_ptr = cppSelf->animationPixmap;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_audioPlayingPixmap(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->audioPlayingPixmap)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->audioPlayingPixmap))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->audioPlayingPixmap)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &(cppSelf->audioPlayingPixmap), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_TabIcon_Data_set_audioPlayingPixmap(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'audioPlayingPixmap' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'audioPlayingPixmap', 'QPixmap' or convertible type expected");
        return -1;
    }

    ::QPixmap& cppOut_ptr = cppSelf->audioPlayingPixmap;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_audioMutedPixmap(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->audioMutedPixmap)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->audioMutedPixmap))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->audioMutedPixmap)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &(cppSelf->audioMutedPixmap), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_TabIcon_Data_set_audioMutedPixmap(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'audioMutedPixmap' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'audioMutedPixmap', 'QPixmap' or convertible type expected");
        return -1;
    }

    ::QPixmap& cppOut_ptr = cppSelf->audioMutedPixmap;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Data
static PyGetSetDef Sbk_TabIcon_Data_getsetlist[] = {
    {const_cast<char *>("framesCount"), Sbk_TabIcon_Data_get_framesCount, Sbk_TabIcon_Data_set_framesCount},
    {const_cast<char *>("animationInterval"), Sbk_TabIcon_Data_get_animationInterval, Sbk_TabIcon_Data_set_animationInterval},
    {const_cast<char *>("animationPixmap"), Sbk_TabIcon_Data_get_animationPixmap, Sbk_TabIcon_Data_set_animationPixmap},
    {const_cast<char *>("audioPlayingPixmap"), Sbk_TabIcon_Data_get_audioPlayingPixmap, Sbk_TabIcon_Data_set_audioPlayingPixmap},
    {const_cast<char *>("audioMutedPixmap"), Sbk_TabIcon_Data_get_audioMutedPixmap, Sbk_TabIcon_Data_set_audioMutedPixmap},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_TabIcon_Data_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_TabIcon_Data_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_TabIcon_Data_Type = nullptr;
static SbkObjectType *Sbk_TabIcon_Data_TypeF(void)
{
    return _Sbk_TabIcon_Data_Type;
}

static PyType_Slot Sbk_TabIcon_Data_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabIcon_Data_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabIcon_Data_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabIcon_Data_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_TabIcon_Data_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabIcon_Data_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabIcon_Data_spec = {
    "1:PyFalkon.TabIcon.Data",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_TabIcon_Data_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Data_PythonToCpp_Data_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabIcon_Data_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Data_PythonToCpp_Data_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_TabIcon_Data_TypeF())))
        return Data_PythonToCpp_Data_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Data_PTR_CppToPython_Data(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::TabIcon::Data *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_TabIcon_Data_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Data_COPY_CppToPython_Data(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_TabIcon_Data_TypeF(), new ::TabIcon::Data(*reinterpret_cast<const ::TabIcon::Data *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Data_PythonToCpp_Data_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::TabIcon::Data *>(cppOut) = *reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_TABICON_DATA_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Data_PythonToCpp_Data_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_TabIcon_Data_TypeF())))
        return Data_PythonToCpp_Data_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *TabIcon_Data_SignatureStrings[] = {
    "1:PyFalkon.TabIcon.Data(self)",
    "0:PyFalkon.TabIcon.Data(self,Data:PyFalkon.TabIcon.Data)",
    "PyFalkon.TabIcon.Data.__copy__()",
    nullptr}; // Sentinel

void init_TabIcon_Data(PyObject *enclosingClass)
{
    _Sbk_TabIcon_Data_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Data",
        "TabIcon::Data",
        &Sbk_TabIcon_Data_spec,
        &Shiboken::callCppDestructor< ::TabIcon::Data >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_TabIcon_Data_Type);
    InitSignatureStrings(pyType, TabIcon_Data_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_TabIcon_Data_Type), Sbk_TabIcon_Data_PropertyStrings);
    SbkPyFalkonTypes[SBK_TABICON_DATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_TabIcon_Data_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_TabIcon_Data_TypeF(),
        Data_PythonToCpp_Data_PTR,
        is_Data_PythonToCpp_Data_PTR_Convertible,
        Data_PTR_CppToPython_Data,
        Data_COPY_CppToPython_Data);

    Shiboken::Conversions::registerConverterName(converter, "TabIcon::Data");
    Shiboken::Conversions::registerConverterName(converter, "TabIcon::Data*");
    Shiboken::Conversions::registerConverterName(converter, "TabIcon::Data&");
    Shiboken::Conversions::registerConverterName(converter, "Data");
    Shiboken::Conversions::registerConverterName(converter, "Data*");
    Shiboken::Conversions::registerConverterName(converter, "Data&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabIcon::Data).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Data_PythonToCpp_Data_COPY,
        is_Data_PythonToCpp_Data_COPY_Convertible);

    qRegisterMetaType< ::TabIcon::Data >("Data");
    qRegisterMetaType< ::TabIcon::Data >("TabIcon::Data");
}
