/* view.c generated by valac 0.56.0, the Vala compiler
 * generated from view.vala, do not modify */

/*
 * Color lines for GNOME
 * Copyright © 1999 Free Software Foundation
 * Authors: Robert Szokovacs <szo@szo.hu>
 *          Szabolcs Ban <shooby@gnome.hu>
 *          Karuna Grewal <karunagrewal98@gmail.com>
 *          Ruxandra Simion <ruxandra.simion93@gmail.com>
 * Copyright © 2007 Christian Persch
 *
 * This game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define VIEW_MINIMUM_BOARD_SIZE 256
#define FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR "background-color"
#define GAME_N_ANIMATIONS 4
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VIEW (view_get_type ())
#define VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW, View))
#define VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW, ViewClass))
#define IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW))
#define IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW))
#define VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW, ViewClass))

typedef struct _View View;
typedef struct _ViewClass ViewClass;
typedef struct _ViewPrivate ViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME_RENDERER (theme_renderer_get_type ())
#define THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_RENDERER, ThemeRenderer))
#define THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_RENDERER, ThemeRendererClass))
#define IS_THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_RENDERER))
#define IS_THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_RENDERER))
#define THEME_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_RENDERER, ThemeRendererClass))

typedef struct _ThemeRenderer ThemeRenderer;
typedef struct _ThemeRendererClass ThemeRendererClass;
enum  {
	VIEW_0_PROPERTY,
	VIEW_NUM_PROPERTIES
};
static GParamSpec* view_properties[VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _theme_renderer_unref0(var) ((var == NULL) ? NULL : (var = (theme_renderer_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamePrivate GamePrivate;

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;

#define TYPE_CELL (cell_get_type ())
#define CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELL, Cell))
#define CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELL, CellClass))
#define IS_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELL))
#define IS_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELL))
#define CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELL, CellClass))

typedef struct _Cell Cell;
typedef struct _CellClass CellClass;

#define TYPE_PIECE (piece_get_type ())
#define PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIECE, Piece))
#define PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIECE, PieceClass))
#define IS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIECE))
#define IS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIECE))
#define PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIECE, PieceClass))

typedef struct _Piece Piece;
typedef struct _PieceClass PieceClass;
#define _piece_unref0(var) ((var == NULL) ? NULL : (var = (piece_unref (var), NULL)))
typedef enum  {
	STATUS_MESSAGE_DESCRIPTION,
	STATUS_MESSAGE_NO_PATH,
	STATUS_MESSAGE_GAME_OVER,
	STATUS_MESSAGE_NONE
} StatusMessage;

#define TYPE_STATUS_MESSAGE (status_message_get_type ())
typedef struct _PiecePrivate PiecePrivate;
typedef struct _CellPrivate CellPrivate;
#define _cell_unref0(var) ((var == NULL) ? NULL : (var = (cell_unref (var), NULL)))

struct _View {
	GtkDrawingArea parent_instance;
	ViewPrivate * priv;
};

struct _ViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ViewPrivate {
	GSettings* settings;
	Game* game;
	ThemeRenderer* theme;
	GtkStyleContext* cs;
	GtkCssProvider* provider;
	GdkRectangle board_rectangle;
	gint piece_size;
	gint cell_x;
	gint cell_y;
	gint start_x;
	gint start_y;
	gint end_x;
	gint end_y;
	gboolean show_cursor;
	gint keyboard_cursor_x;
	gint keyboard_cursor_y;
	gint animation_state;
	guint animation_id;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Board* board;
	gint n_next_pieces;
	gint n_filled_cells;
	GeeArrayList* current_path;
	gboolean animating;
	Piece* animating_piece;
	gint n_categories;
	gchar* score_current_category;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Piece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PiecePrivate * priv;
	gint id;
};

struct _PieceClass {
	GTypeClass parent_class;
	void (*finalize) (Piece *self);
};

struct _Cell {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CellPrivate * priv;
	gint row;
	gint col;
	Cell* parent;
	Piece* piece;
	gint cost;
};

struct _CellClass {
	GTypeClass parent_class;
	void (*finalize) (Cell *self);
};

static gint View_private_offset;
static gpointer view_parent_class = NULL;

VALA_EXTERN GType view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (View, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN gpointer theme_renderer_ref (gpointer instance);
VALA_EXTERN void theme_renderer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_theme_renderer (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_theme_renderer (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_theme_renderer (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_theme_renderer (const GValue* value);
VALA_EXTERN GType theme_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeRenderer, theme_renderer_unref)
VALA_EXTERN View* view_new (GSettings* settings,
                Game* game,
                ThemeRenderer* theme);
VALA_EXTERN View* view_construct (GType object_type,
                      GSettings* settings,
                      Game* game,
                      ThemeRenderer* theme);
static void view_set_background_color (View* self);
static void __lambda8_ (View* self);
static void ___lambda8__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void view_update_sizes (View* self,
                        gint width,
                        gint height);
VALA_EXTERN gpointer board_ref (gpointer instance);
VALA_EXTERN void board_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_board (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_board (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_board (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_board (const GValue* value);
VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, board_unref)
VALA_EXTERN gpointer cell_ref (gpointer instance);
VALA_EXTERN void cell_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_cell (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_cell (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_cell (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_cell (const GValue* value);
VALA_EXTERN GType cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Cell, cell_unref)
VALA_EXTERN gpointer piece_ref (gpointer instance);
VALA_EXTERN void piece_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_piece (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_piece (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_piece (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_piece (const GValue* value);
VALA_EXTERN GType piece_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Piece, piece_unref)
static void __lambda9_ (View* self);
static void ___lambda9__board_board_changed (Board* _sender,
                                      gpointer self);
static void _gtk_widget_queue_draw_board_grid_changed (Board* _sender,
                                                gpointer self);
static void _gtk_widget_queue_draw_game_current_path_cell_pos_changed (Game* _sender,
                                                                gpointer self);
static void view_theme_changed_cb (View* self);
static void _view_theme_changed_cb_theme_renderer_theme_changed (ThemeRenderer* _sender,
                                                          gpointer self);
VALA_EXTERN GeeArrayList* game_get_next_pieces_queue (Game* self);
static void view_move_keyboard_cursor (View* self,
                                gint x,
                                gint y);
VALA_EXTERN gint game_get_n_cols (Game* self);
VALA_EXTERN gint game_get_n_rows (Game* self);
static gboolean view_real_key_press_event (GtkWidget* base,
                                    GdkEventKey* event);
static gboolean view_cell_clicked (View* self,
                            gint cell_x,
                            gint cell_y);
VALA_EXTERN Piece* board_get_piece (Board* self,
                        gint row,
                        gint col);
static gboolean view_animate_clicked (View* self);
static gboolean _view_animate_clicked_gsource_func (gpointer self);
VALA_EXTERN GType status_message_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StatusMessage game_get_status_message (Game* self);
VALA_EXTERN void game_set_status_message (Game* self,
                              StatusMessage value);
VALA_EXTERN gboolean game_make_move (Game* self,
                         gint start_row,
                         gint start_col,
                         gint end_row,
                         gint end_col);
static gboolean view_real_button_press_event (GtkWidget* base,
                                       GdkEventButton* event);
static gboolean view_real_configure_event (GtkWidget* base,
                                    GdkEventConfigure* event);
static void view_fill_background (View* self,
                           cairo_t* cr);
static void view_draw_gridlines (View* self,
                          cairo_t* cr);
static void view_draw_cursor_box (View* self,
                           cairo_t* cr);
static void view_draw_shapes (View* self,
                       cairo_t* cr);
VALA_EXTERN void theme_renderer_render_sprite (ThemeRenderer* self,
                                   cairo_t* cr,
                                   gint type,
                                   gint animation,
                                   gdouble x,
                                   gdouble y,
                                   gint size);
static void view_draw_path (View* self,
                     cairo_t* cr);
VALA_EXTERN gint game_get_current_path_cell_pos (Game* self);
static gboolean view_real_draw (GtkWidget* base,
                         cairo_t* cr);
static void view_finalize (GObject * obj);
static GType view_get_type_once (void);

static inline gpointer
view_get_instance_private (View* self)
{
	return G_STRUCT_MEMBER_P (self, View_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_theme_renderer_ref0 (gpointer self)
{
	return self ? theme_renderer_ref (self) : NULL;
}

static void
__lambda8_ (View* self)
{
	view_set_background_color (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda8__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda8_ ((View*) self);
}

static void
__lambda9_ (View* self)
{
	self->priv->show_cursor = FALSE;
	self->priv->keyboard_cursor_x = -1;
	self->priv->keyboard_cursor_y = -1;
	view_update_sizes (self, gtk_widget_get_allocated_width ((GtkWidget*) self), gtk_widget_get_allocated_height ((GtkWidget*) self));
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda9__board_board_changed (Board* _sender,
                                 gpointer self)
{
	__lambda9_ ((View*) self);
}

static void
_gtk_widget_queue_draw_board_grid_changed (Board* _sender,
                                           gpointer self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
_gtk_widget_queue_draw_game_current_path_cell_pos_changed (Game* _sender,
                                                           gpointer self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
_view_theme_changed_cb_theme_renderer_theme_changed (ThemeRenderer* _sender,
                                                     gpointer self)
{
	view_theme_changed_cb ((View*) self);
}

View*
view_construct (GType object_type,
                GSettings* settings,
                Game* game,
                ThemeRenderer* theme)
{
	View * self = NULL;
	GSettings* _tmp0_;
	Game* _tmp1_;
	ThemeRenderer* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkCssProvider* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkCssProvider* _tmp8_;
	gchar* _tmp9_;
	Board* _tmp10_;
	Board* _tmp11_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (theme != NULL, NULL);
	self = (View*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	_tmp2_ = _theme_renderer_ref0 (theme);
	_theme_renderer_unref0 (self->priv->theme);
	self->priv->theme = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->cs);
	self->priv->cs = _tmp4_;
	_tmp5_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = _tmp5_;
	_tmp6_ = self->priv->cs;
	gtk_style_context_add_class (_tmp6_, "game-view");
	_tmp7_ = self->priv->cs;
	_tmp8_ = self->priv->provider;
	gtk_style_context_add_provider (_tmp7_, (GtkStyleProvider*) _tmp8_, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	view_set_background_color (self);
	_tmp9_ = g_strconcat ("changed::", FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR, NULL);
	g_signal_connect_object (settings, _tmp9_, (GCallback) ___lambda8__g_settings_changed, self, 0);
	_g_free0 (_tmp9_);
	gtk_widget_set_size_request ((GtkWidget*) self, VIEW_MINIMUM_BOARD_SIZE, VIEW_MINIMUM_BOARD_SIZE);
	memset (&self->priv->board_rectangle, 0, sizeof (GdkRectangle));
	self->priv->board_rectangle.y = 0;
	self->priv->board_rectangle.x = self->priv->board_rectangle.y;
	view_update_sizes (self, VIEW_MINIMUM_BOARD_SIZE, VIEW_MINIMUM_BOARD_SIZE);
	_tmp10_ = game->board;
	g_signal_connect_object (_tmp10_, "board-changed", (GCallback) ___lambda9__board_board_changed, self, 0);
	_tmp11_ = game->board;
	g_signal_connect_object (_tmp11_, "grid-changed", (GCallback) _gtk_widget_queue_draw_board_grid_changed, (GtkWidget*) self, 0);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK));
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_grab_focus ((GtkWidget*) self);
	g_signal_connect_object (game, "current-path-cell-pos-changed", (GCallback) _gtk_widget_queue_draw_game_current_path_cell_pos_changed, (GtkWidget*) self, 0);
	g_signal_connect_object (theme, "theme-changed", (GCallback) _view_theme_changed_cb_theme_renderer_theme_changed, self, 0);
	self->priv->start_x = -1;
	self->priv->start_y = -1;
	self->priv->end_x = -1;
	self->priv->end_y = -1;
	self->priv->show_cursor = FALSE;
	self->priv->keyboard_cursor_x = -1;
	self->priv->keyboard_cursor_y = -1;
	self->priv->animation_state = 0;
	self->priv->animation_id = (guint) -1;
	return self;
}

View*
view_new (GSettings* settings,
          Game* game,
          ThemeRenderer* theme)
{
	return view_construct (TYPE_VIEW, settings, game, theme);
}

static void
view_theme_changed_cb (View* self)
{
	Game* _tmp0_;
	Board* _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	g_signal_emit_by_name (_tmp1_, "grid-changed");
	_tmp2_ = self->priv->game;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_next_pieces_queue (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_emit_by_name (_tmp2_, "queue-changed", _tmp5_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
view_set_background_color (View* self)
{
	gchar* color_str = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, FIVE_OR_MORE_APP_KEY_BACKGROUND_COLOR);
	color_str = _tmp1_;
	{
		GtkCssProvider* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->provider;
		_tmp3_ = color_str;
		_tmp4_ = g_strdup_printf (".game-view { background-color: %s; }", _tmp3_);
		_tmp5_ = _tmp4_;
		gtk_css_provider_load_from_data (_tmp2_, _tmp5_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("view.vala:123: Failed to load CSS data to provider");
		_g_free0 (color_str);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (color_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (color_str);
}

static void
view_move_keyboard_cursor (View* self,
                           gint x,
                           gint y)
{
	gint prev_x = 0;
	gint prev_y = 0;
	Game* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Game* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	prev_x = self->priv->keyboard_cursor_x;
	prev_y = self->priv->keyboard_cursor_y;
	if (!self->priv->show_cursor) {
		self->priv->show_cursor = TRUE;
		gtk_widget_queue_draw_area ((GtkWidget*) self, self->priv->keyboard_cursor_x * self->priv->piece_size, self->priv->keyboard_cursor_y * self->priv->piece_size, self->priv->piece_size, self->priv->piece_size);
	}
	self->priv->keyboard_cursor_x = self->priv->keyboard_cursor_x + x;
	if (self->priv->keyboard_cursor_x < 0) {
		self->priv->keyboard_cursor_x = 0;
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_cols (_tmp0_);
	_tmp2_ = _tmp1_;
	if (self->priv->keyboard_cursor_x >= _tmp2_) {
		Game* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = game_get_n_cols (_tmp3_);
		_tmp5_ = _tmp4_;
		self->priv->keyboard_cursor_x = _tmp5_ - 1;
	}
	self->priv->keyboard_cursor_y = self->priv->keyboard_cursor_y + y;
	if (self->priv->keyboard_cursor_y < 0) {
		self->priv->keyboard_cursor_y = 0;
	}
	_tmp6_ = self->priv->game;
	_tmp7_ = game_get_n_rows (_tmp6_);
	_tmp8_ = _tmp7_;
	if (self->priv->keyboard_cursor_y >= _tmp8_) {
		Game* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = self->priv->game;
		_tmp10_ = game_get_n_rows (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->keyboard_cursor_y = _tmp11_ - 1;
	}
	if (self->priv->keyboard_cursor_x == prev_x) {
		_tmp12_ = self->priv->keyboard_cursor_y == prev_y;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		return;
	}
	gtk_widget_queue_draw_area ((GtkWidget*) self, prev_x * self->priv->piece_size, prev_y * self->priv->piece_size, self->priv->piece_size, self->priv->piece_size);
	gtk_widget_queue_draw_area ((GtkWidget*) self, self->priv->keyboard_cursor_x * self->priv->piece_size, self->priv->keyboard_cursor_y * self->priv->piece_size, self->priv->piece_size, self->priv->piece_size);
}

static gboolean
view_real_key_press_event (GtkWidget* base,
                           GdkEventKey* event)
{
	View * self;
	guint key = 0U;
	gboolean result;
	self = (View*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	key = event->keyval;
	switch (key) {
		case GDK_KEY_Left:
		case GDK_KEY_KP_Left:
		{
			view_move_keyboard_cursor (self, -1, 0);
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_KP_Right:
		{
			view_move_keyboard_cursor (self, 1, 0);
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_KP_Up:
		{
			view_move_keyboard_cursor (self, 0, -1);
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_KP_Down:
		{
			view_move_keyboard_cursor (self, 0, 1);
			break;
		}
		case GDK_KEY_Home:
		case GDK_KEY_KP_Home:
		{
			view_move_keyboard_cursor (self, -999, 0);
			break;
		}
		case GDK_KEY_End:
		case GDK_KEY_KP_End:
		{
			view_move_keyboard_cursor (self, 999, 0);
			break;
		}
		case GDK_KEY_Page_Up:
		case GDK_KEY_KP_Page_Up:
		{
			view_move_keyboard_cursor (self, 0, -999);
			break;
		}
		case GDK_KEY_Page_Down:
		case GDK_KEY_KP_Page_Down:
		{
			view_move_keyboard_cursor (self, 0, 999);
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_KP_Space:
		case GDK_KEY_Return:
		case GDK_KEY_KP_Enter:
		{
			if (self->priv->show_cursor) {
				view_cell_clicked (self, self->priv->keyboard_cursor_x, self->priv->keyboard_cursor_y);
			}
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}

static gboolean
_view_animate_clicked_gsource_func (gpointer self)
{
	gboolean result;
	result = view_animate_clicked ((View*) self);
	return result;
}

static gboolean
view_cell_clicked (View* self,
                   gint cell_x,
                   gint cell_y)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Game* _tmp7_;
	Board* _tmp8_;
	Piece* _tmp9_;
	Piece* _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_n_cols (_tmp1_);
	_tmp3_ = _tmp2_;
	if (cell_x >= _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = game_get_n_rows (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = cell_y >= _tmp6_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->keyboard_cursor_x = cell_x;
	self->priv->keyboard_cursor_y = cell_y;
	_tmp7_ = self->priv->game;
	_tmp8_ = _tmp7_->board;
	_tmp9_ = board_get_piece (_tmp8_, cell_y, cell_x);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_piece_unref0 (_tmp10_);
	if (_tmp11_) {
		gboolean _tmp12_ = FALSE;
		if (self->priv->animation_id != ((guint) -1)) {
			g_source_remove (self->priv->animation_id);
			self->priv->animation_id = (guint) -1;
		}
		if (self->priv->start_x == cell_x) {
			_tmp12_ = self->priv->start_y == cell_y;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			self->priv->start_x = -1;
			self->priv->start_y = -1;
			self->priv->animation_state = 0;
			gtk_widget_queue_draw ((GtkWidget*) self);
			result = TRUE;
			return result;
		}
		self->priv->start_x = cell_x;
		self->priv->start_y = cell_y;
		self->priv->animation_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _view_animate_clicked_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		Game* _tmp15_;
		Board* _tmp16_;
		Piece* _tmp17_;
		Piece* _tmp18_;
		gboolean _tmp19_;
		_tmp15_ = self->priv->game;
		_tmp16_ = _tmp15_->board;
		_tmp17_ = board_get_piece (_tmp16_, cell_y, cell_x);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_ == NULL;
		_piece_unref0 (_tmp18_);
		if (_tmp19_) {
			_tmp14_ = self->priv->start_x != -1;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			_tmp13_ = self->priv->start_y != -1;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			Game* _tmp20_;
			StatusMessage _tmp21_;
			StatusMessage _tmp22_;
			gboolean move = FALSE;
			Game* _tmp24_;
			_tmp20_ = self->priv->game;
			_tmp21_ = game_get_status_message (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ != STATUS_MESSAGE_NONE) {
				Game* _tmp23_;
				_tmp23_ = self->priv->game;
				game_set_status_message (_tmp23_, STATUS_MESSAGE_NONE);
			}
			self->priv->end_x = cell_x;
			self->priv->end_y = cell_y;
			_tmp24_ = self->priv->game;
			move = game_make_move (_tmp24_, self->priv->start_y, self->priv->start_x, self->priv->end_y, self->priv->end_x);
			if (!move) {
				result = FALSE;
				return result;
			}
			self->priv->start_x = -1;
			self->priv->start_y = -1;
			if (self->priv->animation_id != ((guint) -1)) {
				g_source_remove (self->priv->animation_id);
				self->priv->animation_id = (guint) -1;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
view_real_button_press_event (GtkWidget* base,
                              GdkEventButton* event)
{
	View * self;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	gboolean result;
	self = (View*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->game;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp2_;
		_tmp2_ = self->priv->game;
		_tmp0_ = _tmp2_->animating;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (event->type != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	if (self->priv->show_cursor) {
		self->priv->show_cursor = FALSE;
		gtk_widget_queue_draw_area ((GtkWidget*) self, self->priv->keyboard_cursor_x * self->priv->piece_size, self->priv->keyboard_cursor_y * self->priv->piece_size, self->priv->piece_size, self->priv->piece_size);
	}
	self->priv->cell_x = ((gint) event->x) / self->priv->piece_size;
	self->priv->cell_y = ((gint) event->y) / self->priv->piece_size;
	result = view_cell_clicked (self, self->priv->cell_x, self->priv->cell_y);
	return result;
}

static gboolean
view_animate_clicked (View* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->animation_state = (self->priv->animation_state + 1) % GAME_N_ANIMATIONS;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
view_update_sizes (View* self,
                   gint width,
                   gint height)
{
	Game* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Game* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Game* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_cols (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->piece_size = (width - 1) / _tmp2_;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_n_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->board_rectangle.width = self->priv->piece_size * _tmp5_;
	_tmp6_ = self->priv->game;
	_tmp7_ = game_get_n_rows (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->board_rectangle.height = self->priv->piece_size * _tmp8_;
}

static gboolean
view_real_configure_event (GtkWidget* base,
                           GdkEventConfigure* event)
{
	View * self;
	gboolean result;
	self = (View*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	view_update_sizes (self, event->width, event->height);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	return result;
}

static void
view_fill_background (View* self,
                      cairo_t* cr)
{
	GtkStyleContext* _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->cs;
	_tmp1_ = self->priv->board_rectangle;
	_tmp2_ = self->priv->board_rectangle;
	_tmp3_ = self->priv->board_rectangle;
	_tmp4_ = self->priv->board_rectangle;
	gtk_render_background (_tmp0_, cr, (gdouble) _tmp1_.x, (gdouble) _tmp2_.y, (gdouble) _tmp3_.width, (gdouble) _tmp4_.height);
}

static void
view_draw_gridlines (View* self,
                     cairo_t* cr)
{
	GdkRGBA grid_color = {0};
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	GdkRectangle border = {0};
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->cs;
	_tmp1_ = self->priv->cs;
	gtk_style_context_get_color (_tmp0_, gtk_style_context_get_state (_tmp1_), &_tmp2_);
	grid_color = _tmp2_;
	_tmp3_ = grid_color;
	gdk_cairo_set_source_rgba (cr, &_tmp3_);
	cairo_set_line_width (cr, 1.0);
	{
		gint i = 0;
		i = self->priv->piece_size;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GdkRectangle _tmp5_;
				GdkRectangle _tmp6_;
				if (!_tmp4_) {
					i += self->priv->piece_size;
				}
				_tmp4_ = FALSE;
				_tmp5_ = self->priv->board_rectangle;
				if (!(i < _tmp5_.width)) {
					break;
				}
				cairo_move_to (cr, i + 0.5, 0 + 0.5);
				_tmp6_ = self->priv->board_rectangle;
				cairo_line_to (cr, i + 0.5, _tmp6_.height + 0.5);
			}
		}
	}
	{
		gint i = 0;
		i = self->priv->piece_size;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GdkRectangle _tmp8_;
				GdkRectangle _tmp9_;
				if (!_tmp7_) {
					i += self->priv->piece_size;
				}
				_tmp7_ = FALSE;
				_tmp8_ = self->priv->board_rectangle;
				if (!(i < _tmp8_.height)) {
					break;
				}
				cairo_move_to (cr, 0 + 0.5, i + 0.5);
				_tmp9_ = self->priv->board_rectangle;
				cairo_line_to (cr, _tmp9_.width + 0.5, i + 0.5);
			}
		}
	}
	memset (&border, 0, sizeof (GdkRectangle));
	border.y = 1;
	border.x = border.y;
	_tmp10_ = self->priv->board_rectangle;
	border.width = _tmp10_.width;
	_tmp11_ = self->priv->board_rectangle;
	border.height = _tmp11_.height;
	_tmp12_ = border;
	gdk_cairo_rectangle (cr, &_tmp12_);
	cairo_stroke (cr);
}

static void
view_draw_cursor_box (View* self,
                      cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (self->priv->show_cursor) {
		GdkRGBA grid_color = {0};
		GtkStyleContext* _tmp0_;
		GtkStyleContext* _tmp1_;
		GdkRGBA _tmp2_ = {0};
		GdkRGBA _tmp3_;
		GdkRectangle cursor_rectangle = {0};
		GdkRectangle _tmp4_;
		_tmp0_ = self->priv->cs;
		_tmp1_ = self->priv->cs;
		gtk_style_context_get_color (_tmp0_, gtk_style_context_get_state (_tmp1_), &_tmp2_);
		grid_color = _tmp2_;
		_tmp3_ = grid_color;
		gdk_cairo_set_source_rgba (cr, &_tmp3_);
		cairo_set_line_width (cr, 2.0);
		memset (&cursor_rectangle, 0, sizeof (GdkRectangle));
		cursor_rectangle.x = (self->priv->keyboard_cursor_x * self->priv->piece_size) + 1;
		cursor_rectangle.y = (self->priv->keyboard_cursor_y * self->priv->piece_size) + 1;
		cursor_rectangle.width = self->priv->piece_size - 1;
		cursor_rectangle.height = self->priv->piece_size - 1;
		_tmp4_ = cursor_rectangle;
		gdk_cairo_rectangle (cr, &_tmp4_);
		cairo_stroke (cr);
	}
}

static void
view_draw_shapes (View* self,
                  cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Game* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = game_get_n_rows (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(row < _tmp4_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							Game* _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							Game* _tmp10_;
							Board* _tmp11_;
							Piece* _tmp12_;
							Piece* _tmp13_;
							gboolean _tmp14_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = col;
								col = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = self->priv->game;
							_tmp8_ = game_get_n_cols (_tmp7_);
							_tmp9_ = _tmp8_;
							if (!(col < _tmp9_)) {
								break;
							}
							_tmp10_ = self->priv->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = board_get_piece (_tmp11_, row, col);
							_tmp13_ = _tmp12_;
							_tmp14_ = _tmp13_ != NULL;
							_piece_unref0 (_tmp13_);
							if (_tmp14_) {
								gint _tmp15_ = 0;
								gboolean _tmp16_ = FALSE;
								ThemeRenderer* _tmp17_;
								Game* _tmp18_;
								Board* _tmp19_;
								Piece* _tmp20_;
								Piece* _tmp21_;
								if (self->priv->start_x == col) {
									_tmp16_ = self->priv->start_y == row;
								} else {
									_tmp16_ = FALSE;
								}
								if (_tmp16_) {
									_tmp15_ = self->priv->animation_state;
								} else {
									_tmp15_ = 0;
								}
								_tmp17_ = self->priv->theme;
								_tmp18_ = self->priv->game;
								_tmp19_ = _tmp18_->board;
								_tmp20_ = board_get_piece (_tmp19_, row, col);
								_tmp21_ = _tmp20_;
								theme_renderer_render_sprite (_tmp17_, cr, _tmp21_->id, _tmp15_, (gdouble) (col * self->priv->piece_size), (gdouble) (row * self->priv->piece_size), self->priv->piece_size);
								_piece_unref0 (_tmp21_);
							}
						}
					}
				}
			}
		}
	}
}

static void
view_draw_path (View* self,
                cairo_t* cr)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp2_ = self->priv->game;
	_tmp3_ = _tmp2_->current_path;
	if (_tmp3_ != NULL) {
		Game* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->game;
		_tmp5_ = _tmp4_->current_path;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Game* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_current_path_cell_pos (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_ != -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Cell* current_cell = NULL;
		Game* _tmp11_;
		GeeArrayList* _tmp12_;
		Game* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gpointer _tmp16_;
		ThemeRenderer* _tmp17_;
		Game* _tmp18_;
		Piece* _tmp19_;
		Cell* _tmp20_;
		Cell* _tmp21_;
		_tmp11_ = self->priv->game;
		_tmp12_ = _tmp11_->current_path;
		_tmp13_ = self->priv->game;
		_tmp14_ = game_get_current_path_cell_pos (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp15_);
		current_cell = (Cell*) _tmp16_;
		_tmp17_ = self->priv->theme;
		_tmp18_ = self->priv->game;
		_tmp19_ = _tmp18_->animating_piece;
		_tmp20_ = current_cell;
		_tmp21_ = current_cell;
		theme_renderer_render_sprite (_tmp17_, cr, _tmp19_->id, self->priv->animation_state, (gdouble) (_tmp20_->col * self->priv->piece_size), (gdouble) (_tmp21_->row * self->priv->piece_size), self->priv->piece_size);
		_cell_unref0 (current_cell);
	}
}

static gboolean
view_real_draw (GtkWidget* base,
                cairo_t* cr)
{
	View * self;
	ThemeRenderer* _tmp0_;
	gboolean result;
	self = (View*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->theme;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	view_fill_background (self, cr);
	view_draw_gridlines (self, cr);
	view_draw_shapes (self, cr);
	view_draw_cursor_box (self, cr);
	view_draw_path (self, cr);
	result = TRUE;
	return result;
}

static void
view_class_init (ViewClass * klass,
                 gpointer klass_data)
{
	view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &View_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) view_real_key_press_event;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) view_real_button_press_event;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) view_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) view_real_draw;
	G_OBJECT_CLASS (klass)->finalize = view_finalize;
}

static void
view_instance_init (View * self,
                    gpointer klass)
{
	self->priv = view_get_instance_private (self);
	self->priv->game = NULL;
	self->priv->theme = NULL;
	self->priv->piece_size = 0;
}

static void
view_finalize (GObject * obj)
{
	View * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW, View);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_theme_renderer_unref0 (self->priv->theme);
	_g_object_unref0 (self->priv->cs);
	_g_object_unref0 (self->priv->provider);
	G_OBJECT_CLASS (view_parent_class)->finalize (obj);
}

static GType
view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (View), 0, (GInstanceInitFunc) view_instance_init, NULL };
	GType view_type_id;
	view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "View", &g_define_type_info, 0);
	View_private_offset = g_type_add_instance_private (view_type_id, sizeof (ViewPrivate));
	return view_type_id;
}

GType
view_get_type (void)
{
	static volatile gsize view_type_id__once = 0;
	if (g_once_init_enter (&view_type_id__once)) {
		GType view_type_id;
		view_type_id = view_get_type_once ();
		g_once_init_leave (&view_type_id__once, view_type_id);
	}
	return view_type_id__once;
}

