/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ipc-flatpak-service.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Builder.Flatpak.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IpcFlatpakService
 * @title: IpcFlatpakService
 * @short_description: Generated C code for the org.gnome.Builder.Flatpak.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Builder.Flatpak.Service ---- */

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_add_installation_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_add_installation_IN_ARG_is_user =
{
  {
    -1,
    (gchar *) "is_user",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_add_installation_IN_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_add_installation_IN_ARG_path.parent_struct,
  &_ipc_flatpak_service_method_info_add_installation_IN_ARG_is_user.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_flatpak_service_method_info_add_installation =
{
  {
    -1,
    (gchar *) "AddInstallation",
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_add_installation_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-installation",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_list_runtimes_OUT_ARG_runtimes =
{
  {
    -1,
    (gchar *) "runtimes",
    (gchar *) "a(sssssssb)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_list_runtimes_OUT_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_list_runtimes_OUT_ARG_runtimes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_flatpak_service_method_info_list_runtimes =
{
  {
    -1,
    (gchar *) "ListRuntimes",
    NULL,
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_list_runtimes_OUT_ARG_pointers,
    NULL
  },
  "handle-list-runtimes",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_get_runtime_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_get_runtime_IN_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_get_runtime_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_get_runtime_OUT_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "(sssssssb)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_get_runtime_OUT_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_get_runtime_OUT_ARG_runtime.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_flatpak_service_method_info_get_runtime =
{
  {
    -1,
    (gchar *) "GetRuntime",
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_get_runtime_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_get_runtime_OUT_ARG_pointers,
    NULL
  },
  "handle-get-runtime",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_runtime_is_known_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_runtime_is_known_IN_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_runtime_is_known_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_runtime_is_known_OUT_ARG_is_known =
{
  {
    -1,
    (gchar *) "is_known",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_runtime_is_known_OUT_ARG_download_size =
{
  {
    -1,
    (gchar *) "download_size",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_runtime_is_known_OUT_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_runtime_is_known_OUT_ARG_is_known.parent_struct,
  &_ipc_flatpak_service_method_info_runtime_is_known_OUT_ARG_download_size.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_flatpak_service_method_info_runtime_is_known =
{
  {
    -1,
    (gchar *) "RuntimeIsKnown",
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_runtime_is_known_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_runtime_is_known_OUT_ARG_pointers,
    NULL
  },
  "handle-runtime-is-known",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_install_IN_ARG_full_ref_name =
{
  {
    -1,
    (gchar *) "full_ref_name",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_install_IN_ARG_if_not_exists =
{
  {
    -1,
    (gchar *) "if_not_exists",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_install_IN_ARG_transfer =
{
  {
    -1,
    (gchar *) "transfer",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_install_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_install_IN_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_install_IN_ARG_full_ref_name.parent_struct,
  &_ipc_flatpak_service_method_info_install_IN_ARG_if_not_exists.parent_struct,
  &_ipc_flatpak_service_method_info_install_IN_ARG_transfer.parent_struct,
  &_ipc_flatpak_service_method_info_install_IN_ARG_parent_window.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_flatpak_service_method_info_install =
{
  {
    -1,
    (gchar *) "Install",
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_install_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_resolve_extension_IN_ARG_sdk =
{
  {
    -1,
    (gchar *) "sdk",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_resolve_extension_IN_ARG_extension =
{
  {
    -1,
    (gchar *) "extension",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_resolve_extension_IN_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_resolve_extension_IN_ARG_sdk.parent_struct,
  &_ipc_flatpak_service_method_info_resolve_extension_IN_ARG_extension.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_method_info_resolve_extension_OUT_ARG_resolved =
{
  {
    -1,
    (gchar *) "resolved",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_method_info_resolve_extension_OUT_ARG_pointers[] =
{
  &_ipc_flatpak_service_method_info_resolve_extension_OUT_ARG_resolved.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_flatpak_service_method_info_resolve_extension =
{
  {
    -1,
    (gchar *) "ResolveExtension",
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_resolve_extension_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_flatpak_service_method_info_resolve_extension_OUT_ARG_pointers,
    NULL
  },
  "handle-resolve-extension",
  FALSE
};

static const GDBusMethodInfo * const _ipc_flatpak_service_method_info_pointers[] =
{
  &_ipc_flatpak_service_method_info_add_installation.parent_struct,
  &_ipc_flatpak_service_method_info_list_runtimes.parent_struct,
  &_ipc_flatpak_service_method_info_get_runtime.parent_struct,
  &_ipc_flatpak_service_method_info_runtime_is_known.parent_struct,
  &_ipc_flatpak_service_method_info_install.parent_struct,
  &_ipc_flatpak_service_method_info_resolve_extension.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_flatpak_service_signal_info_runtime_added_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "(sssssssb)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_flatpak_service_signal_info_runtime_added_ARG_pointers[] =
{
  &_ipc_flatpak_service_signal_info_runtime_added_ARG_runtime.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_flatpak_service_signal_info_runtime_added =
{
  {
    -1,
    (gchar *) "RuntimeAdded",
    (GDBusArgInfo **) &_ipc_flatpak_service_signal_info_runtime_added_ARG_pointers,
    NULL
  },
  "runtime-added"
};

static const GDBusSignalInfo * const _ipc_flatpak_service_signal_info_pointers[] =
{
  &_ipc_flatpak_service_signal_info_runtime_added.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ipc_flatpak_service_property_info_config_dir =
{
  {
    -1,
    (gchar *) "ConfigDir",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "config-dir",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_flatpak_service_property_info_default_arch =
{
  {
    -1,
    (gchar *) "DefaultArch",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "default-arch",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ipc_flatpak_service_property_info_pointers[] =
{
  &_ipc_flatpak_service_property_info_config_dir.parent_struct,
  &_ipc_flatpak_service_property_info_default_arch.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ipc_flatpak_service_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Builder.Flatpak.Service",
    (GDBusMethodInfo **) &_ipc_flatpak_service_method_info_pointers,
    (GDBusSignalInfo **) &_ipc_flatpak_service_signal_info_pointers,
    (GDBusPropertyInfo **) &_ipc_flatpak_service_property_info_pointers,
    NULL
  },
  "flatpak-service",
};


/**
 * ipc_flatpak_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ipc_flatpak_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ipc_flatpak_service_interface_info.parent_struct;
}

/**
 * ipc_flatpak_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IpcFlatpakService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ipc_flatpak_service_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "config-dir");
  g_object_class_override_property (klass, property_id_begin++, "default-arch");
  return property_id_begin - 1;
}



/**
 * IpcFlatpakService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link>.
 */

/**
 * IpcFlatpakServiceIface:
 * @parent_iface: The parent interface.
 * @handle_add_installation: Handler for the #IpcFlatpakService::handle-add-installation signal.
 * @handle_get_runtime: Handler for the #IpcFlatpakService::handle-get-runtime signal.
 * @handle_install: Handler for the #IpcFlatpakService::handle-install signal.
 * @handle_list_runtimes: Handler for the #IpcFlatpakService::handle-list-runtimes signal.
 * @handle_resolve_extension: Handler for the #IpcFlatpakService::handle-resolve-extension signal.
 * @handle_runtime_is_known: Handler for the #IpcFlatpakService::handle-runtime-is-known signal.
 * @get_config_dir: Getter for the #IpcFlatpakService:config-dir property.
 * @get_default_arch: Getter for the #IpcFlatpakService:default-arch property.
 * @runtime_added: Handler for the #IpcFlatpakService::runtime-added signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link>.
 */

typedef IpcFlatpakServiceIface IpcFlatpakServiceInterface;
G_DEFINE_INTERFACE (IpcFlatpakService, ipc_flatpak_service, G_TYPE_OBJECT)

static void
ipc_flatpak_service_default_init (IpcFlatpakServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IpcFlatpakService::handle-add-installation:
   * @object: A #IpcFlatpakService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_is_user: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.AddInstallation">AddInstallation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_flatpak_service_complete_add_installation() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-installation",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, handle_add_installation),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * IpcFlatpakService::handle-list-runtimes:
   * @object: A #IpcFlatpakService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ListRuntimes">ListRuntimes()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_flatpak_service_complete_list_runtimes() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-runtimes",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, handle_list_runtimes),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcFlatpakService::handle-get-runtime:
   * @object: A #IpcFlatpakService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.GetRuntime">GetRuntime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_flatpak_service_complete_get_runtime() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-runtime",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, handle_get_runtime),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcFlatpakService::handle-runtime-is-known:
   * @object: A #IpcFlatpakService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.RuntimeIsKnown">RuntimeIsKnown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_flatpak_service_complete_runtime_is_known() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-runtime-is-known",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, handle_runtime_is_known),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcFlatpakService::handle-install:
   * @object: A #IpcFlatpakService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_full_ref_name: Argument passed by remote caller.
   * @arg_if_not_exists: Argument passed by remote caller.
   * @arg_transfer: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.Install">Install()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_flatpak_service_complete_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, handle_install),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * IpcFlatpakService::handle-resolve-extension:
   * @object: A #IpcFlatpakService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_sdk: Argument passed by remote caller.
   * @arg_extension: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ResolveExtension">ResolveExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_flatpak_service_complete_resolve_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-resolve-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, handle_resolve_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * IpcFlatpakService::runtime-added:
   * @object: A #IpcFlatpakService.
   * @arg_runtime: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Builder-Flatpak-Service.RuntimeAdded">"RuntimeAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("runtime-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcFlatpakServiceIface, runtime_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * IpcFlatpakService:config-dir:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.ConfigDir">"ConfigDir"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("config-dir", "ConfigDir", "ConfigDir", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcFlatpakService:default-arch:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.DefaultArch">"DefaultArch"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("default-arch", "DefaultArch", "DefaultArch", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ipc_flatpak_service_get_config_dir: (skip)
 * @object: A #IpcFlatpakService.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.ConfigDir">"ConfigDir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_flatpak_service_dup_config_dir() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_flatpak_service_get_config_dir (IpcFlatpakService *object)
{
  return IPC_FLATPAK_SERVICE_GET_IFACE (object)->get_config_dir (object);
}

/**
 * ipc_flatpak_service_dup_config_dir: (skip)
 * @object: A #IpcFlatpakService.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.ConfigDir">"ConfigDir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_flatpak_service_dup_config_dir (IpcFlatpakService *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "config-dir", &value, NULL);
  return value;
}

/**
 * ipc_flatpak_service_set_config_dir: (skip)
 * @object: A #IpcFlatpakService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.ConfigDir">"ConfigDir"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_flatpak_service_set_config_dir (IpcFlatpakService *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "config-dir", value, NULL);
}

/**
 * ipc_flatpak_service_get_default_arch: (skip)
 * @object: A #IpcFlatpakService.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.DefaultArch">"DefaultArch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_flatpak_service_dup_default_arch() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_flatpak_service_get_default_arch (IpcFlatpakService *object)
{
  return IPC_FLATPAK_SERVICE_GET_IFACE (object)->get_default_arch (object);
}

/**
 * ipc_flatpak_service_dup_default_arch: (skip)
 * @object: A #IpcFlatpakService.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.DefaultArch">"DefaultArch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_flatpak_service_dup_default_arch (IpcFlatpakService *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "default-arch", &value, NULL);
  return value;
}

/**
 * ipc_flatpak_service_set_default_arch: (skip)
 * @object: A #IpcFlatpakService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Builder-Flatpak-Service.DefaultArch">"DefaultArch"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_flatpak_service_set_default_arch (IpcFlatpakService *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "default-arch", value, NULL);
}

/**
 * ipc_flatpak_service_emit_runtime_added:
 * @object: A #IpcFlatpakService.
 * @arg_runtime: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Builder-Flatpak-Service.RuntimeAdded">"RuntimeAdded"</link> D-Bus signal.
 */
void
ipc_flatpak_service_emit_runtime_added (
    IpcFlatpakService *object,
    GVariant *arg_runtime)
{
  g_signal_emit_by_name (object, "runtime-added", arg_runtime);
}

/**
 * ipc_flatpak_service_call_add_installation:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_is_user: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.AddInstallation">AddInstallation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_call_add_installation_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_call_add_installation_sync() for the synchronous, blocking version of this method.
 */
void
ipc_flatpak_service_call_add_installation (
    IpcFlatpakService *proxy,
    const gchar *arg_path,
    gboolean arg_is_user,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddInstallation",
    g_variant_new ("(^ayb)",
                   arg_path,
                   arg_is_user),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_flatpak_service_call_add_installation_finish:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_call_add_installation().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_flatpak_service_call_add_installation().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_add_installation_finish (
    IpcFlatpakService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_add_installation_sync:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_is_user: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.AddInstallation">AddInstallation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_call_add_installation() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_add_installation_sync (
    IpcFlatpakService *proxy,
    const gchar *arg_path,
    gboolean arg_is_user,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddInstallation",
    g_variant_new ("(^ayb)",
                   arg_path,
                   arg_is_user),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_list_runtimes:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ListRuntimes">ListRuntimes()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_call_list_runtimes_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_call_list_runtimes_sync() for the synchronous, blocking version of this method.
 */
void
ipc_flatpak_service_call_list_runtimes (
    IpcFlatpakService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListRuntimes",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_flatpak_service_call_list_runtimes_finish:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @out_runtimes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_call_list_runtimes().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_flatpak_service_call_list_runtimes().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_list_runtimes_finish (
    IpcFlatpakService *proxy,
    GVariant **out_runtimes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sssssssb))",
                 out_runtimes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_list_runtimes_sync:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @out_runtimes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ListRuntimes">ListRuntimes()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_call_list_runtimes() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_list_runtimes_sync (
    IpcFlatpakService *proxy,
    GVariant **out_runtimes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListRuntimes",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sssssssb))",
                 out_runtimes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_get_runtime:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.GetRuntime">GetRuntime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_call_get_runtime_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_call_get_runtime_sync() for the synchronous, blocking version of this method.
 */
void
ipc_flatpak_service_call_get_runtime (
    IpcFlatpakService *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRuntime",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_flatpak_service_call_get_runtime_finish:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @out_runtime: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_call_get_runtime().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_flatpak_service_call_get_runtime().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_get_runtime_finish (
    IpcFlatpakService *proxy,
    GVariant **out_runtime,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(sssssssb))",
                 out_runtime);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_get_runtime_sync:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_runtime: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.GetRuntime">GetRuntime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_call_get_runtime() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_get_runtime_sync (
    IpcFlatpakService *proxy,
    const gchar *arg_id,
    GVariant **out_runtime,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRuntime",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(sssssssb))",
                 out_runtime);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_runtime_is_known:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.RuntimeIsKnown">RuntimeIsKnown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_call_runtime_is_known_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_call_runtime_is_known_sync() for the synchronous, blocking version of this method.
 */
void
ipc_flatpak_service_call_runtime_is_known (
    IpcFlatpakService *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RuntimeIsKnown",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_flatpak_service_call_runtime_is_known_finish:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @out_is_known: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_download_size: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_call_runtime_is_known().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_flatpak_service_call_runtime_is_known().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_runtime_is_known_finish (
    IpcFlatpakService *proxy,
    gboolean *out_is_known,
    gint64 *out_download_size,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bx)",
                 out_is_known,
                 out_download_size);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_runtime_is_known_sync:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_is_known: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_download_size: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.RuntimeIsKnown">RuntimeIsKnown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_call_runtime_is_known() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_runtime_is_known_sync (
    IpcFlatpakService *proxy,
    const gchar *arg_name,
    gboolean *out_is_known,
    gint64 *out_download_size,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RuntimeIsKnown",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bx)",
                 out_is_known,
                 out_download_size);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_install:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_full_ref_name: Argument to pass with the method invocation.
 * @arg_if_not_exists: Argument to pass with the method invocation.
 * @arg_transfer: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.Install">Install()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_call_install_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_call_install_sync() for the synchronous, blocking version of this method.
 */
void
ipc_flatpak_service_call_install (
    IpcFlatpakService *proxy,
    const gchar *const *arg_full_ref_name,
    gboolean arg_if_not_exists,
    const gchar *arg_transfer,
    const gchar *arg_parent_window,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(^asbos)",
                   arg_full_ref_name,
                   arg_if_not_exists,
                   arg_transfer,
                   arg_parent_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_flatpak_service_call_install_finish:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_call_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_flatpak_service_call_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_install_finish (
    IpcFlatpakService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_install_sync:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_full_ref_name: Argument to pass with the method invocation.
 * @arg_if_not_exists: Argument to pass with the method invocation.
 * @arg_transfer: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.Install">Install()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_call_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_install_sync (
    IpcFlatpakService *proxy,
    const gchar *const *arg_full_ref_name,
    gboolean arg_if_not_exists,
    const gchar *arg_transfer,
    const gchar *arg_parent_window,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(^asbos)",
                   arg_full_ref_name,
                   arg_if_not_exists,
                   arg_transfer,
                   arg_parent_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_resolve_extension:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_sdk: Argument to pass with the method invocation.
 * @arg_extension: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ResolveExtension">ResolveExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_call_resolve_extension_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_call_resolve_extension_sync() for the synchronous, blocking version of this method.
 */
void
ipc_flatpak_service_call_resolve_extension (
    IpcFlatpakService *proxy,
    const gchar *arg_sdk,
    const gchar *arg_extension,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResolveExtension",
    g_variant_new ("(ss)",
                   arg_sdk,
                   arg_extension),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_flatpak_service_call_resolve_extension_finish:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @out_resolved: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_call_resolve_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_flatpak_service_call_resolve_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_resolve_extension_finish (
    IpcFlatpakService *proxy,
    gchar **out_resolved,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_resolved);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_call_resolve_extension_sync:
 * @proxy: A #IpcFlatpakServiceProxy.
 * @arg_sdk: Argument to pass with the method invocation.
 * @arg_extension: Argument to pass with the method invocation.
 * @out_resolved: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ResolveExtension">ResolveExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_call_resolve_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_flatpak_service_call_resolve_extension_sync (
    IpcFlatpakService *proxy,
    const gchar *arg_sdk,
    const gchar *arg_extension,
    gchar **out_resolved,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResolveExtension",
    g_variant_new ("(ss)",
                   arg_sdk,
                   arg_extension),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_resolved);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_flatpak_service_complete_add_installation:
 * @object: A #IpcFlatpakService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.AddInstallation">AddInstallation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_flatpak_service_complete_add_installation (
    IpcFlatpakService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_flatpak_service_complete_list_runtimes:
 * @object: A #IpcFlatpakService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @runtimes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ListRuntimes">ListRuntimes()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_flatpak_service_complete_list_runtimes (
    IpcFlatpakService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *runtimes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sssssssb))",
                   runtimes));
}

/**
 * ipc_flatpak_service_complete_get_runtime:
 * @object: A #IpcFlatpakService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @runtime: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.GetRuntime">GetRuntime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_flatpak_service_complete_get_runtime (
    IpcFlatpakService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *runtime)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(sssssssb))",
                   runtime));
}

/**
 * ipc_flatpak_service_complete_runtime_is_known:
 * @object: A #IpcFlatpakService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_known: Parameter to return.
 * @download_size: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.RuntimeIsKnown">RuntimeIsKnown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_flatpak_service_complete_runtime_is_known (
    IpcFlatpakService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_known,
    gint64 download_size)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bx)",
                   is_known,
                   download_size));
}

/**
 * ipc_flatpak_service_complete_install:
 * @object: A #IpcFlatpakService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.Install">Install()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_flatpak_service_complete_install (
    IpcFlatpakService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_flatpak_service_complete_resolve_extension:
 * @object: A #IpcFlatpakService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @resolved: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Flatpak-Service.ResolveExtension">ResolveExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_flatpak_service_complete_resolve_extension (
    IpcFlatpakService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *resolved)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   resolved));
}

/* ------------------------------------------------------------------------ */

/**
 * IpcFlatpakServiceProxy:
 *
 * The #IpcFlatpakServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcFlatpakServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcFlatpakServiceProxy.
 */

struct _IpcFlatpakServiceProxyPrivate
{
  GData *qdata;
};

static void ipc_flatpak_service_proxy_iface_init (IpcFlatpakServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcFlatpakServiceProxy, ipc_flatpak_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IpcFlatpakServiceProxy)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_FLATPAK_SERVICE, ipc_flatpak_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcFlatpakServiceProxy, ipc_flatpak_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_FLATPAK_SERVICE, ipc_flatpak_service_proxy_iface_init))

#endif
static void
ipc_flatpak_service_proxy_finalize (GObject *object)
{
  IpcFlatpakServiceProxy *proxy = IPC_FLATPAK_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ipc_flatpak_service_proxy_parent_class)->finalize (object);
}

static void
ipc_flatpak_service_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_flatpak_service_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ipc_flatpak_service_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Builder.Flatpak.Service: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ipc_flatpak_service_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_flatpak_service_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Builder.Flatpak.Service", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ipc_flatpak_service_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ipc_flatpak_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ipc_flatpak_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IPC_TYPE_FLATPAK_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_FLATPAK_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ipc_flatpak_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IpcFlatpakServiceProxy *proxy = IPC_FLATPAK_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_flatpak_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_flatpak_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
ipc_flatpak_service_proxy_get_config_dir (IpcFlatpakService *object)
{
  IpcFlatpakServiceProxy *proxy = IPC_FLATPAK_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConfigDir");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ipc_flatpak_service_proxy_get_default_arch (IpcFlatpakService *object)
{
  IpcFlatpakServiceProxy *proxy = IPC_FLATPAK_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultArch");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
ipc_flatpak_service_proxy_init (IpcFlatpakServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ipc_flatpak_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IPC_TYPE_FLATPAK_SERVICE_PROXY, IpcFlatpakServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ipc_flatpak_service_interface_info ());
}

static void
ipc_flatpak_service_proxy_class_init (IpcFlatpakServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ipc_flatpak_service_proxy_finalize;
  gobject_class->get_property = ipc_flatpak_service_proxy_get_property;
  gobject_class->set_property = ipc_flatpak_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ipc_flatpak_service_proxy_g_signal;
  proxy_class->g_properties_changed = ipc_flatpak_service_proxy_g_properties_changed;

  ipc_flatpak_service_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcFlatpakServiceProxyPrivate));
#endif
}

static void
ipc_flatpak_service_proxy_iface_init (IpcFlatpakServiceIface *iface)
{
  iface->get_config_dir = ipc_flatpak_service_proxy_get_config_dir;
  iface->get_default_arch = ipc_flatpak_service_proxy_get_default_arch;
}

/**
 * ipc_flatpak_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_proxy_new_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_flatpak_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_FLATPAK_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Flatpak.Service", NULL);
}

/**
 * ipc_flatpak_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_flatpak_service_proxy_new().
 *
 * Returns: (transfer full) (type IpcFlatpakServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcFlatpakService *
ipc_flatpak_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_FLATPAK_SERVICE (ret);
  else
    return NULL;
}

/**
 * ipc_flatpak_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcFlatpakServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcFlatpakService *
ipc_flatpak_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_FLATPAK_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Flatpak.Service", NULL);
  if (ret != NULL)
    return IPC_FLATPAK_SERVICE (ret);
  else
    return NULL;
}


/**
 * ipc_flatpak_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ipc_flatpak_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_flatpak_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ipc_flatpak_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_flatpak_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_FLATPAK_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Flatpak.Service", NULL);
}

/**
 * ipc_flatpak_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_flatpak_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_flatpak_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IpcFlatpakServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcFlatpakService *
ipc_flatpak_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_FLATPAK_SERVICE (ret);
  else
    return NULL;
}

/**
 * ipc_flatpak_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ipc_flatpak_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_flatpak_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcFlatpakServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcFlatpakService *
ipc_flatpak_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_FLATPAK_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Flatpak.Service", NULL);
  if (ret != NULL)
    return IPC_FLATPAK_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IpcFlatpakServiceSkeleton:
 *
 * The #IpcFlatpakServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcFlatpakServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcFlatpakServiceSkeleton.
 */

struct _IpcFlatpakServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ipc_flatpak_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IPC_TYPE_FLATPAK_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_FLATPAK_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ipc_flatpak_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_flatpak_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ipc_flatpak_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_flatpak_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ipc_flatpak_service_skeleton_vtable =
{
  _ipc_flatpak_service_skeleton_handle_method_call,
  _ipc_flatpak_service_skeleton_handle_get_property,
  _ipc_flatpak_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ipc_flatpak_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ipc_flatpak_service_interface_info ();
}

static GDBusInterfaceVTable *
ipc_flatpak_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ipc_flatpak_service_skeleton_vtable;
}

static GVariant *
ipc_flatpak_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ipc_flatpak_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ipc_flatpak_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ipc_flatpak_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ipc_flatpak_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Builder.Flatpak.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ipc_flatpak_service_emit_changed (gpointer user_data);

static void
ipc_flatpak_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ipc_flatpak_service_emit_changed (skeleton);
}

static void
_ipc_flatpak_service_on_signal_runtime_added (
    IpcFlatpakService *object,
    GVariant *arg_runtime)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@(sssssssb))",
                   arg_runtime));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Builder.Flatpak.Service", "RuntimeAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ipc_flatpak_service_skeleton_iface_init (IpcFlatpakServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcFlatpakServiceSkeleton, ipc_flatpak_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IpcFlatpakServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_FLATPAK_SERVICE, ipc_flatpak_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcFlatpakServiceSkeleton, ipc_flatpak_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_FLATPAK_SERVICE, ipc_flatpak_service_skeleton_iface_init))

#endif
static void
ipc_flatpak_service_skeleton_finalize (GObject *object)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ipc_flatpak_service_skeleton_parent_class)->finalize (object);
}

static void
ipc_flatpak_service_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ipc_flatpak_service_emit_changed (gpointer user_data)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Builder.Flatpak.Service",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ipc_flatpak_service_schedule_emit_changed (IpcFlatpakServiceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ipc_flatpak_service_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ipc_flatpak_service_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ipc_flatpak_service_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ipc_flatpak_service_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_flatpak_service_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ipc_flatpak_service_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ipc_flatpak_service_skeleton_init (IpcFlatpakServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ipc_flatpak_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IPC_TYPE_FLATPAK_SERVICE_SKELETON, IpcFlatpakServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static const gchar *
ipc_flatpak_service_skeleton_get_config_dir (IpcFlatpakService *object)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ipc_flatpak_service_skeleton_get_default_arch (IpcFlatpakService *object)
{
  IpcFlatpakServiceSkeleton *skeleton = IPC_FLATPAK_SERVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ipc_flatpak_service_skeleton_class_init (IpcFlatpakServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ipc_flatpak_service_skeleton_finalize;
  gobject_class->get_property = ipc_flatpak_service_skeleton_get_property;
  gobject_class->set_property = ipc_flatpak_service_skeleton_set_property;
  gobject_class->notify       = ipc_flatpak_service_skeleton_notify;


  ipc_flatpak_service_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ipc_flatpak_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ipc_flatpak_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ipc_flatpak_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ipc_flatpak_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcFlatpakServiceSkeletonPrivate));
#endif
}

static void
ipc_flatpak_service_skeleton_iface_init (IpcFlatpakServiceIface *iface)
{
  iface->runtime_added = _ipc_flatpak_service_on_signal_runtime_added;
  iface->get_config_dir = ipc_flatpak_service_skeleton_get_config_dir;
  iface->get_default_arch = ipc_flatpak_service_skeleton_get_default_arch;
}

/**
 * ipc_flatpak_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Flatpak-Service.top_of_page">org.gnome.Builder.Flatpak.Service</link>.
 *
 * Returns: (transfer full) (type IpcFlatpakServiceSkeleton): The skeleton object.
 */
IpcFlatpakService *
ipc_flatpak_service_skeleton_new (void)
{
  return IPC_FLATPAK_SERVICE (g_object_new (IPC_TYPE_FLATPAK_SERVICE_SKELETON, NULL));
}

