/* gcalccmd.c generated by valac 0.56.1, the Vala compiler
 * generated from gcalccmd.vala, do not modify */

/*
 * Copyright (C) 2009 Rich Burridge
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <stdio.h>
#include <locale.h>
#include <gio/gio.h>

#define MAXLINE 1024
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN Serializer* result_serializer;
Serializer* result_serializer = NULL;

VALA_EXTERN void solve (const gchar* equation);
static gint _vala_main (gchar** args,
                 gint args_length1);

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
solve (const gchar* equation)
{
	gchar* tsep_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* decimal = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* error_token = NULL;
	ConvertEquation* e = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ConvertEquation* _tmp16_;
	ConvertEquation* _tmp17_;
	ConvertEquation* _tmp18_;
	ConvertEquation* _tmp19_;
	ConvertEquation* _tmp20_;
	ErrorCode ret = 0;
	guint representation_base = 0U;
	Number* z = NULL;
	ConvertEquation* _tmp21_;
	guint _tmp22_ = 0U;
	ErrorCode _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	Number* _tmp25_;
	Serializer* _tmp26_;
	Number* _tmp27_;
	g_return_if_fail (equation != NULL);
	_tmp0_ = nl_langinfo (THOUSEP);
	_tmp1_ = g_strdup (_tmp0_);
	tsep_string = _tmp1_;
	_tmp3_ = tsep_string;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = tsep_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (" ");
		_g_free0 (tsep_string);
		tsep_string = _tmp5_;
	}
	_tmp6_ = nl_langinfo (RADIXCHAR);
	_tmp7_ = g_strdup (_tmp6_);
	decimal = _tmp7_;
	_tmp8_ = decimal;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (decimal);
		decimal = _tmp9_;
	}
	error_token = NULL;
	_tmp10_ = tsep_string;
	_tmp11_ = string_replace (equation, _tmp10_, "");
	_tmp12_ = _tmp11_;
	_tmp13_ = decimal;
	_tmp14_ = string_replace (_tmp12_, _tmp13_, ".");
	_tmp15_ = _tmp14_;
	_tmp16_ = convert_equation_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	e = _tmp17_;
	_tmp18_ = e;
	((Equation*) _tmp18_)->base = 10;
	_tmp19_ = e;
	((Equation*) _tmp19_)->wordlen = 32;
	_tmp20_ = e;
	((Equation*) _tmp20_)->angle_units = ANGLE_UNIT_DEGREES;
	_tmp21_ = e;
	_tmp25_ = equation_parse ((Equation*) _tmp21_, &_tmp22_, &_tmp23_, &_tmp24_, NULL, NULL);
	representation_base = _tmp22_;
	ret = _tmp23_;
	_g_free0 (error_token);
	error_token = _tmp24_;
	z = _tmp25_;
	_tmp26_ = result_serializer;
	serializer_set_representation_base (_tmp26_, representation_base);
	_tmp27_ = z;
	if (_tmp27_ != NULL) {
		gchar* str = NULL;
		Serializer* _tmp28_;
		Number* _tmp29_;
		gchar* _tmp30_;
		Serializer* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = result_serializer;
		_tmp29_ = z;
		_tmp30_ = serializer_to_string (_tmp28_, _tmp29_);
		str = _tmp30_;
		_tmp31_ = result_serializer;
		_tmp32_ = serializer_get_error (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_ != NULL) {
			FILE* _tmp34_;
			Serializer* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			Serializer* _tmp38_;
			_tmp34_ = stderr;
			_tmp35_ = result_serializer;
			_tmp36_ = serializer_get_error (_tmp35_);
			_tmp37_ = _tmp36_;
			fprintf (_tmp34_, "%s\n", _tmp37_);
			_tmp38_ = result_serializer;
			serializer_set_error (_tmp38_, NULL);
		} else {
			FILE* _tmp39_;
			const gchar* _tmp40_;
			_tmp39_ = stdout;
			_tmp40_ = str;
			fprintf (_tmp39_, "%s\n", _tmp40_);
		}
		_g_free0 (str);
	} else {
		if (ret == ERROR_CODE_MP) {
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			FILE* _tmp47_;
			_tmp42_ = number_get_error ();
			_tmp43_ = _tmp42_;
			if (_tmp43_ != NULL) {
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				_tmp44_ = number_get_error ();
				_tmp45_ = _tmp44_;
				_tmp41_ = _tmp45_;
			} else {
				const gchar* _tmp46_;
				_tmp46_ = error_token;
				_tmp41_ = _tmp46_;
			}
			_tmp47_ = stderr;
			fprintf (_tmp47_, "Error %s\n", _tmp41_);
		} else {
			FILE* _tmp48_;
			_tmp48_ = stderr;
			fprintf (_tmp48_, "Error %d\n", (gint) ret);
		}
	}
	_g_object_unref0 (z);
	_g_object_unref0 (e);
	_g_free0 (error_token);
	_g_free0 (decimal);
	_g_free0 (tsep_string);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gboolean requires_new_line = FALSE;
	GDateTime* _tmp1_;
	Serializer* _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	CurrencyManager* _tmp4_;
	CurrencyManager* _tmp5_;
	GSettings* _tmp6_;
	CurrencyManager* _tmp7_;
	CurrencyManager* _tmp8_;
	gchar* buffer = NULL;
	gchar* _tmp10_;
	gint buffer_length1;
	gint _buffer_size_;
	gint result;
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	requires_new_line = FALSE;
	_tmp1_ = now;
	g_random_set_seed ((guint32) g_date_time_get_microsecond (_tmp1_));
	setlocale (LC_ALL, "");
	_tmp2_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	_g_object_unref0 (result_serializer);
	result_serializer = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.calculator");
	settings = _tmp3_;
	_tmp4_ = currency_manager_get_default (FALSE, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = settings;
	currency_manager_set_refresh_interval (_tmp5_, g_settings_get_int (_tmp6_, "refresh-interval"));
	_g_object_unref0 (_tmp5_);
	_tmp7_ = currency_manager_get_default (FALSE, TRUE);
	_tmp8_ = _tmp7_;
	currency_manager_refresh_sync (_tmp8_);
	_g_object_unref0 (_tmp8_);
	if (args_length1 == 2) {
		const gchar* _tmp9_;
		_tmp9_ = args[1];
		solve (_tmp9_);
		result = EXIT_SUCCESS;
		_g_object_unref0 (settings);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp10_ = g_new0 (gchar, 1024);
	buffer = _tmp10_;
	buffer_length1 = 1024;
	_buffer_size_ = buffer_length1;
	while (TRUE) {
		FILE* _tmp11_;
		gchar* line = NULL;
		FILE* _tmp12_;
		gchar* _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		const gchar* _tmp26_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "> ");
		_tmp12_ = stdin;
		_tmp13_ = buffer;
		_tmp13__length1 = buffer_length1;
		_tmp14_ = fgets (_tmp13_, (gint) _tmp13__length1, _tmp12_);
		_tmp15_ = g_strdup (_tmp14_);
		line = _tmp15_;
		_tmp16_ = line;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = line;
			_tmp18_ = string_strip (_tmp17_);
			_g_free0 (line);
			line = _tmp18_;
		} else {
			requires_new_line = TRUE;
		}
		_tmp22_ = line;
		if (_tmp22_ == NULL) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp23_;
			_tmp23_ = line;
			_tmp21_ = g_strcmp0 (_tmp23_, "exit") == 0;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			const gchar* _tmp24_;
			_tmp24_ = line;
			_tmp20_ = g_strcmp0 (_tmp24_, "quit") == 0;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			const gchar* _tmp25_;
			_tmp25_ = line;
			_tmp19_ = g_strcmp0 (_tmp25_, "") == 0;
		}
		if (_tmp19_) {
			_g_free0 (line);
			break;
		}
		_tmp26_ = line;
		solve (_tmp26_);
		_g_free0 (line);
	}
	if (requires_new_line) {
		FILE* _tmp27_;
		_tmp27_ = stdout;
		fprintf (_tmp27_, "\n");
	}
	result = EXIT_SUCCESS;
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (settings);
	_g_date_time_unref0 (now);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

