/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.ManifestAttributesChecker;
import net.sourceforge.jnlp.runtime.Translator;

public class BasicValueValidators {
    private static final String DELIMITER = ",";

    public static String[] splitCombination(String val) {
        return val.split(DELIMITER);
    }

    public static ValueValidator getBooleanValidator() {
        return new BooleanValidator();
    }

    public static ValueValidator getFilePathValidator() {
        return new FilePathValidator();
    }

    public static ValueValidator getBrowserPathValidator() {
        return new ValueValidator(){

            @Override
            public void validate(Object value) throws IllegalArgumentException {
                if (value == null) {
                    return;
                }
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("Value should be string!");
                }
                if (BasicValueValidators.verifyFileOrCommand((String)value) == null) {
                    throw new IllegalArgumentException("Value should be file, or on PATH, or known keyword. See possible values.");
                }
            }

            @Override
            public String getPossibleValues() {
                return Translator.VVPossibleBrowserValues();
            }
        };
    }

    public static String verifyFileOrCommand(String cmd) {
        if ((cmd = cmd.split("\\s+")[0]).equals("ALWAYS-ASK") || cmd.equals("INTERNAL-HTML")) {
            return "keyword";
        }
        File fileCandidate = new File(cmd);
        if (fileCandidate.exists() && !fileCandidate.isDirectory()) {
            return cmd;
        }
        String path = System.getenv("PATH");
        if (path != null) {
            String[] pathMembers;
            for (String s : pathMembers = path.split(File.pathSeparator)) {
                File pathCandidate = new File(s, cmd);
                if (!pathCandidate.exists() || pathCandidate.isDirectory()) continue;
                return pathCandidate.toString();
            }
        }
        return null;
    }

    public static ValueValidator getRangedIntegerValidator(int low, int high) {
        return new RangedIntegerValidator(low, high);
    }

    public static ValueValidator getStringValidator(String[] validValues) {
        return new StringValueValidator(validValues);
    }

    public static ValueValidator getMultipleStringValidator(String[] singleValues, String[] comboValues) {
        return new MultipleStringValueValidator(singleValues, comboValues);
    }

    public static ValueValidator getManifestAttributeCheckValidator() {
        return new ManifestAttributeCheckValidator();
    }

    public static ValueValidator getUrlValidator() {
        return new UrlValidator();
    }

    private static class UrlValidator
    implements ValueValidator {
        private UrlValidator() {
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            if (value == null) {
                return;
            }
            try {
                new URL((String)value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleUrlValues");
        }
    }

    private static class ManifestAttributeCheckValidator
    extends MultipleStringValueValidator {
        public ManifestAttributeCheckValidator() {
            super(new String[]{ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.ALL.toString(), ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.NONE.toString()}, new String[]{ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.ALAC.toString(), ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.CODEBASE.toString(), ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.ENTRYPOINT.toString(), ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.PERMISSIONS.toString(), ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.TRUSTED.toString()});
        }
    }

    public static class RustCpValidator
    implements ValueValidator {
        @Override
        public void validate(Object value) throws IllegalArgumentException {
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVRustCpModifiers");
        }
    }

    private static class MultipleStringValueValidator
    implements ValueValidator {
        private final String[] singleOptions;
        private final String[] comboOptions;

        public MultipleStringValueValidator(String[] singleOptions, String[] comboOptions) {
            this.singleOptions = singleOptions;
            this.comboOptions = comboOptions;
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            Object possibleValue = value;
            if (!(possibleValue instanceof String)) {
                throw new IllegalArgumentException("Must be a string");
            }
            String stringVal = (String)possibleValue;
            boolean found = false;
            for (String knownVal : this.singleOptions) {
                if (!knownVal.equals(stringVal)) continue;
                found = true;
                break;
            }
            if (!found) {
                String[] possibleCombo;
                for (String val : possibleCombo = BasicValueValidators.splitCombination(stringVal)) {
                    if (!this.comboOptionsContains(val)) {
                        throw new IllegalArgumentException();
                    }
                    found = true;
                }
            }
            if (!found) {
                throw new IllegalArgumentException();
            }
        }

        private boolean comboOptionsContains(String possibleVal) {
            for (String value : this.comboOptions) {
                if (!value.equals(possibleVal)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getPossibleValues() {
            String message = "(Values that can be used alone only): " + Arrays.toString(this.singleOptions) + " (Values that can be used in combination separated by the delimiter \"" + BasicValueValidators.DELIMITER + "\" with no space expected ): " + Arrays.toString(this.comboOptions);
            return message;
        }
    }

    private static class StringValueValidator
    implements ValueValidator {
        String[] options = null;

        public StringValueValidator(String[] acceptableOptions) {
            this.options = acceptableOptions;
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            Object possibleValue = value;
            if (!(possibleValue instanceof String)) {
                throw new IllegalArgumentException("Must be a string");
            }
            String stringVal = (String)possibleValue;
            boolean found = false;
            for (String knownVal : this.options) {
                if (!knownVal.equals(stringVal)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Arrays.toString(this.options);
        }
    }

    private static class RangedIntegerValidator
    implements ValueValidator {
        private int low = 0;
        private int high = 0;

        public RangedIntegerValidator(int low, int high) {
            this.low = low;
            this.high = high;
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            long actualValue;
            block6: {
                Object possibleValue = value;
                actualValue = 0L;
                try {
                    if (possibleValue instanceof String) {
                        actualValue = Long.valueOf((String)possibleValue);
                        break block6;
                    }
                    if (possibleValue instanceof Integer) {
                        actualValue = ((Integer)possibleValue).intValue();
                        break block6;
                    }
                    if (possibleValue instanceof Long) {
                        actualValue = (Long)possibleValue;
                        break block6;
                    }
                    throw new IllegalArgumentException("Must be an integer");
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Must be an integer");
                }
            }
            if (actualValue < (long)this.low || actualValue > (long)this.high) {
                throw new IllegalArgumentException("Not in range from " + this.low + " to " + this.high);
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleRangedIntegerValues", this.low, this.high);
        }
    }

    static class FilePathValidator
    implements ValueValidator {
        FilePathValidator() {
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            if (value == null) {
                return;
            }
            Object possibleValue = value;
            if (!(possibleValue instanceof String)) {
                throw new IllegalArgumentException("Value should be string!");
            }
            String possibleFile = (String)possibleValue;
            boolean absolute = new File(possibleFile).isAbsolute();
            if (!absolute) {
                throw new IllegalArgumentException("File must be absolute");
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleFileValues");
        }
    }

    private static class BooleanValidator
    implements ValueValidator {
        private BooleanValidator() {
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            String lower;
            Object possibleValue = value;
            if (possibleValue instanceof String && ((lower = ((String)possibleValue).toLowerCase(Locale.ENGLISH)).equals(Boolean.TRUE.toString()) || lower.equals(Boolean.FALSE.toString()))) {
                possibleValue = Boolean.valueOf(lower);
            }
            if (!(possibleValue instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleBooleanValues", Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
    }
}

