/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JWindow;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.swing.ThreadCheckingRepaintManager;

public final class SwingUtils {
    private static final boolean DEBUG_EDT = System.getProperty("icedtea-web.edt.debug", "false").equalsIgnoreCase("true");
    private static final boolean INFO_DIALOG = false;
    private static final boolean TRACE_INVOKE_EDT = false;
    private static final boolean TRACE_TG = false;
    private static boolean DO_SETUP = true;
    private static final ThreadGroup MAIN_GROUP = Thread.currentThread().getThreadGroup();
    private static Window window = null;

    private SwingUtils() {
    }

    public static void setup() {
        if (DO_SETUP) {
            DO_SETUP = false;
            if (DEBUG_EDT) {
                SwingUtils.trace("Using ThreadCheckingRepaintManager");
                RepaintManager.setCurrentManager(new ThreadCheckingRepaintManager());
            }
        }
    }

    static void trace(String msg) {
        System.err.println(msg);
    }

    static void traceWithStack(String msg) {
        SwingUtils.trace(msg);
        new Throwable().printStackTrace();
    }

    public static void info(Window dialog) {
    }

    public static void checkEDT() {
        if (!SwingUtils.isEventDispatchThread()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, new Exception("EDT violation"));
        }
    }

    private static boolean isMainThreadGroup() {
        Thread t = Thread.currentThread();
        ThreadGroup g = t.getThreadGroup();
        return g == MAIN_GROUP;
    }

    public static Window getWindowAncestor(Component c) {
        return SwingUtilities.getWindowAncestor(c);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void invokeLater(Runnable doRun) {
        if (SwingUtils.isMainThreadGroup()) {
            // empty if block
        }
        EventQueue.invokeLater(doRun);
    }

    public static void invokeRunnableOrEnqueueLater(Runnable runnable) {
        if (SwingUtils.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtils.invokeLater(runnable);
        }
    }

    public static void callOnAppContext(Runnable doRun) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(doRun);
    }

    public static void invokeAndWait(Runnable doRun) {
        if (SwingUtils.isEventDispatchThread()) {
            doRun.run();
        } else {
            try {
                SwingUtils.callOnAppContext(doRun);
            }
            catch (InterruptedException ie) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ie);
            }
            catch (InvocationTargetException ite) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ite);
            }
        }
    }

    public static synchronized Window getOrCreateWindowOwner() {
        if (window == null) {
            SwingUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        window = new JWindow().getOwner();
                        window.setName("getOrCreateWindowOwner");
                    }
                    catch (Exception ex) {
                        OutputController.getLogger().log(ex);
                        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("HEADLESS_MISSCONFIGURED"));
                    }
                }
            });
        }
        return window;
    }
}

