/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.StringTokenizer;

public class DnsUrl
extends Uri {
    private String domain;

    public static DnsUrl[] fromList(String urlList) throws MalformedURLException {
        DnsUrl[] urls = new DnsUrl[(urlList.length() + 1) / 2];
        int i = 0;
        StringTokenizer st = new StringTokenizer(urlList, " ");
        while (st.hasMoreTokens()) {
            urls[i++] = new DnsUrl(st.nextToken());
        }
        DnsUrl[] trimmed = new DnsUrl[i];
        System.arraycopy(urls, 0, trimmed, 0, i);
        return trimmed;
    }

    public DnsUrl(String url) throws MalformedURLException {
        super(url);
        if (!this.scheme.equals("dns")) {
            throw new MalformedURLException(url + " is not a valid DNS pseudo-URL");
        }
        this.domain = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        this.domain = this.domain.equals("") ? "." : UrlUtil.decode(this.domain);
    }

    public String getDomain() {
        return this.domain;
    }
}

