/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.SignedMutableBigInteger;
import java.util.Arrays;

class MutableBigInteger {
    int[] value;
    int intLen;
    int offset = 0;
    static final MutableBigInteger ONE = new MutableBigInteger(1);

    MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int val) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = val;
    }

    MutableBigInteger(int[] val) {
        this.value = val;
        this.intLen = val.length;
    }

    MutableBigInteger(BigInteger b) {
        this.intLen = b.mag.length;
        this.value = Arrays.copyOf(b.mag, this.intLen);
    }

    MutableBigInteger(MutableBigInteger val) {
        this.intLen = val.intLen;
        this.value = Arrays.copyOfRange(val.value, val.offset, val.offset + this.intLen);
    }

    private int[] getMagnitudeArray() {
        if (this.offset > 0 || this.value.length != this.intLen) {
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.intLen);
        }
        return this.value;
    }

    private long toLong() {
        assert (this.intLen <= 2) : "this MutableBigInteger exceeds the range of long";
        if (this.intLen == 0) {
            return 0L;
        }
        long d = (long)this.value[this.offset] & 0xFFFFFFFFL;
        return this.intLen == 2 ? d << 32 | (long)this.value[this.offset + 1] & 0xFFFFFFFFL : d;
    }

    BigInteger toBigInteger(int sign) {
        if (this.intLen == 0 || sign == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.getMagnitudeArray(), sign);
    }

    BigDecimal toBigDecimal(int sign, int scale) {
        if (this.intLen == 0 || sign == 0) {
            return BigDecimal.valueOf(0L, scale);
        }
        int[] mag = this.getMagnitudeArray();
        int len = mag.length;
        int d = mag[0];
        if (len > 2 || d < 0 && len == 2) {
            return new BigDecimal(new BigInteger(mag, sign), Long.MIN_VALUE, scale, 0);
        }
        long v = len == 2 ? (long)mag[1] & 0xFFFFFFFFL | ((long)d & 0xFFFFFFFFL) << 32 : (long)d & 0xFFFFFFFFL;
        return new BigDecimal(null, sign == -1 ? -v : v, scale, 0);
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n = this.value.length;
        for (int index = 0; index < n; ++index) {
            this.value[index] = 0;
        }
    }

    void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    final int compare(MutableBigInteger b) {
        int blen = b.intLen;
        if (this.intLen < blen) {
            return -1;
        }
        if (this.intLen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < this.intLen + this.offset) {
            int b1 = this.value[i] + Integer.MIN_VALUE;
            int b2 = bval[j] + Integer.MIN_VALUE;
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    final int compareHalf(MutableBigInteger b) {
        int blen = b.intLen;
        int len = this.intLen;
        if (len <= 0) {
            return blen <= 0 ? 0 : -1;
        }
        if (len > blen) {
            return 1;
        }
        if (len < blen - 1) {
            return -1;
        }
        int[] bval = b.value;
        int bstart = 0;
        int carry = 0;
        if (len != blen) {
            if (bval[bstart] == 1) {
                ++bstart;
                carry = Integer.MIN_VALUE;
            } else {
                return -1;
            }
        }
        int[] val = this.value;
        int i = this.offset;
        int j = bstart;
        while (i < len + this.offset) {
            int bv;
            long hb;
            long v;
            if ((v = (long)val[i++] & 0xFFFFFFFFL) != (hb = (long)(((bv = bval[j++]) >>> 1) + carry) & 0xFFFFFFFFL)) {
                return v < hb ? -1 : 1;
            }
            carry = (bv & 1) << 31;
        }
        return carry == 0 ? 0 : -1;
    }

    private final int getLowestSetBit() {
        int j;
        if (this.intLen == 0) {
            return -1;
        }
        for (j = this.intLen - 1; j > 0 && this.value[j + this.offset] == 0; --j) {
        }
        int b = this.value[j + this.offset];
        if (b == 0) {
            return -1;
        }
        return (this.intLen - 1 - j << 5) + Integer.numberOfTrailingZeros(b);
    }

    private final int getInt(int index) {
        return this.value[this.offset + index];
    }

    private final long getLong(int index) {
        return (long)this.value[this.offset + index] & 0xFFFFFFFFL;
    }

    final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int index = this.offset;
        if (this.value[index] != 0) {
            return;
        }
        int indexBound = index + this.intLen;
        while (++index < indexBound && this.value[index] == 0) {
        }
        int numZeros = index - this.offset;
        this.intLen -= numZeros;
        this.offset = this.intLen == 0 ? 0 : this.offset + numZeros;
    }

    private final void ensureCapacity(int len) {
        if (this.value.length < len) {
            this.value = new int[len];
            this.offset = 0;
            this.intLen = len;
        }
    }

    int[] toIntArray() {
        int[] result = new int[this.intLen];
        for (int i = 0; i < this.intLen; ++i) {
            result[i] = this.value[this.offset + i];
        }
        return result;
    }

    void setInt(int index, int val) {
        this.value[this.offset + index] = val;
    }

    void setValue(int[] val, int length) {
        this.value = val;
        this.intLen = length;
        this.offset = 0;
    }

    void copyValue(MutableBigInteger src) {
        int len = src.intLen;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        System.arraycopy(src.value, src.offset, this.value, 0, len);
        this.intLen = len;
        this.offset = 0;
    }

    void copyValue(int[] val) {
        int len = val.length;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        System.arraycopy(val, 0, this.value, 0, len);
        this.intLen = len;
        this.offset = 0;
    }

    boolean isOne() {
        return this.intLen == 1 && this.value[this.offset] == 1;
    }

    boolean isZero() {
        return this.intLen == 0;
    }

    boolean isEven() {
        return this.intLen == 0 || (this.value[this.offset + this.intLen - 1] & 1) == 0;
    }

    boolean isOdd() {
        return this.isZero() ? false : (this.value[this.offset + this.intLen - 1] & 1) == 1;
    }

    boolean isNormal() {
        if (this.intLen + this.offset > this.value.length) {
            return false;
        }
        if (this.intLen == 0) {
            return true;
        }
        return this.value[this.offset] != 0;
    }

    public String toString() {
        BigInteger b = this.toBigInteger(1);
        return b.toString();
    }

    void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        this.intLen -= nInts;
        if (nBits == 0) {
            return;
        }
        int bitsInHighWord = BigInteger.bitLengthForInt(this.value[this.offset]);
        if (nBits >= bitsInHighWord) {
            this.primitiveLeftShift(32 - nBits);
            --this.intLen;
        } else {
            this.primitiveRightShift(nBits);
        }
    }

    void leftShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int bitsInHighWord = BigInteger.bitLengthForInt(this.value[this.offset]);
        if (n <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
            return;
        }
        int newLen = this.intLen + nInts + 1;
        if (nBits <= 32 - bitsInHighWord) {
            --newLen;
        }
        if (this.value.length < newLen) {
            int[] result = new int[newLen];
            for (int i = 0; i < this.intLen; ++i) {
                result[i] = this.value[this.offset + i];
            }
            this.setValue(result, newLen);
        } else if (this.value.length - this.offset >= newLen) {
            for (int i = 0; i < newLen - this.intLen; ++i) {
                this.value[this.offset + this.intLen + i] = 0;
            }
        } else {
            int i;
            for (i = 0; i < this.intLen; ++i) {
                this.value[i] = this.value[this.offset + i];
            }
            for (i = this.intLen; i < newLen; ++i) {
                this.value[i] = 0;
            }
            this.offset = 0;
        }
        this.intLen = newLen;
        if (nBits == 0) {
            return;
        }
        if (nBits <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
        } else {
            this.primitiveRightShift(32 - nBits);
        }
    }

    private int divadd(int[] a, int[] result, int offset) {
        long carry = 0L;
        for (int j = a.length - 1; j >= 0; --j) {
            long sum = ((long)a[j] & 0xFFFFFFFFL) + ((long)result[j + offset] & 0xFFFFFFFFL) + carry;
            result[j + offset] = (int)sum;
            carry = sum >>> 32;
        }
        return (int)carry;
    }

    private int mulsub(int[] q, int[] a, int x, int len, int offset) {
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
            long difference = (long)q[offset] - product;
            q[offset--] = (int)difference;
            carry = (product >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)carry;
    }

    private final void primitiveRightShift(int n) {
        int i;
        int[] val = this.value;
        int n2 = 32 - n;
        int c = val[i];
        for (i = this.offset + this.intLen - 1; i > this.offset; --i) {
            int b = c;
            c = val[i - 1];
            val[i] = c << n2 | b >>> n;
        }
        int n3 = this.offset;
        val[n3] = val[n3] >>> n;
    }

    private final void primitiveLeftShift(int n) {
        int i;
        int[] val = this.value;
        int n2 = 32 - n;
        int c = val[i];
        int m = i + this.intLen - 1;
        for (i = this.offset; i < m; ++i) {
            int b = c;
            c = val[i + 1];
            val[i] = b << n | c >>> n2;
        }
        int n3 = this.offset + this.intLen - 1;
        val[n3] = val[n3] << n;
    }

    void add(MutableBigInteger addend) {
        long sum;
        int x = this.intLen;
        int y = addend.intLen;
        int resultLen = this.intLen > addend.intLen ? this.intLen : addend.intLen;
        int[] result = this.value.length < resultLen ? new int[resultLen] : this.value;
        int rstart = result.length - 1;
        long carry = 0L;
        while (x > 0 && y > 0) {
            sum = ((long)this.value[--x + this.offset] & 0xFFFFFFFFL) + ((long)addend.value[--y + addend.offset] & 0xFFFFFFFFL) + carry;
            result[rstart--] = (int)sum;
            carry = sum >>> 32;
        }
        while (x > 0) {
            if (carry == 0L && result == this.value && rstart == --x + this.offset) {
                return;
            }
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + carry;
            result[rstart--] = (int)sum;
            carry = sum >>> 32;
        }
        while (y > 0) {
            sum = ((long)addend.value[--y + addend.offset] & 0xFFFFFFFFL) + carry;
            result[rstart--] = (int)sum;
            carry = sum >>> 32;
        }
        if (carry > 0L) {
            if (result.length < ++resultLen) {
                int[] temp = new int[resultLen];
                System.arraycopy(result, 0, temp, 1, result.length);
                temp[0] = 1;
                result = temp;
            } else {
                result[rstart--] = 1;
            }
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = result.length - resultLen;
    }

    int subtract(MutableBigInteger b) {
        int resultLen;
        MutableBigInteger a = this;
        int[] result = this.value;
        int sign = a.compare(b);
        if (sign == 0) {
            this.reset();
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        if (result.length < (resultLen = a.intLen)) {
            result = new int[resultLen];
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        int rstart = result.length - 1;
        while (y > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - ((long)b.value[--y + b.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart--] = (int)diff;
        }
        while (x > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart--] = (int)diff;
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = this.value.length - resultLen;
        this.normalize();
        return sign;
    }

    private int difference(MutableBigInteger b) {
        MutableBigInteger a = this;
        int sign = a.compare(b);
        if (sign == 0) {
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        while (y > 0) {
            diff = ((long)a.value[a.offset + --x] & 0xFFFFFFFFL) - ((long)b.value[b.offset + --y] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        while (x > 0) {
            diff = ((long)a.value[a.offset + --x] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        a.normalize();
        return sign;
    }

    void multiply(MutableBigInteger y, MutableBigInteger z) {
        int xLen = this.intLen;
        int yLen = y.intLen;
        int newLen = xLen + yLen;
        if (z.value.length < newLen) {
            z.value = new int[newLen];
        }
        z.offset = 0;
        z.intLen = newLen;
        long carry = 0L;
        int j = yLen - 1;
        int k = yLen + xLen - 1;
        while (j >= 0) {
            long product = ((long)y.value[j + y.offset] & 0xFFFFFFFFL) * ((long)this.value[xLen - 1 + this.offset] & 0xFFFFFFFFL) + carry;
            z.value[k] = (int)product;
            carry = product >>> 32;
            --j;
            --k;
        }
        z.value[xLen - 1] = (int)carry;
        for (int i = xLen - 2; i >= 0; --i) {
            carry = 0L;
            int j2 = yLen - 1;
            int k2 = yLen + i;
            while (j2 >= 0) {
                long product = ((long)y.value[j2 + y.offset] & 0xFFFFFFFFL) * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + ((long)z.value[k2] & 0xFFFFFFFFL) + carry;
                z.value[k2] = (int)product;
                carry = product >>> 32;
                --j2;
                --k2;
            }
            z.value[i] = (int)carry;
        }
        z.normalize();
    }

    void mul(int y, MutableBigInteger z) {
        if (y == 1) {
            z.copyValue(this);
            return;
        }
        if (y == 0) {
            z.clear();
            return;
        }
        long ylong = (long)y & 0xFFFFFFFFL;
        int[] zval = z.value.length < this.intLen + 1 ? new int[this.intLen + 1] : z.value;
        long carry = 0L;
        for (int i = this.intLen - 1; i >= 0; --i) {
            long product = ylong * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + carry;
            zval[i + 1] = (int)product;
            carry = product >>> 32;
        }
        if (carry == 0L) {
            z.offset = 1;
            z.intLen = this.intLen;
        } else {
            z.offset = 0;
            z.intLen = this.intLen + 1;
            zval[0] = (int)carry;
        }
        z.value = zval;
    }

    int divideOneWord(int divisor, MutableBigInteger quotient) {
        long divisorLong = (long)divisor & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long dividendValue = (long)this.value[this.offset] & 0xFFFFFFFFL;
            int q = (int)(dividendValue / divisorLong);
            int r = (int)(dividendValue - (long)q * divisorLong);
            quotient.value[0] = q;
            quotient.intLen = q == 0 ? 0 : 1;
            quotient.offset = 0;
            return r;
        }
        if (quotient.value.length < this.intLen) {
            quotient.value = new int[this.intLen];
        }
        quotient.offset = 0;
        quotient.intLen = this.intLen;
        int shift = Integer.numberOfLeadingZeros(divisor);
        int rem = this.value[this.offset];
        long remLong = (long)rem & 0xFFFFFFFFL;
        if (remLong < divisorLong) {
            quotient.value[0] = 0;
        } else {
            quotient.value[0] = (int)(remLong / divisorLong);
            rem = (int)(remLong - (long)quotient.value[0] * divisorLong);
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        int xlen = this.intLen;
        int[] qWord = new int[2];
        while (--xlen > 0) {
            long dividendEstimate = remLong << 32 | (long)this.value[this.offset + this.intLen - xlen] & 0xFFFFFFFFL;
            if (dividendEstimate >= 0L) {
                qWord[0] = (int)(dividendEstimate / divisorLong);
                qWord[1] = (int)(dividendEstimate - (long)qWord[0] * divisorLong);
            } else {
                this.divWord(qWord, dividendEstimate, divisor);
            }
            quotient.value[this.intLen - xlen] = qWord[0];
            rem = qWord[1];
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        quotient.normalize();
        if (shift > 0) {
            return rem % divisor;
        }
        return rem;
    }

    MutableBigInteger divide(MutableBigInteger b, MutableBigInteger quotient) {
        if (b.intLen == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            quotient.intLen = quotient.offset;
            return new MutableBigInteger();
        }
        int cmp = this.compare(b);
        if (cmp < 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            return new MutableBigInteger(this);
        }
        if (cmp == 0) {
            quotient.intLen = 1;
            quotient.value[0] = 1;
            quotient.offset = 0;
            return new MutableBigInteger();
        }
        quotient.clear();
        if (b.intLen == 1) {
            int r = this.divideOneWord(b.value[b.offset], quotient);
            if (r == 0) {
                return new MutableBigInteger();
            }
            return new MutableBigInteger(r);
        }
        int[] div = Arrays.copyOfRange(b.value, b.offset, b.offset + b.intLen);
        return this.divideMagnitude(div, quotient);
    }

    long divide(long v, MutableBigInteger quotient) {
        if (v == 0L) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            return 0L;
        }
        if (v < 0L) {
            v = -v;
        }
        int d = (int)(v >>> 32);
        quotient.clear();
        if (d == 0) {
            return (long)this.divideOneWord((int)v, quotient) & 0xFFFFFFFFL;
        }
        int[] div = new int[]{d, (int)(v & 0xFFFFFFFFL)};
        return this.divideMagnitude(div, quotient).toLong();
    }

    private MutableBigInteger divideMagnitude(int[] divisor, MutableBigInteger quotient) {
        MutableBigInteger rem = new MutableBigInteger(new int[this.intLen + 1]);
        System.arraycopy(this.value, this.offset, rem.value, 1, this.intLen);
        rem.intLen = this.intLen;
        rem.offset = 1;
        int nlen = rem.intLen;
        int dlen = divisor.length;
        int limit = nlen - dlen + 1;
        if (quotient.value.length < limit) {
            quotient.value = new int[limit];
            quotient.offset = 0;
        }
        quotient.intLen = limit;
        int[] q = quotient.value;
        int shift = Integer.numberOfLeadingZeros(divisor[0]);
        if (shift > 0) {
            BigInteger.primitiveLeftShift(divisor, dlen, shift);
            rem.leftShift(shift);
        }
        if (rem.intLen == nlen) {
            rem.offset = 0;
            rem.value[0] = 0;
            ++rem.intLen;
        }
        int dh = divisor[0];
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = divisor[1];
        int[] qWord = new int[2];
        for (int j = 0; j < limit; ++j) {
            long nl;
            long rs;
            long estProduct;
            int qhat = 0;
            int qrem = 0;
            boolean skipCorrection = false;
            int nh = rem.value[j + rem.offset];
            int nh2 = nh + Integer.MIN_VALUE;
            int nm = rem.value[j + 1 + rem.offset];
            if (nh == dh) {
                qhat = -1;
                qrem = nh + nm;
                skipCorrection = qrem + Integer.MIN_VALUE < nh2;
            } else {
                long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                if (nChunk >= 0L) {
                    qhat = (int)(nChunk / dhLong);
                    qrem = (int)(nChunk - (long)qhat * dhLong);
                } else {
                    this.divWord(qWord, nChunk, dh);
                    qhat = qWord[0];
                    qrem = qWord[1];
                }
            }
            if (qhat == 0) continue;
            if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL))) {
                --qhat;
                if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                    --qhat;
                }
            }
            rem.value[j + rem.offset] = 0;
            int borrow = this.mulsub(rem.value, divisor, qhat, dlen, j + rem.offset);
            if (borrow + Integer.MIN_VALUE > nh2) {
                this.divadd(divisor, rem.value, j + 1 + rem.offset);
            }
            q[j] = --qhat;
        }
        if (shift > 0) {
            rem.rightShift(shift);
        }
        quotient.normalize();
        rem.normalize();
        return rem;
    }

    private boolean unsignedLongCompare(long one, long two) {
        return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
    }

    private void divWord(int[] result, long n, int d) {
        long dLong = (long)d & 0xFFFFFFFFL;
        if (dLong == 1L) {
            result[0] = (int)n;
            result[1] = 0;
            return;
        }
        long q = (n >>> 1) / (dLong >>> 1);
        long r = n - q * dLong;
        while (r < 0L) {
            r += dLong;
            --q;
        }
        while (r >= dLong) {
            r -= dLong;
            ++q;
        }
        result[0] = (int)q;
        result[1] = (int)r;
    }

    MutableBigInteger hybridGCD(MutableBigInteger b) {
        MutableBigInteger a = this;
        MutableBigInteger q = new MutableBigInteger();
        while (b.intLen != 0) {
            if (Math.abs(a.intLen - b.intLen) < 2) {
                return a.binaryGCD(b);
            }
            MutableBigInteger r = a.divide(b, q);
            a = b;
            b = r;
        }
        return a;
    }

    private MutableBigInteger binaryGCD(MutableBigInteger v) {
        int lb;
        int tsign;
        int s2;
        int k;
        MutableBigInteger u = this;
        MutableBigInteger r = new MutableBigInteger();
        int s1 = u.getLowestSetBit();
        int n = k = s1 < (s2 = v.getLowestSetBit()) ? s1 : s2;
        if (k != 0) {
            u.rightShift(k);
            v.rightShift(k);
        }
        boolean uOdd = k == s1;
        MutableBigInteger t = uOdd ? v : u;
        int n2 = tsign = uOdd ? -1 : 1;
        while ((lb = t.getLowestSetBit()) >= 0) {
            t.rightShift(lb);
            if (tsign > 0) {
                u = t;
            } else {
                v = t;
            }
            if (u.intLen < 2 && v.intLen < 2) {
                int x = u.value[u.offset];
                int y = v.value[v.offset];
                r.value[0] = x = MutableBigInteger.binaryGcd(x, y);
                r.intLen = 1;
                r.offset = 0;
                if (k > 0) {
                    r.leftShift(k);
                }
                return r;
            }
            tsign = u.difference(v);
            if (tsign == 0) break;
            t = tsign >= 0 ? u : v;
        }
        if (k > 0) {
            u.leftShift(k);
        }
        return u;
    }

    static int binaryGcd(int a, int b) {
        int t;
        if (b == 0) {
            return a;
        }
        if (a == 0) {
            return b;
        }
        int aZeros = Integer.numberOfTrailingZeros(a);
        int bZeros = Integer.numberOfTrailingZeros(b);
        a >>>= aZeros;
        b >>>= bZeros;
        int n = t = aZeros < bZeros ? aZeros : bZeros;
        while (a != b) {
            if (a + Integer.MIN_VALUE > b + Integer.MIN_VALUE) {
                a -= b;
                a >>>= Integer.numberOfTrailingZeros(a);
                continue;
            }
            b -= a;
            b >>>= Integer.numberOfTrailingZeros(b);
        }
        return a << t;
    }

    MutableBigInteger mutableModInverse(MutableBigInteger p) {
        if (p.isOdd()) {
            return this.modInverse(p);
        }
        if (this.isEven()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        int powersOf2 = p.getLowestSetBit();
        MutableBigInteger oddMod = new MutableBigInteger(p);
        oddMod.rightShift(powersOf2);
        if (oddMod.isOne()) {
            return this.modInverseMP2(powersOf2);
        }
        MutableBigInteger oddPart = this.modInverse(oddMod);
        MutableBigInteger evenPart = this.modInverseMP2(powersOf2);
        MutableBigInteger y1 = MutableBigInteger.modInverseBP2(oddMod, powersOf2);
        MutableBigInteger y2 = oddMod.modInverseMP2(powersOf2);
        MutableBigInteger temp1 = new MutableBigInteger();
        MutableBigInteger temp2 = new MutableBigInteger();
        MutableBigInteger result = new MutableBigInteger();
        oddPart.leftShift(powersOf2);
        oddPart.multiply(y1, result);
        evenPart.multiply(oddMod, temp1);
        temp1.multiply(y2, temp2);
        result.add(temp2);
        return result.divide(p, temp1);
    }

    MutableBigInteger modInverseMP2(int k) {
        if (this.isEven()) {
            throw new ArithmeticException("Non-invertible. (GCD != 1)");
        }
        if (k > 64) {
            return this.euclidModInverse(k);
        }
        int t = MutableBigInteger.inverseMod32(this.value[this.offset + this.intLen - 1]);
        if (k < 33) {
            t = k == 32 ? t : t & (1 << k) - 1;
            return new MutableBigInteger(t);
        }
        long pLong = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        if (this.intLen > 1) {
            pLong |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long tLong = (long)t & 0xFFFFFFFFL;
        tLong *= 2L - pLong * tLong;
        tLong = k == 64 ? tLong : tLong & (1L << k) - 1L;
        MutableBigInteger result = new MutableBigInteger(new int[2]);
        result.value[0] = (int)(tLong >>> 32);
        result.value[1] = (int)tLong;
        result.intLen = 2;
        result.normalize();
        return result;
    }

    static int inverseMod32(int val) {
        int t = val;
        t *= 2 - val * t;
        t *= 2 - val * t;
        t *= 2 - val * t;
        t *= 2 - val * t;
        return t;
    }

    static MutableBigInteger modInverseBP2(MutableBigInteger mod, int k) {
        return MutableBigInteger.fixup(new MutableBigInteger(1), new MutableBigInteger(mod), k);
    }

    private MutableBigInteger modInverse(MutableBigInteger mod) {
        int trailingZeros;
        MutableBigInteger p = new MutableBigInteger(mod);
        MutableBigInteger f = new MutableBigInteger(this);
        MutableBigInteger g = new MutableBigInteger(p);
        SignedMutableBigInteger c = new SignedMutableBigInteger(1);
        SignedMutableBigInteger d = new SignedMutableBigInteger();
        MutableBigInteger temp = null;
        SignedMutableBigInteger sTemp = null;
        int k = 0;
        if (f.isEven()) {
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k = trailingZeros;
        }
        while (!f.isOne()) {
            if (f.isZero()) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            if (f.compare(g) < 0) {
                temp = f;
                f = g;
                g = temp;
                sTemp = d;
                d = c;
                c = sTemp;
            }
            if (((f.value[f.offset + f.intLen - 1] ^ g.value[g.offset + g.intLen - 1]) & 3) == 0) {
                f.subtract(g);
                c.signedSubtract(d);
            } else {
                f.add(g);
                c.signedAdd(d);
            }
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k += trailingZeros;
        }
        if (c.compare(p) >= 0) {
            MutableBigInteger remainder = c.divide(p, new MutableBigInteger());
            c.copyValue(remainder);
        }
        if (c.sign < 0) {
            c.signedAdd(p);
        }
        return MutableBigInteger.fixup(c, p, k);
    }

    static MutableBigInteger fixup(MutableBigInteger c, MutableBigInteger p, int k) {
        MutableBigInteger temp = new MutableBigInteger();
        int r = -MutableBigInteger.inverseMod32(p.value[p.offset + p.intLen - 1]);
        int numWords = k >> 5;
        for (int i = 0; i < numWords; ++i) {
            int v = r * c.value[c.offset + c.intLen - 1];
            p.mul(v, temp);
            c.add(temp);
            --c.intLen;
        }
        int numBits = k & 0x1F;
        if (numBits != 0) {
            int v = r * c.value[c.offset + c.intLen - 1];
            p.mul(v &= (1 << numBits) - 1, temp);
            c.add(temp);
            c.rightShift(numBits);
        }
        if (c.compare(p) >= 0) {
            c = c.divide(p, new MutableBigInteger());
        }
        return c;
    }

    MutableBigInteger euclidModInverse(int k) {
        MutableBigInteger b = new MutableBigInteger(1);
        b.leftShift(k);
        MutableBigInteger mod = new MutableBigInteger(b);
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = b.divide(a, q);
        MutableBigInteger swapper = b;
        b = r;
        r = swapper;
        MutableBigInteger t1 = new MutableBigInteger(q);
        MutableBigInteger t0 = new MutableBigInteger(1);
        MutableBigInteger temp = new MutableBigInteger();
        while (!b.isOne()) {
            r = a.divide(b, q);
            if (r.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            a = swapper = r;
            if (q.intLen == 1) {
                t1.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t1, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t0.add(q);
            if (a.isOne()) {
                return t0;
            }
            r = b.divide(a, q);
            if (r.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            swapper = b;
            b = r;
            if (q.intLen == 1) {
                t0.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t0, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t1.add(q);
        }
        mod.subtract(t1);
        return mod;
    }
}

