/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;

public class StandardEmitterMBean
extends StandardMBean
implements NotificationEmitter {
    private static final MBeanNotificationInfo[] NO_NOTIFICATION_INFO = new MBeanNotificationInfo[0];
    private final NotificationEmitter emitter;
    private final MBeanNotificationInfo[] notificationInfo;

    public <T> StandardEmitterMBean(T implementation, Class<T> mbeanInterface, NotificationEmitter emitter) {
        this(implementation, mbeanInterface, false, emitter);
    }

    public <T> StandardEmitterMBean(T implementation, Class<T> mbeanInterface, boolean isMXBean, NotificationEmitter emitter) {
        super(implementation, mbeanInterface, isMXBean);
        if (emitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = emitter;
        MBeanNotificationInfo[] infos = emitter.getNotificationInfo();
        this.notificationInfo = infos == null || infos.length == 0 ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])infos.clone();
    }

    protected StandardEmitterMBean(Class<?> mbeanInterface, NotificationEmitter emitter) {
        this(mbeanInterface, false, emitter);
    }

    protected StandardEmitterMBean(Class<?> mbeanInterface, boolean isMXBean, NotificationEmitter emitter) {
        super(mbeanInterface, isMXBean);
        if (emitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = emitter;
        MBeanNotificationInfo[] infos = emitter.getNotificationInfo();
        this.notificationInfo = infos == null || infos.length == 0 ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])infos.clone();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            return NO_NOTIFICATION_INFO;
        }
        if (this.notificationInfo.length == 0) {
            return this.notificationInfo;
        }
        return (MBeanNotificationInfo[])this.notificationInfo.clone();
    }

    public void sendNotification(Notification n) {
        if (!(this.emitter instanceof NotificationBroadcasterSupport)) {
            String msg = "Cannot sendNotification when emitter is not an instance of NotificationBroadcasterSupport: " + this.emitter.getClass().getName();
            throw new ClassCastException(msg);
        }
        ((NotificationBroadcasterSupport)this.emitter).sendNotification(n);
    }

    @Override
    MBeanNotificationInfo[] getNotifications(MBeanInfo info) {
        return this.getNotificationInfo();
    }
}

