/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.OGLBlitLoops;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.BufferedBufImgOps;

class OGLBufImgOps
extends BufferedBufImgOps {
    OGLBufImgOps() {
    }

    static boolean renderImageWithOp(SunGraphics2D sg, BufferedImage img, BufferedImageOp biop, int x, int y) {
        SurfaceData dstData;
        if (biop instanceof ConvolveOp) {
            if (!OGLBufImgOps.isConvolveOpValid((ConvolveOp)biop)) {
                return false;
            }
        } else if (biop instanceof RescaleOp) {
            if (!OGLBufImgOps.isRescaleOpValid((RescaleOp)biop, img)) {
                return false;
            }
        } else if (biop instanceof LookupOp) {
            if (!OGLBufImgOps.isLookupOpValid((LookupOp)biop, img)) {
                return false;
            }
        } else {
            return false;
        }
        if (!((dstData = sg.surfaceData) instanceof OGLSurfaceData) || sg.interpolationType == 3 || sg.compositeState > 1) {
            return false;
        }
        SurfaceData srcData = dstData.getSourceSurfaceData(img, 0, CompositeType.SrcOver, null);
        if (!(srcData instanceof OGLSurfaceData)) {
            srcData = dstData.getSourceSurfaceData(img, 0, CompositeType.SrcOver, null);
            if (!(srcData instanceof OGLSurfaceData)) {
                return false;
            }
        }
        OGLSurfaceData oglSrc = (OGLSurfaceData)srcData;
        OGLGraphicsConfig gc = oglSrc.getOGLGraphicsConfig();
        if (oglSrc.getType() != 3 || !gc.isCapPresent(262144)) {
            return false;
        }
        int sw = img.getWidth();
        int sh = img.getHeight();
        OGLBlitLoops.IsoBlit(srcData, dstData, img, biop, sg.composite, sg.getCompClip(), sg.transform, sg.interpolationType, 0, 0, sw, sh, x, y, x + sw, y + sh, true);
        return true;
    }
}

