/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import sun.reflect.UnsafeQualifiedFieldAccessorImpl;

class UnsafeQualifiedDoubleFieldAccessorImpl
extends UnsafeQualifiedFieldAccessorImpl {
    UnsafeQualifiedDoubleFieldAccessorImpl(Field field, boolean isReadOnly) {
        super(field, isReadOnly);
    }

    @Override
    public Object get(Object obj) throws IllegalArgumentException {
        return new Double(this.getDouble(obj));
    }

    @Override
    public boolean getBoolean(Object obj) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object obj) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object obj) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object obj) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    @Override
    public int getInt(Object obj) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    @Override
    public long getLong(Object obj) throws IllegalArgumentException {
        throw this.newGetLongIllegalArgumentException();
    }

    @Override
    public float getFloat(Object obj) throws IllegalArgumentException {
        throw this.newGetFloatIllegalArgumentException();
    }

    @Override
    public double getDouble(Object obj) throws IllegalArgumentException {
        this.ensureObj(obj);
        return unsafe.getDoubleVolatile(obj, this.fieldOffset);
    }

    @Override
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(value);
        }
        if (value == null) {
            this.throwSetIllegalArgumentException(value);
        }
        if (value instanceof Byte) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, ((Short)value).shortValue());
            return;
        }
        if (value instanceof Character) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, ((Character)value).charValue());
            return;
        }
        if (value instanceof Integer) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, ((Integer)value).intValue());
            return;
        }
        if (value instanceof Long) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, ((Long)value).longValue());
            return;
        }
        if (value instanceof Float) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, ((Float)value).floatValue());
            return;
        }
        if (value instanceof Double) {
            unsafe.putDoubleVolatile(obj, this.fieldOffset, (Double)value);
            return;
        }
        this.throwSetIllegalArgumentException(value);
    }

    @Override
    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(z);
    }

    @Override
    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, b);
    }

    @Override
    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, c);
    }

    @Override
    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, s);
    }

    @Override
    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, i);
    }

    @Override
    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, l);
    }

    @Override
    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(obj, f);
    }

    @Override
    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(d);
        }
        unsafe.putDoubleVolatile(obj, this.fieldOffset, d);
    }
}

