/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.interceptors;

import com.sun.corba.se.impl.logging.InterceptorsSystemException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorList {
    static final int INTERCEPTOR_TYPE_CLIENT = 0;
    static final int INTERCEPTOR_TYPE_SERVER = 1;
    static final int INTERCEPTOR_TYPE_IOR = 2;
    static final int NUM_INTERCEPTOR_TYPES = 3;
    static final Class[] classTypes = new Class[]{ClientRequestInterceptor.class, ServerRequestInterceptor.class, IORInterceptor.class};
    private boolean locked = false;
    private InterceptorsSystemException wrapper;
    private Interceptor[][] interceptors = new Interceptor[3][];

    InterceptorList(InterceptorsSystemException interceptorsSystemException) {
        this.wrapper = interceptorsSystemException;
        this.initInterceptorArrays();
    }

    void register_interceptor(Interceptor interceptor, int n) throws DuplicateName {
        if (this.locked) {
            throw this.wrapper.interceptorListLocked();
        }
        String string = interceptor.name();
        boolean bl = string.equals("");
        boolean bl2 = false;
        Interceptor[] interceptorArray = this.interceptors[n];
        if (!bl) {
            for (Interceptor interceptor2 : interceptorArray) {
                if (!interceptor2.name().equals(string)) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            throw new DuplicateName(string);
        }
        this.growInterceptorArray(n);
        this.interceptors[n][this.interceptors[n].length - 1] = interceptor;
    }

    void lock() {
        this.locked = true;
    }

    Interceptor[] getInterceptors(int n) {
        return this.interceptors[n];
    }

    boolean hasInterceptorsOfType(int n) {
        return this.interceptors[n].length > 0;
    }

    private void initInterceptorArrays() {
        for (int i = 0; i < 3; ++i) {
            Class clazz = classTypes[i];
            this.interceptors[i] = (Interceptor[])Array.newInstance(clazz, 0);
        }
    }

    private void growInterceptorArray(int n) {
        Class clazz = classTypes[n];
        int n2 = this.interceptors[n].length;
        Interceptor[] interceptorArray = (Interceptor[])Array.newInstance(clazz, n2 + 1);
        System.arraycopy(this.interceptors[n], 0, interceptorArray, 0, n2);
        this.interceptors[n] = interceptorArray;
    }

    void destroyAll() {
        int n = this.interceptors.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.interceptors[i].length;
            for (int j = 0; j < n2; ++j) {
                this.interceptors[i][j].destroy();
            }
        }
    }

    void sortInterceptors() {
        ArrayList<Interceptor> arrayList = null;
        ArrayList<Interceptor> arrayList2 = null;
        int n = this.interceptors.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = this.interceptors[i].length;
            if (n2 > 0) {
                arrayList = new ArrayList<Interceptor>();
                arrayList2 = new ArrayList<Interceptor>();
            }
            for (int j = 0; j < n2; ++j) {
                object = this.interceptors[i][j];
                if (object instanceof Comparable) {
                    arrayList.add((Interceptor)object);
                    continue;
                }
                arrayList2.add((Interceptor)object);
            }
            if (n2 <= 0 || arrayList.size() <= 0) continue;
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            object = arrayList2.iterator();
            for (int j = 0; j < n2; ++j) {
                if (iterator.hasNext()) {
                    this.interceptors[i][j] = (Interceptor)iterator.next();
                    continue;
                }
                if (object.hasNext()) {
                    this.interceptors[i][j] = (Interceptor)object.next();
                    continue;
                }
                throw this.wrapper.sortSizeMismatch();
            }
        }
    }
}

