/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseContext;
import java.time.format.DateTimePrintContext;
import java.time.format.DateTimeTextProvider;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.format.ZoneName;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.time.zone.ZoneRulesProvider;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.TimeZoneNameUtility;

public final class DateTimeFormatterBuilder {
    private static final TemporalQuery<ZoneId> QUERY_REGION_ONLY = temporalAccessor -> {
        ZoneId zoneId = temporalAccessor.query(TemporalQueries.zoneId());
        return zoneId != null && !(zoneId instanceof ZoneOffset) ? zoneId : null;
    };
    private DateTimeFormatterBuilder active = this;
    private final DateTimeFormatterBuilder parent;
    private final List<DateTimePrinterParser> printerParsers = new ArrayList<DateTimePrinterParser>();
    private final boolean optional;
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex = -1;
    private static final Map<Character, TemporalField> FIELD_MAP = new HashMap<Character, TemporalField>();
    static final Comparator<String> LENGTH_SORT;

    public static String getLocalizedDateTimePattern(FormatStyle formatStyle, FormatStyle formatStyle2, Chronology chronology, Locale locale) {
        Objects.requireNonNull(locale, "locale");
        Objects.requireNonNull(chronology, "chrono");
        if (formatStyle == null && formatStyle2 == null) {
            throw new IllegalArgumentException("Either dateStyle or timeStyle must be non-null");
        }
        LocaleResources localeResources = LocaleProviderAdapter.getResourceBundleBased().getLocaleResources(locale);
        String string = localeResources.getJavaTimeDateTimePattern(DateTimeFormatterBuilder.convertStyle(formatStyle2), DateTimeFormatterBuilder.convertStyle(formatStyle), chronology.getCalendarType());
        return string;
    }

    private static int convertStyle(FormatStyle formatStyle) {
        if (formatStyle == null) {
            return -1;
        }
        return formatStyle.ordinal();
    }

    public DateTimeFormatterBuilder() {
        this.parent = null;
        this.optional = false;
    }

    private DateTimeFormatterBuilder(DateTimeFormatterBuilder dateTimeFormatterBuilder, boolean bl) {
        this.parent = dateTimeFormatterBuilder;
        this.optional = bl;
    }

    public DateTimeFormatterBuilder parseCaseSensitive() {
        this.appendInternal(SettingsParser.SENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseCaseInsensitive() {
        this.appendInternal(SettingsParser.INSENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseStrict() {
        this.appendInternal(SettingsParser.STRICT);
        return this;
    }

    public DateTimeFormatterBuilder parseLenient() {
        this.appendInternal(SettingsParser.LENIENT);
        return this;
    }

    public DateTimeFormatterBuilder parseDefaulting(TemporalField temporalField, long l) {
        Objects.requireNonNull(temporalField, "field");
        this.appendInternal(new DefaultValueParser(temporalField, l));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField) {
        Objects.requireNonNull(temporalField, "field");
        this.appendValue(new NumberPrinterParser(temporalField, 1, 19, SignStyle.NORMAL));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField, int n) {
        Objects.requireNonNull(temporalField, "field");
        if (n < 1 || n > 19) {
            throw new IllegalArgumentException("The width must be from 1 to 19 inclusive but was " + n);
        }
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(temporalField, n, n, SignStyle.NOT_NEGATIVE);
        this.appendValue(numberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField, int n, int n2, SignStyle signStyle) {
        if (n == n2 && signStyle == SignStyle.NOT_NEGATIVE) {
            return this.appendValue(temporalField, n2);
        }
        Objects.requireNonNull(temporalField, "field");
        Objects.requireNonNull(signStyle, "signStyle");
        if (n < 1 || n > 19) {
            throw new IllegalArgumentException("The minimum width must be from 1 to 19 inclusive but was " + n);
        }
        if (n2 < 1 || n2 > 19) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 19 inclusive but was " + n2);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
        }
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(temporalField, n, n2, signStyle);
        this.appendValue(numberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField temporalField, int n, int n2, int n3) {
        Objects.requireNonNull(temporalField, "field");
        ReducedPrinterParser reducedPrinterParser = new ReducedPrinterParser(temporalField, n, n2, n3, null);
        this.appendValue(reducedPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField temporalField, int n, int n2, ChronoLocalDate chronoLocalDate) {
        Objects.requireNonNull(temporalField, "field");
        Objects.requireNonNull(chronoLocalDate, "baseDate");
        ReducedPrinterParser reducedPrinterParser = new ReducedPrinterParser(temporalField, n, n2, 0, chronoLocalDate);
        this.appendValue(reducedPrinterParser);
        return this;
    }

    private DateTimeFormatterBuilder appendValue(NumberPrinterParser numberPrinterParser) {
        if (this.active.valueParserIndex >= 0) {
            int n = this.active.valueParserIndex;
            NumberPrinterParser numberPrinterParser2 = (NumberPrinterParser)this.active.printerParsers.get(n);
            if (numberPrinterParser.minWidth == numberPrinterParser.maxWidth && numberPrinterParser.signStyle == SignStyle.NOT_NEGATIVE) {
                numberPrinterParser2 = numberPrinterParser2.withSubsequentWidth(numberPrinterParser.maxWidth);
                this.appendInternal(numberPrinterParser.withFixedWidth());
                this.active.valueParserIndex = n;
            } else {
                numberPrinterParser2 = numberPrinterParser2.withFixedWidth();
                this.active.valueParserIndex = this.appendInternal(numberPrinterParser);
            }
            this.active.printerParsers.set(n, numberPrinterParser2);
        } else {
            this.active.valueParserIndex = this.appendInternal(numberPrinterParser);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(TemporalField temporalField, int n, int n2, boolean bl) {
        this.appendInternal(new FractionPrinterParser(temporalField, n, n2, bl));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField) {
        return this.appendText(temporalField, TextStyle.FULL);
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField, TextStyle textStyle) {
        Objects.requireNonNull(temporalField, "field");
        Objects.requireNonNull(textStyle, "textStyle");
        this.appendInternal(new TextPrinterParser(temporalField, textStyle, DateTimeTextProvider.getInstance()));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField, Map<Long, String> map) {
        Objects.requireNonNull(temporalField, "field");
        Objects.requireNonNull(map, "textLookup");
        LinkedHashMap<Long, String> linkedHashMap = new LinkedHashMap<Long, String>(map);
        Map<TextStyle, Map<Long, String>> map2 = Collections.singletonMap(TextStyle.FULL, linkedHashMap);
        final DateTimeTextProvider.LocaleStore localeStore = new DateTimeTextProvider.LocaleStore(map2);
        DateTimeTextProvider dateTimeTextProvider = new DateTimeTextProvider(){

            @Override
            public String getText(Chronology chronology, TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
                return localeStore.getText(l, textStyle);
            }

            @Override
            public String getText(TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
                return localeStore.getText(l, textStyle);
            }

            @Override
            public Iterator<Map.Entry<String, Long>> getTextIterator(Chronology chronology, TemporalField temporalField, TextStyle textStyle, Locale locale) {
                return localeStore.getTextIterator(textStyle);
            }

            @Override
            public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField temporalField, TextStyle textStyle, Locale locale) {
                return localeStore.getTextIterator(textStyle);
            }
        };
        this.appendInternal(new TextPrinterParser(temporalField, TextStyle.FULL, dateTimeTextProvider));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant() {
        this.appendInternal(new InstantPrinterParser(-2));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("The fractional digits must be from -1 to 9 inclusive but was " + n);
        }
        this.appendInternal(new InstantPrinterParser(n));
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        this.appendInternal(OffsetIdPrinterParser.INSTANCE_ID_Z);
        return this;
    }

    public DateTimeFormatterBuilder appendOffset(String string, String string2) {
        this.appendInternal(new OffsetIdPrinterParser(string, string2));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalizedOffset(TextStyle textStyle) {
        Objects.requireNonNull(textStyle, "style");
        if (textStyle != TextStyle.FULL && textStyle != TextStyle.SHORT) {
            throw new IllegalArgumentException("Style must be either full or short");
        }
        this.appendInternal(new LocalizedOffsetIdPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        this.appendInternal(new ZoneIdPrinterParser(TemporalQueries.zoneId(), "ZoneId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneRegionId() {
        this.appendInternal(new ZoneIdPrinterParser(QUERY_REGION_ONLY, "ZoneRegionId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneOrOffsetId() {
        this.appendInternal(new ZoneIdPrinterParser(TemporalQueries.zone(), "ZoneOrOffsetId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        this.appendInternal(new ZoneTextPrinterParser(textStyle, null));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle, Set<ZoneId> set) {
        Objects.requireNonNull(set, "preferredZones");
        this.appendInternal(new ZoneTextPrinterParser(textStyle, set));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyId() {
        this.appendInternal(new ChronoPrinterParser(null));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyText(TextStyle textStyle) {
        Objects.requireNonNull(textStyle, "textStyle");
        this.appendInternal(new ChronoPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle formatStyle, FormatStyle formatStyle2) {
        if (formatStyle == null && formatStyle2 == null) {
            throw new IllegalArgumentException("Either the date or time style must be non-null");
        }
        this.appendInternal(new LocalizedPrinterParser(formatStyle, formatStyle2));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c) {
        this.appendInternal(new CharLiteralPrinterParser(c));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String string) {
        Objects.requireNonNull(string, "literal");
        if (string.length() > 0) {
            if (string.length() == 1) {
                this.appendInternal(new CharLiteralPrinterParser(string.charAt(0)));
            } else {
                this.appendInternal(new StringLiteralPrinterParser(string));
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        this.appendInternal(dateTimeFormatter.toPrinterParser(false));
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        this.appendInternal(dateTimeFormatter.toPrinterParser(true));
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String string) {
        Objects.requireNonNull(string, "pattern");
        this.parsePattern(string);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePattern(String string) {
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                TemporalField temporalField;
                n = i++;
                while (i < string.length() && string.charAt(i) == c) {
                    ++i;
                }
                int n2 = i - n;
                if (c == 'p') {
                    int n3 = 0;
                    if (i < string.length() && ((c = string.charAt(i)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                        n3 = n2;
                        n = i++;
                        while (i < string.length() && string.charAt(i) == c) {
                            ++i;
                        }
                        n2 = i - n;
                    }
                    if (n3 == 0) {
                        throw new IllegalArgumentException("Pad letter 'p' must be followed by valid pad pattern: " + string);
                    }
                    this.padNext(n3);
                }
                if ((temporalField = FIELD_MAP.get(Character.valueOf(c))) != null) {
                    this.parseField(c, n2, temporalField);
                } else if (c == 'z') {
                    if (n2 > 4) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c);
                    }
                    if (n2 == 4) {
                        this.appendZoneText(TextStyle.FULL);
                    } else {
                        this.appendZoneText(TextStyle.SHORT);
                    }
                } else if (c == 'V') {
                    if (n2 != 2) {
                        throw new IllegalArgumentException("Pattern letter count must be 2: " + c);
                    }
                    this.appendZoneId();
                } else if (c == 'Z') {
                    if (n2 < 4) {
                        this.appendOffset("+HHMM", "+0000");
                    } else if (n2 == 4) {
                        this.appendLocalizedOffset(TextStyle.FULL);
                    } else {
                        if (n2 != 5) throw new IllegalArgumentException("Too many pattern letters: " + c);
                        this.appendOffset("+HH:MM:ss", "Z");
                    }
                } else if (c == 'O') {
                    if (n2 == 1) {
                        this.appendLocalizedOffset(TextStyle.SHORT);
                    } else {
                        if (n2 != 4) throw new IllegalArgumentException("Pattern letter count must be 1 or 4: " + c);
                        this.appendLocalizedOffset(TextStyle.FULL);
                    }
                } else if (c == 'X') {
                    if (n2 > 5) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c);
                    }
                    this.appendOffset(OffsetIdPrinterParser.PATTERNS[n2 + (n2 == 1 ? 0 : 1)], "Z");
                } else if (c == 'x') {
                    if (n2 > 5) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c);
                    }
                    String string2 = n2 == 1 ? "+00" : (n2 % 2 == 0 ? "+0000" : "+00:00");
                    this.appendOffset(OffsetIdPrinterParser.PATTERNS[n2 + (n2 == 1 ? 0 : 1)], string2);
                } else if (c == 'W') {
                    if (n2 > 1) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c);
                    }
                    this.appendInternal(new WeekBasedFieldPrinterParser(c, n2));
                } else if (c == 'w') {
                    if (n2 > 2) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c);
                    }
                    this.appendInternal(new WeekBasedFieldPrinterParser(c, n2));
                } else {
                    if (c != 'Y') throw new IllegalArgumentException("Unknown pattern letter: " + c);
                    this.appendInternal(new WeekBasedFieldPrinterParser(c, n2));
                }
                --i;
                continue;
            }
            if (c == '\'') {
                n = i++;
                while (i < string.length()) {
                    if (string.charAt(i) == '\'') {
                        if (i + 1 >= string.length() || string.charAt(i + 1) != '\'') break;
                        ++i;
                    }
                    ++i;
                }
                if (i >= string.length()) {
                    throw new IllegalArgumentException("Pattern ends with an incomplete string literal: " + string);
                }
                String string3 = string.substring(n + 1, i);
                if (string3.length() == 0) {
                    this.appendLiteral('\'');
                    continue;
                }
                this.appendLiteral(string3.replace("''", "'"));
                continue;
            }
            if (c == '[') {
                this.optionalStart();
                continue;
            }
            if (c == ']') {
                if (this.active.parent == null) {
                    throw new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                }
                this.optionalEnd();
                continue;
            }
            if (c == '{' || c == '}' || c == '#') {
                throw new IllegalArgumentException("Pattern includes reserved character: '" + c + "'");
            }
            this.appendLiteral(c);
        }
    }

    private void parseField(char c, int n, TemporalField temporalField) {
        boolean bl = false;
        block0 : switch (c) {
            case 'u': 
            case 'y': {
                if (n == 2) {
                    this.appendValueReduced(temporalField, 2, 2, ReducedPrinterParser.BASE_DATE);
                    break;
                }
                if (n < 4) {
                    this.appendValue(temporalField, n, 19, SignStyle.NORMAL);
                    break;
                }
                this.appendValue(temporalField, n, 19, SignStyle.EXCEEDS_PAD);
                break;
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern \"cc\"");
                }
            }
            case 'L': 
            case 'q': {
                bl = true;
            }
            case 'E': 
            case 'M': 
            case 'Q': 
            case 'e': {
                switch (n) {
                    case 1: 
                    case 2: {
                        if (c == 'c' || c == 'e') {
                            this.appendInternal(new WeekBasedFieldPrinterParser(c, n));
                            break block0;
                        }
                        if (c == 'E') {
                            this.appendText(temporalField, TextStyle.SHORT);
                            break block0;
                        }
                        if (n == 1) {
                            this.appendValue(temporalField);
                            break block0;
                        }
                        this.appendValue(temporalField, 2);
                        break block0;
                    }
                    case 3: {
                        this.appendText(temporalField, bl ? TextStyle.SHORT_STANDALONE : TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, bl ? TextStyle.FULL_STANDALONE : TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, bl ? TextStyle.NARROW_STANDALONE : TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c);
            }
            case 'a': {
                if (n == 1) {
                    this.appendText(temporalField, TextStyle.SHORT);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c);
            }
            case 'G': {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.appendText(temporalField, TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c);
            }
            case 'S': {
                this.appendFraction(ChronoField.NANO_OF_SECOND, n, n, false);
                break;
            }
            case 'F': {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c);
            }
            case 'H': 
            case 'K': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                if (n == 2) {
                    this.appendValue(temporalField, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c);
            }
            case 'D': {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                if (n <= 3) {
                    this.appendValue(temporalField, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c);
            }
            default: {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                this.appendValue(temporalField, n);
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int n) {
        return this.padNext(n, ' ');
    }

    public DateTimeFormatterBuilder padNext(int n, char c) {
        if (n < 1) {
            throw new IllegalArgumentException("The pad width must be at least one but was " + n);
        }
        this.active.padNextWidth = n;
        this.active.padNextChar = c;
        this.active.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.active.valueParserIndex = -1;
        this.active = new DateTimeFormatterBuilder(this.active, true);
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        if (this.active.parent == null) {
            throw new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
        }
        if (this.active.printerParsers.size() > 0) {
            CompositePrinterParser compositePrinterParser = new CompositePrinterParser(this.active.printerParsers, this.active.optional);
            this.active = this.active.parent;
            this.appendInternal(compositePrinterParser);
        } else {
            this.active = this.active.parent;
        }
        return this;
    }

    private int appendInternal(DateTimePrinterParser dateTimePrinterParser) {
        Objects.requireNonNull(dateTimePrinterParser, "pp");
        if (this.active.padNextWidth > 0) {
            if (dateTimePrinterParser != null) {
                dateTimePrinterParser = new PadPrinterParserDecorator(dateTimePrinterParser, this.active.padNextWidth, this.active.padNextChar);
            }
            this.active.padNextWidth = 0;
            this.active.padNextChar = '\u0000';
        }
        this.active.printerParsers.add(dateTimePrinterParser);
        this.active.valueParserIndex = -1;
        return this.active.printerParsers.size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        return this.toFormatter(locale, ResolverStyle.SMART, null);
    }

    DateTimeFormatter toFormatter(ResolverStyle resolverStyle, Chronology chronology) {
        return this.toFormatter(Locale.getDefault(Locale.Category.FORMAT), resolverStyle, chronology);
    }

    private DateTimeFormatter toFormatter(Locale locale, ResolverStyle resolverStyle, Chronology chronology) {
        Objects.requireNonNull(locale, "locale");
        while (this.active.parent != null) {
            this.optionalEnd();
        }
        CompositePrinterParser compositePrinterParser = new CompositePrinterParser(this.printerParsers, false);
        return new DateTimeFormatter(compositePrinterParser, locale, DecimalStyle.STANDARD, resolverStyle, null, chronology, null);
    }

    static {
        FIELD_MAP.put(Character.valueOf('G'), ChronoField.ERA);
        FIELD_MAP.put(Character.valueOf('y'), ChronoField.YEAR_OF_ERA);
        FIELD_MAP.put(Character.valueOf('u'), ChronoField.YEAR);
        FIELD_MAP.put(Character.valueOf('Q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('M'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('L'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('D'), ChronoField.DAY_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('d'), ChronoField.DAY_OF_MONTH);
        FIELD_MAP.put(Character.valueOf('F'), ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        FIELD_MAP.put(Character.valueOf('E'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('c'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('e'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('a'), ChronoField.AMPM_OF_DAY);
        FIELD_MAP.put(Character.valueOf('H'), ChronoField.HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('k'), ChronoField.CLOCK_HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('K'), ChronoField.HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('h'), ChronoField.CLOCK_HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('m'), ChronoField.MINUTE_OF_HOUR);
        FIELD_MAP.put(Character.valueOf('s'), ChronoField.SECOND_OF_MINUTE);
        FIELD_MAP.put(Character.valueOf('S'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('A'), ChronoField.MILLI_OF_DAY);
        FIELD_MAP.put(Character.valueOf('n'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('N'), ChronoField.NANO_OF_DAY);
        LENGTH_SORT = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.length() == string2.length() ? string.compareTo(string2) : string.length() - string2.length();
            }
        };
    }

    static final class WeekBasedFieldPrinterParser
    implements DateTimePrinterParser {
        private char chr;
        private int count;

        WeekBasedFieldPrinterParser(char c, int n) {
            this.chr = c;
            this.count = n;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            return this.printerParser(dateTimePrintContext.getLocale()).format(dateTimePrintContext, stringBuilder);
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            return this.printerParser(dateTimeParseContext.getLocale()).parse(dateTimeParseContext, charSequence, n);
        }

        private DateTimePrinterParser printerParser(Locale locale) {
            WeekFields weekFields = WeekFields.of(locale);
            TemporalField temporalField = null;
            switch (this.chr) {
                case 'Y': {
                    temporalField = weekFields.weekBasedYear();
                    if (this.count == 2) {
                        return new ReducedPrinterParser(temporalField, 2, 2, 0, ReducedPrinterParser.BASE_DATE, 0);
                    }
                    return new NumberPrinterParser(temporalField, this.count, 19, this.count < 4 ? SignStyle.NORMAL : SignStyle.EXCEEDS_PAD, -1);
                }
                case 'c': 
                case 'e': {
                    temporalField = weekFields.dayOfWeek();
                    break;
                }
                case 'w': {
                    temporalField = weekFields.weekOfWeekBasedYear();
                    break;
                }
                case 'W': {
                    temporalField = weekFields.weekOfMonth();
                    break;
                }
                default: {
                    throw new IllegalStateException("unreachable");
                }
            }
            return new NumberPrinterParser(temporalField, this.count == 2 ? 2 : 1, 2, SignStyle.NOT_NEGATIVE);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(30);
            stringBuilder.append("Localized(");
            if (this.chr == 'Y') {
                if (this.count == 1) {
                    stringBuilder.append("WeekBasedYear");
                } else if (this.count == 2) {
                    stringBuilder.append("ReducedValue(WeekBasedYear,2,2,2000-01-01)");
                } else {
                    stringBuilder.append("WeekBasedYear,").append(this.count).append(",").append(19).append(",").append((Object)(this.count < 4 ? SignStyle.NORMAL : SignStyle.EXCEEDS_PAD));
                }
            } else {
                switch (this.chr) {
                    case 'c': 
                    case 'e': {
                        stringBuilder.append("DayOfWeek");
                        break;
                    }
                    case 'w': {
                        stringBuilder.append("WeekOfWeekBasedYear");
                        break;
                    }
                    case 'W': {
                        stringBuilder.append("WeekOfMonth");
                        break;
                    }
                }
                stringBuilder.append(",");
                stringBuilder.append(this.count);
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    static final class LocalizedPrinterParser
    implements DateTimePrinterParser {
        private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>(16, 0.75f, 2);
        private final FormatStyle dateStyle;
        private final FormatStyle timeStyle;

        LocalizedPrinterParser(FormatStyle formatStyle, FormatStyle formatStyle2) {
            this.dateStyle = formatStyle;
            this.timeStyle = formatStyle2;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            Chronology chronology = Chronology.from(dateTimePrintContext.getTemporal());
            return this.formatter(dateTimePrintContext.getLocale(), chronology).toPrinterParser(false).format(dateTimePrintContext, stringBuilder);
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            Chronology chronology = dateTimeParseContext.getEffectiveChronology();
            return this.formatter(dateTimeParseContext.getLocale(), chronology).toPrinterParser(false).parse(dateTimeParseContext, charSequence, n);
        }

        private DateTimeFormatter formatter(Locale locale, Chronology chronology) {
            String string;
            DateTimeFormatter dateTimeFormatter;
            String string2 = chronology.getId() + '|' + locale.toString() + '|' + (Object)((Object)this.dateStyle) + (Object)((Object)this.timeStyle);
            DateTimeFormatter dateTimeFormatter2 = (DateTimeFormatter)FORMATTER_CACHE.get(string2);
            if (dateTimeFormatter2 == null && (dateTimeFormatter = FORMATTER_CACHE.putIfAbsent(string2, dateTimeFormatter2 = new DateTimeFormatterBuilder().appendPattern(string = DateTimeFormatterBuilder.getLocalizedDateTimePattern(this.dateStyle, this.timeStyle, chronology, locale)).toFormatter(locale))) != null) {
                dateTimeFormatter2 = dateTimeFormatter;
            }
            return dateTimeFormatter2;
        }

        public String toString() {
            return "Localized(" + (this.dateStyle != null ? this.dateStyle : "") + "," + (this.timeStyle != null ? this.timeStyle : "") + ")";
        }
    }

    static final class ChronoPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle textStyle;

        ChronoPrinterParser(TextStyle textStyle) {
            this.textStyle = textStyle;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            Chronology chronology = dateTimePrintContext.getValue(TemporalQueries.chronology());
            if (chronology == null) {
                return false;
            }
            if (this.textStyle == null) {
                stringBuilder.append(chronology.getId());
            } else {
                stringBuilder.append(this.getChronologyName(chronology, dateTimePrintContext.getLocale()));
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            if (n < 0 || n > charSequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            Set<Chronology> set = Chronology.getAvailableChronologies();
            Chronology chronology = null;
            int n2 = -1;
            for (Chronology chronology2 : set) {
                String string = this.textStyle == null ? chronology2.getId() : this.getChronologyName(chronology2, dateTimeParseContext.getLocale());
                int n3 = string.length();
                if (n3 <= n2 || !dateTimeParseContext.subSequenceEquals(charSequence, n, string, 0, n3)) continue;
                chronology = chronology2;
                n2 = n3;
            }
            if (chronology == null) {
                return ~n;
            }
            dateTimeParseContext.setParsed(chronology);
            return n + n2;
        }

        private String getChronologyName(Chronology chronology, Locale locale) {
            String string = "calendarname." + chronology.getCalendarType();
            String string2 = (String)DateTimeTextProvider.getLocalizedResource(string, locale);
            return string2 != null ? string2 : chronology.getId();
        }
    }

    static class PrefixTree {
        protected String key;
        protected String value;
        protected char c0;
        protected PrefixTree child;
        protected PrefixTree sibling;

        private PrefixTree(String string, String string2, PrefixTree prefixTree) {
            this.key = string;
            this.value = string2;
            this.child = prefixTree;
            this.c0 = string.length() == 0 ? (char)65535 : this.key.charAt(0);
        }

        public static PrefixTree newTree(DateTimeParseContext dateTimeParseContext) {
            if (dateTimeParseContext.isCaseSensitive()) {
                return new PrefixTree("", null, null);
            }
            return new CI("", null, null);
        }

        public static PrefixTree newTree(Set<String> set, DateTimeParseContext dateTimeParseContext) {
            PrefixTree prefixTree = PrefixTree.newTree(dateTimeParseContext);
            for (String string : set) {
                prefixTree.add0(string, string);
            }
            return prefixTree;
        }

        public PrefixTree copyTree() {
            PrefixTree prefixTree = new PrefixTree(this.key, this.value, null);
            if (this.child != null) {
                prefixTree.child = this.child.copyTree();
            }
            if (this.sibling != null) {
                prefixTree.sibling = this.sibling.copyTree();
            }
            return prefixTree;
        }

        public boolean add(String string, String string2) {
            return this.add0(string, string2);
        }

        private boolean add0(String string, String string2) {
            int n = this.prefixLength(string = this.toKey(string));
            if (n == this.key.length()) {
                if (n < string.length()) {
                    String string3 = string.substring(n);
                    PrefixTree prefixTree = this.child;
                    while (prefixTree != null) {
                        if (this.isEqual(prefixTree.c0, string3.charAt(0))) {
                            return prefixTree.add0(string3, string2);
                        }
                        prefixTree = prefixTree.sibling;
                    }
                    prefixTree = this.newNode(string3, string2, null);
                    prefixTree.sibling = this.child;
                    this.child = prefixTree;
                    return true;
                }
                this.value = string2;
                return true;
            }
            PrefixTree prefixTree = this.newNode(this.key.substring(n), this.value, this.child);
            this.key = string.substring(0, n);
            this.child = prefixTree;
            if (n < string.length()) {
                PrefixTree prefixTree2;
                this.child.sibling = prefixTree2 = this.newNode(string.substring(n), string2, null);
                this.value = null;
            } else {
                this.value = string2;
            }
            return true;
        }

        public String match(CharSequence charSequence, int n, int n2) {
            if (!this.prefixOf(charSequence, n, n2)) {
                return null;
            }
            if (this.child != null && (n += this.key.length()) != n2) {
                PrefixTree prefixTree = this.child;
                do {
                    if (!this.isEqual(prefixTree.c0, charSequence.charAt(n))) continue;
                    String string = prefixTree.match(charSequence, n, n2);
                    if (string != null) {
                        return string;
                    }
                    return this.value;
                } while ((prefixTree = prefixTree.sibling) != null);
            }
            return this.value;
        }

        public String match(CharSequence charSequence, ParsePosition parsePosition) {
            int n;
            int n2 = parsePosition.getIndex();
            if (!this.prefixOf(charSequence, n2, n = charSequence.length())) {
                return null;
            }
            if (this.child != null && (n2 += this.key.length()) != n) {
                PrefixTree prefixTree = this.child;
                do {
                    if (!this.isEqual(prefixTree.c0, charSequence.charAt(n2))) continue;
                    parsePosition.setIndex(n2);
                    String string = prefixTree.match(charSequence, parsePosition);
                    if (string == null) break;
                    return string;
                } while ((prefixTree = prefixTree.sibling) != null);
            }
            parsePosition.setIndex(n2);
            return this.value;
        }

        protected String toKey(String string) {
            return string;
        }

        protected PrefixTree newNode(String string, String string2, PrefixTree prefixTree) {
            return new PrefixTree(string, string2, prefixTree);
        }

        protected boolean isEqual(char c, char c2) {
            return c == c2;
        }

        protected boolean prefixOf(CharSequence charSequence, int n, int n2) {
            if (charSequence instanceof String) {
                return ((String)charSequence).startsWith(this.key, n);
            }
            int n3 = this.key.length();
            if (n3 > n2 - n) {
                return false;
            }
            int n4 = 0;
            while (n3-- > 0) {
                if (this.isEqual(this.key.charAt(n4++), charSequence.charAt(n++))) continue;
                return false;
            }
            return true;
        }

        private int prefixLength(String string) {
            int n;
            for (n = 0; n < string.length() && n < this.key.length(); ++n) {
                if (this.isEqual(string.charAt(n), this.key.charAt(n))) continue;
                return n;
            }
            return n;
        }

        private static class LENIENT
        extends CI {
            private LENIENT(String string, String string2, PrefixTree prefixTree) {
                super(string, string2, prefixTree);
            }

            @Override
            protected CI newNode(String string, String string2, PrefixTree prefixTree) {
                return new LENIENT(string, string2, prefixTree);
            }

            private boolean isLenientChar(char c) {
                return c == ' ' || c == '_' || c == '/';
            }

            @Override
            protected String toKey(String string) {
                for (int i = 0; i < string.length(); ++i) {
                    if (!this.isLenientChar(string.charAt(i))) continue;
                    StringBuilder stringBuilder = new StringBuilder(string.length());
                    stringBuilder.append(string, 0, i);
                    ++i;
                    while (i < string.length()) {
                        if (!this.isLenientChar(string.charAt(i))) {
                            stringBuilder.append(string.charAt(i));
                        }
                        ++i;
                    }
                    return stringBuilder.toString();
                }
                return string;
            }

            @Override
            public String match(CharSequence charSequence, ParsePosition parsePosition) {
                int n = parsePosition.getIndex();
                int n2 = charSequence.length();
                int n3 = this.key.length();
                int n4 = 0;
                while (n4 < n3 && n < n2) {
                    if (this.isLenientChar(charSequence.charAt(n))) {
                        ++n;
                        continue;
                    }
                    if (this.isEqual(this.key.charAt(n4++), charSequence.charAt(n++))) continue;
                    return null;
                }
                if (n4 != n3) {
                    return null;
                }
                if (this.child != null && n != n2) {
                    int n5;
                    for (n5 = n; n5 < n2 && this.isLenientChar(charSequence.charAt(n5)); ++n5) {
                    }
                    if (n5 < n2) {
                        PrefixTree prefixTree = this.child;
                        do {
                            if (!this.isEqual(prefixTree.c0, charSequence.charAt(n5))) continue;
                            parsePosition.setIndex(n5);
                            String string = prefixTree.match(charSequence, parsePosition);
                            if (string == null) break;
                            return string;
                        } while ((prefixTree = prefixTree.sibling) != null);
                    }
                }
                parsePosition.setIndex(n);
                return this.value;
            }
        }

        private static class CI
        extends PrefixTree {
            private CI(String string, String string2, PrefixTree prefixTree) {
                super(string, string2, prefixTree);
            }

            @Override
            protected CI newNode(String string, String string2, PrefixTree prefixTree) {
                return new CI(string, string2, prefixTree);
            }

            @Override
            protected boolean isEqual(char c, char c2) {
                return DateTimeParseContext.charEqualsIgnoreCase(c, c2);
            }

            @Override
            protected boolean prefixOf(CharSequence charSequence, int n, int n2) {
                int n3 = this.key.length();
                if (n3 > n2 - n) {
                    return false;
                }
                int n4 = 0;
                while (n3-- > 0) {
                    if (this.isEqual(this.key.charAt(n4++), charSequence.charAt(n++))) continue;
                    return false;
                }
                return true;
            }
        }
    }

    static class ZoneIdPrinterParser
    implements DateTimePrinterParser {
        private final TemporalQuery<ZoneId> query;
        private final String description;
        private static volatile Map.Entry<Integer, PrefixTree> cachedPrefixTree;
        private static volatile Map.Entry<Integer, PrefixTree> cachedPrefixTreeCI;

        ZoneIdPrinterParser(TemporalQuery<ZoneId> temporalQuery, String string) {
            this.query = temporalQuery;
            this.description = string;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            ZoneId zoneId = dateTimePrintContext.getValue(this.query);
            if (zoneId == null) {
                return false;
            }
            stringBuilder.append(zoneId.getId());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PrefixTree getTree(DateTimeParseContext dateTimeParseContext) {
            Map.Entry<Integer, PrefixTree> entry;
            Set<String> set = ZoneRulesProvider.getAvailableZoneIds();
            int n = set.size();
            Map.Entry<Integer, PrefixTree> entry2 = entry = dateTimeParseContext.isCaseSensitive() ? cachedPrefixTree : cachedPrefixTreeCI;
            if (entry == null || entry.getKey() != n) {
                ZoneIdPrinterParser zoneIdPrinterParser = this;
                synchronized (zoneIdPrinterParser) {
                    Map.Entry<Integer, PrefixTree> entry3 = entry = dateTimeParseContext.isCaseSensitive() ? cachedPrefixTree : cachedPrefixTreeCI;
                    if (entry == null || entry.getKey() != n) {
                        entry = new AbstractMap.SimpleImmutableEntry<Integer, PrefixTree>(n, PrefixTree.newTree(set, dateTimeParseContext));
                        if (dateTimeParseContext.isCaseSensitive()) {
                            cachedPrefixTree = entry;
                        } else {
                            cachedPrefixTreeCI = entry;
                        }
                    }
                }
            }
            return entry.getValue();
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            ParsePosition parsePosition;
            PrefixTree prefixTree;
            String string;
            int n2 = charSequence.length();
            if (n > n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n == n2) {
                return ~n;
            }
            char c = charSequence.charAt(n);
            if (c == '+' || c == '-') {
                return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n, OffsetIdPrinterParser.INSTANCE_ID_Z);
            }
            if (n2 >= n + 2) {
                char c2 = charSequence.charAt(n + 1);
                if (dateTimeParseContext.charEquals(c, 'U') && dateTimeParseContext.charEquals(c2, 'T')) {
                    if (n2 >= n + 3 && dateTimeParseContext.charEquals(charSequence.charAt(n + 2), 'C')) {
                        return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n + 3, OffsetIdPrinterParser.INSTANCE_ID_ZERO);
                    }
                    return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n + 2, OffsetIdPrinterParser.INSTANCE_ID_ZERO);
                }
                if (dateTimeParseContext.charEquals(c, 'G') && n2 >= n + 3 && dateTimeParseContext.charEquals(c2, 'M') && dateTimeParseContext.charEquals(charSequence.charAt(n + 2), 'T')) {
                    return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n + 3, OffsetIdPrinterParser.INSTANCE_ID_ZERO);
                }
            }
            if ((string = (prefixTree = this.getTree(dateTimeParseContext)).match(charSequence, parsePosition = new ParsePosition(n))) == null) {
                if (dateTimeParseContext.charEquals(c, 'Z')) {
                    dateTimeParseContext.setParsed(ZoneOffset.UTC);
                    return n + 1;
                }
                return ~n;
            }
            dateTimeParseContext.setParsed(ZoneId.of(string));
            return parsePosition.getIndex();
        }

        private int parseOffsetBased(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n, int n2, OffsetIdPrinterParser offsetIdPrinterParser) {
            String string = charSequence.toString().substring(n, n2).toUpperCase();
            if (n2 >= charSequence.length()) {
                dateTimeParseContext.setParsed(ZoneId.of(string));
                return n2;
            }
            if (charSequence.charAt(n2) == '0' || dateTimeParseContext.charEquals(charSequence.charAt(n2), 'Z')) {
                dateTimeParseContext.setParsed(ZoneId.of(string));
                return n2;
            }
            DateTimeParseContext dateTimeParseContext2 = dateTimeParseContext.copy();
            int n3 = offsetIdPrinterParser.parse(dateTimeParseContext2, charSequence, n2);
            try {
                if (n3 < 0) {
                    if (offsetIdPrinterParser == OffsetIdPrinterParser.INSTANCE_ID_Z) {
                        return ~n;
                    }
                    dateTimeParseContext.setParsed(ZoneId.of(string));
                    return n2;
                }
                int n4 = (int)dateTimeParseContext2.getParsed(ChronoField.OFFSET_SECONDS).longValue();
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n4);
                dateTimeParseContext.setParsed(ZoneId.ofOffset(string, zoneOffset));
                return n3;
            }
            catch (DateTimeException dateTimeException) {
                return ~n;
            }
        }

        public String toString() {
            return this.description;
        }
    }

    static final class ZoneTextPrinterParser
    extends ZoneIdPrinterParser {
        private final TextStyle textStyle;
        private Set<String> preferredZones;
        private static final int STD = 0;
        private static final int DST = 1;
        private static final int GENERIC = 2;
        private static final Map<String, SoftReference<Map<Locale, String[]>>> cache = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();
        private final Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> cachedTree = new HashMap<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>>();
        private final Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> cachedTreeCI = new HashMap<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>>();

        ZoneTextPrinterParser(TextStyle textStyle, Set<ZoneId> set) {
            super(TemporalQueries.zone(), "ZoneText(" + (Object)((Object)textStyle) + ")");
            this.textStyle = Objects.requireNonNull(textStyle, "textStyle");
            if (set != null && set.size() != 0) {
                this.preferredZones = new HashSet<String>();
                for (ZoneId zoneId : set) {
                    this.preferredZones.add(zoneId.getId());
                }
            }
        }

        private String getDisplayName(String string, int n, Locale locale) {
            String[] stringArray;
            if (this.textStyle == TextStyle.NARROW) {
                return null;
            }
            SoftReference<Map<Locale, String[]>> softReference = cache.get(string);
            Map<Locale, String[]> map = null;
            if (softReference == null || (map = softReference.get()) == null || (stringArray = map.get(locale)) == null) {
                stringArray = TimeZoneNameUtility.retrieveDisplayNames(string, locale);
                if (stringArray == null) {
                    return null;
                }
                stringArray = Arrays.copyOfRange(stringArray, 0, 7);
                stringArray[5] = TimeZoneNameUtility.retrieveGenericDisplayName(string, 1, locale);
                if (stringArray[5] == null) {
                    stringArray[5] = stringArray[0];
                }
                stringArray[6] = TimeZoneNameUtility.retrieveGenericDisplayName(string, 0, locale);
                if (stringArray[6] == null) {
                    stringArray[6] = stringArray[0];
                }
                if (map == null) {
                    map = new ConcurrentHashMap<Locale, String[]>();
                }
                map.put(locale, stringArray);
                cache.put(string, new SoftReference<Map<Locale, String[]>>(map));
            }
            switch (n) {
                case 0: {
                    return stringArray[this.textStyle.zoneNameStyleIndex() + 1];
                }
                case 1: {
                    return stringArray[this.textStyle.zoneNameStyleIndex() + 3];
                }
            }
            return stringArray[this.textStyle.zoneNameStyleIndex() + 5];
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            ZoneId zoneId = dateTimePrintContext.getValue(TemporalQueries.zoneId());
            if (zoneId == null) {
                return false;
            }
            String string = zoneId.getId();
            if (!(zoneId instanceof ZoneOffset)) {
                TemporalAccessor temporalAccessor = dateTimePrintContext.getTemporal();
                String string2 = this.getDisplayName(string, temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS) ? (zoneId.getRules().isDaylightSavings(Instant.from(temporalAccessor)) ? 1 : 0) : 2, dateTimePrintContext.getLocale());
                if (string2 != null) {
                    string = string2;
                }
            }
            stringBuilder.append(string);
            return true;
        }

        @Override
        protected PrefixTree getTree(DateTimeParseContext dateTimeParseContext) {
            if (this.textStyle == TextStyle.NARROW) {
                return super.getTree(dateTimeParseContext);
            }
            Locale locale = dateTimeParseContext.getLocale();
            boolean bl = dateTimeParseContext.isCaseSensitive();
            Set<String> set = ZoneRulesProvider.getAvailableZoneIds();
            int n = set.size();
            Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> map = bl ? this.cachedTree : this.cachedTreeCI;
            Map.Entry<Integer, SoftReference<PrefixTree>> entry = null;
            PrefixTree prefixTree = null;
            String[][] stringArray = null;
            entry = map.get(locale);
            if (entry == null || entry.getKey() != n || (prefixTree = entry.getValue().get()) == null) {
                int n2;
                String string;
                prefixTree = PrefixTree.newTree(dateTimeParseContext);
                for (String[] stringArray2 : stringArray = TimeZoneNameUtility.getZoneStrings(locale)) {
                    string = stringArray2[0];
                    if (!set.contains(string)) continue;
                    prefixTree.add(string, string);
                    string = ZoneName.toZid(string, locale);
                    int n3 = n2 = this.textStyle == TextStyle.FULL ? 1 : 2;
                    while (n2 < stringArray2.length) {
                        prefixTree.add(stringArray2[n2], string);
                        n2 += 2;
                    }
                }
                if (this.preferredZones != null) {
                    for (String[] stringArray2 : stringArray) {
                        string = stringArray2[0];
                        if (!this.preferredZones.contains(string) || !set.contains(string)) continue;
                        int n4 = n2 = this.textStyle == TextStyle.FULL ? 1 : 2;
                        while (n2 < stringArray2.length) {
                            prefixTree.add(stringArray2[n2], string);
                            n2 += 2;
                        }
                    }
                }
                map.put(locale, new AbstractMap.SimpleImmutableEntry<Integer, SoftReference<PrefixTree>>(n, new SoftReference<PrefixTree>(prefixTree)));
            }
            return prefixTree;
        }
    }

    static final class LocalizedOffsetIdPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle style;

        LocalizedOffsetIdPrinterParser(TextStyle textStyle) {
            this.style = textStyle;
        }

        private static StringBuilder appendHMS(StringBuilder stringBuilder, int n) {
            return stringBuilder.append((char)(n / 10 + 48)).append((char)(n % 10 + 48));
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            int n;
            Long l = dateTimePrintContext.getValue(ChronoField.OFFSET_SECONDS);
            if (l == null) {
                return false;
            }
            String string = "GMT";
            if (string != null) {
                stringBuilder.append(string);
            }
            if ((n = Math.toIntExact(l)) != 0) {
                int n2 = Math.abs(n / 3600 % 100);
                int n3 = Math.abs(n / 60 % 60);
                int n4 = Math.abs(n % 60);
                stringBuilder.append(n < 0 ? "-" : "+");
                if (this.style == TextStyle.FULL) {
                    LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n2);
                    stringBuilder.append(':');
                    LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n3);
                    if (n4 != 0) {
                        stringBuilder.append(':');
                        LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n4);
                    }
                } else {
                    if (n2 >= 10) {
                        stringBuilder.append((char)(n2 / 10 + 48));
                    }
                    stringBuilder.append((char)(n2 % 10 + 48));
                    if (n3 != 0 || n4 != 0) {
                        stringBuilder.append(':');
                        LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n3);
                        if (n4 != 0) {
                            stringBuilder.append(':');
                            LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n4);
                        }
                    }
                }
            }
            return true;
        }

        int getDigit(CharSequence charSequence, int n) {
            char c = charSequence.charAt(n);
            if (c < '0' || c > '9') {
                return -1;
            }
            return c - 48;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2;
            int n3 = n;
            int n4 = n3 + charSequence.length();
            String string = "GMT";
            if (string != null) {
                if (!dateTimeParseContext.subSequenceEquals(charSequence, n3, string, 0, string.length())) {
                    return ~n;
                }
                n3 += string.length();
            }
            int n5 = 0;
            if (n3 == n4) {
                return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n3);
            }
            char c = charSequence.charAt(n3);
            if (c == '+') {
                n5 = 1;
            } else if (c == '-') {
                n5 = -1;
            } else {
                return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n3);
            }
            ++n3;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (this.style == TextStyle.FULL) {
                n2 = this.getDigit(charSequence, n3++);
                int n9 = this.getDigit(charSequence, n3++);
                if (n2 < 0 || n9 < 0 || charSequence.charAt(n3++) != ':') {
                    return ~n;
                }
                n6 = n2 * 10 + n9;
                int n10 = this.getDigit(charSequence, n3++);
                int n11 = this.getDigit(charSequence, n3++);
                if (n10 < 0 || n11 < 0) {
                    return ~n;
                }
                n7 = n10 * 10 + n11;
                if (n3 + 2 < n4 && charSequence.charAt(n3) == ':') {
                    int n12 = this.getDigit(charSequence, n3 + 1);
                    int n13 = this.getDigit(charSequence, n3 + 2);
                    if (n12 >= 0 && n13 >= 0) {
                        n8 = n12 * 10 + n13;
                        n3 += 3;
                    }
                }
            } else {
                if ((n6 = this.getDigit(charSequence, n3++)) < 0) {
                    return ~n;
                }
                if (n3 < n4) {
                    n2 = this.getDigit(charSequence, n3);
                    if (n2 >= 0) {
                        n6 = n6 * 10 + n2;
                        ++n3;
                    }
                    if (n3 + 2 < n4 && charSequence.charAt(n3) == ':' && n3 + 2 < n4 && charSequence.charAt(n3) == ':') {
                        int n14 = this.getDigit(charSequence, n3 + 1);
                        int n15 = this.getDigit(charSequence, n3 + 2);
                        if (n14 >= 0 && n15 >= 0) {
                            n7 = n14 * 10 + n15;
                            if ((n3 += 3) + 2 < n4 && charSequence.charAt(n3) == ':') {
                                int n16 = this.getDigit(charSequence, n3 + 1);
                                int n17 = this.getDigit(charSequence, n3 + 2);
                                if (n16 >= 0 && n17 >= 0) {
                                    n8 = n16 * 10 + n17;
                                    n3 += 3;
                                }
                            }
                        }
                    }
                }
            }
            long l = (long)n5 * ((long)n6 * 3600L + (long)n7 * 60L + (long)n8);
            return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, l, n, n3);
        }

        public String toString() {
            return "LocalizedOffset(" + (Object)((Object)this.style) + ")";
        }
    }

    static final class OffsetIdPrinterParser
    implements DateTimePrinterParser {
        static final String[] PATTERNS = new String[]{"+HH", "+HHmm", "+HH:mm", "+HHMM", "+HH:MM", "+HHMMss", "+HH:MM:ss", "+HHMMSS", "+HH:MM:SS"};
        static final OffsetIdPrinterParser INSTANCE_ID_Z = new OffsetIdPrinterParser("+HH:MM:ss", "Z");
        static final OffsetIdPrinterParser INSTANCE_ID_ZERO = new OffsetIdPrinterParser("+HH:MM:ss", "0");
        private final String noOffsetText;
        private final int type;

        OffsetIdPrinterParser(String string, String string2) {
            Objects.requireNonNull(string, "pattern");
            Objects.requireNonNull(string2, "noOffsetText");
            this.type = this.checkPattern(string);
            this.noOffsetText = string2;
        }

        private int checkPattern(String string) {
            for (int i = 0; i < PATTERNS.length; ++i) {
                if (!PATTERNS[i].equals(string)) continue;
                return i;
            }
            throw new IllegalArgumentException("Invalid zone offset pattern: " + string);
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            Long l = dateTimePrintContext.getValue(ChronoField.OFFSET_SECONDS);
            if (l == null) {
                return false;
            }
            int n = Math.toIntExact(l);
            if (n == 0) {
                stringBuilder.append(this.noOffsetText);
            } else {
                int n2 = Math.abs(n / 3600 % 100);
                int n3 = Math.abs(n / 60 % 60);
                int n4 = Math.abs(n % 60);
                int n5 = stringBuilder.length();
                int n6 = n2;
                stringBuilder.append(n < 0 ? "-" : "+").append((char)(n2 / 10 + 48)).append((char)(n2 % 10 + 48));
                if (this.type >= 3 || this.type >= 1 && n3 > 0) {
                    stringBuilder.append(this.type % 2 == 0 ? ":" : "").append((char)(n3 / 10 + 48)).append((char)(n3 % 10 + 48));
                    n6 += n3;
                    if (this.type >= 7 || this.type >= 5 && n4 > 0) {
                        stringBuilder.append(this.type % 2 == 0 ? ":" : "").append((char)(n4 / 10 + 48)).append((char)(n4 % 10 + 48));
                        n6 += n4;
                    }
                }
                if (n6 == 0) {
                    stringBuilder.setLength(n5);
                    stringBuilder.append(this.noOffsetText);
                }
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            char c;
            int n2 = charSequence.length();
            int n3 = this.noOffsetText.length();
            if (n3 == 0) {
                if (n == n2) {
                    return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n);
                }
            } else {
                if (n == n2) {
                    return ~n;
                }
                if (dateTimeParseContext.subSequenceEquals(charSequence, n, this.noOffsetText, 0, n3)) {
                    return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n + n3);
                }
            }
            if ((c = charSequence.charAt(n)) == '+' || c == '-') {
                int n4 = c == '-' ? -1 : 1;
                int[] nArray = new int[4];
                nArray[0] = n + 1;
                if (!(this.parseNumber(nArray, 1, charSequence, true) || this.parseNumber(nArray, 2, charSequence, this.type >= 3) || this.parseNumber(nArray, 3, charSequence, false))) {
                    long l = (long)n4 * ((long)nArray[1] * 3600L + (long)nArray[2] * 60L + (long)nArray[3]);
                    return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, l, n, nArray[0]);
                }
            }
            if (n3 == 0) {
                return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n + n3);
            }
            return ~n;
        }

        private boolean parseNumber(int[] nArray, int n, CharSequence charSequence, boolean bl) {
            if ((this.type + 3) / 2 < n) {
                return false;
            }
            int n2 = nArray[0];
            if (this.type % 2 == 0 && n > 1) {
                if (n2 + 1 > charSequence.length() || charSequence.charAt(n2) != ':') {
                    return bl;
                }
                ++n2;
            }
            if (n2 + 2 > charSequence.length()) {
                return bl;
            }
            char c = charSequence.charAt(n2++);
            char c2 = charSequence.charAt(n2++);
            if (c < '0' || c > '9' || c2 < '0' || c2 > '9') {
                return bl;
            }
            int n3 = (c - 48) * 10 + (c2 - 48);
            if (n3 < 0 || n3 > 59) {
                return bl;
            }
            nArray[n] = n3;
            nArray[0] = n2;
            return false;
        }

        public String toString() {
            String string = this.noOffsetText.replace("'", "''");
            return "Offset(" + PATTERNS[this.type] + ",'" + string + "')";
        }
    }

    static final class InstantPrinterParser
    implements DateTimePrinterParser {
        private static final long SECONDS_PER_10000_YEARS = 315569520000L;
        private static final long SECONDS_0000_TO_1970 = 62167219200L;
        private final int fractionalDigits;

        InstantPrinterParser(int n) {
            this.fractionalDigits = n;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            LocalDateTime localDateTime;
            long l;
            long l2;
            long l3;
            Long l4 = dateTimePrintContext.getValue(ChronoField.INSTANT_SECONDS);
            Long l5 = null;
            if (dateTimePrintContext.getTemporal().isSupported(ChronoField.NANO_OF_SECOND)) {
                l5 = dateTimePrintContext.getTemporal().getLong(ChronoField.NANO_OF_SECOND);
            }
            if (l4 == null) {
                return false;
            }
            long l6 = l4;
            int n = ChronoField.NANO_OF_SECOND.checkValidIntValue(l5 != null ? l5 : 0L);
            if (l6 >= -62167219200L) {
                l3 = l6 - 315569520000L + 62167219200L;
                l2 = Math.floorDiv(l3, 315569520000L) + 1L;
                l = Math.floorMod(l3, 315569520000L);
                localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, 0, ZoneOffset.UTC);
                if (l2 > 0L) {
                    stringBuilder.append('+').append(l2);
                }
                stringBuilder.append(localDateTime);
                if (localDateTime.getSecond() == 0) {
                    stringBuilder.append(":00");
                }
            } else {
                l3 = l6 + 62167219200L;
                l2 = l3 / 315569520000L;
                l = l3 % 315569520000L;
                localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, 0, ZoneOffset.UTC);
                int n2 = stringBuilder.length();
                stringBuilder.append(localDateTime);
                if (localDateTime.getSecond() == 0) {
                    stringBuilder.append(":00");
                }
                if (l2 < 0L) {
                    if (localDateTime.getYear() == -10000) {
                        stringBuilder.replace(n2, n2 + 2, Long.toString(l2 - 1L));
                    } else if (l == 0L) {
                        stringBuilder.insert(n2, l2);
                    } else {
                        stringBuilder.insert(n2 + 1, Math.abs(l2));
                    }
                }
            }
            if (this.fractionalDigits < 0 && n > 0 || this.fractionalDigits > 0) {
                stringBuilder.append('.');
                int n3 = 100000000;
                for (int i = 0; this.fractionalDigits == -1 && n > 0 || this.fractionalDigits == -2 && (n > 0 || i % 3 != 0) || i < this.fractionalDigits; ++i) {
                    int n4 = n / n3;
                    stringBuilder.append((char)(n4 + 48));
                    n -= n4 * n3;
                    n3 /= 10;
                }
            }
            stringBuilder.append('Z');
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            DateTimeParseContext dateTimeParseContext2;
            int n2 = this.fractionalDigits < 0 ? 0 : this.fractionalDigits;
            int n3 = this.fractionalDigits < 0 ? 9 : this.fractionalDigits;
            CompositePrinterParser compositePrinterParser = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, n2, n3, true).appendLiteral('Z').toFormatter().toPrinterParser(false);
            int n4 = compositePrinterParser.parse(dateTimeParseContext2 = dateTimeParseContext.copy(), charSequence, n);
            if (n4 < 0) {
                return n4;
            }
            long l = dateTimeParseContext2.getParsed(ChronoField.YEAR);
            int n5 = dateTimeParseContext2.getParsed(ChronoField.MONTH_OF_YEAR).intValue();
            int n6 = dateTimeParseContext2.getParsed(ChronoField.DAY_OF_MONTH).intValue();
            int n7 = dateTimeParseContext2.getParsed(ChronoField.HOUR_OF_DAY).intValue();
            int n8 = dateTimeParseContext2.getParsed(ChronoField.MINUTE_OF_HOUR).intValue();
            Long l2 = dateTimeParseContext2.getParsed(ChronoField.SECOND_OF_MINUTE);
            Long l3 = dateTimeParseContext2.getParsed(ChronoField.NANO_OF_SECOND);
            int n9 = l2 != null ? l2.intValue() : 0;
            int n10 = l3 != null ? l3.intValue() : 0;
            int n11 = 0;
            if (n7 == 24 && n8 == 0 && n9 == 0 && n10 == 0) {
                n7 = 0;
                n11 = 1;
            } else if (n7 == 23 && n8 == 59 && n9 == 60) {
                dateTimeParseContext.setParsedLeapSecond();
                n9 = 59;
            }
            int n12 = (int)l % 10000;
            try {
                LocalDateTime localDateTime = LocalDateTime.of(n12, n5, n6, n7, n8, n9, 0).plusDays(n11);
                long l4 = localDateTime.toEpochSecond(ZoneOffset.UTC);
            }
            catch (RuntimeException runtimeException) {
                return ~n;
            }
            int n13 = n4;
            n13 = dateTimeParseContext.setParsedField(ChronoField.INSTANT_SECONDS, l4 += Math.multiplyExact(l / 10000L, 315569520000L), n, n13);
            return dateTimeParseContext.setParsedField(ChronoField.NANO_OF_SECOND, n10, n, n13);
        }

        public String toString() {
            return "Instant()";
        }
    }

    static final class TextPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final TextStyle textStyle;
        private final DateTimeTextProvider provider;
        private volatile NumberPrinterParser numberPrinterParser;

        TextPrinterParser(TemporalField temporalField, TextStyle textStyle, DateTimeTextProvider dateTimeTextProvider) {
            this.field = temporalField;
            this.textStyle = textStyle;
            this.provider = dateTimeTextProvider;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            Long l = dateTimePrintContext.getValue(this.field);
            if (l == null) {
                return false;
            }
            Chronology chronology = dateTimePrintContext.getTemporal().query(TemporalQueries.chronology());
            String string = chronology == null || chronology == IsoChronology.INSTANCE ? this.provider.getText(this.field, l, this.textStyle, dateTimePrintContext.getLocale()) : this.provider.getText(chronology, this.field, l, this.textStyle, dateTimePrintContext.getLocale());
            if (string == null) {
                return this.numberPrinterParser().format(dateTimePrintContext, stringBuilder);
            }
            stringBuilder.append(string);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2 = charSequence.length();
            if (n < 0 || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            TextStyle textStyle = dateTimeParseContext.isStrict() ? this.textStyle : null;
            Chronology chronology = dateTimeParseContext.getEffectiveChronology();
            Iterator<Map.Entry<String, Long>> iterator = chronology == null || chronology == IsoChronology.INSTANCE ? this.provider.getTextIterator(this.field, textStyle, dateTimeParseContext.getLocale()) : this.provider.getTextIterator(chronology, this.field, textStyle, dateTimeParseContext.getLocale());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Map.Entry<String, Long> entry = iterator.next();
                    String string = entry.getKey();
                    if (!dateTimeParseContext.subSequenceEquals(string, 0, charSequence, n, string.length())) continue;
                    return dateTimeParseContext.setParsedField(this.field, entry.getValue(), n, n + string.length());
                }
                if (dateTimeParseContext.isStrict()) {
                    return ~n;
                }
            }
            return this.numberPrinterParser().parse(dateTimeParseContext, charSequence, n);
        }

        private NumberPrinterParser numberPrinterParser() {
            if (this.numberPrinterParser == null) {
                this.numberPrinterParser = new NumberPrinterParser(this.field, 1, 19, SignStyle.NORMAL);
            }
            return this.numberPrinterParser;
        }

        public String toString() {
            if (this.textStyle == TextStyle.FULL) {
                return "Text(" + this.field + ")";
            }
            return "Text(" + this.field + "," + (Object)((Object)this.textStyle) + ")";
        }
    }

    static final class FractionPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final int minWidth;
        private final int maxWidth;
        private final boolean decimalPoint;

        FractionPrinterParser(TemporalField temporalField, int n, int n2, boolean bl) {
            Objects.requireNonNull(temporalField, "field");
            if (!temporalField.range().isFixed()) {
                throw new IllegalArgumentException("Field must have a fixed set of values: " + temporalField);
            }
            if (n < 0 || n > 9) {
                throw new IllegalArgumentException("Minimum width must be from 0 to 9 inclusive but was " + n);
            }
            if (n2 < 1 || n2 > 9) {
                throw new IllegalArgumentException("Maximum width must be from 1 to 9 inclusive but was " + n2);
            }
            if (n2 < n) {
                throw new IllegalArgumentException("Maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
            }
            this.field = temporalField;
            this.minWidth = n;
            this.maxWidth = n2;
            this.decimalPoint = bl;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            Long l = dateTimePrintContext.getValue(this.field);
            if (l == null) {
                return false;
            }
            DecimalStyle decimalStyle = dateTimePrintContext.getDecimalStyle();
            BigDecimal bigDecimal = this.convertToFraction(l);
            if (bigDecimal.scale() == 0) {
                if (this.minWidth > 0) {
                    if (this.decimalPoint) {
                        stringBuilder.append(decimalStyle.getDecimalSeparator());
                    }
                    for (int i = 0; i < this.minWidth; ++i) {
                        stringBuilder.append(decimalStyle.getZeroDigit());
                    }
                }
            } else {
                int n = Math.min(Math.max(bigDecimal.scale(), this.minWidth), this.maxWidth);
                bigDecimal = bigDecimal.setScale(n, RoundingMode.FLOOR);
                String string = bigDecimal.toPlainString().substring(2);
                string = decimalStyle.convertNumberToI18N(string);
                if (this.decimalPoint) {
                    stringBuilder.append(decimalStyle.getDecimalSeparator());
                }
                stringBuilder.append(string);
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2;
            int n3 = dateTimeParseContext.isStrict() ? this.minWidth : 0;
            int n4 = dateTimeParseContext.isStrict() ? this.maxWidth : 9;
            int n5 = charSequence.length();
            if (n == n5) {
                return n3 > 0 ? ~n : n;
            }
            if (this.decimalPoint) {
                if (charSequence.charAt(n) != dateTimeParseContext.getDecimalStyle().getDecimalSeparator()) {
                    return n3 > 0 ? ~n : n;
                }
                ++n;
            }
            if ((n2 = n + n3) > n5) {
                return ~n;
            }
            int n6 = Math.min(n + n4, n5);
            int n7 = 0;
            int n8 = n;
            while (n8 < n6) {
                char c = charSequence.charAt(n8++);
                int n9 = dateTimeParseContext.getDecimalStyle().convertToDigit(c);
                if (n9 < 0) {
                    if (n8 < n2) {
                        return ~n;
                    }
                    --n8;
                    break;
                }
                n7 = n7 * 10 + n9;
            }
            BigDecimal bigDecimal = new BigDecimal(n7).movePointLeft(n8 - n);
            long l = this.convertFromFraction(bigDecimal);
            return dateTimeParseContext.setParsedField(this.field, l, n, n8);
        }

        private BigDecimal convertToFraction(long l) {
            ValueRange valueRange = this.field.range();
            valueRange.checkValidValue(l, this.field);
            BigDecimal bigDecimal = BigDecimal.valueOf(valueRange.getMinimum());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(valueRange.getMaximum()).subtract(bigDecimal).add(BigDecimal.ONE);
            BigDecimal bigDecimal3 = BigDecimal.valueOf(l).subtract(bigDecimal);
            BigDecimal bigDecimal4 = bigDecimal3.divide(bigDecimal2, 9, RoundingMode.FLOOR);
            return bigDecimal4.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : bigDecimal4.stripTrailingZeros();
        }

        private long convertFromFraction(BigDecimal bigDecimal) {
            ValueRange valueRange = this.field.range();
            BigDecimal bigDecimal2 = BigDecimal.valueOf(valueRange.getMinimum());
            BigDecimal bigDecimal3 = BigDecimal.valueOf(valueRange.getMaximum()).subtract(bigDecimal2).add(BigDecimal.ONE);
            BigDecimal bigDecimal4 = bigDecimal.multiply(bigDecimal3).setScale(0, RoundingMode.FLOOR).add(bigDecimal2);
            return bigDecimal4.longValueExact();
        }

        public String toString() {
            String string = this.decimalPoint ? ",DecimalPoint" : "";
            return "Fraction(" + this.field + "," + this.minWidth + "," + this.maxWidth + string + ")";
        }
    }

    static final class ReducedPrinterParser
    extends NumberPrinterParser {
        static final LocalDate BASE_DATE = LocalDate.of(2000, 1, 1);
        private final int baseValue;
        private final ChronoLocalDate baseDate;

        ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate) {
            this(temporalField, n, n2, n3, chronoLocalDate, 0);
            if (n < 1 || n > 10) {
                throw new IllegalArgumentException("The minWidth must be from 1 to 10 inclusive but was " + n);
            }
            if (n2 < 1 || n2 > 10) {
                throw new IllegalArgumentException("The maxWidth must be from 1 to 10 inclusive but was " + n);
            }
            if (n2 < n) {
                throw new IllegalArgumentException("Maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
            }
            if (chronoLocalDate == null) {
                if (!temporalField.range().isValidValue(n3)) {
                    throw new IllegalArgumentException("The base value must be within the range of the field");
                }
                if ((long)n3 + EXCEED_POINTS[n2] > Integer.MAX_VALUE) {
                    throw new DateTimeException("Unable to add printer-parser as the range exceeds the capacity of an int");
                }
            }
        }

        private ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate, int n4) {
            super(temporalField, n, n2, SignStyle.NOT_NEGATIVE, n4);
            this.baseValue = n3;
            this.baseDate = chronoLocalDate;
        }

        @Override
        long getValue(DateTimePrintContext dateTimePrintContext, long l) {
            long l2 = Math.abs(l);
            int n = this.baseValue;
            if (this.baseDate != null) {
                Chronology chronology = Chronology.from(dateTimePrintContext.getTemporal());
                n = chronology.date(this.baseDate).get(this.field);
            }
            if (l >= (long)n && l < (long)n + EXCEED_POINTS[this.minWidth]) {
                return l2 % EXCEED_POINTS[this.minWidth];
            }
            return l2 % EXCEED_POINTS[this.maxWidth];
        }

        @Override
        int setValue(DateTimeParseContext dateTimeParseContext, long l, int n, int n2) {
            int n3;
            long l2;
            int n4 = this.baseValue;
            if (this.baseDate != null) {
                Chronology chronology2 = dateTimeParseContext.getEffectiveChronology();
                n4 = chronology2.date(this.baseDate).get(this.field);
                l2 = l;
                dateTimeParseContext.addChronoChangedListener(chronology -> this.setValue(dateTimeParseContext, l2, n, n2));
            }
            if ((n3 = n2 - n) == this.minWidth && l >= 0L) {
                l2 = EXCEED_POINTS[this.minWidth];
                long l3 = (long)n4 % l2;
                long l4 = (long)n4 - l3;
                l = n4 > 0 ? l4 + l : l4 - l;
                if (l < (long)n4) {
                    l += l2;
                }
            }
            return dateTimeParseContext.setParsedField(this.field, l, n, n2);
        }

        @Override
        ReducedPrinterParser withFixedWidth() {
            if (this.subsequentWidth == -1) {
                return this;
            }
            return new ReducedPrinterParser(this.field, this.minWidth, this.maxWidth, this.baseValue, this.baseDate, -1);
        }

        @Override
        ReducedPrinterParser withSubsequentWidth(int n) {
            return new ReducedPrinterParser(this.field, this.minWidth, this.maxWidth, this.baseValue, this.baseDate, this.subsequentWidth + n);
        }

        @Override
        boolean isFixedWidth(DateTimeParseContext dateTimeParseContext) {
            if (!dateTimeParseContext.isStrict()) {
                return false;
            }
            return super.isFixedWidth(dateTimeParseContext);
        }

        @Override
        public String toString() {
            return "ReducedValue(" + this.field + "," + this.minWidth + "," + this.maxWidth + "," + (this.baseDate != null ? this.baseDate : Integer.valueOf(this.baseValue)) + ")";
        }
    }

    static class NumberPrinterParser
    implements DateTimePrinterParser {
        static final long[] EXCEED_POINTS = new long[]{0L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L};
        final TemporalField field;
        final int minWidth;
        final int maxWidth;
        private final SignStyle signStyle;
        final int subsequentWidth;

        NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle) {
            this.field = temporalField;
            this.minWidth = n;
            this.maxWidth = n2;
            this.signStyle = signStyle;
            this.subsequentWidth = 0;
        }

        protected NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle, int n3) {
            this.field = temporalField;
            this.minWidth = n;
            this.maxWidth = n2;
            this.signStyle = signStyle;
            this.subsequentWidth = n3;
        }

        NumberPrinterParser withFixedWidth() {
            if (this.subsequentWidth == -1) {
                return this;
            }
            return new NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, -1);
        }

        NumberPrinterParser withSubsequentWidth(int n) {
            return new NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, this.subsequentWidth + n);
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            String string;
            Long l = dateTimePrintContext.getValue(this.field);
            if (l == null) {
                return false;
            }
            long l2 = this.getValue(dateTimePrintContext, l);
            DecimalStyle decimalStyle = dateTimePrintContext.getDecimalStyle();
            String string2 = string = l2 == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l2));
            if (string.length() > this.maxWidth) {
                throw new DateTimeException("Field " + this.field + " cannot be printed as the value " + l2 + " exceeds the maximum print width of " + this.maxWidth);
            }
            string = decimalStyle.convertNumberToI18N(string);
            if (l2 >= 0L) {
                switch (this.signStyle) {
                    case EXCEEDS_PAD: {
                        if (this.minWidth >= 19 || l2 < EXCEED_POINTS[this.minWidth]) break;
                        stringBuilder.append(decimalStyle.getPositiveSign());
                        break;
                    }
                    case ALWAYS: {
                        stringBuilder.append(decimalStyle.getPositiveSign());
                    }
                }
            } else {
                switch (this.signStyle) {
                    case EXCEEDS_PAD: 
                    case ALWAYS: 
                    case NORMAL: {
                        stringBuilder.append(decimalStyle.getNegativeSign());
                        break;
                    }
                    case NOT_NEGATIVE: {
                        throw new DateTimeException("Field " + this.field + " cannot be printed as the value " + l2 + " cannot be negative according to the SignStyle");
                    }
                }
            }
            for (int i = 0; i < this.minWidth - string.length(); ++i) {
                stringBuilder.append(decimalStyle.getZeroDigit());
            }
            stringBuilder.append(string);
            return true;
        }

        long getValue(DateTimePrintContext dateTimePrintContext, long l) {
            return l;
        }

        boolean isFixedWidth(DateTimeParseContext dateTimeParseContext) {
            return this.subsequentWidth == -1 || this.subsequentWidth > 0 && this.minWidth == this.maxWidth && this.signStyle == SignStyle.NOT_NEGATIVE;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2;
            int n3 = charSequence.length();
            if (n == n3) {
                return ~n;
            }
            char c = charSequence.charAt(n);
            boolean bl = false;
            boolean bl2 = false;
            if (c == dateTimeParseContext.getDecimalStyle().getPositiveSign()) {
                if (!this.signStyle.parse(true, dateTimeParseContext.isStrict(), this.minWidth == this.maxWidth)) {
                    return ~n;
                }
                bl2 = true;
                ++n;
            } else if (c == dateTimeParseContext.getDecimalStyle().getNegativeSign()) {
                if (!this.signStyle.parse(false, dateTimeParseContext.isStrict(), this.minWidth == this.maxWidth)) {
                    return ~n;
                }
                bl = true;
                ++n;
            } else if (this.signStyle == SignStyle.ALWAYS && dateTimeParseContext.isStrict()) {
                return ~n;
            }
            int n4 = dateTimeParseContext.isStrict() || this.isFixedWidth(dateTimeParseContext) ? this.minWidth : 1;
            int n5 = n + n4;
            if (n5 > n3) {
                return ~n;
            }
            int n6 = (dateTimeParseContext.isStrict() || this.isFixedWidth(dateTimeParseContext) ? this.maxWidth : 9) + Math.max(this.subsequentWidth, 0);
            long l = 0L;
            BigInteger bigInteger = null;
            int n7 = n;
            for (n2 = 0; n2 < 2; ++n2) {
                int n8;
                int n9 = Math.min(n7 + n6, n3);
                while (n7 < n9) {
                    n8 = charSequence.charAt(n7++);
                    int n10 = dateTimeParseContext.getDecimalStyle().convertToDigit((char)n8);
                    if (n10 < 0) {
                        if (--n7 >= n5) break;
                        return ~n;
                    }
                    if (n7 - n > 18) {
                        if (bigInteger == null) {
                            bigInteger = BigInteger.valueOf(l);
                        }
                        bigInteger = bigInteger.multiply(BigInteger.TEN).add(BigInteger.valueOf(n10));
                        continue;
                    }
                    l = l * 10L + (long)n10;
                }
                if (this.subsequentWidth <= 0 || n2 != 0) break;
                n8 = n7 - n;
                n6 = Math.max(n4, n8 - this.subsequentWidth);
                n7 = n;
                l = 0L;
                bigInteger = null;
            }
            if (bl) {
                if (bigInteger != null) {
                    if (bigInteger.equals(BigInteger.ZERO) && dateTimeParseContext.isStrict()) {
                        return ~(n - 1);
                    }
                    bigInteger = bigInteger.negate();
                } else {
                    if (l == 0L && dateTimeParseContext.isStrict()) {
                        return ~(n - 1);
                    }
                    l = -l;
                }
            } else if (this.signStyle == SignStyle.EXCEEDS_PAD && dateTimeParseContext.isStrict()) {
                n2 = n7 - n;
                if (bl2) {
                    if (n2 <= this.minWidth) {
                        return ~(n - 1);
                    }
                } else if (n2 > this.minWidth) {
                    return ~n;
                }
            }
            if (bigInteger != null) {
                if (bigInteger.bitLength() > 63) {
                    bigInteger = bigInteger.divide(BigInteger.TEN);
                    --n7;
                }
                return this.setValue(dateTimeParseContext, bigInteger.longValue(), n, n7);
            }
            return this.setValue(dateTimeParseContext, l, n, n7);
        }

        int setValue(DateTimeParseContext dateTimeParseContext, long l, int n, int n2) {
            return dateTimeParseContext.setParsedField(this.field, l, n, n2);
        }

        public String toString() {
            if (this.minWidth == 1 && this.maxWidth == 19 && this.signStyle == SignStyle.NORMAL) {
                return "Value(" + this.field + ")";
            }
            if (this.minWidth == this.maxWidth && this.signStyle == SignStyle.NOT_NEGATIVE) {
                return "Value(" + this.field + "," + this.minWidth + ")";
            }
            return "Value(" + this.field + "," + this.minWidth + "," + this.maxWidth + "," + (Object)((Object)this.signStyle) + ")";
        }
    }

    static final class StringLiteralPrinterParser
    implements DateTimePrinterParser {
        private final String literal;

        StringLiteralPrinterParser(String string) {
            this.literal = string;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            stringBuilder.append(this.literal);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2 = charSequence.length();
            if (n > n2 || n < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!dateTimeParseContext.subSequenceEquals(charSequence, n, this.literal, 0, this.literal.length())) {
                return ~n;
            }
            return n + this.literal.length();
        }

        public String toString() {
            String string = this.literal.replace("'", "''");
            return "'" + string + "'";
        }
    }

    static final class CharLiteralPrinterParser
    implements DateTimePrinterParser {
        private final char literal;

        CharLiteralPrinterParser(char c) {
            this.literal = c;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            stringBuilder.append(this.literal);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2 = charSequence.length();
            if (n == n2) {
                return ~n;
            }
            char c = charSequence.charAt(n);
            if (c != this.literal && (dateTimeParseContext.isCaseSensitive() || Character.toUpperCase(c) != Character.toUpperCase(this.literal) && Character.toLowerCase(c) != Character.toLowerCase(this.literal))) {
                return ~n;
            }
            return n + 1;
        }

        public String toString() {
            if (this.literal == '\'') {
                return "''";
            }
            return "'" + this.literal + "'";
        }
    }

    static class DefaultValueParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final long value;

        DefaultValueParser(TemporalField temporalField, long l) {
            this.field = temporalField;
            this.value = l;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            if (dateTimeParseContext.getParsed(this.field) == null) {
                dateTimeParseContext.setParsedField(this.field, this.value, n, n);
            }
            return n;
        }
    }

    static enum SettingsParser implements DateTimePrinterParser
    {
        SENSITIVE,
        INSENSITIVE,
        STRICT,
        LENIENT;


        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            switch (this.ordinal()) {
                case 0: {
                    dateTimeParseContext.setCaseSensitive(true);
                    break;
                }
                case 1: {
                    dateTimeParseContext.setCaseSensitive(false);
                    break;
                }
                case 2: {
                    dateTimeParseContext.setStrict(true);
                    break;
                }
                case 3: {
                    dateTimeParseContext.setStrict(false);
                }
            }
            return n;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "ParseCaseSensitive(true)";
                }
                case 1: {
                    return "ParseCaseSensitive(false)";
                }
                case 2: {
                    return "ParseStrict(true)";
                }
                case 3: {
                    return "ParseStrict(false)";
                }
            }
            throw new IllegalStateException("Unreachable");
        }
    }

    static final class PadPrinterParserDecorator
    implements DateTimePrinterParser {
        private final DateTimePrinterParser printerParser;
        private final int padWidth;
        private final char padChar;

        PadPrinterParserDecorator(DateTimePrinterParser dateTimePrinterParser, int n, char c) {
            this.printerParser = dateTimePrinterParser;
            this.padWidth = n;
            this.padChar = c;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            int n = stringBuilder.length();
            if (!this.printerParser.format(dateTimePrintContext, stringBuilder)) {
                return false;
            }
            int n2 = stringBuilder.length() - n;
            if (n2 > this.padWidth) {
                throw new DateTimeException("Cannot print as output of " + n2 + " characters exceeds pad width of " + this.padWidth);
            }
            for (int i = 0; i < this.padWidth - n2; ++i) {
                stringBuilder.insert(n, this.padChar);
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2;
            boolean bl = dateTimeParseContext.isStrict();
            if (n > charSequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (n == charSequence.length()) {
                return ~n;
            }
            int n3 = n + this.padWidth;
            if (n3 > charSequence.length()) {
                if (bl) {
                    return ~n;
                }
                n3 = charSequence.length();
            }
            for (n2 = n; n2 < n3 && dateTimeParseContext.charEquals(charSequence.charAt(n2), this.padChar); ++n2) {
            }
            int n4 = this.printerParser.parse(dateTimeParseContext, charSequence = charSequence.subSequence(0, n3), n2);
            if (n4 != n3 && bl) {
                return ~(n + n2);
            }
            return n4;
        }

        public String toString() {
            return "Pad(" + this.printerParser + "," + this.padWidth + (this.padChar == ' ' ? ")" : ",'" + this.padChar + "')");
        }
    }

    static final class CompositePrinterParser
    implements DateTimePrinterParser {
        private final DateTimePrinterParser[] printerParsers;
        private final boolean optional;

        CompositePrinterParser(List<DateTimePrinterParser> list, boolean bl) {
            this(list.toArray(new DateTimePrinterParser[list.size()]), bl);
        }

        CompositePrinterParser(DateTimePrinterParser[] dateTimePrinterParserArray, boolean bl) {
            this.printerParsers = dateTimePrinterParserArray;
            this.optional = bl;
        }

        public CompositePrinterParser withOptional(boolean bl) {
            if (bl == this.optional) {
                return this;
            }
            return new CompositePrinterParser(this.printerParsers, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            int n = stringBuilder.length();
            if (this.optional) {
                dateTimePrintContext.startOptional();
            }
            try {
                for (DateTimePrinterParser dateTimePrinterParser : this.printerParsers) {
                    if (dateTimePrinterParser.format(dateTimePrintContext, stringBuilder)) continue;
                    stringBuilder.setLength(n);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (this.optional) {
                    dateTimePrintContext.endOptional();
                }
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            DateTimePrinterParser dateTimePrinterParser;
            if (this.optional) {
                dateTimeParseContext.startOptional();
                int n2 = n;
                for (DateTimePrinterParser dateTimePrinterParser2 : this.printerParsers) {
                    if ((n2 = dateTimePrinterParser2.parse(dateTimeParseContext, charSequence, n2)) >= 0) continue;
                    dateTimeParseContext.endOptional(false);
                    return n;
                }
                dateTimeParseContext.endOptional(true);
                return n2;
            }
            DateTimePrinterParser[] dateTimePrinterParserArray = this.printerParsers;
            int n3 = dateTimePrinterParserArray.length;
            for (int i = 0; i < n3 && (n = (dateTimePrinterParser = dateTimePrinterParserArray[i]).parse(dateTimeParseContext, charSequence, n)) >= 0; ++i) {
            }
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.printerParsers != null) {
                stringBuilder.append(this.optional ? "[" : "(");
                for (DateTimePrinterParser dateTimePrinterParser : this.printerParsers) {
                    stringBuilder.append(dateTimePrinterParser);
                }
                stringBuilder.append(this.optional ? "]" : ")");
            }
            return stringBuilder.toString();
        }
    }

    static interface DateTimePrinterParser {
        public boolean format(DateTimePrintContext var1, StringBuilder var2);

        public int parse(DateTimeParseContext var1, CharSequence var2, int var3);
    }
}

