/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.jar.Manifest;
import sun.nio.ByteBuffered;

public abstract class Resource {
    private InputStream cis;

    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength() throws IOException;

    private synchronized InputStream cachedInputStream() throws IOException {
        if (this.cis == null) {
            this.cis = this.getInputStream();
        }
        return this.cis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] byArray;
        int n;
        InputStream inputStream = this.cachedInputStream();
        boolean bl = Thread.interrupted();
        while (true) {
            try {
                n = this.getContentLength();
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.interrupted();
                bl = true;
                continue;
            }
            break;
        }
        try {
            int n2;
            byArray = new byte[]{};
            if (n == -1) {
                n = Integer.MAX_VALUE;
            }
            for (int i = 0; i < n; i += n2) {
                int n3;
                if (i >= byArray.length) {
                    n3 = Math.min(n - i, byArray.length + 1024);
                    if (byArray.length < i + n3) {
                        byArray = Arrays.copyOf(byArray, i + n3);
                    }
                } else {
                    n3 = byArray.length - i;
                }
                n2 = 0;
                try {
                    n2 = inputStream.read(byArray, i, n3);
                }
                catch (InterruptedIOException interruptedIOException) {
                    Thread.interrupted();
                    bl = true;
                }
                if (n2 >= 0) continue;
                if (n != Integer.MAX_VALUE) {
                    throw new EOFException("Detect premature EOF");
                }
                if (byArray.length != i) {
                    byArray = Arrays.copyOf(byArray, i);
                }
                break;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                bl = true;
            }
            catch (IOException iOException) {}
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        return byArray;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        InputStream inputStream = this.cachedInputStream();
        if (inputStream instanceof ByteBuffered) {
            return ((ByteBuffered)((Object)inputStream)).getByteBuffer();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        return null;
    }

    public Exception getDataError() {
        return null;
    }
}

