/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.net.SocketPermission;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sun.misc.ObjectInputFilter;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.RuntimeUtil;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.Util;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

final class DGCImpl
implements DGC {
    static final Log dgcLog = Log.getLog("sun.rmi.dgc", "dgc", LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.dgc.logLevel"))));
    private static final long leaseValue = AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
    private static final long leaseCheckInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.checkInterval", leaseValue / 2L));
    private static final ScheduledExecutorService scheduler = AccessController.doPrivileged(new RuntimeUtil.GetInstanceAction()).getScheduler();
    private static DGCImpl dgc;
    private Map<VMID, LeaseInfo> leaseTable = new HashMap<VMID, LeaseInfo>();
    private Future<?> checker = null;
    private static final String DGC_FILTER_PROPNAME = "sun.rmi.transport.dgcFilter";
    private static int DGC_MAX_DEPTH;
    private static int DGC_MAX_ARRAY_SIZE;
    private static final ObjectInputFilter dgcFilter;

    static DGCImpl getDGCImpl() {
        return dgc;
    }

    private static ObjectInputFilter initDgcFilter() {
        ObjectInputFilter objectInputFilter = null;
        String string = System.getProperty(DGC_FILTER_PROPNAME);
        if (string == null) {
            string = Security.getProperty(DGC_FILTER_PROPNAME);
        }
        if (string != null) {
            objectInputFilter = ObjectInputFilter.Config.createFilter(string);
            if (dgcLog.isLoggable(Log.BRIEF)) {
                dgcLog.log(Log.BRIEF, "dgcFilter = " + objectInputFilter);
            }
        }
        return objectInputFilter;
    }

    private DGCImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lease dirty(ObjID[] objIDArray, long l, Lease lease) {
        ObjID[] objIDArray2;
        VMID vMID = lease.getVMID();
        long l2 = leaseValue;
        if (dgcLog.isLoggable(Log.VERBOSE)) {
            dgcLog.log(Log.VERBOSE, "vmid = " + vMID);
        }
        if (vMID == null) {
            vMID = new VMID();
            if (dgcLog.isLoggable(Log.BRIEF)) {
                try {
                    objIDArray2 = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    objIDArray2 = "<unknown host>";
                }
                dgcLog.log(Log.BRIEF, " assigning vmid " + vMID + " to client " + (String)objIDArray2);
            }
        }
        lease = new Lease(vMID, l2);
        objIDArray2 = this.leaseTable;
        synchronized (objIDArray2) {
            LeaseInfo leaseInfo = this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                this.leaseTable.put(vMID, new LeaseInfo(vMID, l2));
                if (this.checker == null) {
                    this.checker = scheduler.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            DGCImpl.this.checkLeases();
                        }
                    }, leaseCheckInterval, leaseCheckInterval, TimeUnit.MILLISECONDS);
                }
            } else {
                leaseInfo.renew(l2);
            }
        }
        for (ObjID objID : objIDArray) {
            if (dgcLog.isLoggable(Log.VERBOSE)) {
                dgcLog.log(Log.VERBOSE, "id = " + objID + ", vmid = " + vMID + ", duration = " + l2);
            }
            ObjectTable.referenced(objID, l, vMID);
        }
        return lease;
    }

    @Override
    public void clean(ObjID[] objIDArray, long l, VMID vMID, boolean bl) {
        for (ObjID objID : objIDArray) {
            if (dgcLog.isLoggable(Log.VERBOSE)) {
                dgcLog.log(Log.VERBOSE, "id = " + objID + ", vmid = " + vMID + ", strong = " + bl);
            }
            ObjectTable.unreferenced(objID, l, vMID, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTarget(VMID vMID, Target target) {
        Map<VMID, LeaseInfo> map = this.leaseTable;
        synchronized (map) {
            LeaseInfo leaseInfo = this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                target.vmidDead(vMID);
            } else {
                leaseInfo.notifySet.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTarget(VMID vMID, Target target) {
        Map<VMID, LeaseInfo> map = this.leaseTable;
        synchronized (map) {
            LeaseInfo leaseInfo = this.leaseTable.get(vMID);
            if (leaseInfo != null) {
                leaseInfo.notifySet.remove(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLeases() {
        long l = System.currentTimeMillis();
        ArrayList<LeaseInfo> arrayList = new ArrayList<LeaseInfo>();
        Map<VMID, LeaseInfo> map = this.leaseTable;
        synchronized (map) {
            Iterator<LeaseInfo> object = this.leaseTable.values().iterator();
            while (object.hasNext()) {
                LeaseInfo leaseInfo = object.next();
                if (!leaseInfo.expired(l)) continue;
                arrayList.add(leaseInfo);
                object.remove();
            }
            if (this.leaseTable.isEmpty()) {
                this.checker.cancel(false);
                this.checker = null;
            }
        }
        for (LeaseInfo leaseInfo : arrayList) {
            for (Target target : leaseInfo.notifySet) {
                target.vmidDead(leaseInfo.vmid);
            }
        }
    }

    private static ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        Object object;
        if (dgcFilter != null && (object = dgcFilter.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
            return object;
        }
        if (filterInfo.depth() > (long)DGC_MAX_DEPTH) {
            return ObjectInputFilter.Status.REJECTED;
        }
        object = filterInfo.serialClass();
        if (object != null) {
            while (((Class)object).isArray()) {
                if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > (long)DGC_MAX_ARRAY_SIZE) {
                    return ObjectInputFilter.Status.REJECTED;
                }
                object = ((Class)object).getComponentType();
            }
            if (((Class)object).isPrimitive()) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            return object == ObjID.class || object == UID.class || object == VMID.class || object == Lease.class ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
        }
        return ObjectInputFilter.Status.UNDECIDED;
    }

    static {
        DGC_MAX_DEPTH = 5;
        DGC_MAX_ARRAY_SIZE = 10000;
        dgcFilter = AccessController.doPrivileged(DGCImpl::initDgcFilter);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    try {
                        dgc = new DGCImpl();
                        final ObjID objID = new ObjID(2);
                        LiveRef liveRef = new LiveRef(objID, 0);
                        final UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef, filterInfo -> DGCImpl.checkInput(filterInfo));
                        final Remote remote = Util.createProxy(DGCImpl.class, new UnicastRef(liveRef), true);
                        unicastServerRef.setSkeleton(dgc);
                        Permissions permissions = new Permissions();
                        permissions.add(new SocketPermission("*", "accept,resolve"));
                        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{new ProtectionDomain(null, permissions)};
                        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
                        Target target = AccessController.doPrivileged(new PrivilegedAction<Target>(){

                            @Override
                            public Target run() {
                                return new Target(dgc, unicastServerRef, remote, objID, true);
                            }
                        }, accessControlContext);
                        ObjectTable.putTarget(target);
                    }
                    catch (RemoteException remoteException) {
                        throw new Error("exception initializing server-side DGC", remoteException);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                return null;
            }
        });
    }

    private static class LeaseInfo {
        VMID vmid;
        long expiration;
        Set<Target> notifySet = new HashSet<Target>();

        LeaseInfo(VMID vMID, long l) {
            this.vmid = vMID;
            this.expiration = System.currentTimeMillis() + l;
        }

        synchronized void renew(long l) {
            long l2 = System.currentTimeMillis() + l;
            if (l2 > this.expiration) {
                this.expiration = l2;
            }
        }

        boolean expired(long l) {
            if (this.expiration < l) {
                if (dgcLog.isLoggable(Log.BRIEF)) {
                    dgcLog.log(Log.BRIEF, this.vmid.toString());
                }
                return true;
            }
            return false;
        }
    }
}

