/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.IOException;
import java.util.List;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.ccache.FileCredentialsCache;

public abstract class CredentialsCache {
    static CredentialsCache singleton = null;
    static String cacheName;
    private static boolean DEBUG;

    public static CredentialsCache getInstance(PrincipalName principalName) {
        return FileCredentialsCache.acquireInstance(principalName, null);
    }

    public static CredentialsCache getInstance(String string) {
        if (string.length() >= 5 && string.substring(0, 5).equalsIgnoreCase("FILE:")) {
            return FileCredentialsCache.acquireInstance(null, string.substring(5));
        }
        return FileCredentialsCache.acquireInstance(null, string);
    }

    public static CredentialsCache getInstance(PrincipalName principalName, String string) {
        if (string != null && string.length() >= 5 && string.regionMatches(true, 0, "FILE:", 0, 5)) {
            return FileCredentialsCache.acquireInstance(principalName, string.substring(5));
        }
        return FileCredentialsCache.acquireInstance(principalName, string);
    }

    public static CredentialsCache getInstance() {
        return FileCredentialsCache.acquireInstance();
    }

    public static CredentialsCache create(PrincipalName principalName, String string) {
        if (string == null) {
            throw new RuntimeException("cache name error");
        }
        if (string.length() >= 5 && string.regionMatches(true, 0, "FILE:", 0, 5)) {
            string = string.substring(5);
            return FileCredentialsCache.New(principalName, string);
        }
        return FileCredentialsCache.New(principalName, string);
    }

    public static CredentialsCache create(PrincipalName principalName) {
        return FileCredentialsCache.New(principalName);
    }

    public static String cacheName() {
        return cacheName;
    }

    public abstract PrincipalName getPrimaryPrincipal();

    public abstract void update(sun.security.krb5.internal.ccache.Credentials var1);

    public abstract void save() throws IOException, KrbException;

    public abstract sun.security.krb5.internal.ccache.Credentials[] getCredsList();

    public abstract sun.security.krb5.internal.ccache.Credentials getDefaultCreds();

    public abstract Credentials getInitialCreds();

    public abstract sun.security.krb5.internal.ccache.Credentials getCreds(PrincipalName var1);

    public abstract sun.security.krb5.internal.ccache.Credentials getCreds(LoginOptions var1, PrincipalName var2);

    public abstract void addConfigEntry(ConfigEntry var1);

    public abstract List<ConfigEntry> getConfigEntries();

    public ConfigEntry getConfigEntry(String string) {
        List<ConfigEntry> list = this.getConfigEntries();
        if (list != null) {
            for (ConfigEntry configEntry : list) {
                if (!configEntry.getName().equals(string)) continue;
                return configEntry;
            }
        }
        return null;
    }

    static {
        DEBUG = Krb5.DEBUG;
    }

    public static class ConfigEntry {
        private final String name;
        private final PrincipalName princ;
        private final byte[] data;

        public ConfigEntry(String string, PrincipalName principalName, byte[] byArray) {
            this.name = string;
            this.princ = principalName;
            this.data = byArray;
        }

        public String getName() {
            return this.name;
        }

        public PrincipalName getPrinc() {
            return this.princ;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.name + (this.princ != null ? "." + this.princ : "") + ": " + new String(this.data);
        }

        public PrincipalName getSName() {
            try {
                return new PrincipalName("krb5_ccache_conf_data/" + this.name + (this.princ != null ? "/" + this.princ : "") + "@X-CACHECONF:");
            }
            catch (RealmException realmException) {
                throw new AssertionError((Object)realmException);
            }
        }
    }
}

