
#ifndef KDECORATIONS2_EXPORT_H
#define KDECORATIONS2_EXPORT_H

#ifdef KDECORATIONS2_STATIC_DEFINE
#  define KDECORATIONS2_EXPORT
#  define KDECORATIONS2_NO_EXPORT
#else
#  ifndef KDECORATIONS2_EXPORT
#    ifdef kdecorations2_EXPORTS
        /* We are building this library */
#      define KDECORATIONS2_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDECORATIONS2_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDECORATIONS2_NO_EXPORT
#    define KDECORATIONS2_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDECORATIONS2_DECL_DEPRECATED
#  define KDECORATIONS2_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDECORATIONS2_DECL_DEPRECATED_EXPORT
#  define KDECORATIONS2_DECL_DEPRECATED_EXPORT KDECORATIONS2_EXPORT KDECORATIONS2_DECL_DEPRECATED
#endif

#ifndef KDECORATIONS2_DECL_DEPRECATED_NO_EXPORT
#  define KDECORATIONS2_DECL_DEPRECATED_NO_EXPORT KDECORATIONS2_NO_EXPORT KDECORATIONS2_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDECORATIONS2_NO_DEPRECATED
#    define KDECORATIONS2_NO_DEPRECATED
#  endif
#endif

#define KDECORATIONS2_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

#if defined(KDECORATIONS2_NO_DEPRECATED)
#  undef KDECORATIONS2_DEPRECATED
#  define KDECORATIONS2_DEPRECATED_EXPORT KDECORATIONS2_EXPORT
#  define KDECORATIONS2_DEPRECATED_NO_EXPORT KDECORATIONS2_NO_EXPORT
#elif defined(KDECORATIONS2_NO_DEPRECATED_WARNINGS)
#  define KDECORATIONS2_DEPRECATED
#  define KDECORATIONS2_DEPRECATED_EXPORT KDECORATIONS2_EXPORT
#  define KDECORATIONS2_DEPRECATED_NO_EXPORT KDECORATIONS2_NO_EXPORT
#else
#  define KDECORATIONS2_DEPRECATED KDECORATIONS2_DECL_DEPRECATED
#  define KDECORATIONS2_DEPRECATED_EXPORT KDECORATIONS2_DECL_DEPRECATED_EXPORT
#  define KDECORATIONS2_DEPRECATED_NO_EXPORT KDECORATIONS2_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDECORATIONS2_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDECORATIONS2_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDECORATIONS2_NO_DEPRECATED
#  define KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x51904
#endif
#ifdef KDECORATIONS2_NO_DEPRECATED_WARNINGS
#  define KDECORATIONS2_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDECORATIONS2_DEPRECATED_WARNINGS_SINCE
#  ifdef KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDECORATIONS2_DEPRECATED_WARNINGS_SINCE KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDECORATIONS2_DEPRECATED_WARNINGS_SINCE 0x51904
#  endif
#endif

#ifndef KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KDECORATIONS2_DEPRECATED
#  define KDECORATIONS2_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDECORATIONS2_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDECORATIONS2_DEPRECATED_WARNINGS_SINCE >= 0x51500
#  define KDECORATIONS2_DEPRECATED_VERSION_5_21(text) KDECORATIONS2_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECORATIONS2_DEPRECATED_VERSION_5_21(text)
#endif
#define KDECORATIONS2_DEPRECATED_VERSION_5(minor, text)      KDECORATIONS2_DEPRECATED_VERSION_5_##minor(text)
#define KDECORATIONS2_DEPRECATED_VERSION(major, minor, text) KDECORATIONS2_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDECORATIONS2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECORATIONS2_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDECORATIONS2_DEPRECATED_VERSION(major, minor, text)
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECORATIONS2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KDECORATIONS2_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KDECORATIONS2_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KDECORATIONS2_EXPORT_H


#define KDECORATIONS2_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

#if defined(KDECORATIONS2_NO_DEPRECATED)
#  undef KDECORATIONS2_DEPRECATED
#  define KDECORATIONS2_DEPRECATED_EXPORT KDECORATIONS2_EXPORT
#  define KDECORATIONS2_DEPRECATED_NO_EXPORT KDECORATIONS2_NO_EXPORT
#elif defined(KDECORATIONS2_NO_DEPRECATED_WARNINGS)
#  define KDECORATIONS2_DEPRECATED
#  define KDECORATIONS2_DEPRECATED_EXPORT KDECORATIONS2_EXPORT
#  define KDECORATIONS2_DEPRECATED_NO_EXPORT KDECORATIONS2_NO_EXPORT
#else
#  define KDECORATIONS2_DEPRECATED KDECORATIONS2_DECL_DEPRECATED
#  define KDECORATIONS2_DEPRECATED_EXPORT KDECORATIONS2_DECL_DEPRECATED_EXPORT
#  define KDECORATIONS2_DEPRECATED_NO_EXPORT KDECORATIONS2_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDECORATIONS2_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDECORATIONS2_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDECORATIONS2_NO_DEPRECATED
#  define KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x51904
#endif
#ifdef KDECORATIONS2_NO_DEPRECATED_WARNINGS
#  define KDECORATIONS2_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDECORATIONS2_DEPRECATED_WARNINGS_SINCE
#  ifdef KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDECORATIONS2_DEPRECATED_WARNINGS_SINCE KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDECORATIONS2_DEPRECATED_WARNINGS_SINCE 0x51904
#  endif
#endif

#ifndef KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KDECORATIONS2_DEPRECATED
#  define KDECORATIONS2_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDECORATIONS2_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDECORATIONS2_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDECORATIONS2_DEPRECATED_WARNINGS_SINCE >= 0x51500
#  define KDECORATIONS2_DEPRECATED_VERSION_5_21(text) KDECORATIONS2_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECORATIONS2_DEPRECATED_VERSION_5_21(text)
#endif
#define KDECORATIONS2_DEPRECATED_VERSION_5(minor, text)      KDECORATIONS2_DEPRECATED_VERSION_5_##minor(text)
#define KDECORATIONS2_DEPRECATED_VERSION(major, minor, text) KDECORATIONS2_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDECORATIONS2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECORATIONS2_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDECORATIONS2_DEPRECATED_VERSION(major, minor, text)
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECORATIONS2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDECORATIONS2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KDECORATIONS2_EXPORT_H */
