
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "mbim-ms-uicc-low-level-access.h"
#include "mbim-message-private.h"
#include "mbim-enum-types.h"
#include "mbim-error-types.h"
#include "mbim-device.h"
#include "mbim-utils.h"

/*****************************************************************************/
/* Struct: MbimTerminalCapabilityInfo */

static void
_mbim_terminal_capability_info_free (MbimTerminalCapabilityInfo *var)
{
    if (!var)
        return;

    g_free (var->terminal_capability_data);
    g_free (var);
}

void
mbim_terminal_capability_info_array_free (MbimTerminalCapabilityInfoArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_terminal_capability_info_free (array[i]);
    g_free (array);
}

static MbimTerminalCapabilityInfo *
_mbim_message_read_mbim_terminal_capability_info_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimTerminalCapabilityInfo *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimTerminalCapabilityInfo, 1);

    {
        const guint8 *tmp;

        if (!_mbim_message_read_byte_array (self, relative_offset, offset, FALSE, FALSE, 0, &tmp, &(out->terminal_capability_data_size), error, FALSE))
            goto out;
        out->terminal_capability_data = g_malloc (out->terminal_capability_data_size);
        memcpy (out->terminal_capability_data, tmp, out->terminal_capability_data_size);
        /* no offset update expected, this should be the last field */
    }

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->terminal_capability_data);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_terminal_capability_info_struct_array (
    const MbimMessage *self,
    guint32 array_size,
    guint32 relative_offset_array_start,
    gboolean refs,
    MbimTerminalCapabilityInfoArray **out_array,
    GError **error)
{
    GError *inner_error = NULL;
    MbimTerminalCapabilityInfoArray *out;
    guint32 i;
    guint32 offset;

    if (!array_size) {
        *out_array = NULL;
        return TRUE;
    }

    out = g_new0 (MbimTerminalCapabilityInfo *, array_size + 1);

    if (!refs) {
        _mbim_message_read_guint32 (self, relative_offset_array_start, &offset, &inner_error);
        for (i = 0; !inner_error && (i < array_size); i++, offset += 0)
            out[i] = _mbim_message_read_mbim_terminal_capability_info_struct (self, offset, NULL, &inner_error);
    } else {
        offset = relative_offset_array_start;
        for (i = 0; !inner_error && (i < array_size); i++, offset += 8) {
            guint32 tmp_offset;

            if (_mbim_message_read_guint32 (self, offset, &tmp_offset, &inner_error))
                out[i] = _mbim_message_read_mbim_terminal_capability_info_struct (self, tmp_offset, NULL, &inner_error);
        }
    }

    if (!inner_error) {
        *out_array = out;
        return TRUE;
    }

    mbim_terminal_capability_info_array_free (out);
    g_propagate_error (error, inner_error);
    return FALSE;
}

static gchar *
_mbim_message_print_mbim_terminal_capability_info_struct (
    const MbimTerminalCapabilityInfo *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  TerminalCapabilityData = ", line_prefix);
    {
        guint i;
        guint array_size;

        array_size = self->terminal_capability_data_size;
        g_string_append (str, "'");
        for (i = 0; i < array_size; i++)
            g_string_append_printf (str, "%02x%s", self->terminal_capability_data[i], (i == (array_size - 1)) ? "" : ":" );
        g_string_append (str, "'");
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_terminal_capability_info_struct_new (const MbimTerminalCapabilityInfo *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_byte_array (builder, FALSE, FALSE, TRUE, value->terminal_capability_data, value->terminal_capability_data_size, FALSE);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_terminal_capability_info_struct (
    MbimStructBuilder *builder,
    const MbimTerminalCapabilityInfo *value)
{
    GByteArray *raw;

    raw = _mbim_terminal_capability_info_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_terminal_capability_info_struct (
    MbimMessageCommandBuilder *builder,
    const MbimTerminalCapabilityInfo *value)
{
    _mbim_struct_builder_append_mbim_terminal_capability_info_struct (builder->contents_builder, value);
}

static void
_mbim_struct_builder_append_mbim_terminal_capability_info_struct_array (
    MbimStructBuilder *builder,
    const MbimTerminalCapabilityInfo *const *values,
    guint32 n_values,
    gboolean refs)
{
    guint32 offset;
    guint32 i;
    GByteArray *raw_all = NULL;

    if (!refs) {
        for (i = 0; i < n_values; i++) {
            GByteArray *raw;

            raw = _mbim_terminal_capability_info_struct_new (values[i]);
            if (!raw_all)
                raw_all = raw;
            else {
                g_byte_array_append (raw_all, raw->data, raw->len);
                g_byte_array_unref (raw);
            }
        }

        if (!raw_all) {
            offset = 0;
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
        } else {
            guint32 offset_offset;

            /* Offset of the offset */
            offset_offset = builder->fixed_buffer->len;
            /* Length *not* in LE yet */
            offset = builder->variable_buffer->len;
            /* Add the offset value */
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
            /* Configure the value to get updated */
            g_array_append_val (builder->offsets, offset_offset);
            /* Add the final array itself */
            g_byte_array_append (builder->variable_buffer, raw_all->data, raw_all->len);
            g_byte_array_unref (raw_all);
        }
    } else {
        for (i = 0; i < n_values; i++) {
            guint32 length;
            guint32 offset_offset;
            GByteArray *raw;

            raw = _mbim_terminal_capability_info_struct_new (values[i]);
            g_assert (raw->len > 0);

            /* Offset of the offset */
            offset_offset = builder->fixed_buffer->len;

            /* Length *not* in LE yet */
            offset = builder->variable_buffer->len;
            /* Add the offset value */
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
            /* Configure the value to get updated */
            g_array_append_val (builder->offsets, offset_offset);

            /* Add the length value */
            length = GUINT32_TO_LE (raw->len);
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&length, sizeof (length));

            /* And finally, the bytearray itself to the variable buffer */
            g_byte_array_append (builder->variable_buffer, (const guint8 *)raw->data, (guint)raw->len);
            g_byte_array_unref (raw);
        }
    }
}

static void
_mbim_message_command_builder_append_mbim_terminal_capability_info_struct_array (
    MbimMessageCommandBuilder *builder,
    const MbimTerminalCapabilityInfo *const *values,
    guint32 n_values,
    gboolean refs)
{
    _mbim_struct_builder_append_mbim_terminal_capability_info_struct_array (builder->contents_builder, values, n_values, refs);
}

/*****************************************************************************/
/* Message (Query): MBIM Message MS UICC Low Level Access ATR */

MbimMessage *
mbim_message_ms_uicc_low_level_access_atr_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_ATR,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_atr_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS UICC Low Level Access ATR */

gboolean
mbim_message_ms_uicc_low_level_access_atr_response_parse (
    const MbimMessage *message,
    gchar **out_atr,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_atr = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'atr' variable */
    {
        if ((out_atr != NULL) && !_mbim_message_read_string (message, 0, offset, &_atr, error))
            goto out;
        offset += 8;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_atr != NULL)
            *out_atr = _atr;
    } else {
        g_free (_atr);
    }

    return success;
}

static gchar *
mbim_message_ms_uicc_low_level_access_atr_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  atr = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        g_string_append_printf (str, "'%s'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS UICC Low Level Access Open Channel */

MbimMessage *
mbim_message_ms_uicc_low_level_access_open_channel_set_new (
    const guint32 app_id_size,
    const guint8 *app_id,
    guint32 select_p2_arg,
    guint32 channel_group,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_OPEN_CHANNEL,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_byte_array (builder, TRUE, TRUE, TRUE, app_id, app_id_size, TRUE);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, select_p2_arg);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, channel_group);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_open_channel_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  AppId = ", line_prefix);
    {
        guint i;
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, TRUE, TRUE, 0, &tmp, &tmpsize, &inner_error, TRUE))
            goto out;
        offset += 8;
        g_string_append (str, "'");
        for (i = 0; i  < tmpsize; i++)
            g_string_append_printf (str, "%02x%s", tmp[i], (i == (tmpsize - 1)) ? "" : ":" );
        g_string_append (str, "'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SelectP2Arg = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ChannelGroup = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS UICC Low Level Access Open Channel */

gboolean
mbim_message_ms_uicc_low_level_access_open_channel_response_parse (
    const MbimMessage *message,
    guint32 *out_status,
    guint32 *out_channel,
    guint32 *out_response_size,
    const guint8 **out_response,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'Status' variable */
    {
        if ((out_status != NULL) && !_mbim_message_read_guint32 (message, offset, out_status, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Channel' variable */
    {
        if ((out_channel != NULL) && !_mbim_message_read_guint32 (message, offset, out_channel, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Response' variable */
    {
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, TRUE, TRUE, 0, &tmp, &tmpsize, error, TRUE))
            goto out;
        if (out_response != NULL)
            *out_response = tmp;
        if (out_response_size != NULL)
            *out_response_size = tmpsize;
        offset += 8;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_uicc_low_level_access_open_channel_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Status = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Channel = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Response = ", line_prefix);
    {
        guint i;
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, TRUE, TRUE, 0, &tmp, &tmpsize, &inner_error, TRUE))
            goto out;
        offset += 8;
        g_string_append (str, "'");
        for (i = 0; i  < tmpsize; i++)
            g_string_append_printf (str, "%02x%s", tmp[i], (i == (tmpsize - 1)) ? "" : ":" );
        g_string_append (str, "'");
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS UICC Low Level Access Close Channel */

MbimMessage *
mbim_message_ms_uicc_low_level_access_close_channel_set_new (
    guint32 channel,
    guint32 channel_group,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_CLOSE_CHANNEL,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, channel);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, channel_group);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_close_channel_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Channel = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ChannelGroup = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS UICC Low Level Access Close Channel */

gboolean
mbim_message_ms_uicc_low_level_access_close_channel_response_parse (
    const MbimMessage *message,
    guint32 *out_status,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'Status' variable */
    {
        if ((out_status != NULL) && !_mbim_message_read_guint32 (message, offset, out_status, error))
            goto out;
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_uicc_low_level_access_close_channel_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Status = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS UICC Low Level Access APDU */

MbimMessage *
mbim_message_ms_uicc_low_level_access_apdu_set_new (
    guint32 channel,
    MbimUiccSecureMessaging secure_messaging,
    MbimUiccClassByteType class_byte_type,
    const guint32 command_size,
    const guint8 *command,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_APDU,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, channel);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, secure_messaging);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, class_byte_type);
    }
    {
        _mbim_message_command_builder_append_byte_array (builder, TRUE, TRUE, TRUE, command, command_size, TRUE);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_apdu_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Channel = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SecureMessaging = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_UICC_SECURE_MESSAGING_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_uicc_secure_messaging_get_string ((MbimUiccSecureMessaging)tmp));
#elif defined __MBIM_UICC_SECURE_MESSAGING_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uicc_secure_messaging_build_string_from_mask ((MbimUiccSecureMessaging)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ClassByteType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_UICC_CLASS_BYTE_TYPE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_uicc_class_byte_type_get_string ((MbimUiccClassByteType)tmp));
#elif defined __MBIM_UICC_CLASS_BYTE_TYPE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uicc_class_byte_type_build_string_from_mask ((MbimUiccClassByteType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Command = ", line_prefix);
    {
        guint i;
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, TRUE, TRUE, 0, &tmp, &tmpsize, &inner_error, TRUE))
            goto out;
        offset += 8;
        g_string_append (str, "'");
        for (i = 0; i  < tmpsize; i++)
            g_string_append_printf (str, "%02x%s", tmp[i], (i == (tmpsize - 1)) ? "" : ":" );
        g_string_append (str, "'");
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS UICC Low Level Access APDU */

gboolean
mbim_message_ms_uicc_low_level_access_apdu_response_parse (
    const MbimMessage *message,
    guint32 *out_status,
    guint32 *out_response_size,
    const guint8 **out_response,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'Status' variable */
    {
        if ((out_status != NULL) && !_mbim_message_read_guint32 (message, offset, out_status, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Response' variable */
    {
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, TRUE, TRUE, 0, &tmp, &tmpsize, error, TRUE))
            goto out;
        if (out_response != NULL)
            *out_response = tmp;
        if (out_response_size != NULL)
            *out_response_size = tmpsize;
        offset += 8;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_uicc_low_level_access_apdu_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Status = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Response = ", line_prefix);
    {
        guint i;
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, TRUE, TRUE, 0, &tmp, &tmpsize, &inner_error, TRUE))
            goto out;
        offset += 8;
        g_string_append (str, "'");
        for (i = 0; i  < tmpsize; i++)
            g_string_append_printf (str, "%02x%s", tmp[i], (i == (tmpsize - 1)) ? "" : ":" );
        g_string_append (str, "'");
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message MS UICC Low Level Access Terminal Capability */

MbimMessage *
mbim_message_ms_uicc_low_level_access_terminal_capability_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_TERMINAL_CAPABILITY,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_terminal_capability_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS UICC Low Level Access Terminal Capability */

MbimMessage *
mbim_message_ms_uicc_low_level_access_terminal_capability_set_new (
    guint32 terminal_capability_count,
    const MbimTerminalCapabilityInfo *const *terminal_capability,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_TERMINAL_CAPABILITY,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, terminal_capability_count);
    }
    {
        _mbim_message_command_builder_append_mbim_terminal_capability_info_struct_array (builder, terminal_capability, terminal_capability_count, TRUE);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_terminal_capability_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _terminal_capability_count;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  TerminalCapabilityCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_terminal_capability_count, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _terminal_capability_count);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TerminalCapability = ", line_prefix);
    {
        g_autoptr(MbimTerminalCapabilityInfoArray) tmp = NULL;
        g_autofree gchar *new_line_prefix = NULL;
        guint i;

        if (!_mbim_message_read_mbim_terminal_capability_info_struct_array (message, _terminal_capability_count, offset, TRUE, &tmp, &inner_error))
            goto out;
        offset += (8 * _terminal_capability_count);
        new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
        g_string_append (str, "'{\n");
        for (i = 0; i < _terminal_capability_count; i++) {
            g_autofree gchar *struct_str = NULL;

            g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
            struct_str = _mbim_message_print_mbim_terminal_capability_info_struct (tmp[i], new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s    },\n", line_prefix);
        }
        g_string_append_printf (str, "%s  }'", line_prefix);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS UICC Low Level Access Terminal Capability */

gboolean
mbim_message_ms_uicc_low_level_access_terminal_capability_response_parse (
    const MbimMessage *message,
    guint32 *out_terminal_capability_count,
    MbimTerminalCapabilityInfoArray **out_terminal_capability,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _terminal_capability_count;
    MbimTerminalCapabilityInfo **_terminal_capability = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'TerminalCapabilityCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_terminal_capability_count, error))
            goto out;
        if (out_terminal_capability_count != NULL)
            *out_terminal_capability_count = _terminal_capability_count;
        offset += 4;
    }

    /* Read the 'TerminalCapability' variable */
    {
        if ((out_terminal_capability != NULL) && !_mbim_message_read_mbim_terminal_capability_info_struct_array (message, _terminal_capability_count, offset, TRUE, &_terminal_capability, error))
            goto out;
        offset += (8 * _terminal_capability_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_terminal_capability != NULL)
            *out_terminal_capability = _terminal_capability;
    } else {
        mbim_terminal_capability_info_array_free (_terminal_capability);
    }

    return success;
}

static gchar *
mbim_message_ms_uicc_low_level_access_terminal_capability_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _terminal_capability_count;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  TerminalCapabilityCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_terminal_capability_count, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _terminal_capability_count);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TerminalCapability = ", line_prefix);
    {
        g_autoptr(MbimTerminalCapabilityInfoArray) tmp = NULL;
        g_autofree gchar *new_line_prefix = NULL;
        guint i;

        if (!_mbim_message_read_mbim_terminal_capability_info_struct_array (message, _terminal_capability_count, offset, TRUE, &tmp, &inner_error))
            goto out;
        offset += (8 * _terminal_capability_count);
        new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
        g_string_append (str, "'{\n");
        for (i = 0; i < _terminal_capability_count; i++) {
            g_autofree gchar *struct_str = NULL;

            g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
            struct_str = _mbim_message_print_mbim_terminal_capability_info_struct (tmp[i], new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s    },\n", line_prefix);
        }
        g_string_append_printf (str, "%s  }'", line_prefix);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message MS UICC Low Level Access Reset */

MbimMessage *
mbim_message_ms_uicc_low_level_access_reset_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_RESET,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_reset_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS UICC Low Level Access Reset */

MbimMessage *
mbim_message_ms_uicc_low_level_access_reset_set_new (
    MbimUiccPassThroughAction pass_through_action,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_UICC_LOW_LEVEL_ACCESS,
                                                 MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_RESET,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, pass_through_action);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_uicc_low_level_access_reset_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  PassThroughAction = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_UICC_PASS_THROUGH_ACTION_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_uicc_pass_through_action_get_string ((MbimUiccPassThroughAction)tmp));
#elif defined __MBIM_UICC_PASS_THROUGH_ACTION_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uicc_pass_through_action_build_string_from_mask ((MbimUiccPassThroughAction)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS UICC Low Level Access Reset */

gboolean
mbim_message_ms_uicc_low_level_access_reset_response_parse (
    const MbimMessage *message,
    MbimUiccPassThroughStatus *out_pass_through_status,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'PassThroughStatus' variable */
    {
        if (out_pass_through_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_pass_through_status = (MbimUiccPassThroughStatus)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_uicc_low_level_access_reset_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  PassThroughStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_UICC_PASS_THROUGH_STATUS_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_uicc_pass_through_status_get_string ((MbimUiccPassThroughStatus)tmp));
#elif defined __MBIM_UICC_PASS_THROUGH_STATUS_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uicc_pass_through_status_build_string_from_mask ((MbimUiccPassThroughStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

typedef struct {
  gchar * (* query_cb)        (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* set_cb)          (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* response_cb)     (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* notification_cb) (const MbimMessage *message, const gchar *line_prefix, GError **error);
} GetPrintableCallbacks;

static const GetPrintableCallbacks get_printable_callbacks[] = {
    [MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_ATR] = {
        .query_cb = mbim_message_ms_uicc_low_level_access_atr_query_get_printable,
        .response_cb = mbim_message_ms_uicc_low_level_access_atr_response_get_printable,
    },
    [MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_OPEN_CHANNEL] = {
        .set_cb = mbim_message_ms_uicc_low_level_access_open_channel_set_get_printable,
        .response_cb = mbim_message_ms_uicc_low_level_access_open_channel_response_get_printable,
    },
    [MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_CLOSE_CHANNEL] = {
        .set_cb = mbim_message_ms_uicc_low_level_access_close_channel_set_get_printable,
        .response_cb = mbim_message_ms_uicc_low_level_access_close_channel_response_get_printable,
    },
    [MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_APDU] = {
        .set_cb = mbim_message_ms_uicc_low_level_access_apdu_set_get_printable,
        .response_cb = mbim_message_ms_uicc_low_level_access_apdu_response_get_printable,
    },
    [MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_TERMINAL_CAPABILITY] = {
        .query_cb = mbim_message_ms_uicc_low_level_access_terminal_capability_query_get_printable,
        .set_cb = mbim_message_ms_uicc_low_level_access_terminal_capability_set_get_printable,
        .response_cb = mbim_message_ms_uicc_low_level_access_terminal_capability_response_get_printable,
    },
    [MBIM_CID_MS_UICC_LOW_LEVEL_ACCESS_RESET] = {
        .query_cb = mbim_message_ms_uicc_low_level_access_reset_query_get_printable,
        .set_cb = mbim_message_ms_uicc_low_level_access_reset_set_get_printable,
        .response_cb = mbim_message_ms_uicc_low_level_access_reset_response_get_printable,
    },
};

gchar *
__mbim_message_ms_uicc_low_level_access_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (get_printable_callbacks[cid].query_cb)
                            return get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (get_printable_callbacks[cid].set_cb)
                            return get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (get_printable_callbacks)) {
                if (get_printable_callbacks[cid].response_cb)
                    return get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (get_printable_callbacks)) {
                if (get_printable_callbacks[cid].notification_cb)
                    return get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_INVALID_MESSAGE,
                 "Unknown contents");
    return NULL;
}
