/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_or extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0b2f\u0b41\u0b15\u0b4d\u0b24 \u0b06\u0b30\u0b2c \u0b0f\u0b2e\u0b3f\u0b30\u0b47\u0b1f\u0b38\u0b4d \u0b26\u0b3f\u0b30\u0b39\u0b3e\u0b2e\u0b4d" },
            { "afn", "\u0b06\u0b2b\u0b17\u0b3e\u0b28 \u0b06\u0b2b\u0b17\u0b3e\u0b28\u0b3f" },
            { "all", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b5f \u0b32\u0b47\u0b15\u0b4d" },
            { "amd", "\u0b05\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b40\u0b5f \u0b21\u0b4d\u0b30\u0b3e\u0b2e\u0b4d" },
            { "ang", "\u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21\u0b4d \u0b06\u0b23\u0b4d\u0b1f\u0b3f\u0b32\u0b3f\u0b5f \u0b17\u0b3f\u0b32\u0b21\u0b30\u0b4d" },
            { "aoa", "\u0b05\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b40\u0b5f \u0b15\u0b71\u0b3e\u0b28\u0b1c\u0b3e" },
            { "ars", "\u0b06\u0b30\u0b4d\u0b1c\u0b47\u0b23\u0b4d\u0b1f\u0b3e\u0b07\u0b28\u0b4d\u200d \u0b2a\u0b47\u0b38\u0b4b" },
            { "aud", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "awg", "\u0b06\u0b30\u0b41\u0b2c\u0b40\u0b5f \u0b2b\u0b4d\u0b32\u0b4b\u0b30\u0b3f\u0b28\u0b4d" },
            { "azn", "\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b3f \u0b2e\u0b28\u0b24\u0b4d" },
            { "bam", "\u0b2c\u0b4b\u0b38\u0b28\u0b3f\u0b06-\u0b39\u0b30\u0b4d\u0b1c\u0b17\u0b4b\u0b2d\u0b3f\u0b28\u0b3e \u0b15\u0b28\u0b2d\u0b30\u0b4d\u0b1f\u0b3f\u0b2c\u0b32\u0b4d \u0b2e\u0b3e\u0b30\u0b4d\u0b15\u0b4d" },
            { "bbd", "\u0b2c\u0b3e\u0b30\u0b4d\u0b2c\u0b3e\u0b21\u0b40\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "bdt", "\u0b2c\u0b19\u0b4d\u0b17\u0b33\u0b3e\u0b26\u0b47\u0b36\u0b40 \u0b1f\u0b3e\u0b15\u0b3e" },
            { "bgn", "\u0b2c\u0b41\u0b32\u0b17\u0b47\u0b30\u0b40\u0b5f \u0b32\u0b47\u0b2d\u0b4d" },
            { "bhd", "\u0b2c\u0b3e\u0b03\u0b30\u0b47\u0b28\u0b3f \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "bif", "\u0b2c\u0b41\u0b30\u0b41\u0b23\u0b4d\u0b21\u0b3f\u0b5f \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "bmd", "\u0b2c\u0b30\u0b4d\u0b2e\u0b4d\u0b5f\u0b41\u0b21\u0b3e \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "bnd", "\u0b2c\u0b4d\u0b30\u0b41\u0b28\u0b47\u0b07 \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "bob", "\u0b2c\u0b4b\u0b32\u0b3f\u0b2d\u0b40\u0b5f \u0b2c\u0b4b\u0b32\u0b3f\u0b2d\u0b3f\u0b06\u0b28\u0b4b" },
            { "brl", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b40\u0b5f \u0b30\u0b3f\u0b0f\u0b32\u0b4d" },
            { "bsd", "\u0b2c\u0b3e\u0b39\u0b3e\u0b2e\u0b40\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "btn", "\u0b2d\u0b41\u0b1f\u0b3e\u0b28\u0b40 \u0b17\u0b32\u0b1f\u0b4d\u0b30\u0b41\u0b2e\u0b4d" },
            { "bwp", "\u0b2c\u0b4b\u0b24\u0b4d\u0b38\u0b71\u0b3e\u0b28\u0b3e \u0b2a\u0b41\u0b32\u0b3e" },
            { "byn", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b38\u0b3f \u0b30\u0b41\u0b2c\u0b32\u0b4d" },
            { "bzd", "\u0b2c\u0b47\u0b32\u0b3f\u0b1c\u0b4d \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "cad", "\u0b15\u0b3e\u0b28\u0b47\u0b21\u0b3f\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "cdf", "\u0b15\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b1c\u0b4d \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "chf", "\u0b38\u0b41\u0b07\u0b38\u0b4d \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "clp", "\u0b1a\u0b3f\u0b32\u0b3f \u0b2a\u0b47\u0b38\u0b4b" },
            { "cnh", "\u0b1a\u0b3f\u0b28\u0b40 \u0b5f\u0b41\u0b06\u0b28\u0b4d (\u0b05\u0b2b\u0b38\u0b4b\u0b30\u0b4d)" },
            { "cny", "\u0b1a\u0b3f\u0b28\u0b40 \u0b5f\u0b41\u0b06\u0b28\u0b4d" },
            { "cop", "\u0b15\u0b32\u0b4b\u0b2e\u0b4d\u0b2c\u0b40\u0b5f \u0b2a\u0b47\u0b38\u0b4b" },
            { "crc", "\u0b15\u0b4b\u0b37\u0b4d\u0b1f\u0b3e \u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b15\u0b4b\u0b32\u0b4b\u0b28\u0b4d" },
            { "cuc", "\u0b15\u0b4d\u0b5f\u0b41\u0b2c\u0b3e\u0b28\u0b4d \u0b15\u0b28\u0b2d\u0b30\u0b4d\u0b1f\u0b3f\u0b2c\u0b32\u0b4d \u0b2a\u0b47\u0b38\u0b4b" },
            { "cup", "\u0b15\u0b4d\u0b5f\u0b41\u0b2c\u0b3e\u0b28\u0b4d \u0b2a\u0b47\u0b38\u0b4b" },
            { "cve", "\u0b15\u0b47\u0b2a\u0b4d \u0b2d\u0b47\u0b30\u0b4d\u0b26\u0b47\u0b5f \u0b0f\u0b38\u0b4d\u0b15\u0b41\u0b21\u0b4b" },
            { "czk", "\u0b1a\u0b47\u0b15\u0b4d \u0b15\u0b4b\u0b30\u0b41\u0b28\u0b3e" },
            { "djf", "\u0b1c\u0b3f\u0b2c\u0b4c\u0b1f\u0b3f\u0b5f \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "dkk", "\u0b21\u0b3e\u0b28\u0b3f\u0b38\u0b4d \u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b4d" },
            { "dop", "\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b40\u0b5f \u0b2a\u0b47\u0b38\u0b4b" },
            { "dzd", "\u0b06\u0b32\u0b1c\u0b47\u0b30\u0b40\u0b5f \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "egp", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b5f \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "ern", "\u0b0f\u0b30\u0b3f\u0b1f\u0b4d\u0b30\u0b47\u0b5f \u0b28\u0b3e\u0b15\u0b2b\u0b3e" },
            { "etb", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b5f \u0b2c\u0b3f\u0b30\u0b4d" },
            { "eur", "\u0b5f\u0b41\u0b30\u0b4b" },
            { "fjd", "\u0b2b\u0b3f\u0b1c\u0b3f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "fkp", "\u0b2b\u0b15\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21\u0b4d \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "gbp", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "gel", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b5f \u0b32\u0b3e\u0b30\u0b3f" },
            { "ghs", "\u0b18\u0b3e\u0b28\u0b3f\u0b5f \u0b38\u0b47\u0b21\u0b3f" },
            { "gip", "\u0b17\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b32\u0b1f\u0b30\u0b4d \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "gmd", "\u0b17\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b5f \u0b21\u0b3e\u0b32\u0b3e\u0b38\u0b3f" },
            { "gnf", "\u0b17\u0b41\u0b07\u0b28\u0b47\u0b5f \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "gtq", "\u0b17\u0b41\u0b0f\u0b1f\u0b2e\u0b3e\u0b32\u0b40\u0b5f \u0b15\u0b4d\u0b35\u0b47\u0b24\u0b1c\u0b3e\u0b32\u0b4d" },
            { "gyd", "\u0b17\u0b3e\u0b5f\u0b3e\u0b28\u0b3f\u0b38\u0b4d \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "hkd", "\u0b39\u0b02 \u0b15\u0b02 \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "hnl", "\u0b39\u0b4b\u0b23\u0b4d\u0b21\u0b41\u0b30\u0b40\u0b5f \u0b32\u0b47\u0b2e\u0b2a\u0b3f\u0b30\u0b3e" },
            { "hrk", "\u0b15\u0b4d\u0b30\u0b4b\u0b0f\u0b38\u0b40\u0b5f \u0b15\u0b41\u0b28\u0b3e" },
            { "htg", "\u0b39\u0b3e\u0b07\u0b24\u0b40\u0b5f \u0b17\u0b4b\u0b30\u0b21\u0b4d" },
            { "huf", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b3f\u0b5f \u0b2b\u0b4b\u0b30\u0b3f\u0b23\u0b4d\u0b1f\u0b4d" },
            { "idr", "\u0b07\u0b23\u0b4d\u0b21\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b5f \u0b30\u0b41\u0b2a\u0b3f\u0b06" },
            { "ils", "\u0b07\u0b38\u0b4d\u0b30\u0b3e\u0b07\u0b32\u0b3f \u0b28\u0b4d\u0b5f\u0b41 \u0b36\u0b47\u0b15\u0b47\u0b32\u0b4d" },
            { "inr", "\u0b2d\u0b3e\u0b30\u0b24\u0b40\u0b5f \u0b1f\u0b19\u0b4d\u0b15\u0b3e" },
            { "iqd", "\u0b07\u0b30\u0b3e\u0b15\u0b3f \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "irr", "\u0b07\u0b30\u0b3e\u0b28\u0b40 \u0b30\u0b3f\u0b06\u0b32\u0b4d" },
            { "isk", "\u0b06\u0b07\u0b38\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d\u200d \u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b3e" },
            { "jmd", "\u0b1c\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b40\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "jod", "\u0b1c\u0b30\u0b4d\u0b21\u0b3e\u0b28\u0b3f\u0b5f \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "jpy", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b5f\u0b47\u0b28\u0b4d" },
            { "kes", "\u0b15\u0b47\u0b28\u0b3f\u0b5f \u0b36\u0b3f\u0b32\u0b3f\u0b02" },
            { "kgs", "\u0b15\u0b3f\u0b30\u0b4d\u0b17\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b40 \u0b38\u0b4b\u0b2e\u0b4d" },
            { "khr", "\u0b15\u0b3e\u0b2e\u0b4d\u0b35\u0b4b\u0b21\u0b3f\u0b5f \u0b30\u0b3f\u0b0f\u0b32\u0b4d" },
            { "kmf", "\u0b15\u0b4b\u0b2e\u0b4b\u0b30\u0b40\u0b5f \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "kpw", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b15\u0b4b\u0b30\u0b3f\u0b06\u0b07 \u0b71\u0b4b\u0b28\u0b4d" },
            { "krw", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b15\u0b4b\u0b30\u0b3f\u0b06\u0b07 \u0b71\u0b4b\u0b28\u0b4d" },
            { "kwd", "\u0b15\u0b41\u0b71\u0b47\u0b24\u0b3f \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "kyd", "\u0b15\u0b47\u0b2e\u0b47\u0b28\u0b4d \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "kzt", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b40 \u0b24\u0b47\u0b19\u0b4d\u0b17\u0b47" },
            { "lak", "\u0b32\u0b3e\u0b13\u0b1f\u0b3f\u0b5f \u0b15\u0b3f\u0b2a\u0b4d" },
            { "lbp", "\u0b32\u0b47\u0b2c\u0b3e\u0b28\u0b3f\u0b1c\u0b4d \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "lkr", "\u0b36\u0b4d\u0b30\u0b40\u0b32\u0b19\u0b4d\u0b15\u0b3f\u0b5f \u0b30\u0b41\u0b2a\u0b3f" },
            { "lrd", "\u0b32\u0b3f\u0b2c\u0b47\u0b30\u0b40\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "lyd", "\u0b32\u0b3f\u0b2c\u0b4d\u0b5f \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "mad", "\u0b2e\u0b4b\u0b30\u0b4b\u0b15\u0b40\u0b5f \u0b26\u0b3f\u0b30\u0b4d\u0b39\u0b3e\u0b2e\u0b4d" },
            { "mdl", "\u0b2e\u0b4b\u0b32\u0b21\u0b4b\u0b2d\u0b3e\u0b28\u0b4d \u0b32\u0b47\u0b5f\u0b41" },
            { "mga", "\u0b2e\u0b3e\u0b32\u0b3e\u0b17\u0b3e\u0b38\u0b3f \u0b0f\u0b30\u0b3f\u0b06\u0b30\u0b40" },
            { "mkd", "\u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b40\u0b5f \u0b21\u0b3f\u0b28\u0b30\u0b4d" },
            { "mmk", "\u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b2e\u0b3e\u0b30\u0b4d \u0b15\u0b4d\u0b5f\u0b3e\u0b24\u0b4d\u200c" },
            { "mnt", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b5f \u0b24\u0b41\u0b17\u0b4d\u0b30\u0b3f\u0b15\u0b4d" },
            { "mop", "\u0b2e\u0b3e\u0b15\u0b3e\u0b28\u0b47\u0b1c\u0b4d \u0b2a\u0b3e\u0b1f\u0b3e\u0b15\u0b3e" },
            { "mro", "\u0b2e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b3f\u0b5f \u0b06\u0b17\u0b41\u0b07\u0b05 (1973\u20132017)" },
            { "mru", "\u0b2e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b3f\u0b5f \u0b06\u0b17\u0b41\u0b07\u0b05" },
            { "mur", "\u0b2e\u0b4c\u0b30\u0b3f\u0b38\u0b40\u0b5f \u0b30\u0b41\u0b2a\u0b3f" },
            { "mvr", "\u0b2e\u0b3e\u0b32\u0b21\u0b3f\u0b2d\u0b3f\u0b5f \u0b30\u0b41\u0b2b\u0b3f\u0b5f\u0b3e" },
            { "mwk", "\u0b2e\u0b32\u0b3e\u0b71\u0b3f \u0b15\u0b4d\u0b71\u0b3e\u0b1a\u0b3e" },
            { "mxn", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b40\u0b5f \u0b2a\u0b47\u0b38\u0b4b" },
            { "myr", "\u0b2e\u0b3e\u0b32\u0b47\u0b38\u0b3f\u0b5f \u0b30\u0b3f\u0b19\u0b4d\u0b17\u0b3f\u0b1f\u0b4d" },
            { "mzn", "\u0b2e\u0b4b\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b15\u0b40\u0b5f \u0b2e\u0b47\u0b1f\u0b3f\u0b15\u0b3e\u0b32\u0b4d" },
            { "nad", "\u0b28\u0b3e\u0b2e\u0b3f\u0b2c\u0b3f\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "ngn", "\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b3f\u0b06\u0b07 \u0b28\u0b3e\u0b07\u0b30\u0b3e" },
            { "nio", "\u0b28\u0b3f\u0b15\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b06 \u0b15\u0b4b\u0b30\u0b4d\u0b21\u0b4b\u0b2c\u0b3e" },
            { "nok", "\u0b28\u0b30\u0b71\u0b47\u0b5f\u0b40\u0b5f \u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b4d" },
            { "npr", "\u0b28\u0b47\u0b2a\u0b3e\u0b33\u0b3f \u0b30\u0b41\u0b2a\u0b3f" },
            { "nzd", "\u0b28\u0b4d\u0b5f\u0b41\u0b1c\u0b3f\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21\u0b4d \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "omr", "\u0b13\u0b2e\u0b3e\u0b28\u0b3f \u0b30\u0b3f\u0b06\u0b32\u0b4d" },
            { "pab", "\u0b2a\u0b3e\u0b28\u0b3e\u0b2e\u0b3e\u0b28\u0b3f\u0b5f \u0b2c\u0b3e\u0b32\u0b2c\u0b4b\u0b06" },
            { "pen", "\u0b2a\u0b47\u0b30\u0b41\u0b2d\u0b40\u0b5f \u0b38\u0b4b\u0b32\u0b4d" },
            { "pgk", "\u0b2a\u0b2a\u0b41\u0b06 \u0b28\u0b4d\u0b5f\u0b41 \u0b17\u0b41\u0b07\u0b28\u0b3f\u0b5f \u0b15\u0b3f\u0b28\u0b3e" },
            { "php", "\u0b2b\u0b3f\u0b32\u0b3f\u0b2a\u0b3f\u0b28\u0b3f \u0b2a\u0b47\u0b38\u0b4b" },
            { "pkr", "\u0b2a\u0b3e\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b40 \u0b30\u0b41\u0b2a\u0b3f" },
            { "pln", "\u0b2a\u0b4b\u0b32\u0b3f\u0b36\u0b4d \u0b1c\u0b4d\u0b32\u0b1f\u0b40" },
            { "pyg", "\u0b2a\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b06\u0b5f\u0b3e\u0b28\u0b4d \u0b17\u0b41\u0b06\u0b30\u0b3e\u0b28\u0b3f" },
            { "qar", "\u0b15\u0b4d\u0b35\u0b3e\u0b24\u0b3e\u0b30\u0b3f \u0b30\u0b3f\u0b06\u0b32\u0b4d" },
            { "ron", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b5f \u0b32\u0b47\u0b09" },
            { "rsd", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06\u0b07 \u0b26\u0b3f\u0b28\u0b3e\u0b30" },
            { "rub", "\u0b30\u0b41\u0b37\u0b3f \u0b30\u0b41\u0b2c\u0b32\u0b4d" },
            { "rwf", "\u0b30\u0b41\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "sar", "\u0b38\u0b4c\u0b26\u0b3f \u0b30\u0b3f\u0b5f\u0b3e\u0b32\u0b4d" },
            { "sbd", "\u0b38\u0b4b\u0b32\u0b4b\u0b2e\u0b4b\u0b28\u0b4d \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "scr", "\u0b38\u0b47\u0b5f\u0b1a\u0b47\u0b32\u0b4b\u0b07\u0b38\u0b4d \u0b30\u0b41\u0b2a\u0b3f" },
            { "sdg", "\u0b38\u0b41\u0b26\u0b3e\u0b28\u0b40\u0b1c \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "sek", "\u0b38\u0b4d\u0b71\u0b47\u0b21\u0b3f\u0b36\u0b4d \u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b3e" },
            { "sgd", "\u0b38\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b2a\u0b41\u0b30\u0b4d \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "shp", "\u0b38\u0b47\u0b23\u0b4d\u0b1f\u0b4d. \u0b39\u0b47\u0b32\u0b47\u0b28\u0b3e \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "sll", "\u0b38\u0b3f\u0b0f\u0b30\u0b3e \u0b32\u0b3f\u0b13\u0b28\u0b40\u0b5f \u0b32\u0b47\u0b13\u0b28\u0b4d" },
            { "sos", "\u0b38\u0b4b\u0b2e\u0b3e\u0b32\u0b3f \u0b38\u0b3f\u0b32\u0b3f\u0b02" },
            { "srd", "\u0b38\u0b41\u0b30\u0b3f\u0b28\u0b3e\u0b2e\u0b3f\u0b1c\u0b4d \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "ssp", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b41\u0b21\u0b3e\u0b28\u0b3f\u0b1c\u0b4d\u200d \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "std", "\u0b38\u0b3e\u0b13 \u0b24\u0b4b\u0b2e\u0b47 & \u0b2a\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b2a\u0b4d \u0b21\u0b4b\u0b2c\u0b4d\u0b30\u0b3e (1977\u20132017)" },
            { "stn", "\u0b38\u0b3e\u0b13 \u0b24\u0b4b\u0b2e\u0b47 & \u0b2a\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b2a\u0b4d \u0b21\u0b4b\u0b2c\u0b4d\u0b30\u0b3e" },
            { "syp", "\u0b38\u0b3f\u0b30\u0b3f\u0b5f \u0b2a\u0b3e\u0b09\u0b23\u0b4d\u0b21\u0b4d" },
            { "szl", "\u0b38\u0b4d\u0b35\u0b3e\u0b1c\u0b3f \u0b32\u0b3f\u0b32\u0b3e\u0b1e\u0b4d\u0b1c\u0b47\u0b28\u0b3f" },
            { "thb", "\u0b25\u0b3e\u0b07 \u0b2d\u0b3e\u0b1f\u0b4d" },
            { "tjs", "\u0b24\u0b3e\u0b1c\u0b3f\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b40 \u0b38\u0b4b\u0b2e\u0b4b\u0b28\u0b3f" },
            { "tmt", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b2e\u0b47\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b40 \u0b2e\u0b28\u0b24\u0b4d\u200c" },
            { "tnd", "\u0b1f\u0b41\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b07 \u0b26\u0b3f\u0b28\u0b3e\u0b30\u0b4d" },
            { "top", "\u0b24\u0b4b\u0b19\u0b4d\u0b17\u0b3f\u0b5f \u0b2a\u0b3e\u0b19\u0b4d\u0b17\u0b3e" },
            { "try", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b5f \u0b32\u0b3f\u0b30\u0b3e" },
            { "ttd", "\u0b24\u0b4d\u0b30\u0b3f\u0b28\u0b3f\u0b26\u0b3e\u0b26\u0b4d \u0b0f\u0b2c\u0b02 \u0b1f\u0b4b\u0b2c\u0b3e\u0b17\u0b4b \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "twd", "\u0b28\u0b4d\u0b5f\u0b41 \u0b24\u0b3e\u0b07\u0b71\u0b3e\u0b28\u0b4d \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "tzs", "\u0b24\u0b3e\u0b28\u0b1c\u0b3e\u0b28\u0b40\u0b5f \u0b36\u0b3f\u0b32\u0b3f\u0b02" },
            { "uah", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b47\u0b28\u0b40\u0b5f \u0b39\u0b4d\u0b30\u0b3e\u0b07\u0b2d\u0b28\u0b3f\u0b06" },
            { "ugx", "\u0b09\u0b17\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b5f \u0b36\u0b3f\u0b32\u0b3f\u0b02" },
            { "usd", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30 \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "uyu", "\u0b09\u0b30\u0b41\u0b17\u0b41\u0b07\u0b5f\u0b3e\u0b28\u0b4d \u0b2a\u0b47\u0b38\u0b4b" },
            { "uzs", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b40 \u0b38\u0b4b\u0b2e\u0b4d" },
            { "vef", "\u0b2d\u0b47\u0b28\u0b47\u0b1c\u0b41\u0b0f\u0b32\u0b3e\u0b28\u0b4d \u0b2c\u0b4b\u0b32\u0b3f\u0b2d\u0b3e\u0b30\u0b4d (2008\u20132018)" },
            { "ves", "\u0b2d\u0b47\u0b28\u0b47\u0b1c\u0b41\u0b0f\u0b32\u0b3e\u0b28\u0b4d \u0b2c\u0b4b\u0b32\u0b3f\u0b2d\u0b3e\u0b30\u0b4d" },
            { "vnd", "\u0b2d\u0b40\u0b0f\u0b24\u0b28\u0b3e\u0b2e\u0b40\u0b5f \u0b21\u0b19\u0b4d\u0b17" },
            { "vuv", "\u0b2d\u0b3e\u0b28\u0b41\u0b06\u0b1f\u0b41 \u0b2d\u0b3e\u0b1f\u0b41" },
            { "wst", "\u0b38\u0b3e\u0b2e\u0b4b\u0b5f\u0b3f\u0b5f \u0b24\u0b3e\u0b32\u0b3e" },
            { "xaf", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b40 CFA \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "xcd", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b15\u0b3e\u0b30\u0b3f\u0b2c\u0b40\u0b5f \u0b21\u0b32\u0b3e\u0b30\u0b4d" },
            { "xof", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3f\u0b5f CFA \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "xpf", "CFP \u0b2b\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b15\u0b4d" },
            { "xxx", "\u0b05\u0b1c\u0b23\u0b3e \u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e" },
            { "yer", "\u0b5f\u0b47\u0b2e\u0b47\u0b28\u0b3f \u0b30\u0b3f\u0b06\u0b32\u0b4d" },
            { "zar", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3f\u0b5f \u0b30\u0b3e\u0b23\u0b4d\u0b21\u0b4d" },
            { "zmw", "\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b40\u0b5f \u0b15\u0b4d\u0b71\u0b3e\u0b1a\u0b3e" },
        };
        return data;
    }
}
