/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_uz extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Markaziy Afrika vaqti",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskva standart vaqti",
               "MSK",
               "Moskva yozgi vaqti",
               "MSD",
               "Moskva vaqti",
               "MT",
            };
        final String[] Japan = new String[] {
               "Yaponiya standart vaqti",
               "JST",
               "Yaponiya yozgi vaqti",
               "JDT",
               "Yaponiya vaqti",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pokiston standart vaqti",
               "PKT",
               "Pokiston yozgi vaqti",
               "PKST",
               "Pokiston vaqti",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Tayvan standart vaqti",
               "CST",
               "Tayvan yozgi vaqti",
               "CDT",
               "Tayvan vaqti",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Xovd standart vaqti",
               "HOVT",
               "Xovd yozgi vaqti",
               "HOVST",
               "Xovd vaqti",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan standart vaqti",
               "MAGT",
               "Magadan yozgi vaqti",
               "MAGST",
               "Magadan vaqti",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Markaziy Avstraliya g\u2018arbiy standart vaqti",
               "ACWST",
               "Markaziy Avstraliya g\u2018arbiy yozgi vaqti",
               "ACWDT",
               "Markaziy Avstraliya g\u2018arbiy vaqti",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Markaziy Yevropa standart vaqti",
               "CET",
               "Markaziy Yevropa yozgi vaqti",
               "CEST",
               "Markaziy Yevropa vaqti",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Saxalin standart vaqti",
               "SAKT",
               "Saxalin yozgi vaqti",
               "SAKST",
               "Saxalin vaqti",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvay standart vaqti",
               "PYT",
               "Paragvay yozgi vaqti",
               "PYST",
               "Paragvay vaqti",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malayziya vaqti",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Sharqiy Amerika standart vaqti",
               "EST",
               "Sharqiy Amerika yozgi vaqti",
               "EDT",
               "Sharqiy Amerika vaqti",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Xau standart vaqti",
               "LHST",
               "Lord-Xau yozgi vaqti",
               "LHDT",
               "Lord-Xau vaqti",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Yangi Zelandiya standart vaqti",
               "NZST",
               "Yangi Zelandiya yozgi vaqti",
               "NZDT",
               "Yangi Zelandiya vaqti",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hind okeani vaqti",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk standart vaqti",
               "YAKT",
               "Yakutsk yozgi vaqti",
               "YAKST",
               "Yakutsk vaqti",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mavrikiy standart vaqti",
               "MUT",
               "Mavrikiy yozgi vaqti",
               "MUST",
               "Mavrikiy vaqti",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Sharqiy Afrika vaqti",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Sharqiy Timor vaqti",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Solomon orollari vaqti",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae vaqti",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall orollari vaqti",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Sharqiy Yevropa standart vaqti",
               "EET",
               "Sharqiy Yevropa yozgi vaqti",
               "EEST",
               "Sharqiy Yevropa vaqti",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Nyufaundlend standart vaqti",
               "NST",
               "Nyufaundlend yozgi vaqti",
               "NDT",
               "Nyufaundlend vaqti",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afg\u02bboniston vaqti",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Gonkong standart vaqti",
               "HKT",
               "Gonkong yozgi vaqti",
               "HKST",
               "Gonkong vaqti",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "G\u02bbarbiy Argentina standart vaqti",
               "ART",
               "G\u02bbarbiy Argentina yozgi vaqti",
               "ARST",
               "G\u02bbarbiy Argentina vaqti",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantika standart vaqti",
               "AST",
               "Atlantika yozgi vaqti",
               "ADT",
               "Atlantika vaqti",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape vaqti",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Boliviya vaqti",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen-Pyer va Mikelon standart vaqti",
               "PMST",
               "Sen-Pyer va Mikelon yozgi vaqti",
               "PMDT",
               "Sen-Pyer va Mikelon vaqti",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hindixitoy vaqti",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg standart vaqti",
               "YEKT",
               "Yekaterinburg yozgi vaqti",
               "YEKST",
               "Yekaterinburg vaqti",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldiv orollari vaqti",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Taiti vaqti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Isroil standart vaqti",
               "IST",
               "Isroil yozgi vaqti",
               "IDT",
               "Isroil vaqti",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Markaziy Indoneziya vaqti",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Uollis va Futuna vaqti",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Janubiy Afrika standart vaqti",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syova vaqti",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Layn orollari vaqti",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "O\u02bbzbekiston standart vaqti",
               "UZT",
               "O\u02bbzbekiston yozgi vaqti",
               "UZST",
               "O\u02bbzbekiston vaqti",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk standart vaqti",
               "OMST",
               "Omsk yozgi vaqti",
               "OMSST",
               "Omsk vaqti",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seyshel orollari vaqti",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Urugvay standart vaqti",
               "UYT",
               "Urugvay yozgi vaqti",
               "UYST",
               "Urugvay vaqti",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal vaqti",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Bator standart vaqti",
               "ULAT",
               "Ulan-Bator yozgi vaqti",
               "ULAST",
               "Ulan-Bator vaqti",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Markaziy Amerika standart vaqti",
               "CST",
               "Markaziy Amerika yozgi vaqti",
               "CDT",
               "Markaziy Amerika vaqti",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk vaqti",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niuye vaqti",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Ueyk oroli vaqti",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Folklend orollari standart vaqti",
               "FKT",
               "Folklend orollari yozgi vaqti",
               "FKST",
               "Folklend orollari vaqti",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu standart vaqti",
               "VUT",
               "Vanuatu yozgi vaqti",
               "VUST",
               "Vanuatu vaqti",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk standart vaqti",
               "NOVT",
               "Novosibirsk yozgi vaqti",
               "NOVST",
               "Novosibirsk vaqti",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapur vaqti",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azor orollari standart vaqti",
               "AZOT",
               "Azor orollari yozgi vaqti",
               "AZOST",
               "Azor orollari vaqti",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia standart vaqti",
               "WSST",
               "Apia yozgi vaqti",
               "WSDT",
               "Apia vaqti",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Butan vaqti",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinam vaqti",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru vaqti",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk standart vaqti",
               "KRAT",
               "Krasnoyarsk yozgi vaqti",
               "KRAST",
               "Krasnoyarsk vaqti",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "G\u02bbarbiy Qozog\u02bbiston vaqti",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanma vaqti",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Rojdestvo oroli vaqti",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonka standart vaqti",
               "AMT",
               "Amazonka yozgi vaqti",
               "AMST",
               "Amazonka vaqti",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Sharqiy Qozog\u02bbiston vaqti",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fiji standart vaqti",
               "FJT",
               "Fiji yozgi vaqti",
               "FJST",
               "Fiji vaqti",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reyunion vaqti",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokos orollari vaqti",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatem standart vaqti",
               "CHAST",
               "Chatem yozgi vaqti",
               "CHADT",
               "Chatem vaqti",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostok vaqti",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentina standart vaqti",
               "ART",
               "Argentina yozgi vaqti",
               "ARST",
               "Argentina vaqti",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambye vaqti",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu vaqti",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos vaqti",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Makkuori oroli vaqti",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venesuela vaqti",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Gavayi-aleut standart vaqti",
               "HAST",
               "Gavayi-aleut yozgi vaqti",
               "HADT",
               "Gavayi-aleut vaqti",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Markaziy Avstraliya standart vaqti",
               "ACST",
               "Markaziy Avstraliya yozgi vaqti",
               "ACDT",
               "Markaziy Avstraliya vaqti",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Shimoliy Amerika Tinch okeani standart vaqti",
               "PST",
               "Shimoliy Amerika Tinch okeani yozgi vaqti",
               "PDT",
               "Shimoliy Amerika Tinch okeani vaqti",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks orollari vaqti",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmaniston standart vaqti",
               "TMT",
               "Turkmaniston yozgi vaqti",
               "TMST",
               "Turkmaniston vaqti",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "G\u2018arbiy Yevropa standart vaqti",
               "WET",
               "G\u2018arbiy Yevropa yozgi vaqti",
               "WEST",
               "G\u2018arbiy Yevropa vaqti",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kabo-Verde standart vaqti",
               "CVT",
               "Kabo-Verde yozgi vaqti",
               "CVST",
               "Kabo-Verde vaqti",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk oroli vaqti",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Gayana vaqti",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern vaqti",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rotera vaqti",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa standart vaqti",
               "SST",
               "Samoa yozgi vaqti",
               "SDT",
               "Samoa vaqti",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau vaqti",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Kaliningrad va Minsk vaqti",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Ozarbayjon standart vaqti",
               "AZT",
               "Ozarbayjon yozgi vaqti",
               "AZST",
               "Ozarbayjon vaqti",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mouson vaqti",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksika Tinch okeani standart vaqti",
               "MST",
               "Meksika Tinch okeani yozgi vaqti",
               "MDT",
               "Meksika Tinch okeani vaqti",
               "MT",
            };
        final String[] Davis = new String[] {
               "Deyvis vaqti",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kuba standart vaqti",
               "CST",
               "Kuba yozgi vaqti",
               "CDT",
               "Kuba vaqti",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "G\u02bbarbiy Afrika standart vaqti",
               "CAT",
               "G\u02bbarbiy Afrika yozgi vaqti",
               "CAST",
               "G\u02bbarbiy Afrika vaqti",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Grinvich o\u2018rtacha vaqti",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filippin standart vaqti",
               "PHT",
               "Filippin yozgi vaqti",
               "PHST",
               "Filippin vaqti",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Fransuz Janubiy va Antarktika vaqti",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Janubiy Georgiya vaqti",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Yangi Kaledoniya standart vaqti",
               "NCT",
               "Yangi Kaledoniya yozgi vaqti",
               "NCST",
               "Yangi Kaledoniya vaqti",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Bruney-Dorussalom vaqti",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Eron standart vaqti",
               "IRST",
               "Eron yozgi vaqti",
               "IRDT",
               "Eron vaqti",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Pasxa oroli standart vaqti",
               "EAST",
               "Pasxa oroli yozgi vaqti",
               "EASST",
               "Pasxa oroli vaqti",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Shimoli-g\u2018arbiy Meksika standart vaqti",
               "PST",
               "Shimoli-g\u2018arbiy Meksika yozgi vaqti",
               "PDT",
               "Shimoli-g\u2018arbiy Meksika vaqti",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dyumon-d\u2019Yurvil vaqti",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tojikiston vaqti",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga standart vaqti",
               "TOT",
               "Tonga yozgi vaqti",
               "TOST",
               "Tonga vaqti",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh standart vaqti",
               "BDT",
               "Bangladesh yozgi vaqti",
               "BDST",
               "Bangladesh vaqti",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru standart vaqti",
               "PET",
               "Peru yozgi vaqti",
               "PEST",
               "Peru vaqti",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "G\u02bbarbiy Grenlandiya standart vaqti",
               "WGT",
               "G\u02bbarbiy Grenlandiya yozgi vaqti",
               "WGST",
               "G\u02bbarbiy Grenlandiya vaqti",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvador vaqti",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Sharqiy Grenlandiya standart vaqti",
               "EGT",
               "Sharqiy Grenlandiya yozgi vaqti",
               "EGST",
               "Sharqiy Grenlandiya vaqti",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Fors ko\u2018rfazi standart vaqti",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Sharqiy Indoneziya vaqti",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Koreya standart vaqti",
               "KST",
               "Koreya yozgi vaqti",
               "KDT",
               "Koreya vaqti",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "G\u2018arbiy Avstraliya standart vaqti",
               "AWST",
               "G\u2018arbiy Avstraliya yozgi vaqti",
               "AWDT",
               "G\u2018arbiy Avstraliya vaqti",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Qirg\u02bbiziston vaqti",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "G\u02bbarbiy Indoneziya vaqti",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Sharqiy Avstraliya standart vaqti",
               "AEST",
               "Sharqiy Avstraliya yozgi vaqti",
               "AEDT",
               "Sharqiy Avstraliya vaqti",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Fransuz Gvianasi vaqti",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbiya standart vaqti",
               "COT",
               "Kolumbiya yozgi vaqti",
               "COST",
               "Kolumbiya vaqti",
               "COT",
            };
        final String[] Chile = new String[] {
               "Chili standart vaqti",
               "CLT",
               "Chili yozgi vaqti",
               "CLST",
               "Chili vaqti",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert orollari vaqti",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Shimoliy Amerika tog\u02bb standart vaqti",
               "MST",
               "Shimoliy Amerika tog\u02bb yozgi vaqti",
               "MDT",
               "Shimoliy Amerika tog\u02bb vaqti",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markiz orollari vaqti",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Saudiya Arabistoni standart vaqti",
               "AST",
               "Saudiya Arabistoni yozgi vaqti",
               "ADT",
               "Saudiya Arabistoni vaqti",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alyaska standart vaqti",
               "AKST",
               "Alyaska yozgi vaqti",
               "AKDT",
               "Alyaska vaqti",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok standart vaqti",
               "VLAT",
               "Vladivostok yozgi vaqti",
               "VLAST",
               "Vladivostok vaqti",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro standart vaqti",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk standart vaqti",
               "IRKT",
               "Irkutsk yozgi vaqti",
               "IRKST",
               "Irkutsk vaqti",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gruziya standart vaqti",
               "GET",
               "Gruziya yozgi vaqti",
               "GEST",
               "Gruziya vaqti",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau vaqti",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Yangi Gvineya vaqti",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernandu-di-Noronya standart vaqti",
               "FNT",
               "Fernandu-di-Noronya yozgi vaqti",
               "FNST",
               "Fernandu-di-Noronya vaqti",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choybalsan standart vaqti",
               "CHOT",
               "Choybalsan yozgi vaqti",
               "CHOST",
               "Choybalsan vaqti",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Braziliya standart vaqti",
               "BRT",
               "Braziliya yozgi vaqti",
               "BRST",
               "Braziliya vaqti",
               "BRT",
            };
        final String[] China = new String[] {
               "Xitoy standart vaqti",
               "CST",
               "Xitoy yozgi vaqti",
               "CDT",
               "Xitoy vaqti",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armaniston standart vaqti",
               "AMT",
               "Armaniston yozgi vaqti",
               "AMST",
               "Armaniston vaqti",
               "AMT",
            };
        final String[] India = new String[] {
               "Hindiston vaqti",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Kuk orollari standart vaqti",
               "CKT",
               "Kuk orollari yarim yozgi vaqti",
               "CKHST",
               "Kuk orollari vaqti",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Grinvich o\u2018rtacha vaqti",
                    "GMT",
                    "Britaniya yozgi vaqti",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Grinvich o\u2018rtacha vaqti",
                    "GMT",
                    "Irlandiya yozgi vaqti",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
