/* rygel-browse.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-browse.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <glib.h>
#include <gio/gio.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;
typedef struct _RygelBrowsePrivate RygelBrowsePrivate;
enum  {
	RYGEL_BROWSE_0_PROPERTY,
	RYGEL_BROWSE_NUM_PROPERTIES
};
static GParamSpec* rygel_browse_properties[RYGEL_BROWSE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY_ERROR (rygel_content_directory_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelBrowseFetchResultsData RygelBrowseFetchResultsData;
typedef struct _RygelBrowseHandleChildrenRequestData RygelBrowseHandleChildrenRequestData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelBrowse {
	RygelMediaQueryAction parent_instance;
	RygelBrowsePrivate * priv;
};

struct _RygelBrowseClass {
	RygelMediaQueryActionClass parent_class;
};

struct _RygelBrowsePrivate {
	gboolean fetch_metadata;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

struct _RygelBrowseFetchResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelBrowse* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	RygelMediaObjects* _tmp5_;
	GError* _inner_error0_;
};

struct _RygelBrowseHandleChildrenRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelBrowse* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	GError* _tmp0_;
	RygelMediaContainer* container;
	RygelMediaContainer* _tmp1_;
	gboolean _tmp2_;
	RygelMediaContainer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaContainer* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelMediaContainer* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	RygelMediaContainer* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* sort_criteria;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaContainer* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp27_;
	const gchar* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	RygelMediaObjects* _tmp31_;
	const gchar* _tmp32_;
	GError* _inner_error0_;
};

static gint RygelBrowse_private_offset;
static gpointer rygel_browse_parent_class = NULL;

VALA_EXTERN GType rygel_media_query_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_browse_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_media_query_action_parse_args (RygelMediaQueryAction* self,
                                          GError** error);
VALA_EXTERN void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self,
                                             RygelMediaObject* media_object,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
VALA_EXTERN void rygel_media_query_action_handle_error (RygelMediaQueryAction* self,
                                            GError* _error_);
VALA_EXTERN RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir,
                               GUPnPServiceAction* action);
VALA_EXTERN RygelBrowse* rygel_browse_construct (GType object_type,
                                     RygelContentDirectory* content_dir,
                                     GUPnPServiceAction* action);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
VALA_EXTERN RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type,
                                                           RygelContentDirectory* content_dir,
                                                           GUPnPServiceAction* action);
VALA_EXTERN const gchar* rygel_client_hacks_get_object_id (RygelClientHacks* self);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_browse_real_parse_args (RygelMediaQueryAction* base,
                                   GError** error);
VALA_EXTERN GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_error_get_type (void) G_GNUC_CONST ;
static void rygel_browse_real_fetch_results_data_free (gpointer _data);
static void rygel_browse_real_fetch_results (RygelMediaQueryAction* base,
                                      RygelMediaObject* media_object,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean rygel_browse_real_fetch_results_co (RygelBrowseFetchResultsData* _data_);
static RygelMediaObjects* rygel_browse_handle_metadata_request (RygelBrowse* self,
                                                         RygelMediaObject* media_object,
                                                         GError** error);
static void rygel_browse_handle_children_request (RygelBrowse* self,
                                           RygelMediaObject* media_object,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static RygelMediaObjects* rygel_browse_handle_children_request_finish (RygelBrowse* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void rygel_browse_fetch_results_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void rygel_browse_handle_children_request_data_free (gpointer _data);
static gboolean rygel_browse_handle_children_request_co (RygelBrowseHandleChildrenRequestData* _data_);
static void rygel_browse_handle_children_request_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void rygel_browse_real_handle_error (RygelMediaQueryAction* base,
                                     GError* _error_);
static void rygel_browse_finalize (GObject * obj);
static GType rygel_browse_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_browse_get_instance_private (RygelBrowse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelBrowse_private_offset);
}

static GUPnPServiceAction*
_vala_GUPnPServiceAction_copy (GUPnPServiceAction* self)
{
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}

static gpointer
__vala_GUPnPServiceAction_copy0 (gpointer self)
{
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

RygelBrowse*
rygel_browse_construct (GType object_type,
                        RygelContentDirectory* content_dir,
                        GUPnPServiceAction* action)
{
	RygelBrowse * self = NULL;
	GUPnPServiceAction* _tmp0_;
	RygelClientHacks* _tmp1_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	_tmp0_ = __vala_GUPnPServiceAction_copy0 (action);
	self = (RygelBrowse*) rygel_media_query_action_construct (object_type, content_dir, _tmp0_);
	_tmp1_ = ((RygelMediaQueryAction*) self)->hacks;
	if (_tmp1_ != NULL) {
		RygelClientHacks* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = ((RygelMediaQueryAction*) self)->hacks;
		_tmp3_ = rygel_client_hacks_get_object_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (((RygelMediaQueryAction*) self)->object_id_arg);
		((RygelMediaQueryAction*) self)->object_id_arg = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("ObjectID");
		_g_free0 (((RygelMediaQueryAction*) self)->object_id_arg);
		((RygelMediaQueryAction*) self)->object_id_arg = _tmp6_;
	}
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

RygelBrowse*
rygel_browse_new (RygelContentDirectory* content_dir,
                  GUPnPServiceAction* action)
{
	return rygel_browse_construct (RYGEL_TYPE_BROWSE, content_dir, action);
}

static void
rygel_browse_real_parse_args (RygelMediaQueryAction* base,
                              GError** error)
{
	RygelBrowse * self;
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (RygelBrowse*) base;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_browse_parent_class)->parse_args (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = ((RygelMediaQueryAction*) self)->action;
	gupnp_service_action_get (_tmp0_, "BrowseFlag", G_TYPE_STRING, &_tmp1_, NULL);
	_g_free0 (((RygelMediaQueryAction*) self)->browse_flag);
	((RygelMediaQueryAction*) self)->browse_flag = _tmp1_;
	_tmp3_ = ((RygelMediaQueryAction*) self)->browse_flag;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = ((RygelMediaQueryAction*) self)->browse_flag;
		_tmp2_ = g_strcmp0 (_tmp4_, "BrowseDirectChildren") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->fetch_metadata = FALSE;
	} else {
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		_tmp6_ = ((RygelMediaQueryAction*) self)->browse_flag;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = ((RygelMediaQueryAction*) self)->browse_flag;
			_tmp5_ = g_strcmp0 (_tmp7_, "BrowseMetadata") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			self->priv->fetch_metadata = TRUE;
		} else {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Invalid Arguments"));
			_inner_error0_ = _tmp8_;
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

static void
rygel_browse_real_fetch_results_data_free (gpointer _data)
{
	RygelBrowseFetchResultsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBrowseFetchResultsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_browse_real_fetch_results (RygelMediaQueryAction* base,
                                 RygelMediaObject* media_object,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelBrowse * self;
	RygelBrowseFetchResultsData* _data_;
	RygelBrowse* _tmp0_;
	RygelMediaObject* _tmp1_;
	g_return_if_fail (media_object != NULL);
	self = (RygelBrowse*) base;
	_data_ = g_slice_new0 (RygelBrowseFetchResultsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_browse_real_fetch_results_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (media_object);
	_g_object_unref0 (_data_->media_object);
	_data_->media_object = _tmp1_;
	rygel_browse_real_fetch_results_co (_data_);
}

static RygelMediaObjects*
rygel_browse_fetch_results_finish (RygelMediaQueryAction* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	RygelMediaObjects* result;
	RygelBrowseFetchResultsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_browse_fetch_results_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	RygelBrowseFetchResultsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_browse_real_fetch_results_co (_data_);
}

static gboolean
rygel_browse_real_fetch_results_co (RygelBrowseFetchResultsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->fetch_metadata) {
		_data_->_tmp1_ = rygel_browse_handle_metadata_request (_data_->self, _data_->media_object, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_data_->result = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_state_ = 1;
		rygel_browse_handle_children_request (_data_->self, _data_->media_object, rygel_browse_fetch_results_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = rygel_browse_handle_children_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_data_->result = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp3_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static RygelMediaObjects*
rygel_browse_handle_metadata_request (RygelBrowse* self,
                                      RygelMediaObject* media_object,
                                      GError** error)
{
	RygelMediaObjects* results = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_object != NULL, NULL);
	((RygelMediaQueryAction*) self)->total_matches = (guint) 1;
	_tmp0_ = rygel_media_objects_new ();
	results = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) results, media_object);
	result = results;
	return result;
}

static void
rygel_browse_handle_children_request_data_free (gpointer _data)
{
	RygelBrowseHandleChildrenRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBrowseHandleChildrenRequestData, _data_);
}

static void
rygel_browse_handle_children_request (RygelBrowse* self,
                                      RygelMediaObject* media_object,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RygelBrowseHandleChildrenRequestData* _data_;
	RygelBrowse* _tmp0_;
	RygelMediaObject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media_object != NULL);
	_data_ = g_slice_new0 (RygelBrowseHandleChildrenRequestData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_browse_handle_children_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (media_object);
	_g_object_unref0 (_data_->media_object);
	_data_->media_object = _tmp1_;
	rygel_browse_handle_children_request_co (_data_);
}

static RygelMediaObjects*
rygel_browse_handle_children_request_finish (RygelBrowse* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	RygelMediaObjects* result;
	RygelBrowseHandleChildrenRequestData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_browse_handle_children_request_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	RygelBrowseHandleChildrenRequestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_browse_handle_children_request_co (_data_);
}

static gboolean
rygel_browse_handle_children_request_co (RygelBrowseHandleChildrenRequestData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!RYGEL_IS_MEDIA_CONTAINER (_data_->media_object)) {
		_data_->_tmp0_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Cannot browse children on item"));
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->media_object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer));
	_data_->container = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->container;
	_data_->_tmp4_ = rygel_media_container_get_child_count (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (-1 < _data_->_tmp5_) {
		_data_->_tmp6_ = _data_->container;
		_data_->_tmp7_ = rygel_media_container_get_child_count (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp2_ = _data_->_tmp8_ < G_MAXINT;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp9_ = _data_->container;
		_data_->_tmp10_ = rygel_media_container_get_child_count (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		((RygelMediaQueryAction*) _data_->self)->total_matches = (guint) _data_->_tmp11_;
	} else {
		((RygelMediaQueryAction*) _data_->self)->total_matches = (guint) 0;
	}
	if (((RygelMediaQueryAction*) _data_->self)->requested_count == ((guint) 0)) {
		((RygelMediaQueryAction*) _data_->self)->requested_count = ((RygelMediaQueryAction*) _data_->self)->total_matches;
	}
	_data_->_tmp13_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
	_data_->_tmp12_ = _data_->_tmp13_;
	if (_data_->_tmp12_ == NULL) {
		_data_->_tmp14_ = _data_->container;
		_data_->_tmp15_ = rygel_media_container_get_sort_criteria (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp12_ = _data_->_tmp16_;
	}
	_data_->_tmp17_ = g_strdup (_data_->_tmp12_);
	_data_->sort_criteria = _data_->_tmp17_;
	_data_->_tmp19_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
	if (_data_->_tmp19_ == NULL) {
		_data_->_tmp20_ = _data_->container;
		_data_->_tmp21_ = rygel_media_container_get_sort_criteria (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = g_strdup_printf ("none, using default: %s", _data_->_tmp22_);
		_g_free0 (_data_->_tmp18_);
		_data_->_tmp18_ = _data_->_tmp23_;
	} else {
		_data_->_tmp24_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
		_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
		_g_free0 (_data_->_tmp18_);
		_data_->_tmp18_ = _data_->_tmp25_;
	}
	_data_->_tmp26_ = ((RygelMediaQueryAction*) _data_->self)->object_id;
	g_debug ("Fetching %u children of container '%s' from index %u " "with sort criteria %s", ((RygelMediaQueryAction*) _data_->self)->requested_count, _data_->_tmp26_, ((RygelMediaQueryAction*) _data_->self)->index, _data_->_tmp18_);
	_data_->_tmp27_ = _data_->container;
	_data_->_tmp28_ = _data_->sort_criteria;
	_data_->_tmp29_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_state_ = 1;
	rygel_media_container_get_children (_data_->_tmp27_, ((RygelMediaQueryAction*) _data_->self)->index, ((RygelMediaQueryAction*) _data_->self)->requested_count, _data_->_tmp28_, _data_->_tmp30_, rygel_browse_handle_children_request_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp31_ = rygel_media_container_get_children_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
	_data_->children = _data_->_tmp31_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->_tmp18_);
		_g_free0 (_data_->sort_criteria);
		_g_object_unref0 (_data_->container);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = ((RygelMediaQueryAction*) _data_->self)->object_id;
	g_debug ("rygel-browse.vala:125: Fetched %u children of container '%s' from inde" \
"x %u.", ((RygelMediaQueryAction*) _data_->self)->requested_count, _data_->_tmp32_, ((RygelMediaQueryAction*) _data_->self)->index);
	_data_->result = _data_->children;
	_g_free0 (_data_->_tmp18_);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->container);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_browse_real_handle_error (RygelMediaQueryAction* base,
                                GError* _error_)
{
	RygelBrowse * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelBrowse*) base;
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = ((RygelMediaQueryAction*) self)->object_id;
	_tmp1_ = _error_->message;
	g_warning (_ ("Failed to browse “%s”: %s\n"), _tmp0_, _tmp1_);
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_browse_parent_class)->handle_error (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), _error_);
}

static void
rygel_browse_class_init (RygelBrowseClass * klass,
                         gpointer klass_data)
{
	rygel_browse_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelBrowse_private_offset);
	((RygelMediaQueryActionClass *) klass)->parse_args = (void (*) (RygelMediaQueryAction*, GError**)) rygel_browse_real_parse_args;
	((RygelMediaQueryActionClass *) klass)->fetch_results = (void (*) (RygelMediaQueryAction*, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_browse_real_fetch_results;
	((RygelMediaQueryActionClass *) klass)->fetch_results_finish = (RygelMediaObjects* (*) (RygelMediaQueryAction*, GAsyncResult*, GError**)) rygel_browse_fetch_results_finish;
	((RygelMediaQueryActionClass *) klass)->handle_error = (void (*) (RygelMediaQueryAction*, GError*)) rygel_browse_real_handle_error;
	G_OBJECT_CLASS (klass)->finalize = rygel_browse_finalize;
}

static void
rygel_browse_instance_init (RygelBrowse * self,
                            gpointer klass)
{
	self->priv = rygel_browse_get_instance_private (self);
}

static void
rygel_browse_finalize (GObject * obj)
{
	RygelBrowse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BROWSE, RygelBrowse);
	G_OBJECT_CLASS (rygel_browse_parent_class)->finalize (obj);
}

/**
 * Browse action implementation. This class is more or less the state-machine
 * associated with the Browse action handling that exists to make asynchronous
 * handling of Browse action possible.
 */
static GType
rygel_browse_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelBrowseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_browse_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBrowse), 0, (GInstanceInitFunc) rygel_browse_instance_init, NULL };
	GType rygel_browse_type_id;
	rygel_browse_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_QUERY_ACTION, "RygelBrowse", &g_define_type_info, 0);
	RygelBrowse_private_offset = g_type_add_instance_private (rygel_browse_type_id, sizeof (RygelBrowsePrivate));
	return rygel_browse_type_id;
}

GType
rygel_browse_get_type (void)
{
	static volatile gsize rygel_browse_type_id__once = 0;
	if (g_once_init_enter (&rygel_browse_type_id__once)) {
		GType rygel_browse_type_id;
		rygel_browse_type_id = rygel_browse_get_type_once ();
		g_once_init_leave (&rygel_browse_type_id__once, rygel_browse_type_id);
	}
	return rygel_browse_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

