/* rygel-subtitle-manager.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-subtitle-manager.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>.
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define TYPE_SUBTITLE_MANAGER_ERROR (subtitle_manager_error_get_type ())

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
typedef struct _RygelSubtitleManagerPrivate RygelSubtitleManagerPrivate;
enum  {
	RYGEL_SUBTITLE_MANAGER_0_PROPERTY,
	RYGEL_SUBTITLE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* rygel_subtitle_manager_properties[RYGEL_SUBTITLE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	SUBTITLE_MANAGER_ERROR_NO_SUBTITLE
} SubtitleManagerError;
#define SUBTITLE_MANAGER_ERROR subtitle_manager_error_quark ()

struct _RygelSubtitleManager {
	GObject parent_instance;
	RygelSubtitleManagerPrivate * priv;
};

struct _RygelSubtitleManagerClass {
	GObjectClass parent_class;
};

static gpointer rygel_subtitle_manager_parent_class = NULL;
static RygelSubtitleManager* rygel_subtitle_manager_manager;
static RygelSubtitleManager* rygel_subtitle_manager_manager = NULL;

VALA_EXTERN GQuark subtitle_manager_error_quark (void);
GType subtitle_manager_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
VALA_EXTERN RygelSubtitleManager* rygel_subtitle_manager_new (void);
VALA_EXTERN RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type);
VALA_EXTERN GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self,
                                                    const gchar* uri,
                                                    GError** error);
static void rygel_subtitle_manager_finalize (GObject * obj);
static GType rygel_subtitle_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
subtitle_manager_error_quark (void)
{
	return g_quark_from_static_string ("subtitle-manager-error-quark");
}

static GType
subtitle_manager_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, "SUBTITLE_MANAGER_ERROR_NO_SUBTITLE", "no-subtitle"}, {0, NULL, NULL}};
	GType subtitle_manager_error_type_id;
	subtitle_manager_error_type_id = g_enum_register_static ("SubtitleManagerError", values);
	return subtitle_manager_error_type_id;
}

GType
subtitle_manager_error_get_type (void)
{
	static volatile gsize subtitle_manager_error_type_id__once = 0;
	if (g_once_init_enter (&subtitle_manager_error_type_id__once)) {
		GType subtitle_manager_error_type_id;
		subtitle_manager_error_type_id = subtitle_manager_error_get_type_once ();
		g_once_init_leave (&subtitle_manager_error_type_id__once, subtitle_manager_error_type_id);
	}
	return subtitle_manager_error_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelSubtitleManager*
rygel_subtitle_manager_get_default (void)
{
	RygelSubtitleManager* _tmp0_;
	RygelSubtitleManager* _tmp2_;
	RygelSubtitleManager* _tmp3_;
	RygelSubtitleManager* result;
	_tmp0_ = rygel_subtitle_manager_manager;
	if (_tmp0_ == NULL) {
		RygelSubtitleManager* _tmp1_;
		_tmp1_ = rygel_subtitle_manager_new ();
		_g_object_unref0 (rygel_subtitle_manager_manager);
		rygel_subtitle_manager_manager = _tmp1_;
	}
	_tmp2_ = rygel_subtitle_manager_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

GeeArrayList*
rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self,
                                      const gchar* uri,
                                      GError** error)
{
	GFile* video_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* directory = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* basename = NULL;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gint ext_index = 0;
	const gchar* _tmp7_;
	gchar** exts = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint exts_length1;
	gint _exts_size_;
	GeeArrayList* subtitles = NULL;
	GeeArrayList* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeArrayList* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	video_file = _tmp0_;
	_tmp1_ = video_file;
	if (!g_file_is_native (_tmp1_)) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _ ("No subtitle available"));
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (video_file);
		return NULL;
	}
	_tmp3_ = video_file;
	_tmp4_ = g_file_get_parent (_tmp3_);
	directory = _tmp4_;
	_tmp5_ = video_file;
	_tmp6_ = g_file_get_basename (_tmp5_);
	basename = _tmp6_;
	_tmp7_ = basename;
	ext_index = string_last_index_of_char (_tmp7_, (gunichar) '.', 0);
	if (ext_index >= 0) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = basename;
		_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) ext_index);
		_g_free0 (basename);
		basename = _tmp9_;
	}
	_tmp10_ = g_strdup ("srt");
	_tmp11_ = g_strdup ("smi");
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp10_;
	_tmp12_[1] = _tmp11_;
	exts = _tmp12_;
	exts_length1 = 2;
	_exts_size_ = exts_length1;
	_tmp13_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, (GDestroyNotify) rygel_subtitle_unref, NULL, NULL, NULL);
	subtitles = _tmp13_;
	_tmp14_ = exts;
	_tmp14__length1 = exts_length1;
	{
		gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = _tmp14_;
		ext_collection_length1 = _tmp14__length1;
		for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
			gchar* _tmp15_;
			gchar* ext = NULL;
			_tmp15_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp15_;
			{
				gchar* filename = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				GFile* subtitle_file = NULL;
				GFile* _tmp22_;
				const gchar* _tmp23_;
				GFile* _tmp24_;
				_tmp16_ = basename;
				_tmp17_ = g_strconcat (_tmp16_, ".", NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = ext;
				_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp18_);
				filename = _tmp21_;
				_tmp22_ = directory;
				_tmp23_ = filename;
				_tmp24_ = g_file_get_child (_tmp22_, _tmp23_);
				subtitle_file = _tmp24_;
				{
					gchar* attribs = NULL;
					gchar* _tmp25_;
					GFileInfo* info = NULL;
					GFile* _tmp26_;
					const gchar* _tmp27_;
					GFileInfo* _tmp28_;
					GFileInfo* _tmp29_;
					_tmp25_ = g_strdup (G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
					attribs = _tmp25_;
					_tmp26_ = subtitle_file;
					_tmp27_ = attribs;
					_tmp28_ = g_file_query_info (_tmp26_, _tmp27_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
					info = _tmp28_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (attribs);
						goto __catch0_g_error;
					}
					_tmp29_ = info;
					if (g_file_info_get_attribute_boolean (_tmp29_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
						gchar* content_type = NULL;
						GFileInfo* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						RygelSubtitle* subtitle = NULL;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						RygelSubtitle* _tmp35_;
						RygelSubtitle* _tmp36_;
						GFile* _tmp37_;
						gchar* _tmp38_;
						RygelSubtitle* _tmp39_;
						GFileInfo* _tmp40_;
						GeeArrayList* _tmp41_;
						RygelSubtitle* _tmp42_;
						_tmp30_ = info;
						_tmp31_ = g_file_info_get_attribute_string (_tmp30_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
						_tmp32_ = g_strdup (_tmp31_);
						content_type = _tmp32_;
						_tmp33_ = content_type;
						_tmp34_ = ext;
						_tmp35_ = rygel_subtitle_new (_tmp33_, _tmp34_, "srt");
						subtitle = _tmp35_;
						_tmp36_ = subtitle;
						_tmp37_ = subtitle_file;
						_tmp38_ = g_file_get_uri (_tmp37_);
						_g_free0 (_tmp36_->uri);
						_tmp36_->uri = _tmp38_;
						_tmp39_ = subtitle;
						_tmp40_ = info;
						_tmp39_->size = (gint64) g_file_info_get_attribute_uint64 (_tmp40_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
						_tmp41_ = subtitles;
						_tmp42_ = subtitle;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
						_rygel_subtitle_unref0 (subtitle);
						_g_free0 (content_type);
					}
					_g_object_unref0 (info);
					_g_free0 (attribs);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					GFile* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					GError* _tmp46_;
					const gchar* _tmp47_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp43_ = subtitle_file;
					_tmp44_ = g_file_get_path (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = err;
					_tmp47_ = _tmp46_->message;
					g_debug ("rygel-subtitle-manager.vala:88: Failed to query file information for %" \
"s: %s", _tmp45_, _tmp47_);
					_g_free0 (_tmp45_);
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (subtitle_file);
					_g_free0 (filename);
					_g_free0 (ext);
					_g_object_unref0 (subtitles);
					exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (basename);
					_g_object_unref0 (directory);
					_g_object_unref0 (video_file);
					return NULL;
				}
				_g_object_unref0 (subtitle_file);
				_g_free0 (filename);
				_g_free0 (ext);
			}
		}
	}
	_tmp48_ = subtitles;
	_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_ == 0) {
		GError* _tmp51_;
		_tmp51_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _ ("No subtitle available"));
		_inner_error0_ = _tmp51_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (subtitles);
		exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (basename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	result = subtitles;
	exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (video_file);
	return result;
}

RygelSubtitleManager*
rygel_subtitle_manager_construct (GType object_type)
{
	RygelSubtitleManager * self = NULL;
	self = (RygelSubtitleManager*) g_object_new (object_type, NULL);
	return self;
}

RygelSubtitleManager*
rygel_subtitle_manager_new (void)
{
	return rygel_subtitle_manager_construct (RYGEL_TYPE_SUBTITLE_MANAGER);
}

static void
rygel_subtitle_manager_class_init (RygelSubtitleManagerClass * klass,
                                   gpointer klass_data)
{
	rygel_subtitle_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_manager_finalize;
}

static void
rygel_subtitle_manager_instance_init (RygelSubtitleManager * self,
                                      gpointer klass)
{
}

static void
rygel_subtitle_manager_finalize (GObject * obj)
{
	RygelSubtitleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager);
	G_OBJECT_CLASS (rygel_subtitle_manager_parent_class)->finalize (obj);
}

/**
 * Provides subtitles for videos.
 */
static GType
rygel_subtitle_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitleManager), 0, (GInstanceInitFunc) rygel_subtitle_manager_instance_init, NULL };
	GType rygel_subtitle_manager_type_id;
	rygel_subtitle_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitleManager", &g_define_type_info, 0);
	return rygel_subtitle_manager_type_id;
}

GType
rygel_subtitle_manager_get_type (void)
{
	static volatile gsize rygel_subtitle_manager_type_id__once = 0;
	if (g_once_init_enter (&rygel_subtitle_manager_type_id__once)) {
		GType rygel_subtitle_manager_type_id;
		rygel_subtitle_manager_type_id = rygel_subtitle_manager_get_type_once ();
		g_once_init_leave (&rygel_subtitle_manager_type_id__once, rygel_subtitle_manager_type_id);
	}
	return rygel_subtitle_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

