/* object.c generated by valac 0.56.1, the Vala compiler
 * generated from object.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2017 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

enum  {
	SEAHORSE_OBJECT_0_PROPERTY,
	SEAHORSE_OBJECT_PLACE_PROPERTY,
	SEAHORSE_OBJECT_ICON_PROPERTY,
	SEAHORSE_OBJECT_LABEL_PROPERTY,
	SEAHORSE_OBJECT_MARKUP_PROPERTY,
	SEAHORSE_OBJECT_NICKNAME_PROPERTY,
	SEAHORSE_OBJECT_IDENTIFIER_PROPERTY,
	SEAHORSE_OBJECT_USAGE_PROPERTY,
	SEAHORSE_OBJECT_OBJECT_FLAGS_PROPERTY,
	SEAHORSE_OBJECT_DELETABLE_PROPERTY,
	SEAHORSE_OBJECT_EXPORTABLE_PROPERTY,
	SEAHORSE_OBJECT_NUM_PROPERTIES
};
static GParamSpec* seahorse_object_properties[SEAHORSE_OBJECT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SeahorseObjectPrivate {
	SeahorsePlace* _place;
	GIcon* _icon;
	gchar* _label;
	gchar* _markup;
	gboolean markup_explicit;
	gchar* _nickname;
	gboolean nickname_explicit;
	gchar* _identifier;
	SeahorseUsage _usage;
	SeahorseFlags _object_flags;
};

static gint SeahorseObject_private_offset;
static gpointer seahorse_object_parent_class = NULL;

static void seahorse_object_recalculate_label (SeahorseObject* self);
static void seahorse_object_finalize (GObject * obj);
static GType seahorse_object_get_type_once (void);
static void _vala_seahorse_object_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_seahorse_object_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
seahorse_object_get_instance_private (SeahorseObject* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseObject_private_offset);
}

SeahorseObject*
seahorse_object_construct (GType object_type)
{
	SeahorseObject * self = NULL;
	self = (SeahorseObject*) g_object_new (object_type, NULL);
	return self;
}

SeahorseObject*
seahorse_object_new (void)
{
	return seahorse_object_construct (SEAHORSE_TYPE_OBJECT);
}

SeahorseFlags
seahorse_object_get_flags (SeahorseObject* self)
{
	SeahorseFlags _tmp0_;
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_object_flags;
	result = _tmp0_;
	return result;
}

void
seahorse_object_set_flags (SeahorseObject* self,
                           SeahorseFlags flags)
{
	g_return_if_fail (self != NULL);
	seahorse_object_set_object_flags (self, flags);
}

static void
seahorse_object_recalculate_label (SeahorseObject* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->markup_explicit) {
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = seahorse_object_get_label (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
		if (_tmp0_ == NULL) {
			_tmp0_ = "";
		}
		_tmp3_ = g_markup_escape_text (_tmp0_, (gssize) -1);
		_tmp4_ = _tmp3_;
		seahorse_object_set_markup (self, _tmp4_);
		_g_free0 (_tmp4_);
		g_object_notify ((GObject*) self, "markup");
	}
	if (!self->priv->nickname_explicit) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = seahorse_object_get_label (self);
		_tmp7_ = _tmp6_;
		_tmp5_ = _tmp7_;
		if (_tmp5_ == NULL) {
			_tmp5_ = "";
		}
		seahorse_object_set_nickname (self, _tmp5_);
		g_object_notify ((GObject*) self, "nickname");
	}
}

SeahorsePlace*
seahorse_object_get_place (SeahorseObject* self)
{
	SeahorsePlace* result;
	SeahorsePlace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_place;
	result = _tmp0_;
	return result;
}

void
seahorse_object_set_place (SeahorseObject* self,
                           SeahorsePlace* value)
{
	SeahorsePlace* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_object_get_place (self);
	if (old_value != value) {
		self->priv->_place = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_PLACE_PROPERTY]);
	}
}

GIcon*
seahorse_object_get_icon (SeahorseObject* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_object_set_icon (SeahorseObject* self,
                          GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_object_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_ICON_PROPERTY]);
	}
}

const gchar*
seahorse_object_get_label (SeahorseObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
seahorse_object_set_label (SeahorseObject* self,
                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp0_;
	seahorse_object_recalculate_label (self);
	g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_LABEL_PROPERTY]);
}

const gchar*
seahorse_object_get_markup (SeahorseObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_markup;
	result = _tmp0_;
	return result;
}

void
seahorse_object_set_markup (SeahorseObject* self,
                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->markup_explicit = TRUE;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_markup);
	self->priv->_markup = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_MARKUP_PROPERTY]);
}

const gchar*
seahorse_object_get_nickname (SeahorseObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}

void
seahorse_object_set_nickname (SeahorseObject* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->nickname_explicit = TRUE;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_nickname);
	self->priv->_nickname = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_NICKNAME_PROPERTY]);
}

const gchar*
seahorse_object_get_identifier (SeahorseObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_identifier;
	result = _tmp0_;
	return result;
}

void
seahorse_object_set_identifier (SeahorseObject* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_identifier);
	self->priv->_identifier = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_IDENTIFIER_PROPERTY]);
}

SeahorseUsage
seahorse_object_get_usage (SeahorseObject* self)
{
	SeahorseUsage result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_usage;
	return result;
}

void
seahorse_object_set_usage (SeahorseObject* self,
                           SeahorseUsage value)
{
	SeahorseUsage old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_object_get_usage (self);
	if (old_value != value) {
		self->priv->_usage = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_USAGE_PROPERTY]);
	}
}

SeahorseFlags
seahorse_object_get_object_flags (SeahorseObject* self)
{
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_object_flags;
	return result;
}

void
seahorse_object_set_object_flags (SeahorseObject* self,
                                  SeahorseFlags value)
{
	SeahorseFlags old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_object_get_object_flags (self);
	if (old_value != value) {
		self->priv->_object_flags = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_object_properties[SEAHORSE_OBJECT_OBJECT_FLAGS_PROPERTY]);
	}
}

gboolean
seahorse_object_get_deletable (SeahorseObject* self)
{
	gboolean result;
	SeahorseFlags _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_object_flags;
	result = (_tmp0_ & SEAHORSE_FLAG_DELETABLE) == SEAHORSE_FLAG_DELETABLE;
	return result;
}

gboolean
seahorse_object_get_exportable (SeahorseObject* self)
{
	gboolean result;
	SeahorseFlags _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_object_flags;
	result = (_tmp0_ & SEAHORSE_FLAG_EXPORTABLE) == SEAHORSE_FLAG_EXPORTABLE;
	return result;
}

static void
seahorse_object_class_init (SeahorseObjectClass * klass,
                            gpointer klass_data)
{
	seahorse_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_object_finalize;
	/**
	     * The place this Object came from.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_PLACE_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_PLACE_PROPERTY] = g_param_spec_object ("place", "place", "place", SEAHORSE_TYPE_PLACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Stock ID for this Object.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_ICON_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * This object's displayable label.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_LABEL_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * This object's displayable markup.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_MARKUP_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_MARKUP_PROPERTY] = g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * This object's short name.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_NICKNAME_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_NICKNAME_PROPERTY] = g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Displayable ID for the object.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_IDENTIFIER_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_IDENTIFIER_PROPERTY] = g_param_spec_string ("identifier", "identifier", "identifier", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * How this object is used.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_USAGE_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_USAGE_PROPERTY] = g_param_spec_enum ("usage", "usage", "usage", SEAHORSE_TYPE_USAGE, SEAHORSE_USAGE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * This object's flags.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_OBJECT_FLAGS_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_OBJECT_FLAGS_PROPERTY] = g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, SEAHORSE_FLAG_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether this Object can be deleted.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_DELETABLE_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_DELETABLE_PROPERTY] = g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Whether this Object can be exported.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_OBJECT_EXPORTABLE_PROPERTY, seahorse_object_properties[SEAHORSE_OBJECT_EXPORTABLE_PROPERTY] = g_param_spec_boolean ("exportable", "exportable", "exportable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_object_instance_init (SeahorseObject * self,
                               gpointer klass)
{
	GThemedIcon* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = seahorse_object_get_instance_private (self);
	self->priv->_place = NULL;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("gtk-missing-image");
	self->priv->_icon = (GIcon*) _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_label = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_markup = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_nickname = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_identifier = _tmp4_;
	self->priv->_usage = SEAHORSE_USAGE_NONE;
	self->priv->_object_flags = SEAHORSE_FLAG_NONE;
}

static void
seahorse_object_finalize (GObject * obj)
{
	SeahorseObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_OBJECT, SeahorseObject);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_markup);
	_g_free0 (self->priv->_nickname);
	_g_free0 (self->priv->_identifier);
	G_OBJECT_CLASS (seahorse_object_parent_class)->finalize (obj);
}

/**
 * The base class for passwords/keys and others that are handled by Seahorse.
 */
 G_GNUC_NO_INLINE static GType
seahorse_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseObject), 0, (GInstanceInitFunc) seahorse_object_instance_init, NULL };
	GType seahorse_object_type_id;
	seahorse_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseObject", &g_define_type_info, 0);
	SeahorseObject_private_offset = g_type_add_instance_private (seahorse_object_type_id, sizeof (SeahorseObjectPrivate));
	return seahorse_object_type_id;
}

GType
seahorse_object_get_type (void)
{
	static volatile gsize seahorse_object_type_id__once = 0;
	if (g_once_init_enter (&seahorse_object_type_id__once)) {
		GType seahorse_object_type_id;
		seahorse_object_type_id = seahorse_object_get_type_once ();
		g_once_init_leave (&seahorse_object_type_id__once, seahorse_object_type_id);
	}
	return seahorse_object_type_id__once;
}

static void
_vala_seahorse_object_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	SeahorseObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_OBJECT, SeahorseObject);
	switch (property_id) {
		case SEAHORSE_OBJECT_PLACE_PROPERTY:
		g_value_set_object (value, seahorse_object_get_place (self));
		break;
		case SEAHORSE_OBJECT_ICON_PROPERTY:
		g_value_set_object (value, seahorse_object_get_icon (self));
		break;
		case SEAHORSE_OBJECT_LABEL_PROPERTY:
		g_value_set_string (value, seahorse_object_get_label (self));
		break;
		case SEAHORSE_OBJECT_MARKUP_PROPERTY:
		g_value_set_string (value, seahorse_object_get_markup (self));
		break;
		case SEAHORSE_OBJECT_NICKNAME_PROPERTY:
		g_value_set_string (value, seahorse_object_get_nickname (self));
		break;
		case SEAHORSE_OBJECT_IDENTIFIER_PROPERTY:
		g_value_set_string (value, seahorse_object_get_identifier (self));
		break;
		case SEAHORSE_OBJECT_USAGE_PROPERTY:
		g_value_set_enum (value, seahorse_object_get_usage (self));
		break;
		case SEAHORSE_OBJECT_OBJECT_FLAGS_PROPERTY:
		g_value_set_flags (value, seahorse_object_get_object_flags (self));
		break;
		case SEAHORSE_OBJECT_DELETABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_object_get_deletable (self));
		break;
		case SEAHORSE_OBJECT_EXPORTABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_object_get_exportable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_object_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	SeahorseObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_OBJECT, SeahorseObject);
	switch (property_id) {
		case SEAHORSE_OBJECT_PLACE_PROPERTY:
		seahorse_object_set_place (self, g_value_get_object (value));
		break;
		case SEAHORSE_OBJECT_ICON_PROPERTY:
		seahorse_object_set_icon (self, g_value_get_object (value));
		break;
		case SEAHORSE_OBJECT_LABEL_PROPERTY:
		seahorse_object_set_label (self, g_value_get_string (value));
		break;
		case SEAHORSE_OBJECT_MARKUP_PROPERTY:
		seahorse_object_set_markup (self, g_value_get_string (value));
		break;
		case SEAHORSE_OBJECT_NICKNAME_PROPERTY:
		seahorse_object_set_nickname (self, g_value_get_string (value));
		break;
		case SEAHORSE_OBJECT_IDENTIFIER_PROPERTY:
		seahorse_object_set_identifier (self, g_value_get_string (value));
		break;
		case SEAHORSE_OBJECT_USAGE_PROPERTY:
		seahorse_object_set_usage (self, g_value_get_enum (value));
		break;
		case SEAHORSE_OBJECT_OBJECT_FLAGS_PROPERTY:
		seahorse_object_set_object_flags (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

