/* generate.c generated by valac 0.56.1, the Vala compiler
 * generated from generate.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <glib/gi18n-lib.h>
#include "libseahorse/seahorse-progress.h"

enum  {
	SEAHORSE_SSH_GENERATE_0_PROPERTY,
	SEAHORSE_SSH_GENERATE_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_generate_properties[SEAHORSE_SSH_GENERATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseSshGeneratePrivate {
	SeahorseSshSource* source;
	GtkGrid* details_grid;
	SeahorseSshKeyLengthChooser* key_length_chooser;
	GtkEntry* email_entry;
	GtkComboBoxText* algorithm_combo_box;
	GtkButton* create_with_setup_button;
	GtkButton* create_no_setup_button;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseSshGenerate* self;
	gchar* filename;
	SeahorseSshGenerateOperation* op;
	gboolean upload;
};

static gint SeahorseSshGenerate_private_offset;
static gpointer seahorse_ssh_generate_parent_class = NULL;

static void __lambda22_ (SeahorseSshGenerate* self,
                  GtkButton* b);
static void seahorse_ssh_generate_create_key (SeahorseSshGenerate* self,
                                       gboolean upload);
static void ___lambda22__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda27_ (SeahorseSshGenerate* self,
                  GtkButton* b);
static void ___lambda27__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void seahorse_ssh_generate_on_algo_changed (SeahorseSshGenerate* self,
                                            GtkComboBox* combo);
static void _seahorse_ssh_generate_on_algo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda23_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda24_ (Block1Data* _data1_,
                   GObject* obj,
                   GAsyncResult* res);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda24__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda23__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void seahorse_ssh_generate_finalize (GObject * obj);
static GType seahorse_ssh_generate_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_generate_get_instance_private (SeahorseSshGenerate* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshGenerate_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda22_ (SeahorseSshGenerate* self,
             GtkButton* b)
{
	g_return_if_fail (b != NULL);
	seahorse_ssh_generate_create_key (self, FALSE);
}

static void
___lambda22__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda22_ ((SeahorseSshGenerate*) self, _sender);
}

static void
__lambda27_ (SeahorseSshGenerate* self,
             GtkButton* b)
{
	g_return_if_fail (b != NULL);
	seahorse_ssh_generate_create_key (self, TRUE);
}

static void
___lambda27__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda27_ ((SeahorseSshGenerate*) self, _sender);
}

SeahorseSshGenerate*
seahorse_ssh_generate_construct (GType object_type,
                                 SeahorseSshSource* src,
                                 GtkWindow* parent)
{
	SeahorseSshGenerate * self = NULL;
	SeahorseSshSource* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	SeahorseSshKeyLengthChooser* _tmp3_;
	SeahorseSshKeyLengthChooser* _tmp4_;
	GtkGrid* _tmp5_;
	SeahorseSshKeyLengthChooser* _tmp6_;
	GtkComboBoxText* _tmp7_;
	g_return_val_if_fail (src != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (SeahorseSshGenerate*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	_tmp0_ = _g_object_ref0 (src);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp0_;
	_tmp1_ = self->priv->create_no_setup_button;
	g_signal_connect_object (_tmp1_, "clicked", (GCallback) ___lambda22__gtk_button_clicked, self, 0);
	_tmp2_ = self->priv->create_with_setup_button;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) ___lambda27__gtk_button_clicked, self, 0);
	_tmp3_ = seahorse_ssh_key_length_chooser_new (SEAHORSE_SSH_ALGORITHM_RSA);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->key_length_chooser);
	self->priv->key_length_chooser = _tmp3_;
	_tmp4_ = self->priv->key_length_chooser;
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = self->priv->details_grid;
	_tmp6_ = self->priv->key_length_chooser;
	gtk_grid_attach (_tmp5_, (GtkWidget*) _tmp6_, 1, 3, 1, 1);
	_tmp7_ = self->priv->algorithm_combo_box;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp7_, 0);
	return self;
}

SeahorseSshGenerate*
seahorse_ssh_generate_new (SeahorseSshSource* src,
                           GtkWindow* parent)
{
	return seahorse_ssh_generate_construct (SEAHORSE_SSH_TYPE_GENERATE, src, parent);
}

static void
seahorse_ssh_generate_on_algo_changed (SeahorseSshGenerate* self,
                                       GtkComboBox* combo)
{
	gchar* t = NULL;
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	SeahorseSshKeyLengthChooser* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->algorithm_combo_box;
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
	t = _tmp1_;
	_tmp2_ = self->priv->key_length_chooser;
	seahorse_ssh_key_length_chooser_set_algorithm (_tmp2_, seahorse_ssh_algorithm_from_string (t));
	_g_free0 (t);
}

static void
_seahorse_ssh_generate_on_algo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	seahorse_ssh_generate_on_algo_changed ((SeahorseSshGenerate*) self, _sender);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SeahorseSshGenerate* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->op);
		_g_free0 (_data1_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda24_ (Block1Data* _data1_,
              GObject* obj,
              GAsyncResult* res)
{
	SeahorseSshGenerate* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseSshKey* key = NULL;
		SeahorseSshSource* _tmp0_;
		SeahorseSshKey* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = self->priv->source;
		_tmp1_ = seahorse_ssh_source_add_key_from_filename_finish (_tmp0_, res, &_inner_error0_);
		key = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data1_->upload) {
			_tmp2_ = key != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GList* keys = NULL;
			SeahorseSshKey* _tmp3_;
			GList* _tmp4_;
			keys = NULL;
			_tmp3_ = _g_object_ref0 (key);
			keys = g_list_append (keys, _tmp3_);
			_tmp4_ = keys;
			seahorse_ssh_upload_prompt (_tmp4_, NULL);
			(keys == NULL) ? NULL : (keys = (_g_list_free__g_object_unref0_ (keys), NULL));
		}
		_g_object_unref0 (key);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		seahorse_util_show_error (NULL, _ ("Couldn’t load newly generated Secure Shell key"), _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda24__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda24_ (self, source_object, res);
	block1_data_unref (self);
}

static void
__lambda23_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseSshGenerate* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseSshSource* _tmp0_;
		seahorse_ssh_generate_operation_generate_finish (_data1_->op, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = self->priv->source;
		seahorse_ssh_source_add_key_from_filename (_tmp0_, _data1_->filename, ____lambda24__gasync_ready_callback, block1_data_ref (_data1_));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error (NULL, _ ("Couldn’t generate Secure Shell key"), _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda23__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda23_ (self, source_object, res);
	block1_data_unref (self);
}

static void
seahorse_ssh_generate_create_key (SeahorseSshGenerate* self,
                                  gboolean upload)
{
	Block1Data* _data1_;
	gchar* email = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* t = NULL;
	GtkComboBoxText* _tmp4_;
	gchar* _tmp5_;
	SeahorseSshAlgorithm type = 0;
	guint bits = 0U;
	SeahorseSshKeyLengthChooser* _tmp6_;
	SeahorseSshSource* _tmp7_;
	gchar* _tmp8_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp9_;
	SeahorseSshGenerateOperation* _tmp10_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->upload = upload;
	_tmp0_ = self->priv->email_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	email = _tmp3_;
	_tmp4_ = self->priv->algorithm_combo_box;
	_tmp5_ = gtk_combo_box_text_get_active_text (_tmp4_);
	t = _tmp5_;
	type = seahorse_ssh_algorithm_from_string (t);
	_vala_assert (type != SEAHORSE_SSH_ALGORITHM_UNKNOWN, "type != Algorithm.UNKNOWN");
	_tmp6_ = self->priv->key_length_chooser;
	bits = (guint) seahorse_ssh_key_length_chooser_get_length (_tmp6_);
	_tmp7_ = self->priv->source;
	_tmp8_ = seahorse_ssh_source_new_filename_for_algorithm (_tmp7_, type);
	_data1_->filename = _tmp8_;
	_tmp9_ = g_cancellable_new ();
	cancellable = _tmp9_;
	_tmp10_ = seahorse_ssh_generate_operation_new ();
	_data1_->op = _tmp10_;
	seahorse_ssh_generate_operation_generate_async (_data1_->op, _data1_->filename, email, type, bits, cancellable, ___lambda23__gasync_ready_callback, block1_data_ref (_data1_));
	seahorse_progress_show (cancellable, _ ("Creating Secure Shell Key"), FALSE);
	gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
	gtk_widget_destroy ((GtkWidget*) self);
	_g_object_unref0 (cancellable);
	_g_free0 (t);
	_g_free0 (email);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
seahorse_ssh_generate_class_init (SeahorseSshGenerateClass * klass,
                                  gpointer klass_data)
{
	seahorse_ssh_generate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshGenerate_private_offset);
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_generate_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-ssh-generate.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "details_grid", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, details_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "email_entry", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, email_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "algorithm_combo_box", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, algorithm_combo_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "create_with_setup_button", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, create_with_setup_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "create_no_setup_button", FALSE, SeahorseSshGenerate_private_offset + G_STRUCT_OFFSET (SeahorseSshGeneratePrivate, create_no_setup_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_algo_changed", G_CALLBACK(_seahorse_ssh_generate_on_algo_changed_gtk_combo_box_changed));
}

static void
seahorse_ssh_generate_instance_init (SeahorseSshGenerate * self,
                                     gpointer klass)
{
	self->priv = seahorse_ssh_generate_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_ssh_generate_finalize (GObject * obj)
{
	SeahorseSshGenerate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_GENERATE, SeahorseSshGenerate);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->key_length_chooser);
	G_OBJECT_CLASS (seahorse_ssh_generate_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_generate_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshGenerateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_generate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshGenerate), 0, (GInstanceInitFunc) seahorse_ssh_generate_instance_init, NULL };
	GType seahorse_ssh_generate_type_id;
	seahorse_ssh_generate_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseSshGenerate", &g_define_type_info, 0);
	SeahorseSshGenerate_private_offset = g_type_add_instance_private (seahorse_ssh_generate_type_id, sizeof (SeahorseSshGeneratePrivate));
	return seahorse_ssh_generate_type_id;
}

GType
seahorse_ssh_generate_get_type (void)
{
	static volatile gsize seahorse_ssh_generate_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_generate_type_id__once)) {
		GType seahorse_ssh_generate_type_id;
		seahorse_ssh_generate_type_id = seahorse_ssh_generate_get_type_once ();
		g_once_init_leave (&seahorse_ssh_generate_type_id__once, seahorse_ssh_generate_type_id);
	}
	return seahorse_ssh_generate_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

