/* key-length-chooser.c generated by valac 0.56.1, the Vala compiler
 * generated from key-length-chooser.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2018 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_SSH_KEY_LENGTH_CHOOSER_0_PROPERTY,
	SEAHORSE_SSH_KEY_LENGTH_CHOOSER_ALGORITHM_PROPERTY,
	SEAHORSE_SSH_KEY_LENGTH_CHOOSER_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_key_length_chooser_properties[SEAHORSE_SSH_KEY_LENGTH_CHOOSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SeahorseSshKeyLengthChooserPrivate {
	GtkSpinButton* spin_button;
	GtkComboBoxText* combobox;
	GtkLabel* not_supported;
	SeahorseSshAlgorithm _algorithm;
};

static gint SeahorseSshKeyLengthChooser_private_offset;
static gpointer seahorse_ssh_key_length_chooser_parent_class = NULL;

static void seahorse_ssh_key_length_chooser_on_algo_changed (SeahorseSshKeyLengthChooser* self,
                                                      GObject* src,
                                                      GParamSpec* pspec);
static void _seahorse_ssh_key_length_chooser_on_algo_changed_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static void seahorse_ssh_key_length_chooser_finalize (GObject * obj);
static GType seahorse_ssh_key_length_chooser_get_type_once (void);
static void _vala_seahorse_ssh_key_length_chooser_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_seahorse_ssh_key_length_chooser_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_key_length_chooser_get_instance_private (SeahorseSshKeyLengthChooser* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshKeyLengthChooser_private_offset);
}

static void
_seahorse_ssh_key_length_chooser_on_algo_changed_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	seahorse_ssh_key_length_chooser_on_algo_changed ((SeahorseSshKeyLengthChooser*) self, _sender, pspec);
}

SeahorseSshKeyLengthChooser*
seahorse_ssh_key_length_chooser_construct (GType object_type,
                                           SeahorseSshAlgorithm algo)
{
	SeahorseSshKeyLengthChooser * self = NULL;
	GtkAdjustment* rsa_size_adj = NULL;
	GtkAdjustment* _tmp0_;
	GtkSpinButton* _tmp1_;
	GtkSpinButton* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GtkComboBoxText* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GtkComboBoxText* _tmp7_;
	GtkComboBoxText* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	self = (SeahorseSshKeyLengthChooser*) g_object_new (object_type, NULL);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = gtk_adjustment_new ((gdouble) 2048, (gdouble) 1024, (gdouble) 8193, (gdouble) 256, (gdouble) 10, (gdouble) 1);
	g_object_ref_sink (_tmp0_);
	rsa_size_adj = _tmp0_;
	_tmp1_ = (GtkSpinButton*) gtk_spin_button_new (rsa_size_adj, (gdouble) 1, (guint) 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->spin_button);
	self->priv->spin_button = _tmp1_;
	_tmp2_ = self->priv->spin_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->combobox);
	self->priv->combobox = _tmp3_;
	_tmp4_ = self->priv->combobox;
	gtk_combo_box_text_append_text (_tmp4_, "256");
	_tmp5_ = self->priv->combobox;
	gtk_combo_box_text_append_text (_tmp5_, "384");
	_tmp6_ = self->priv->combobox;
	gtk_combo_box_text_append_text (_tmp6_, "521");
	_tmp7_ = self->priv->combobox;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp7_, 0);
	_tmp8_ = self->priv->combobox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->not_supported);
	self->priv->not_supported = _tmp9_;
	_tmp10_ = self->priv->not_supported;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GObject*) self, "notify::algorithm", (GCallback) _seahorse_ssh_key_length_chooser_on_algo_changed_g_object_notify, self, 0);
	seahorse_ssh_key_length_chooser_set_algorithm (self, algo);
	_g_object_unref0 (rsa_size_adj);
	return self;
}

SeahorseSshKeyLengthChooser*
seahorse_ssh_key_length_chooser_new (SeahorseSshAlgorithm algo)
{
	return seahorse_ssh_key_length_chooser_construct (SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, algo);
}

/**
     * Returns the chosen key length (in bits). In case of an unknown algorithm,
     * it will return 0.
     */
gint
seahorse_ssh_key_length_chooser_get_length (SeahorseSshKeyLengthChooser* self)
{
	SeahorseSshAlgorithm _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_algorithm;
	switch (_tmp0_) {
		case SEAHORSE_SSH_ALGORITHM_RSA:
		{
			GtkSpinButton* _tmp1_;
			_tmp1_ = self->priv->spin_button;
			result = gtk_spin_button_get_value_as_int (_tmp1_);
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_DSA:
		{
			result = 1024;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_ECDSA:
		{
			GtkComboBoxText* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gint _tmp5_;
			_tmp2_ = self->priv->combobox;
			_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = atoi (_tmp4_);
			_g_free0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_ED25519:
		{
			result = 256;
			return result;
		}
		default:
		{
			result = 0;
			return result;
		}
	}
}

static void
seahorse_ssh_key_length_chooser_on_algo_changed (SeahorseSshKeyLengthChooser* self,
                                                 GObject* src,
                                                 GParamSpec* pspec)
{
	SeahorseSshAlgorithm _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_algorithm;
	switch (_tmp0_) {
		case SEAHORSE_SSH_ALGORITHM_RSA:
		{
			GtkSpinButton* _tmp1_;
			_tmp1_ = self->priv->spin_button;
			gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp1_);
			break;
		}
		case SEAHORSE_SSH_ALGORITHM_ECDSA:
		{
			GtkComboBoxText* _tmp2_;
			_tmp2_ = self->priv->combobox;
			gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp2_);
			break;
		}
		case SEAHORSE_SSH_ALGORITHM_DSA:
		{
			GtkLabel* _tmp3_;
			GtkLabel* _tmp4_;
			_tmp3_ = self->priv->not_supported;
			gtk_label_set_label (_tmp3_, _ ("1024 bits"));
			_tmp4_ = self->priv->not_supported;
			gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp4_);
			break;
		}
		case SEAHORSE_SSH_ALGORITHM_ED25519:
		{
			GtkLabel* _tmp5_;
			GtkLabel* _tmp6_;
			_tmp5_ = self->priv->not_supported;
			gtk_label_set_label (_tmp5_, _ ("256 bits"));
			_tmp6_ = self->priv->not_supported;
			gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp6_);
			break;
		}
		case SEAHORSE_SSH_ALGORITHM_UNKNOWN:
		{
			GtkLabel* _tmp7_;
			GtkLabel* _tmp8_;
			_tmp7_ = self->priv->not_supported;
			gtk_label_set_label (_tmp7_, _ ("Unknown key type!"));
			_tmp8_ = self->priv->not_supported;
			gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp8_);
			break;
		}
		default:
		break;
	}
}

SeahorseSshAlgorithm
seahorse_ssh_key_length_chooser_get_algorithm (SeahorseSshKeyLengthChooser* self)
{
	SeahorseSshAlgorithm result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_algorithm;
	return result;
}

void
seahorse_ssh_key_length_chooser_set_algorithm (SeahorseSshKeyLengthChooser* self,
                                               SeahorseSshAlgorithm value)
{
	SeahorseSshAlgorithm old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_length_chooser_get_algorithm (self);
	if (old_value != value) {
		self->priv->_algorithm = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_length_chooser_properties[SEAHORSE_SSH_KEY_LENGTH_CHOOSER_ALGORITHM_PROPERTY]);
	}
}

static void
seahorse_ssh_key_length_chooser_class_init (SeahorseSshKeyLengthChooserClass * klass,
                                            gpointer klass_data)
{
	seahorse_ssh_key_length_chooser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshKeyLengthChooser_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_key_length_chooser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_key_length_chooser_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_key_length_chooser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_LENGTH_CHOOSER_ALGORITHM_PROPERTY, seahorse_ssh_key_length_chooser_properties[SEAHORSE_SSH_KEY_LENGTH_CHOOSER_ALGORITHM_PROPERTY] = g_param_spec_enum ("algorithm", "algorithm", "algorithm", SEAHORSE_SSH_TYPE_ALGORITHM, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_ssh_key_length_chooser_instance_init (SeahorseSshKeyLengthChooser * self,
                                               gpointer klass)
{
	self->priv = seahorse_ssh_key_length_chooser_get_instance_private (self);
}

static void
seahorse_ssh_key_length_chooser_finalize (GObject * obj)
{
	SeahorseSshKeyLengthChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, SeahorseSshKeyLengthChooser);
	_g_object_unref0 (self->priv->spin_button);
	_g_object_unref0 (self->priv->combobox);
	_g_object_unref0 (self->priv->not_supported);
	G_OBJECT_CLASS (seahorse_ssh_key_length_chooser_parent_class)->finalize (obj);
}

/**
 * The KeyLengthChooser allows the user choose the amount of bits a key should
 * have (i.e. the strength of a key). Since the several types of keys (see
 * {@link Ssh.Algorithm}) all support several sizes in their own way (if at
 * all even), we need to adjust the UI to the chosen type.
 *
 * Please also refer to the man pages of ssh-keygen to know why some
 * some restrictions are added.
 */
 G_GNUC_NO_INLINE static GType
seahorse_ssh_key_length_chooser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshKeyLengthChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_key_length_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshKeyLengthChooser), 0, (GInstanceInitFunc) seahorse_ssh_key_length_chooser_instance_init, NULL };
	GType seahorse_ssh_key_length_chooser_type_id;
	seahorse_ssh_key_length_chooser_type_id = g_type_register_static (gtk_stack_get_type (), "SeahorseSshKeyLengthChooser", &g_define_type_info, 0);
	SeahorseSshKeyLengthChooser_private_offset = g_type_add_instance_private (seahorse_ssh_key_length_chooser_type_id, sizeof (SeahorseSshKeyLengthChooserPrivate));
	return seahorse_ssh_key_length_chooser_type_id;
}

GType
seahorse_ssh_key_length_chooser_get_type (void)
{
	static volatile gsize seahorse_ssh_key_length_chooser_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_key_length_chooser_type_id__once)) {
		GType seahorse_ssh_key_length_chooser_type_id;
		seahorse_ssh_key_length_chooser_type_id = seahorse_ssh_key_length_chooser_get_type_once ();
		g_once_init_leave (&seahorse_ssh_key_length_chooser_type_id__once, seahorse_ssh_key_length_chooser_type_id);
	}
	return seahorse_ssh_key_length_chooser_type_id__once;
}

static void
_vala_seahorse_ssh_key_length_chooser_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	SeahorseSshKeyLengthChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, SeahorseSshKeyLengthChooser);
	switch (property_id) {
		case SEAHORSE_SSH_KEY_LENGTH_CHOOSER_ALGORITHM_PROPERTY:
		g_value_set_enum (value, seahorse_ssh_key_length_chooser_get_algorithm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_key_length_chooser_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	SeahorseSshKeyLengthChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_KEY_LENGTH_CHOOSER, SeahorseSshKeyLengthChooser);
	switch (property_id) {
		case SEAHORSE_SSH_KEY_LENGTH_CHOOSER_ALGORITHM_PROPERTY:
		seahorse_ssh_key_length_chooser_set_algorithm (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

