/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class Symbol
extends ControlSequence
implements Expandable,
CaseChangeable {
    public static final Object[][] GENERIC_SYMBOLS = new Object[][]{{"{", 123}, {"}", 125}, {"%", 37}, {"_", 95}, {"&", 38}, {"$", 36}, {"#", 35}, {"lbrack", 91}, {"rbrack", 93}};
    public static final Object[][] TEXT_SYMBOLS = new Object[][]{{"P", 182}, {"S", 167}, {"O", 216}, {"o", 248}, {"copyright", 169}, {"ldots", 8230}, {"pounds", 163}, {"dag", 8224}, {"ddag", 8225}, {"slash", 47}, {"textendash", 8211}, {"textemdash", 8212}, {"textasciicircum", 94}, {"textasciitilde", 126}, {"textbackslash", 92}, {"textbar", 124}, {"textbardbl", 8214}, {"textbraceleft", 123}, {"textbraceright", 125}, {"textdollar", 36}, {"textbullet", 8226}, {"textexclamdown", 161}, {"textgreater", 62}, {"textless", 60}, {"textminus", 8722}, {"textperiodcentered", 183}, {"textasteriskcentered", 65290}, {"textquestiondown", 191}, {"textquotedbl", 34}, {"textquotedblleft", 8220}, {"textquotedblright", 8221}, {"textquoteleft", 8216}, {"textquoteright", 8217}, {"textsection", 167}, {"textparagraph", 182}, {"textsterling", 163}, {"textregistered", 174}, {"texttrademark", 8482}, {"textunderscore", 95}, {"textvisiblespace", 9251}, {"textperthousand", 8240}, {"textpertenthousand", 8241}, {"textasteriskcentered", 8727}, {"textdagger", 8224}, {"textdaggerdbl", 8225}, {"guilsinglleft", 8249}, {"guilsinglright", 8250}, {"guillemotleft", 171}, {"guillemotright", 187}, {"yen", 165}, {"ss", 223}, {"ae", 230}, {"AE", 198}, {"eth", 240}, {"Thorn", 222}, {"thorn", 254}, {"micro", 181}, {"degree", 176}, {"textdegree", 176}, {"L", 321}, {"l", 322}, {"OE", 338}, {"oe", 339}, {"AA", 197}, {"aa", 229}, {"i", 305}, {"j", 567}, {"IJ", 306}, {"ij", 307}, {"ng", 331}, {"NG", 330}, {"th", 254}, {"TH", 222}, {"dh", 240}, {"DH", 208}, {"dj", 273}, {"DJ", 272}, {"quotedblbase", 8222}, {"quotesinglbase", 8218}};
    public static final Object[][] BIG_MATH_SYMBOLS = new Object[][]{{"bigsqcap", 8851, 10757}, {"bigsqcup", 8852, 10758}, {"sum", 8721, 8721}, {"bigcap", 8745, 8898}, {"bigcup", 8746, 8899}, {"bigodot", 8857, 10752}, {"bigoplus", 8853, 10753}, {"bigotimes", 8855, 10754}, {"biguplus", 8846, 10756}, {"bigvee", 8744, 8897}, {"bigwedge", 8743, 8896}, {"int", 8747, 8747}, {"intop", 8747, 8747}, {"smallint", 8747, 8747}, {"varint", 8747, 8747}, {"oint", 8750, 8750}, {"ointop", 8750, 8750}, {"varoint", 8750, 8750}, {"coprod", 10815, 8720}, {"bigcurlyvee", 8910, 8910}, {"bigcurlywedge", 8911, 8911}, {"iint", 8748, 8748}, {"iiint", 8749, 8749}, {"oiint", 8751, 8751}, {"oiiint", 8752, 8752}, {"ointclockwise", 8754, 8754}, {"ointctrclockwise", 8755, 8755}, {"sumint", 10763, 10763}, {"sqint", 10774, 10774}, {"fint", 10767, 10767}, {"landdownint", 10778, 10778}, {"landupint", 10777, 10777}, {"bigtimes", 10761, 10761}, {"prod", 8719, 8719}, {"bigtriangleup", 9651, 9651}, {"bigtriangledown", 9661, 9661}, {"varbigtriangleup", 9651, 9651}, {"varbigtriangledown", 9661, 9661}};
    public static final Object[][] DELIMITER_SYMBOLS = new Object[][]{{"vert", 8739}, {"Vert", 8741}, {"langle", 10216}, {"rangle", 10217}, {"lvert", 8739}, {"rvert", 8739}, {"lVert", 8741}, {"rVert", 8741}};
    public static final Object[][] GREEK_SYMBOLS = new Object[][]{{"Alpha", 120546}, {"Beta", 120547}, {"Gamma", 120548}, {"Delta", 120549}, {"Epsilon", 120550}, {"Zeta", 120551}, {"Eta", 120552}, {"Theta", 120553}, {"Iota", 120554}, {"Kappa", 120555}, {"Lambda", 120556}, {"Mu", 120557}, {"Nu", 120558}, {"Xi", 120559}, {"Omicron", 120560}, {"Pi", 120561}, {"Rho", 120562}, {"Theta", 120563}, {"Sigma", 120564}, {"Tau", 120565}, {"Upsilon", 120566}, {"Phi", 120567}, {"Chi", 120568}, {"Psi", 120569}, {"Omega", 120570}, {"nabla", 120571}, {"alpha", 120572}, {"beta", 120573}, {"gamma", 120574}, {"delta", 120575}, {"varepsilon", 120576}, {"zeta", 120577}, {"eta", 120578}, {"theta", 120579}, {"iota", 120580}, {"kappa", 120581}, {"lambda", 120582}, {"mu", 120583}, {"nu", 120584}, {"xi", 120585}, {"omicron", 120586}, {"pi", 120587}, {"rho", 120588}, {"varsigma", 120589}, {"sigma", 120590}, {"tau", 120591}, {"upsilon", 120592}, {"varphi", 120593}, {"chi", 120594}, {"psi", 120595}, {"omega", 120596}, {"epsilon", 120598}, {"vartheta", 120599}, {"varkappa", 120600}, {"phi", 120601}, {"varrho", 120602}, {"varpi", 120603}};
    public static final Object[][] MATH_SYMBOLS = new Object[][]{{"digamma", 989}, {"Digamma", 988}, {"forall", 8704}, {"complement", 8705}, {"partial", 8706}, {"varpartialdiff", 120597}, {"exists", 8707}, {"nexists", 8708}, {"varnothing", 8709}, {"in", 8712}, {"notin", 8713}, {"ni", 8715}, {"owns", 8715}, {"notni", 8716}, {"vdots", 8942}, {"cdots", 8943}, {"ddots", 8945}, {"surd", 8730}, {"infty", 8734}, {"rightangle", 8735}, {"angle", 8736}, {"measuredangle", 8737}, {"sphericalangle", 8738}, {"mathdollar", 36}, {"mathellipsis", 8230}, {"mathparagraph", 182}, {"mathsection", 167}, {"mathsterling", 163}, {"mathunderscore", 95}, {"bot", 8869}, {"top", 8868}, {"Im", 8465}, {"ell", 8467}, {"Re", 8476}, {"ohm", 8486}, {"mho", 8487}, {"mathring", 8491}, {"aleph", 8501}, {"beth", 8502}, {"gimel", 8503}, {"daleth", 8504}, {"hbar", 8463}, {"wp", 8472}, {"Bbbk", 120156}, {"game", 8513}, {"Finv", 8498}, {"imath", 120484}, {"jmath", 120485}, {"emptyset", 8709}, {"prime", 8242}, {"hbar", 8463}, {"triangle", 9651}, {"neg", 172}, {"flat", 9837}, {"natural", 9838}, {"sharp", 9839}, {"clubsuit", 9827}, {"diamondsuit", 9826}, {"heartsuit", 9825}, {"spadesuit", 9824}, {"ldotp", 46}, {"colon", 8758}, {"cdotp", 8901}};
    public static final Object[][] BINARY_MATH_SYMBOLS = new Object[][]{{"le", 8804}, {"leq", 8804}, {"ge", 8805}, {"geq", 8805}, {"ll", 8810}, {"gg", 8811}, {"neq", 8800}, {"ne", 8800}, {"amalg", 10815}, {"approx", 8776}, {"approxeq", 8778}, {"ast", 8727}, {"asymp", 8781}, {"backsim", 8765}, {"because", 8757}, {"between", 8812}, {"bigcirc", 9675}, {"bigtriangledown", 9663}, {"bigtriangleup", 9653}, {"bowtie", 8904}, {"bullet", 8226}, {"bumpeq", 8783}, {"cap", 8745}, {"cdot", 8729}, {"cong", 8773}, {"circ", 8728}, {"cup", 8746}, {"dagger", 8224}, {"dashv", 8867}, {"ddagger", 8225}, {"diamond", 11046}, {"div", 247}, {"doteqdot", 8785}, {"fallingdotseq", 8786}, {"lhd", 8882}, {"mp", 8723}, {"ncong", 8775}, {"notcong", 8775}, {"nmid", 8740}, {"notmid", 8740}, {"nprec", 8832}, {"notprec", 8832}, {"npreceq", 8928}, {"notpreceq", 8928}, {"nsucc", 8833}, {"notsucc", 8833}, {"nsucceq", 8929}, {"notsucceq", 8929}, {"odot", 8857}, {"ominus", 8854}, {"oplus", 8853}, {"oslash", 8856}, {"otimes", 8855}, {"pm", 177}, {"rhd", 8883}, {"setminus", 8726}, {"sqcap", 8851}, {"sqcup", 8852}, {"star", 8902}, {"times", 215}, {"triangleleft", 9667}, {"triangleright", 9655}, {"unlhd", 8884}, {"unrhd", 8885}, {"uplus", 8846}, {"vee", 8744}, {"wedge", 8743}, {"wr", 8768}, {"wreath", 8768}, {"boxdot", 8865}, {"boxminus", 8863}, {"boxplus", 8862}, {"boxtimes", 8864}, {"Cap", 8914}, {"centerdot", 8901}, {"circledast", 8859}, {"circledcirc", 8858}, {"circleddash", 8861}, {"Cup", 8915}, {"curlyvee", 8910}, {"curlywedge", 8911}, {"divideontimes", 8903}, {"dotequal", 8784}, {"dotplus", 8724}, {"doublebarwedge", 10846}, {"equiv", 8801}, {"frown", 8276}, {"intercal", 8890}, {"Join", 10781}, {"leftthreetimes", 8907}, {"ltimes", 8905}, {"mid", 8739}, {"models", 8871}, {"nparallel", 8742}, {"notparallel", 8742}, {"nvdash", 8876}, {"notvdash", 8876}, {"nvDash", 8877}, {"notvDash", 8877}, {"nVDash", 8879}, {"notVDash", 8879}, {"parallel", 8741}, {"perp", 8869}, {"prec", 8826}, {"preceq", 8828}, {"propto", 8733}, {"sqsubseteq", 8849}, {"sqsupseteq", 8850}, {"rightthreetimes", 8908}, {"rtimes", 8906}, {"sim", 8764}, {"simeq", 8771}, {"smallsetminus", 10741}, {"smile", 8255}, {"succ", 8827}, {"succeq", 8829}, {"therefore", 8756}, {"veebar", 10849}, {"plus", 43}, {"minus", 8722}, {"udtimes", 10710}, {"vdash", 8866}, {"Vdash", 8873}, {"vDash", 8872}, {"Vvdash", 8874}, {"vcentcolon", 8758}, {"squaredots", 8759}, {"dotminus", 8760}, {"eqcolon", 8761}, {"risingdotseq", 8787}, {"eqqcolon", 8789}, {"nearrow", 8599}, {"searrow", 8600}, {"nwarrow", 8598}, {"swarrow", 8601}, {"Leftrightarrow", 8660}, {"Leftarrow", 8656}, {"Rightarrow", 8658}, {"supset", 8835}, {"subset", 8834}, {"supseteq", 8839}, {"subseteq", 8838}, {"not", 8725}, {"leftrightarrow", 8596}, {"leftarrow", 8592}, {"gets", 8592}, {"rightarrow", 8594}, {"to", 8594}, {"mapsto", 8614}, {"leftharpoonup", 8636}, {"leftharpoondown", 8637}, {"rightharpoonup", 8640}, {"rightharpoondown", 8641}, {"rightleftharpoons", 8652}, {"doteq", 8784}, {"hookrightarrow", 8618}, {"hookleftarrow", 8617}, {"Longrightarrow", 10233}, {"longrightarrow", 10230}, {"longleftarrow", 10229}, {"Longleftarrow", 10232}, {"longmapsto", 10236}, {"longleftrightarrow", 10231}, {"Longleftrightarrow", 10234}, {"iff", 10234}};
    protected int codePoint;

    public Symbol(String string, int n) {
        super(string);
        this.codePoint = n;
    }

    @Override
    public Object clone() {
        return new Symbol(this.getName(), this.codePoint);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Symbol)) {
            return false;
        }
        return this.codePoint == ((Symbol)object).codePoint;
    }

    @Override
    public TeXObject toLowerCase(TeXParser teXParser) {
        if (!Character.isUpperCase(this.codePoint) && !Character.isTitleCase(this.codePoint)) {
            return this;
        }
        return teXParser.getListener().getOther(Character.toLowerCase(this.codePoint));
    }

    @Override
    public TeXObject toUpperCase(TeXParser teXParser) {
        if (!Character.isLowerCase(this.codePoint)) {
            return this;
        }
        return teXParser.getListener().getOther(Character.toUpperCase(this.codePoint));
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.codePoint));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    public void write(TeXParser teXParser) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXSettings teXSettings = teXParser.getSettings();
        int n = teXSettings.getCharCode(this.codePoint);
        teXParserListener.getWriteable().writeCodePoint(n == -1 ? this.codePoint : n);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.write(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    public int getCharCode() {
        return this.codePoint;
    }

    public void setCharCode(int n) {
        this.codePoint = n;
    }

    public static void addCommands(TeXParser teXParser, TeXParserListener teXParserListener) {
        int n;
        String string;
        int n2;
        for (n2 = 0; n2 < GENERIC_SYMBOLS.length; ++n2) {
            string = GENERIC_SYMBOLS[n2][0].toString();
            n = (Integer)GENERIC_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createSymbol(string, n));
        }
        for (n2 = 0; n2 < TEXT_SYMBOLS.length; ++n2) {
            string = TEXT_SYMBOLS[n2][0].toString();
            n = (Integer)TEXT_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createSymbol(string, n));
        }
        for (n2 = 0; n2 < GREEK_SYMBOLS.length; ++n2) {
            string = GREEK_SYMBOLS[n2][0].toString();
            n = (Integer)GREEK_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createGreekSymbol(string, n));
        }
        for (n2 = 0; n2 < MATH_SYMBOLS.length; ++n2) {
            string = MATH_SYMBOLS[n2][0].toString();
            n = (Integer)MATH_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createMathSymbol(string, n));
        }
        for (n2 = 0; n2 < BINARY_MATH_SYMBOLS.length; ++n2) {
            string = BINARY_MATH_SYMBOLS[n2][0].toString();
            n = (Integer)BINARY_MATH_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createBinarySymbol(string, n));
        }
        for (n2 = 0; n2 < DELIMITER_SYMBOLS.length; ++n2) {
            string = DELIMITER_SYMBOLS[n2][0].toString();
            n = (Integer)DELIMITER_SYMBOLS[n2][1];
            teXParser.putControlSequence(teXParserListener.createDelimiterSymbol(string, n));
        }
        for (n2 = 0; n2 < BIG_MATH_SYMBOLS.length; ++n2) {
            string = BIG_MATH_SYMBOLS[n2][0].toString();
            n = (Integer)BIG_MATH_SYMBOLS[n2][1];
            int n3 = (Integer)BIG_MATH_SYMBOLS[n2][2];
            teXParser.putControlSequence(teXParserListener.createBigOperator(string, n, n3));
        }
    }
}

