/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.core.files.Database;
import org.islandoftex.arara.core.localization.LanguageController;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/islandoftex/arara/core/files/FileHandling;", "", "()V", "calculateHash", "", "path", "Ljava/nio/file/Path;", "changeExtension", "extension", "", "hasChanged", "", "file", "databaseFile", "isSubDirectory", "child", "parent", "normalize", "core"})
public final class FileHandling {
    @NotNull
    public static final FileHandling INSTANCE = new FileHandling();

    private FileHandling() {
    }

    @JvmStatic
    @NotNull
    public static final Path normalize(@NotNull Path path2) throws AraraException {
        Intrinsics.checkNotNullParameter(path2, "path");
        Path path3 = path2.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue(path3, "path.toAbsolutePath().normalize()");
        return path3;
    }

    @JvmStatic
    @NotNull
    public static final Path changeExtension(@NotNull Path path2, @NotNull String extension) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(extension, "extension");
        String name = StringsKt.substringBeforeLast$default(((Object)path2.getFileName()).toString(), '.', null, 2, null) + '.' + extension;
        Path path3 = path2.resolveSibling(name);
        Intrinsics.checkNotNullExpressionValue(path3, "path.resolveSibling(name)");
        return FileHandling.normalize(path3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isSubDirectory(@NotNull Path child, @NotNull Path parent) throws AraraException {
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(parent, "parent");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(child, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(parent, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        boolean bl = FileHandling.normalize(child).startsWith(FileHandling.normalize(parent));
        return bl;
    }

    @JvmStatic
    public static final long calculateHash(@NotNull Path path2) throws AraraException {
        long l;
        Intrinsics.checkNotNullParameter(path2, "path");
        try {
            CRC32 $this$calculateHash_u24lambda_u2d0 = new CRC32();
            boolean bl = false;
            byte[] byArray = Files.readAllBytes(path2);
            Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(this)");
            $this$calculateHash_u24lambda_u2d0.update(byArray);
            l = $this$calculateHash_u24lambda_u2d0.getValue();
        }
        catch (IOException exception) {
            throw new AraraException(LanguageController.getMessages().getERROR_CALCULATEHASH_IO_EXCEPTION(), exception);
        }
        return l;
    }

    @JvmStatic
    public static final boolean hasChanged(@NotNull Path file2, @NotNull Path databaseFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(databaseFile, "databaseFile");
        org.islandoftex.arara.api.files.Database database = Database.Companion.load(databaseFile);
        Path path2 = FileHandling.normalize(file2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (database.contains(path2)) {
                database.remove(path2);
                database.save(databaseFile);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            long hash = FileHandling.calculateHash(file2);
            if (database.contains(path2)) {
                Long value = database.get(path2);
                Long l = value;
                if (l != null && hash == l) {
                    bl = false;
                } else {
                    database.set(path2, hash);
                    database.save(databaseFile);
                    bl = true;
                }
            } else {
                database.set(path2, hash);
                database.save(databaseFile);
                bl = true;
            }
        }
        return bl;
    }
}

