/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.Introspection;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.ContextTransaction;
import org.apache.tomcat.util.descriptor.web.InjectionTarget;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.descriptor.web.NamingResources;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.apache.tomcat.util.res.StringManager;

public class NamingResourcesImpl
extends LifecycleMBeanBase
implements Serializable,
NamingResources {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NamingResourcesImpl.class);
    private static final StringManager sm = StringManager.getManager(NamingResourcesImpl.class);
    private volatile boolean resourceRequireExplicitRegistration = false;
    private Object container = null;
    private final Set<String> entries = new HashSet<String>();
    private final Map<String, ContextEjb> ejbs = new HashMap<String, ContextEjb>();
    private final Map<String, ContextEnvironment> envs = new HashMap<String, ContextEnvironment>();
    private final Map<String, ContextLocalEjb> localEjbs = new HashMap<String, ContextLocalEjb>();
    private final Map<String, MessageDestinationRef> mdrs = new HashMap<String, MessageDestinationRef>();
    private final HashMap<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap();
    private final HashMap<String, ContextResource> resources = new HashMap();
    private final HashMap<String, ContextResourceLink> resourceLinks = new HashMap();
    private final HashMap<String, ContextService> services = new HashMap();
    private ContextTransaction transaction = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object object) {
        this.container = object;
    }

    public void setTransaction(ContextTransaction contextTransaction) {
        this.transaction = contextTransaction;
    }

    public ContextTransaction getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb contextEjb) {
        String string = contextEjb.getLink();
        String string2 = contextEjb.getLookupName();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            throw new IllegalArgumentException(sm.getString("namingResources.ejbLookupLink", new Object[]{contextEjb.getName()}));
        }
        if (this.entries.contains(contextEjb.getName())) {
            return;
        }
        this.entries.add(contextEjb.getName());
        Map<String, ContextEjb> map = this.ejbs;
        synchronized (map) {
            contextEjb.setNamingResources((NamingResources)this);
            this.ejbs.put(contextEjb.getName(), contextEjb);
        }
        this.support.firePropertyChange("ejb", null, contextEjb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment contextEnvironment) {
        Object object;
        String string;
        List list;
        if (this.entries.contains(contextEnvironment.getName())) {
            list = this.findEnvironment(contextEnvironment.getName());
            string = this.findResourceLink(contextEnvironment.getName());
            if (list != null) {
                if (!list.getOverride()) return;
                this.removeEnvironment(contextEnvironment.getName());
            } else {
                if (string == null) return;
                object = this.getServer().getGlobalNamingResources();
                if (((NamingResourcesImpl)object).findEnvironment(string.getGlobal()) != null) {
                    if (!((NamingResourcesImpl)object).findEnvironment(string.getGlobal()).getOverride()) return;
                    this.removeResourceLink(contextEnvironment.getName());
                }
            }
        }
        list = contextEnvironment.getInjectionTargets();
        string = contextEnvironment.getValue();
        object = contextEnvironment.getLookupName();
        if (list != null && list.size() > 0 && (string == null || string.length() == 0)) {
            return;
        }
        if (string != null && string.length() > 0 && object != null && ((String)object).length() > 0) {
            throw new IllegalArgumentException(sm.getString("namingResources.envEntryLookupValue", new Object[]{contextEnvironment.getName()}));
        }
        if (!this.checkResourceType((ResourceBase)contextEnvironment)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{contextEnvironment.getName(), contextEnvironment.getType()}));
        }
        this.entries.add(contextEnvironment.getName());
        Map<String, ContextEnvironment> map = this.envs;
        synchronized (map) {
            contextEnvironment.setNamingResources((NamingResources)this);
            this.envs.put(contextEnvironment.getName(), contextEnvironment);
        }
        this.support.firePropertyChange("environment", null, contextEnvironment);
        if (!this.resourceRequireExplicitRegistration) return;
        try {
            MBeanUtils.createMBean(contextEnvironment);
            return;
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
        }
    }

    private Server getServer() {
        if (this.container instanceof Server) {
            return (Server)this.container;
        }
        if (this.container instanceof Context) {
            Engine engine = (Engine)((Context)this.container).getParent().getParent();
            return engine.getService().getServer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb contextLocalEjb) {
        if (this.entries.contains(contextLocalEjb.getName())) {
            return;
        }
        this.entries.add(contextLocalEjb.getName());
        Map<String, ContextLocalEjb> map = this.localEjbs;
        synchronized (map) {
            contextLocalEjb.setNamingResources((NamingResources)this);
            this.localEjbs.put(contextLocalEjb.getName(), contextLocalEjb);
        }
        this.support.firePropertyChange("localEjb", null, contextLocalEjb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        if (this.entries.contains(messageDestinationRef.getName())) {
            return;
        }
        if (!this.checkResourceType((ResourceBase)messageDestinationRef)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{messageDestinationRef.getName(), messageDestinationRef.getType()}));
        }
        this.entries.add(messageDestinationRef.getName());
        Map<String, MessageDestinationRef> map = this.mdrs;
        synchronized (map) {
            messageDestinationRef.setNamingResources((NamingResources)this);
            this.mdrs.put(messageDestinationRef.getName(), messageDestinationRef);
        }
        this.support.firePropertyChange("messageDestinationRef", null, messageDestinationRef);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource contextResource) {
        if (this.entries.contains(contextResource.getName())) {
            return;
        }
        if (!this.checkResourceType((ResourceBase)contextResource)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{contextResource.getName(), contextResource.getType()}));
        }
        this.entries.add(contextResource.getName());
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            contextResource.setNamingResources((NamingResources)this);
            this.resources.put(contextResource.getName(), contextResource);
        }
        this.support.firePropertyChange("resource", null, contextResource);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(contextResource);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResource.getName()}), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(ContextResourceEnvRef contextResourceEnvRef) {
        if (this.entries.contains(contextResourceEnvRef.getName())) {
            return;
        }
        if (!this.checkResourceType((ResourceBase)contextResourceEnvRef)) {
            throw new IllegalArgumentException(sm.getString("namingResources.resourceTypeFail", new Object[]{contextResourceEnvRef.getName(), contextResourceEnvRef.getType()}));
        }
        this.entries.add(contextResourceEnvRef.getName());
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            contextResourceEnvRef.setNamingResources((NamingResources)this);
            this.resourceEnvRefs.put(contextResourceEnvRef.getName(), contextResourceEnvRef);
        }
        this.support.firePropertyChange("resourceEnvRef", null, contextResourceEnvRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceLink(ContextResourceLink contextResourceLink) {
        if (this.entries.contains(contextResourceLink.getName())) {
            return;
        }
        this.entries.add(contextResourceLink.getName());
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            contextResourceLink.setNamingResources((NamingResources)this);
            this.resourceLinks.put(contextResourceLink.getName(), contextResourceLink);
        }
        this.support.firePropertyChange("resourceLink", null, contextResourceLink);
        if (this.resourceRequireExplicitRegistration) {
            try {
                MBeanUtils.createMBean(contextResourceLink);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ContextService contextService) {
        if (this.entries.contains(contextService.getName())) {
            return;
        }
        this.entries.add(contextService.getName());
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            contextService.setNamingResources((NamingResources)this);
            this.services.put(contextService.getName(), contextService);
        }
        this.support.firePropertyChange("service", null, contextService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String string) {
        Map<String, ContextEjb> map = this.ejbs;
        synchronized (map) {
            return this.ejbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        Map<String, ContextEjb> map = this.ejbs;
        synchronized (map) {
            ContextEjb[] contextEjbArray = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(contextEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String string) {
        Map<String, ContextEnvironment> map = this.envs;
        synchronized (map) {
            return this.envs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        Map<String, ContextEnvironment> map = this.envs;
        synchronized (map) {
            ContextEnvironment[] contextEnvironmentArray = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(contextEnvironmentArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String string) {
        Map<String, ContextLocalEjb> map = this.localEjbs;
        synchronized (map) {
            return this.localEjbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        Map<String, ContextLocalEjb> map = this.localEjbs;
        synchronized (map) {
            ContextLocalEjb[] contextLocalEjbArray = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(contextLocalEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef findMessageDestinationRef(String string) {
        Map<String, MessageDestinationRef> map = this.mdrs;
        synchronized (map) {
            return this.mdrs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef[] findMessageDestinationRefs() {
        Map<String, MessageDestinationRef> map = this.mdrs;
        synchronized (map) {
            MessageDestinationRef[] messageDestinationRefArray = new MessageDestinationRef[this.mdrs.size()];
            return this.mdrs.values().toArray(messageDestinationRefArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String string) {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            return this.resources.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink findResourceLink(String string) {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            return this.resourceLinks.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink[] findResourceLinks() {
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            ContextResourceLink[] contextResourceLinkArray = new ContextResourceLink[this.resourceLinks.size()];
            return this.resourceLinks.values().toArray(contextResourceLinkArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] contextResourceArray = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(contextResourceArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef findResourceEnvRef(String string) {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return this.resourceEnvRefs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef[] findResourceEnvRefs() {
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            ContextResourceEnvRef[] contextResourceEnvRefArray = new ContextResourceEnvRef[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.values().toArray(contextResourceEnvRefArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService findService(String string) {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            return this.services.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService[] findServices() {
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            ContextService[] contextServiceArray = new ContextService[this.services.size()];
            return this.services.values().toArray(contextServiceArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String string) {
        this.entries.remove(string);
        ContextEjb contextEjb = null;
        Map<String, ContextEjb> map = this.ejbs;
        synchronized (map) {
            contextEjb = this.ejbs.remove(string);
        }
        if (contextEjb != null) {
            this.support.firePropertyChange("ejb", contextEjb, null);
            contextEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String string) {
        this.entries.remove(string);
        ContextEnvironment contextEnvironment = null;
        Map<String, ContextEnvironment> map = this.envs;
        synchronized (map) {
            contextEnvironment = this.envs.remove(string);
        }
        if (contextEnvironment != null) {
            this.support.firePropertyChange("environment", contextEnvironment, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(contextEnvironment);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
                }
            }
            contextEnvironment.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String string) {
        this.entries.remove(string);
        ContextLocalEjb contextLocalEjb = null;
        Map<String, ContextLocalEjb> map = this.localEjbs;
        synchronized (map) {
            contextLocalEjb = this.localEjbs.remove(string);
        }
        if (contextLocalEjb != null) {
            this.support.firePropertyChange("localEjb", contextLocalEjb, null);
            contextLocalEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestinationRef(String string) {
        this.entries.remove(string);
        MessageDestinationRef messageDestinationRef = null;
        Map<String, MessageDestinationRef> map = this.mdrs;
        synchronized (map) {
            messageDestinationRef = this.mdrs.remove(string);
        }
        if (messageDestinationRef != null) {
            this.support.firePropertyChange("messageDestinationRef", messageDestinationRef, null);
            messageDestinationRef.setNamingResources(null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String string) {
        this.entries.remove(string);
        ContextResource contextResource = null;
        HashMap<String, ContextResource> hashMap = this.resources;
        synchronized (hashMap) {
            contextResource = this.resources.remove(string);
        }
        if (contextResource != null) {
            this.support.firePropertyChange("resource", contextResource, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(contextResource);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResource.getName()}), (Throwable)exception);
                }
            }
            contextResource.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String string) {
        this.entries.remove(string);
        ContextResourceEnvRef contextResourceEnvRef = null;
        HashMap<String, ContextResourceEnvRef> hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            contextResourceEnvRef = this.resourceEnvRefs.remove(string);
        }
        if (contextResourceEnvRef != null) {
            this.support.firePropertyChange("resourceEnvRef", contextResourceEnvRef, null);
            contextResourceEnvRef.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceLink(String string) {
        this.entries.remove(string);
        ContextResourceLink contextResourceLink = null;
        HashMap<String, ContextResourceLink> hashMap = this.resourceLinks;
        synchronized (hashMap) {
            contextResourceLink = this.resourceLinks.remove(string);
        }
        if (contextResourceLink != null) {
            this.support.firePropertyChange("resourceLink", contextResourceLink, null);
            if (this.resourceRequireExplicitRegistration) {
                try {
                    MBeanUtils.destroyMBean(contextResourceLink);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
                }
            }
            contextResourceLink.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(String string) {
        this.entries.remove(string);
        ContextService contextService = null;
        HashMap<String, ContextService> hashMap = this.services;
        synchronized (hashMap) {
            contextService = this.services.remove(string);
        }
        if (contextService != null) {
            this.support.firePropertyChange("service", contextService, null);
            contextService.setNamingResources(null);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.resourceRequireExplicitRegistration = true;
        for (ContextResource contextResource : this.resources.values()) {
            try {
                MBeanUtils.createMBean(contextResource);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResource.getName()}), (Throwable)exception);
            }
        }
        for (ContextEnvironment contextEnvironment : this.envs.values()) {
            try {
                MBeanUtils.createMBean(contextEnvironment);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
            }
        }
        for (ContextResourceLink contextResourceLink : this.resourceLinks.values()) {
            try {
                MBeanUtils.createMBean(contextResourceLink);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanCreateFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.cleanUp();
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
    }

    private void cleanUp() {
        javax.naming.Context context;
        if (this.resources.size() == 0) {
            return;
        }
        try {
            if (this.container instanceof Server) {
                context = ((Server)this.container).getGlobalNamingContext();
            } else {
                context = ContextBindings.getClassLoader();
                context = (javax.naming.Context)context.lookup("comp/env");
            }
        }
        catch (NamingException namingException) {
            log.warn((Object)sm.getString("namingResources.cleanupNoContext", new Object[]{this.container}), (Throwable)namingException);
            return;
        }
        for (ContextResource contextResource : this.resources.values()) {
            Object object;
            String string;
            if (!contextResource.getSingleton() || (string = contextResource.getCloseMethod()) == null || string.length() <= 0) continue;
            String string2 = contextResource.getName();
            try {
                object = context.lookup(string2);
            }
            catch (NamingException namingException) {
                log.warn((Object)sm.getString("namingResources.cleanupNoResource", new Object[]{contextResource.getName(), this.container}), (Throwable)namingException);
                continue;
            }
            this.cleanUp(object, string2, string);
        }
    }

    private void cleanUp(Object object, String string, String string2) {
        Method method = null;
        try {
            method = object.getClass().getMethod(string2, null);
        }
        catch (SecurityException securityException) {
            log.debug((Object)sm.getString("namingResources.cleanupCloseSecurity", new Object[]{string2, string, this.container}));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug((Object)sm.getString("namingResources.cleanupNoClose", new Object[]{string, this.container, string2}));
            return;
        }
        try {
            method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            log.warn((Object)sm.getString("namingResources.cleanupCloseFailed", new Object[]{string2, string, this.container}), (Throwable)exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)invocationTargetException);
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("namingResources.cleanupCloseFailed", new Object[]{string2, string, this.container}), throwable);
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.resourceRequireExplicitRegistration = false;
        for (ContextResourceLink contextResourceLink : this.resourceLinks.values()) {
            try {
                MBeanUtils.destroyMBean(contextResourceLink);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResourceLink.getName()}), (Throwable)exception);
            }
        }
        for (ContextEnvironment contextEnvironment : this.envs.values()) {
            try {
                MBeanUtils.destroyMBean(contextEnvironment);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextEnvironment.getName()}), (Throwable)exception);
            }
        }
        for (ContextResource contextResource : this.resources.values()) {
            try {
                MBeanUtils.destroyMBean(contextResource);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("namingResources.mbeanDestroyFail", new Object[]{contextResource.getName()}), (Throwable)exception);
            }
        }
        super.destroyInternal();
    }

    @Override
    protected String getDomainInternal() {
        Object object = this.getContainer();
        if (object instanceof JmxEnabled) {
            return ((JmxEnabled)object).getDomain();
        }
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        Object object = this.getContainer();
        if (object instanceof Container) {
            return "type=NamingResources" + ((Container)object).getMBeanKeyProperties();
        }
        return "type=NamingResources";
    }

    private boolean checkResourceType(ResourceBase resourceBase) {
        if (!(this.container instanceof Context)) {
            return true;
        }
        if (resourceBase.getInjectionTargets() == null || resourceBase.getInjectionTargets().size() == 0) {
            return true;
        }
        Context context = (Context)this.container;
        String string = resourceBase.getType();
        Class<?> clazz = null;
        if (string != null && (clazz = Introspection.loadClass(context, string)) == null) {
            return true;
        }
        Class<?> clazz2 = this.getCompatibleType(context, resourceBase, clazz);
        if (clazz2 == null) {
            return false;
        }
        resourceBase.setType(clazz2.getCanonicalName());
        return true;
    }

    private Class<?> getCompatibleType(Context context, ResourceBase resourceBase, Class<?> clazz) {
        Class<?> clazz2 = null;
        for (InjectionTarget injectionTarget : resourceBase.getInjectionTargets()) {
            Class<?> clazz3 = Introspection.loadClass(context, injectionTarget.getTargetClass());
            if (clazz3 == null) continue;
            String string = injectionTarget.getTargetName();
            Class<?> clazz4 = this.getSetterType(clazz3, string);
            if (clazz4 == null) {
                clazz4 = this.getFieldType(clazz3, string);
            }
            if (clazz4 == null) continue;
            clazz4 = Introspection.convertPrimitiveType(clazz4);
            if (clazz == null) {
                if (clazz2 == null) {
                    clazz2 = clazz4;
                    continue;
                }
                if (clazz4.isAssignableFrom(clazz2)) continue;
                if (clazz2.isAssignableFrom(clazz4)) {
                    clazz2 = clazz4;
                    continue;
                }
                return null;
            }
            if (clazz4.isAssignableFrom(clazz)) {
                clazz2 = clazz;
                continue;
            }
            return null;
        }
        return clazz2;
    }

    private Class<?> getSetterType(Class<?> clazz, String string) {
        Method[] methodArray = Introspection.getDeclaredMethods(clazz);
        if (methodArray != null && methodArray.length > 0) {
            for (Method method : methodArray) {
                if (!Introspection.isValidSetter(method) || !Introspection.getPropertyName(method).equals(string)) continue;
                return method.getParameterTypes()[0];
            }
        }
        return null;
    }

    private Class<?> getFieldType(Class<?> clazz, String string) {
        Field[] fieldArray = Introspection.getDeclaredFields(clazz);
        if (fieldArray != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                if (!field.getName().equals(string)) continue;
                return field.getType();
            }
        }
        return null;
    }
}

