/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractGroup;

public class GenericGroup<UD extends UserDatabase>
extends AbstractGroup {
    protected final UD database;
    protected final CopyOnWriteArrayList<Role> roles = new CopyOnWriteArrayList();

    GenericGroup(UD UD, String string, String string2, List<Role> list) {
        this.database = UD;
        this.groupname = string;
        this.description = string2;
        if (list != null) {
            this.roles.addAll(list);
        }
    }

    @Override
    public Iterator<Role> getRoles() {
        return this.roles.iterator();
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public Iterator<User> getUsers() {
        ArrayList<User> arrayList = new ArrayList<User>();
        Iterator<User> iterator = this.database.getUsers();
        while (iterator.hasNext()) {
            User user = iterator.next();
            if (!user.isInGroup(this)) continue;
            arrayList.add(user);
        }
        return arrayList.iterator();
    }

    @Override
    public void addRole(Role role) {
        if (this.roles.addIfAbsent(role)) {
            this.database.modifiedGroup(this);
        }
    }

    @Override
    public boolean isInRole(Role role) {
        return this.roles.contains(role);
    }

    @Override
    public void removeRole(Role role) {
        if (this.roles.remove(role)) {
            this.database.modifiedGroup(this);
        }
    }

    @Override
    public void removeRoles() {
        if (!this.roles.isEmpty()) {
            this.roles.clear();
            this.database.modifiedGroup(this);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GenericGroup) {
            GenericGroup genericGroup = (GenericGroup)object;
            return genericGroup.database == this.database && this.groupname.equals(genericGroup.getGroupname());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.database == null ? 0 : this.database.hashCode());
        n = 31 * n + (this.groupname == null ? 0 : this.groupname.hashCode());
        return n;
    }
}

