/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import javax.management.ObjectName;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.jmx.JmxRegistry;

public abstract class ChannelInterceptorBase
implements ChannelInterceptor {
    private ChannelInterceptor next;
    private ChannelInterceptor previous;
    private Channel channel;
    protected int optionFlag = 0;
    private ObjectName oname = null;

    public boolean okToProcess(int n) {
        if (this.optionFlag == 0) {
            return true;
        }
        return (this.optionFlag & n) == this.optionFlag;
    }

    @Override
    public final void setNext(ChannelInterceptor channelInterceptor) {
        this.next = channelInterceptor;
    }

    @Override
    public final ChannelInterceptor getNext() {
        return this.next;
    }

    @Override
    public final void setPrevious(ChannelInterceptor channelInterceptor) {
        this.previous = channelInterceptor;
    }

    @Override
    public void setOptionFlag(int n) {
        this.optionFlag = n;
    }

    @Override
    public final ChannelInterceptor getPrevious() {
        return this.previous;
    }

    @Override
    public int getOptionFlag() {
        return this.optionFlag;
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        if (this.getNext() != null) {
            this.getNext().sendMessage(memberArray, channelMessage, interceptorPayload);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (this.getPrevious() != null) {
            this.getPrevious().messageReceived(channelMessage);
        }
    }

    @Override
    public void memberAdded(Member member) {
        if (this.getPrevious() != null) {
            this.getPrevious().memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        if (this.getPrevious() != null) {
            this.getPrevious().memberDisappeared(member);
        }
    }

    @Override
    public void heartbeat() {
        if (this.getNext() != null) {
            this.getNext().heartbeat();
        }
    }

    @Override
    public boolean hasMembers() {
        if (this.getNext() != null) {
            return this.getNext().hasMembers();
        }
        return false;
    }

    @Override
    public Member[] getMembers() {
        if (this.getNext() != null) {
            return this.getNext().getMembers();
        }
        return null;
    }

    @Override
    public Member getMember(Member member) {
        if (this.getNext() != null) {
            return this.getNext().getMember(member);
        }
        return null;
    }

    @Override
    public Member getLocalMember(boolean bl) {
        if (this.getNext() != null) {
            return this.getNext().getLocalMember(bl);
        }
        return null;
    }

    @Override
    public void start(int n) throws ChannelException {
        JmxRegistry jmxRegistry;
        if (this.getNext() != null) {
            this.getNext().start(n);
        }
        if ((jmxRegistry = JmxRegistry.getRegistry(this.channel)) != null) {
            this.oname = jmxRegistry.registerJmx(",component=Interceptor,interceptorName=" + this.getClass().getSimpleName(), this);
        }
    }

    @Override
    public void stop(int n) throws ChannelException {
        if (this.getNext() != null) {
            this.getNext().stop(n);
        }
        if (this.oname != null) {
            JmxRegistry.getRegistry(this.channel).unregisterJmx(this.oname);
            this.oname = null;
        }
        this.channel = null;
    }

    @Override
    public void fireInterceptorEvent(ChannelInterceptor.InterceptorEvent interceptorEvent) {
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

