/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.FragmentationInterceptorMBean;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FragmentationInterceptor
extends ChannelInterceptorBase
implements FragmentationInterceptorMBean {
    private static final Log log = LogFactory.getLog(FragmentationInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(FragmentationInterceptor.class);
    protected final HashMap<FragKey, FragCollection> fragpieces = new HashMap();
    private int maxSize = 102400;
    private long expire = 60000L;
    protected final boolean deepclone = true;

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        boolean bl;
        int n = channelMessage.getMessage().getLength();
        boolean bl2 = bl = n > this.maxSize && this.okToProcess(channelMessage.getOptions());
        if (bl) {
            this.frag(memberArray, channelMessage, interceptorPayload);
        } else {
            channelMessage.getMessage().append(bl);
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        boolean bl = XByteBuffer.toBoolean(channelMessage.getMessage().getBytesDirect(), channelMessage.getMessage().getLength() - 1);
        channelMessage.getMessage().trim(1);
        if (bl) {
            this.defrag(channelMessage);
        } else {
            super.messageReceived(channelMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FragCollection getFragCollection(FragKey fragKey, ChannelMessage channelMessage) {
        FragCollection fragCollection = this.fragpieces.get(fragKey);
        if (fragCollection == null) {
            HashMap<FragKey, FragCollection> hashMap = this.fragpieces;
            synchronized (hashMap) {
                fragCollection = this.fragpieces.get(fragKey);
                if (fragCollection == null) {
                    fragCollection = new FragCollection(channelMessage);
                    this.fragpieces.put(fragKey, fragCollection);
                }
            }
        }
        return fragCollection;
    }

    public void removeFragCollection(FragKey fragKey) {
        this.fragpieces.remove(fragKey);
    }

    public void defrag(ChannelMessage channelMessage) {
        FragKey fragKey = new FragKey(channelMessage.getUniqueId());
        FragCollection fragCollection = this.getFragCollection(fragKey, channelMessage);
        fragCollection.addMessage((ChannelMessage)channelMessage.deepclone());
        if (fragCollection.complete()) {
            this.removeFragCollection(fragKey);
            ChannelMessage channelMessage2 = fragCollection.assemble();
            super.messageReceived(channelMessage2);
        }
    }

    public void frag(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        int n = channelMessage.getMessage().getLength();
        int n2 = n / this.maxSize + (n % this.maxSize == 0 ? 0 : 1);
        ChannelMessage[] channelMessageArray = new ChannelMessage[n2];
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            ChannelMessage channelMessage2 = (ChannelMessage)channelMessage.clone();
            int n4 = i * this.maxSize;
            int n5 = Math.min(n3, this.maxSize);
            channelMessage2.getMessage().clear();
            channelMessage2.getMessage().append(channelMessage.getMessage().getBytesDirect(), n4, n5);
            channelMessage2.getMessage().append(i);
            channelMessage2.getMessage().append(n2);
            channelMessage2.getMessage().append(true);
            channelMessageArray[i] = channelMessage2;
            n3 -= n5;
        }
        for (ChannelMessage channelMessage3 : channelMessageArray) {
            super.sendMessage(memberArray, channelMessage3, interceptorPayload);
        }
    }

    @Override
    public void heartbeat() {
        block3: {
            try {
                Object[] objectArray;
                Set<FragKey> set = this.fragpieces.keySet();
                for (Object object : objectArray = set.toArray()) {
                    FragKey fragKey = (FragKey)object;
                    if (fragKey == null || !fragKey.expired(this.getExpire())) continue;
                    this.removeFragCollection(fragKey);
                }
            }
            catch (Exception exception) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)sm.getString("fragmentationInterceptor.heartbeat.failed"), (Throwable)exception);
            }
        }
        super.heartbeat();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getExpire() {
        return this.expire;
    }

    @Override
    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    @Override
    public void setExpire(long l) {
        this.expire = l;
    }

    public static class FragKey {
        private final byte[] uniqueId;
        private final long received = System.currentTimeMillis();

        public FragKey(byte[] byArray) {
            this.uniqueId = byArray;
        }

        public int hashCode() {
            return XByteBuffer.toInt(this.uniqueId, 0);
        }

        public boolean equals(Object object) {
            if (object instanceof FragKey) {
                return Arrays.equals(this.uniqueId, ((FragKey)object).uniqueId);
            }
            return false;
        }

        public boolean expired(long l) {
            return System.currentTimeMillis() - this.received > l;
        }
    }

    public static class FragCollection {
        private final long received = System.currentTimeMillis();
        private final ChannelMessage msg;
        private final XByteBuffer[] frags;

        public FragCollection(ChannelMessage channelMessage) {
            int n = XByteBuffer.toInt(channelMessage.getMessage().getBytesDirect(), channelMessage.getMessage().getLength() - 4);
            this.frags = new XByteBuffer[n];
            this.msg = channelMessage;
        }

        public void addMessage(ChannelMessage channelMessage) {
            channelMessage.getMessage().trim(4);
            int n = XByteBuffer.toInt(channelMessage.getMessage().getBytesDirect(), channelMessage.getMessage().getLength() - 4);
            channelMessage.getMessage().trim(4);
            this.frags[n] = channelMessage.getMessage();
        }

        public boolean complete() {
            boolean bl = true;
            for (int i = 0; i < this.frags.length && bl; ++i) {
                bl = this.frags[i] != null;
            }
            return bl;
        }

        public ChannelMessage assemble() {
            if (!this.complete()) {
                throw new IllegalStateException(sm.getString("fragmentationInterceptor.fragments.missing"));
            }
            int n = 0;
            for (XByteBuffer xByteBuffer : this.frags) {
                n += xByteBuffer.getLength();
            }
            XByteBuffer xByteBuffer = new XByteBuffer(n, false);
            this.msg.setMessage(xByteBuffer);
            for (XByteBuffer xByteBuffer2 : this.frags) {
                this.msg.getMessage().append(xByteBuffer2.getBytesDirect(), 0, xByteBuffer2.getLength());
            }
            return this.msg;
        }

        public boolean expired(long l) {
            return System.currentTimeMillis() - this.received > l;
        }
    }
}

