/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.apache.catalina.TomcatPrincipal;
import org.ietf.jgss.GSSCredential;

public class GenericPrincipal
implements TomcatPrincipal,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final String password;
    protected final String[] roles;
    protected final Principal userPrincipal;
    protected final transient LoginContext loginContext;
    protected transient GSSCredential gssCredential = null;

    public GenericPrincipal(String string, String string2, List<String> list) {
        this(string, string2, list, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list, Principal principal) {
        this(string, string2, list, principal, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list, Principal principal, LoginContext loginContext) {
        this(string, string2, list, principal, loginContext, null);
    }

    public GenericPrincipal(String string, String string2, List<String> list, Principal principal, LoginContext loginContext, GSSCredential gSSCredential) {
        this.name = string;
        this.password = string2;
        this.userPrincipal = principal;
        if (list == null) {
            this.roles = new String[0];
        } else {
            this.roles = list.toArray(new String[0]);
            if (this.roles.length > 1) {
                Arrays.sort(this.roles);
            }
        }
        this.loginContext = loginContext;
        this.gssCredential = gSSCredential;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getRoles() {
        return this.roles;
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return this;
    }

    @Override
    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    protected void setGssCredential(GSSCredential gSSCredential) {
        this.gssCredential = gSSCredential;
    }

    public boolean hasRole(String string) {
        if ("*".equals(string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, string) >= 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GenericPrincipal[");
        stringBuilder.append(this.name);
        stringBuilder.append('(');
        for (String string : this.roles) {
            stringBuilder.append(string).append(',');
        }
        stringBuilder.append(")]");
        return stringBuilder.toString();
    }

    @Override
    public void logout() throws Exception {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
        if (this.gssCredential != null) {
            this.gssCredential.dispose();
        }
    }

    private Object writeReplace() {
        return new SerializablePrincipal(this.name, this.password, this.roles, this.userPrincipal);
    }

    private static class SerializablePrincipal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String password;
        private final String[] roles;
        private final Principal principal;

        public SerializablePrincipal(String string, String string2, String[] stringArray, Principal principal) {
            this.name = string;
            this.password = string2;
            this.roles = stringArray;
            this.principal = principal instanceof Serializable ? principal : null;
        }

        private Object readResolve() {
            return new GenericPrincipal(this.name, this.password, Arrays.asList(this.roles), this.principal);
        }
    }
}

