/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.storeconfig.IStoreFactory;
import org.apache.catalina.storeconfig.StoreAppender;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreRegistry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StoreFactoryBase
implements IStoreFactory {
    private static Log log = LogFactory.getLog(StoreFactoryBase.class);
    private StoreRegistry registry;
    private StoreAppender storeAppender = new StoreAppender();
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.storeconfig");
    private static final String info = "org.apache.catalina.config.StoreFactoryBase/1.0";

    public String getInfo() {
        return info;
    }

    @Override
    public StoreAppender getStoreAppender() {
        return this.storeAppender;
    }

    @Override
    public void setStoreAppender(StoreAppender storeAppender) {
        this.storeAppender = storeAppender;
    }

    @Override
    public void setRegistry(StoreRegistry storeRegistry) {
        this.registry = storeRegistry;
    }

    @Override
    public StoreRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void storeXMLHead(PrintWriter printWriter) {
        printWriter.print("<?xml version=\"1.0\" encoding=\"");
        printWriter.print(this.getRegistry().getEncoding());
        printWriter.println("\"?>");
    }

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
        if (storeDescription != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("factory.storeTag", new Object[]{storeDescription.getTag(), object}));
            }
            this.getStoreAppender().printIndent(printWriter, n + 2);
            if (!storeDescription.isChildren()) {
                this.getStoreAppender().printTag(printWriter, n, object, storeDescription);
            } else {
                this.getStoreAppender().printOpenTag(printWriter, n + 2, object, storeDescription);
                this.storeChildren(printWriter, n + 2, object, storeDescription);
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printCloseTag(printWriter, storeDescription);
            }
        } else {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
        }
    }

    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
    }

    protected void storeElement(PrintWriter printWriter, int n, Object object) throws Exception {
        if (object != null) {
            IStoreFactory iStoreFactory = this.getRegistry().findStoreFactory(object.getClass());
            if (iStoreFactory != null) {
                StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
                if (!storeDescription.isTransientChild(object.getClass().getName())) {
                    iStoreFactory.store(printWriter, n, object);
                }
            } else {
                log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
            }
        }
    }

    protected void storeElementArray(PrintWriter printWriter, int n, Object[] objectArray) throws Exception {
        if (objectArray != null) {
            for (Object object : objectArray) {
                try {
                    this.storeElement(printWriter, n, object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

