/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);
static GType vala_initializer_list_get_type_once (void);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns the initializer expression list
 *
 * @return expression list
 */
ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	result = _tmp0_;
	return result;
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		gint _expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_expr_list = _tmp0_;
		_tmp1_ = _expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_expr_size = _tmp3_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			_tmp4_ = _expr_index;
			_tmp5_ = _expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaExpression*) _tmp7_;
			_tmp8_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp4_ = _initializer_index;
			_tmp5_ = _initializer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			_tmp8_ = initializer;
			if (!vala_expression_is_constant (_tmp8_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp4_ = _initializer_index;
			_tmp5_ = _initializer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			_tmp8_ = initializer;
			if (!vala_expression_is_pure (_tmp8_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp4_ = _initializer_index;
			_tmp5_ = _initializer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			_tmp8_ = initializer;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp5_ = _initializer_index;
			_tmp6_ = _initializer_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _initializer_list;
			_tmp8_ = vala_list_get (_tmp7_, _initializer_index);
			initializer = (ValaExpression*) _tmp8_;
			if (first) {
				GString* _tmp9_;
				ValaExpression* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = builder;
				_tmp10_ = initializer;
				_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
				_tmp12_ = _tmp11_;
				g_string_append (_tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
				first = FALSE;
			} else {
				GString* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = builder;
				_tmp14_ = initializer;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_string_append_printf (_tmp13_, ", %s", _tmp16_);
				_g_free0 (_tmp16_);
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	_tmp17_ = builder;
	g_string_append_c (_tmp17_, '}');
	_tmp18_ = builder;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp221_;
	gboolean _tmp222_;
	gboolean _tmp276_;
	gboolean _tmp277_;
	ValaDataType* _tmp284_;
	ValaDataType* _tmp285_;
	gboolean _tmp288_;
	gboolean _tmp289_;
	gboolean result;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			_tmp12_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
				ValaArrayType* array_type = NULL;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				gboolean requires_constants_only = FALSE;
				ValaCodeNode* node = NULL;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				ValaCodeNode* _tmp25_;
				ValaCodeNode* _tmp26_;
				ValaDataType* inner_target_type = NULL;
				ValaArrayType* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				_tmp14_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp15_ = _tmp14_;
				array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				requires_constants_only = FALSE;
				_tmp16_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				node = _tmp17_;
				while (TRUE) {
					ValaCodeNode* _tmp18_;
					ValaCodeNode* _tmp19_;
					ValaCodeNode* _tmp20_;
					ValaCodeNode* _tmp21_;
					ValaCodeNode* _tmp22_;
					_tmp18_ = node;
					if (!(_tmp18_ != NULL)) {
						break;
					}
					_tmp19_ = node;
					if (VALA_IS_CONSTANT (_tmp19_)) {
						requires_constants_only = TRUE;
						break;
					}
					_tmp20_ = node;
					_tmp21_ = vala_code_node_get_parent_node (_tmp20_);
					_tmp22_ = _tmp21_;
					node = _tmp22_;
				}
				_tmp25_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp26_)) {
					_tmp24_ = !requires_constants_only;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					gboolean _tmp27_ = FALSE;
					ValaCodeNode* _tmp28_;
					ValaCodeNode* _tmp29_;
					_tmp28_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp29_ = _tmp28_;
					if (!VALA_IS_INITIALIZER_LIST (_tmp29_)) {
						_tmp27_ = TRUE;
					} else {
						ValaCodeNode* _tmp30_;
						ValaCodeNode* _tmp31_;
						ValaDataType* _tmp32_;
						ValaDataType* _tmp33_;
						ValaTypeSymbol* _tmp34_;
						ValaTypeSymbol* _tmp35_;
						_tmp30_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp31_ = _tmp30_;
						_tmp32_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
						_tmp33_ = _tmp32_;
						_tmp34_ = vala_data_type_get_type_symbol (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp27_ = VALA_IS_STRUCT (_tmp35_);
					}
					_tmp23_ = _tmp27_;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					ValaCodeNode* old_parent_node = NULL;
					ValaCodeNode* _tmp36_;
					ValaCodeNode* _tmp37_;
					ValaCodeNode* _tmp38_;
					ValaArrayCreationExpression* array_creation = NULL;
					ValaArrayType* _tmp39_;
					ValaDataType* _tmp40_;
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					ValaDataType* _tmp43_;
					ValaArrayType* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					ValaSourceReference* _tmp47_;
					ValaSourceReference* _tmp48_;
					ValaArrayCreationExpression* _tmp49_;
					ValaArrayCreationExpression* _tmp50_;
					ValaArrayCreationExpression* _tmp51_;
					ValaArrayType* _tmp52_;
					ValaDataType* _tmp53_;
					ValaDataType* _tmp54_;
					ValaDataType* _tmp55_;
					ValaDataType* _tmp56_;
					ValaArrayCreationExpression* _tmp57_;
					ValaDataType* _tmp58_;
					ValaDataType* _tmp59_;
					ValaArrayCreationExpression* _tmp60_;
					ValaDataType* _tmp61_;
					ValaDataType* _tmp62_;
					ValaCodeNode* _tmp63_;
					ValaArrayCreationExpression* _tmp64_;
					ValaArrayCreationExpression* _tmp65_;
					_tmp36_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					_tmp38_ = _vala_code_node_ref0 (_tmp37_);
					old_parent_node = _tmp38_;
					_tmp39_ = array_type;
					_tmp40_ = vala_array_type_get_element_type (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = vala_data_type_copy (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = array_type;
					_tmp45_ = vala_array_type_get_rank (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp48_ = _tmp47_;
					_tmp49_ = vala_array_creation_expression_new (_tmp43_, _tmp46_, self, _tmp48_);
					_tmp50_ = _tmp49_;
					_vala_code_node_unref0 (_tmp43_);
					array_creation = _tmp50_;
					_tmp51_ = array_creation;
					_tmp52_ = array_type;
					_tmp53_ = vala_array_type_get_length_type (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = vala_data_type_copy (_tmp54_);
					_tmp56_ = _tmp55_;
					vala_array_creation_expression_set_length_type (_tmp51_, _tmp56_);
					_vala_code_node_unref0 (_tmp56_);
					_tmp57_ = array_creation;
					_tmp58_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp59_ = _tmp58_;
					vala_expression_set_target_type ((ValaExpression*) _tmp57_, _tmp59_);
					_tmp60_ = array_creation;
					_tmp61_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
					_tmp62_ = _tmp61_;
					vala_expression_set_formal_target_type ((ValaExpression*) _tmp60_, _tmp62_);
					_tmp63_ = old_parent_node;
					_tmp64_ = array_creation;
					vala_code_node_replace_expression (_tmp63_, (ValaExpression*) self, (ValaExpression*) _tmp64_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp65_ = array_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp65_, context);
					_vala_code_node_unref0 (array_creation);
					_vala_code_node_unref0 (old_parent_node);
					return result;
				}
				_tmp66_ = array_type;
				_tmp67_ = vala_array_type_get_rank (_tmp66_);
				_tmp68_ = _tmp67_;
				if (_tmp68_ > 1) {
					ValaArrayType* inner_array_type = NULL;
					ValaArrayType* _tmp69_;
					ValaDataType* _tmp70_;
					ValaArrayType* _tmp71_;
					gint _tmp72_;
					gint _tmp73_;
					ValaArrayType* _tmp74_;
					ValaDataType* _tmp75_;
					_tmp69_ = array_type;
					_tmp70_ = vala_data_type_copy ((ValaDataType*) _tmp69_);
					inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp71_ = inner_array_type;
					_tmp72_ = vala_array_type_get_rank (_tmp71_);
					_tmp73_ = _tmp72_;
					vala_array_type_set_rank (_tmp71_, _tmp73_ - 1);
					_tmp74_ = inner_array_type;
					_tmp75_ = _vala_code_node_ref0 ((ValaDataType*) _tmp74_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp75_;
					_vala_code_node_unref0 (inner_array_type);
				} else {
					ValaArrayType* _tmp76_;
					ValaDataType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					_tmp76_ = array_type;
					_tmp77_ = vala_array_type_get_element_type (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = vala_data_type_copy (_tmp78_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp79_;
				}
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp80_;
					gint _e_size = 0;
					ValaList* _tmp81_;
					gint _tmp82_;
					gint _tmp83_;
					gint _e_index = 0;
					_tmp80_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp80_;
					_tmp81_ = _e_list;
					_tmp82_ = vala_collection_get_size ((ValaCollection*) _tmp81_);
					_tmp83_ = _tmp82_;
					_e_size = _tmp83_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp84_;
						gint _tmp85_;
						ValaExpression* e = NULL;
						ValaList* _tmp86_;
						gpointer _tmp87_;
						ValaExpression* _tmp88_;
						ValaDataType* _tmp89_;
						_e_index = _e_index + 1;
						_tmp84_ = _e_index;
						_tmp85_ = _e_size;
						if (!(_tmp84_ < _tmp85_)) {
							break;
						}
						_tmp86_ = _e_list;
						_tmp87_ = vala_list_get (_tmp86_, _e_index);
						e = (ValaExpression*) _tmp87_;
						_tmp88_ = e;
						_tmp89_ = inner_target_type;
						vala_expression_set_target_type (_tmp88_, _tmp89_);
						_vala_code_node_unref0 (e);
					}
				}
				_vala_code_node_unref0 (inner_target_type);
			} else {
				ValaDataType* _tmp90_;
				ValaDataType* _tmp91_;
				ValaTypeSymbol* _tmp92_;
				ValaTypeSymbol* _tmp93_;
				_tmp90_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp91_ = _tmp90_;
				_tmp92_ = vala_data_type_get_type_symbol (_tmp91_);
				_tmp93_ = _tmp92_;
				if (VALA_IS_STRUCT (_tmp93_)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp94_;
					ValaDataType* _tmp95_;
					ValaTypeSymbol* _tmp96_;
					ValaTypeSymbol* _tmp97_;
					gboolean _tmp104_ = FALSE;
					ValaCodeNode* _tmp105_;
					ValaCodeNode* _tmp106_;
					gboolean in_array_creation_initializer = FALSE;
					ValaObjectCreationExpression* struct_creation = NULL;
					ValaIterator* field_it = NULL;
					ValaStruct* _tmp154_;
					ValaList* _tmp155_;
					ValaIterator* _tmp156_;
					_tmp94_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_data_type_get_type_symbol (_tmp95_);
					_tmp97_ = _tmp96_;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_STRUCT, ValaStruct);
					while (TRUE) {
						ValaStruct* _tmp98_;
						ValaStruct* _tmp99_;
						ValaStruct* _tmp100_;
						ValaStruct* _tmp101_;
						ValaStruct* _tmp102_;
						ValaStruct* _tmp103_;
						_tmp98_ = st;
						_tmp99_ = vala_struct_get_base_struct (_tmp98_);
						_tmp100_ = _tmp99_;
						if (!(_tmp100_ != NULL)) {
							break;
						}
						_tmp101_ = st;
						_tmp102_ = vala_struct_get_base_struct (_tmp101_);
						_tmp103_ = _tmp102_;
						st = _tmp103_;
					}
					_tmp105_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp106_ = _tmp105_;
					if (VALA_IS_INITIALIZER_LIST (_tmp106_)) {
						ValaCodeNode* _tmp107_;
						ValaCodeNode* _tmp108_;
						ValaCodeNode* _tmp109_;
						ValaCodeNode* _tmp110_;
						_tmp107_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_code_node_get_parent_node (_tmp108_);
						_tmp110_ = _tmp109_;
						_tmp104_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp110_);
					} else {
						_tmp104_ = FALSE;
					}
					in_array_creation_initializer = _tmp104_;
					struct_creation = NULL;
					if (in_array_creation_initializer) {
						ValaSymbol* sym = NULL;
						ValaStruct* _tmp111_;
						ValaMemberAccess* ma = NULL;
						ValaSymbol* _tmp112_;
						const gchar* _tmp113_;
						const gchar* _tmp114_;
						ValaSourceReference* _tmp115_;
						ValaSourceReference* _tmp116_;
						ValaMemberAccess* _tmp117_;
						ValaMemberAccess* _tmp118_;
						ValaSymbol* _tmp119_;
						ValaMemberAccess* inner = NULL;
						ValaMemberAccess* _tmp120_;
						ValaMemberAccess* _tmp121_;
						ValaMemberAccess* _tmp144_;
						ValaSourceReference* _tmp145_;
						ValaSourceReference* _tmp146_;
						ValaObjectCreationExpression* _tmp147_;
						ValaObjectCreationExpression* _tmp148_;
						ValaDataType* _tmp149_;
						ValaDataType* _tmp150_;
						ValaDataType* _tmp151_;
						ValaDataType* _tmp152_;
						ValaObjectCreationExpression* _tmp153_;
						_tmp111_ = st;
						sym = (ValaSymbol*) _tmp111_;
						_tmp112_ = sym;
						_tmp113_ = vala_symbol_get_name (_tmp112_);
						_tmp114_ = _tmp113_;
						_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp116_ = _tmp115_;
						_tmp117_ = vala_member_access_new_simple (_tmp114_, _tmp116_);
						ma = _tmp117_;
						_tmp118_ = ma;
						_tmp119_ = sym;
						vala_expression_set_symbol_reference ((ValaExpression*) _tmp118_, _tmp119_);
						_tmp120_ = ma;
						_tmp121_ = _vala_code_node_ref0 (_tmp120_);
						inner = _tmp121_;
						while (TRUE) {
							gboolean _tmp122_ = FALSE;
							ValaSymbol* _tmp123_;
							ValaSymbol* _tmp124_;
							ValaSymbol* _tmp125_;
							ValaSymbol* _tmp131_;
							ValaSymbol* _tmp132_;
							ValaSymbol* _tmp133_;
							ValaMemberAccess* ma_inner = NULL;
							ValaSymbol* _tmp134_;
							const gchar* _tmp135_;
							const gchar* _tmp136_;
							ValaSourceReference* _tmp137_;
							ValaSourceReference* _tmp138_;
							ValaMemberAccess* _tmp139_;
							ValaMemberAccess* _tmp140_;
							ValaMemberAccess* _tmp141_;
							ValaMemberAccess* _tmp142_;
							ValaMemberAccess* _tmp143_;
							_tmp123_ = sym;
							_tmp124_ = vala_symbol_get_parent_symbol (_tmp123_);
							_tmp125_ = _tmp124_;
							if (_tmp125_ != NULL) {
								ValaSymbol* _tmp126_;
								ValaSymbol* _tmp127_;
								ValaSymbol* _tmp128_;
								ValaNamespace* _tmp129_;
								ValaNamespace* _tmp130_;
								_tmp126_ = sym;
								_tmp127_ = vala_symbol_get_parent_symbol (_tmp126_);
								_tmp128_ = _tmp127_;
								_tmp129_ = vala_code_context_get_root (context);
								_tmp130_ = _tmp129_;
								_tmp122_ = _tmp128_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp122_ = FALSE;
							}
							if (!_tmp122_) {
								break;
							}
							_tmp131_ = sym;
							_tmp132_ = vala_symbol_get_parent_symbol (_tmp131_);
							_tmp133_ = _tmp132_;
							sym = _tmp133_;
							_tmp134_ = sym;
							_tmp135_ = vala_symbol_get_name (_tmp134_);
							_tmp136_ = _tmp135_;
							_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp138_ = _tmp137_;
							_tmp139_ = vala_member_access_new_simple (_tmp136_, _tmp138_);
							ma_inner = _tmp139_;
							_tmp140_ = inner;
							_tmp141_ = ma_inner;
							vala_member_access_set_inner (_tmp140_, (ValaExpression*) _tmp141_);
							_tmp142_ = ma_inner;
							_tmp143_ = _vala_code_node_ref0 (_tmp142_);
							_vala_code_node_unref0 (inner);
							inner = _tmp143_;
							_vala_code_node_unref0 (ma_inner);
						}
						_tmp144_ = ma;
						_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp146_ = _tmp145_;
						_tmp147_ = vala_object_creation_expression_new (_tmp144_, _tmp146_);
						_vala_code_node_unref0 (struct_creation);
						struct_creation = _tmp147_;
						_tmp148_ = struct_creation;
						_tmp149_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp151_ = vala_data_type_copy (_tmp150_);
						_tmp152_ = _tmp151_;
						vala_expression_set_target_type ((ValaExpression*) _tmp148_, _tmp152_);
						_vala_code_node_unref0 (_tmp152_);
						_tmp153_ = struct_creation;
						vala_object_creation_expression_set_struct_creation (_tmp153_, TRUE);
						_vala_code_node_unref0 (inner);
						_vala_code_node_unref0 (ma);
					}
					_tmp154_ = st;
					_tmp155_ = vala_struct_get_fields (_tmp154_);
					_tmp156_ = vala_iterable_iterator ((ValaIterable*) _tmp155_);
					field_it = _tmp156_;
					{
						ValaList* _e_list = NULL;
						ValaList* _tmp157_;
						gint _e_size = 0;
						ValaList* _tmp158_;
						gint _tmp159_;
						gint _tmp160_;
						gint _e_index = 0;
						_tmp157_ = vala_initializer_list_get_initializers (self);
						_e_list = _tmp157_;
						_tmp158_ = _e_list;
						_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
						_tmp160_ = _tmp159_;
						_e_size = _tmp160_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp161_;
							gint _tmp162_;
							ValaExpression* e = NULL;
							ValaList* _tmp163_;
							gpointer _tmp164_;
							ValaField* field = NULL;
							_e_index = _e_index + 1;
							_tmp161_ = _e_index;
							_tmp162_ = _e_size;
							if (!(_tmp161_ < _tmp162_)) {
								break;
							}
							_tmp163_ = _e_list;
							_tmp164_ = vala_list_get (_tmp163_, _e_index);
							e = (ValaExpression*) _tmp164_;
							field = NULL;
							while (TRUE) {
								ValaField* _tmp165_;
								ValaIterator* _tmp166_;
								ValaIterator* _tmp174_;
								gpointer _tmp175_;
								ValaField* _tmp176_;
								ValaMemberBinding _tmp177_;
								ValaMemberBinding _tmp178_;
								_tmp165_ = field;
								if (!(_tmp165_ == NULL)) {
									break;
								}
								_tmp166_ = field_it;
								if (!vala_iterator_next (_tmp166_)) {
									ValaExpression* _tmp167_;
									ValaSourceReference* _tmp168_;
									ValaSourceReference* _tmp169_;
									ValaDataType* _tmp170_;
									ValaDataType* _tmp171_;
									gchar* _tmp172_;
									gchar* _tmp173_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp167_ = e;
									_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp167_);
									_tmp169_ = _tmp168_;
									_tmp170_ = vala_expression_get_target_type ((ValaExpression*) self);
									_tmp171_ = _tmp170_;
									_tmp172_ = vala_code_node_to_string ((ValaCodeNode*) _tmp171_);
									_tmp173_ = _tmp172_;
									vala_report_error (_tmp169_, "too many expressions in initializer list for `%s'", _tmp173_);
									_g_free0 (_tmp173_);
									result = FALSE;
									_vala_code_node_unref0 (field);
									_vala_code_node_unref0 (e);
									_vala_iterator_unref0 (field_it);
									_vala_code_node_unref0 (struct_creation);
									return result;
								}
								_tmp174_ = field_it;
								_tmp175_ = vala_iterator_get (_tmp174_);
								_vala_code_node_unref0 (field);
								field = (ValaField*) _tmp175_;
								_tmp176_ = field;
								_tmp177_ = vala_field_get_binding (_tmp176_);
								_tmp178_ = _tmp177_;
								if (_tmp178_ != VALA_MEMBER_BINDING_INSTANCE) {
									_vala_code_node_unref0 (field);
									field = NULL;
								}
							}
							if (in_array_creation_initializer) {
								ValaMemberInitializer* member_init = NULL;
								ValaField* _tmp179_;
								const gchar* _tmp180_;
								const gchar* _tmp181_;
								ValaExpression* _tmp182_;
								ValaExpression* _tmp183_;
								ValaSourceReference* _tmp184_;
								ValaSourceReference* _tmp185_;
								ValaMemberInitializer* _tmp186_;
								ValaObjectCreationExpression* _tmp187_;
								ValaMemberInitializer* _tmp188_;
								_tmp179_ = field;
								_tmp180_ = vala_symbol_get_name ((ValaSymbol*) _tmp179_);
								_tmp181_ = _tmp180_;
								_tmp182_ = e;
								_tmp183_ = e;
								_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
								_tmp185_ = _tmp184_;
								_tmp186_ = vala_member_initializer_new (_tmp181_, _tmp182_, _tmp185_);
								member_init = _tmp186_;
								_tmp187_ = struct_creation;
								_tmp188_ = member_init;
								vala_object_creation_expression_add_member_initializer (_tmp187_, _tmp188_);
								_vala_code_node_unref0 (member_init);
							} else {
								ValaExpression* _tmp189_;
								ValaField* _tmp190_;
								ValaDataType* _tmp191_;
								ValaDataType* _tmp192_;
								ValaDataType* _tmp193_;
								ValaDataType* _tmp194_;
								ValaDataType* _tmp195_;
								ValaDataType* _tmp196_;
								gboolean _tmp197_;
								gboolean _tmp198_;
								_tmp189_ = e;
								_tmp190_ = field;
								_tmp191_ = vala_variable_get_variable_type ((ValaVariable*) _tmp190_);
								_tmp192_ = _tmp191_;
								_tmp193_ = vala_data_type_copy (_tmp192_);
								_tmp194_ = _tmp193_;
								vala_expression_set_target_type (_tmp189_, _tmp194_);
								_vala_code_node_unref0 (_tmp194_);
								_tmp195_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp196_ = _tmp195_;
								_tmp197_ = vala_data_type_get_value_owned (_tmp196_);
								_tmp198_ = _tmp197_;
								if (!_tmp198_) {
									ValaExpression* _tmp199_;
									ValaDataType* _tmp200_;
									ValaDataType* _tmp201_;
									_tmp199_ = e;
									_tmp200_ = vala_expression_get_target_type (_tmp199_);
									_tmp201_ = _tmp200_;
									vala_data_type_set_value_owned (_tmp201_, FALSE);
								}
							}
							_vala_code_node_unref0 (field);
							_vala_code_node_unref0 (e);
						}
					}
					if (in_array_creation_initializer) {
						ValaCodeNode* _tmp202_;
						ValaCodeNode* _tmp203_;
						ValaObjectCreationExpression* _tmp204_;
						ValaObjectCreationExpression* _tmp205_;
						_tmp202_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp203_ = _tmp202_;
						_tmp204_ = struct_creation;
						vala_code_node_replace_expression (_tmp203_, (ValaExpression*) self, (ValaExpression*) _tmp204_);
						vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
						_tmp205_ = struct_creation;
						result = vala_code_node_check ((ValaCodeNode*) _tmp205_, context);
						_vala_iterator_unref0 (field_it);
						_vala_code_node_unref0 (struct_creation);
						return result;
					}
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
				} else {
					ValaSourceReference* _tmp206_;
					ValaSourceReference* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_code_node_to_string ((ValaCodeNode*) _tmp209_);
					_tmp211_ = _tmp210_;
					vala_report_error (_tmp207_, "initializer list used for `%s', which is neither array nor struct", _tmp211_);
					_g_free0 (_tmp211_);
					result = FALSE;
					return result;
				}
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp212_;
		gint _expr_size = 0;
		ValaList* _tmp213_;
		gint _tmp214_;
		gint _tmp215_;
		gint _expr_index = 0;
		_tmp212_ = self->priv->initializers;
		_expr_list = _tmp212_;
		_tmp213_ = _expr_list;
		_tmp214_ = vala_collection_get_size ((ValaCollection*) _tmp213_);
		_tmp215_ = _tmp214_;
		_expr_size = _tmp215_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp216_;
			gint _tmp217_;
			ValaExpression* expr = NULL;
			ValaList* _tmp218_;
			gpointer _tmp219_;
			ValaExpression* _tmp220_;
			_expr_index = _expr_index + 1;
			_tmp216_ = _expr_index;
			_tmp217_ = _expr_size;
			if (!(_tmp216_ < _tmp217_)) {
				break;
			}
			_tmp218_ = _expr_list;
			_tmp219_ = vala_list_get (_tmp218_, _expr_index);
			expr = (ValaExpression*) _tmp219_;
			_tmp220_ = expr;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp220_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp221_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp222_ = _tmp221_;
	if (_tmp222_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp223_;
		gint _e_size = 0;
		ValaList* _tmp224_;
		gint _tmp225_;
		gint _tmp226_;
		gint _e_index = 0;
		_tmp223_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp223_;
		_tmp224_ = _e_list;
		_tmp225_ = vala_collection_get_size ((ValaCollection*) _tmp224_);
		_tmp226_ = _tmp225_;
		_e_size = _tmp226_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp227_;
			gint _tmp228_;
			ValaExpression* e = NULL;
			ValaList* _tmp229_;
			gpointer _tmp230_;
			ValaExpression* _tmp231_;
			ValaDataType* _tmp232_;
			ValaDataType* _tmp233_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp237_;
			gboolean _tmp238_ = FALSE;
			ValaUnaryExpression* _tmp239_;
			_e_index = _e_index + 1;
			_tmp227_ = _e_index;
			_tmp228_ = _e_size;
			if (!(_tmp227_ < _tmp228_)) {
				break;
			}
			_tmp229_ = _e_list;
			_tmp230_ = vala_list_get (_tmp229_, _e_index);
			e = (ValaExpression*) _tmp230_;
			_tmp231_ = e;
			_tmp232_ = vala_expression_get_value_type (_tmp231_);
			_tmp233_ = _tmp232_;
			if (_tmp233_ == NULL) {
				ValaExpression* _tmp234_;
				ValaSourceReference* _tmp235_;
				ValaSourceReference* _tmp236_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp234_ = e;
				_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp234_);
				_tmp236_ = _tmp235_;
				vala_report_error (_tmp236_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp237_ = e;
			unary = VALA_IS_UNARY_EXPRESSION (_tmp237_) ? ((ValaUnaryExpression*) _tmp237_) : NULL;
			_tmp239_ = unary;
			if (_tmp239_ != NULL) {
				gboolean _tmp240_ = FALSE;
				ValaUnaryExpression* _tmp241_;
				ValaUnaryOperator _tmp242_;
				ValaUnaryOperator _tmp243_;
				_tmp241_ = unary;
				_tmp242_ = vala_unary_expression_get_operator (_tmp241_);
				_tmp243_ = _tmp242_;
				if (_tmp243_ == VALA_UNARY_OPERATOR_REF) {
					_tmp240_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp244_;
					ValaUnaryOperator _tmp245_;
					ValaUnaryOperator _tmp246_;
					_tmp244_ = unary;
					_tmp245_ = vala_unary_expression_get_operator (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp240_ = _tmp246_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp238_ = _tmp240_;
			} else {
				_tmp238_ = FALSE;
			}
			if (_tmp238_) {
			} else {
				gboolean _tmp247_ = FALSE;
				gboolean _tmp248_ = FALSE;
				ValaExpression* _tmp249_;
				_tmp249_ = e;
				if (VALA_IS_NULL_LITERAL (_tmp249_)) {
					ValaExpression* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					_tmp250_ = e;
					_tmp251_ = vala_expression_get_target_type (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp248_ = _tmp252_ != NULL;
				} else {
					_tmp248_ = FALSE;
				}
				if (_tmp248_) {
					ValaExpression* _tmp253_;
					ValaDataType* _tmp254_;
					ValaDataType* _tmp255_;
					_tmp253_ = e;
					_tmp254_ = vala_expression_get_target_type (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp247_ = vala_data_type_is_real_non_null_struct_type (_tmp255_);
				} else {
					_tmp247_ = FALSE;
				}
				if (_tmp247_) {
				} else {
					ValaExpression* _tmp256_;
					ValaDataType* _tmp257_;
					ValaDataType* _tmp258_;
					ValaExpression* _tmp259_;
					ValaDataType* _tmp260_;
					ValaDataType* _tmp261_;
					_tmp256_ = e;
					_tmp257_ = vala_expression_get_value_type (_tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = e;
					_tmp260_ = vala_expression_get_target_type (_tmp259_);
					_tmp261_ = _tmp260_;
					if (!vala_data_type_compatible (_tmp258_, _tmp261_)) {
						ValaExpression* _tmp262_;
						ValaExpression* _tmp263_;
						ValaSourceReference* _tmp264_;
						ValaSourceReference* _tmp265_;
						ValaExpression* _tmp266_;
						ValaDataType* _tmp267_;
						ValaDataType* _tmp268_;
						gchar* _tmp269_;
						gchar* _tmp270_;
						ValaExpression* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						gchar* _tmp274_;
						gchar* _tmp275_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp262_ = e;
						vala_code_node_set_error ((ValaCodeNode*) _tmp262_, TRUE);
						_tmp263_ = e;
						_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
						_tmp265_ = _tmp264_;
						_tmp266_ = e;
						_tmp267_ = vala_expression_get_target_type (_tmp266_);
						_tmp268_ = _tmp267_;
						_tmp269_ = vala_code_node_to_string ((ValaCodeNode*) _tmp268_);
						_tmp270_ = _tmp269_;
						_tmp271_ = e;
						_tmp272_ = vala_expression_get_value_type (_tmp271_);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_code_node_to_string ((ValaCodeNode*) _tmp273_);
						_tmp275_ = _tmp274_;
						vala_report_error (_tmp265_, "Expected initializer of type `%s' but got `%s'", _tmp270_, _tmp275_);
						_g_free0 (_tmp275_);
						_g_free0 (_tmp270_);
					}
				}
			}
			_vala_code_node_unref0 (e);
		}
	}
	_tmp276_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp277_ = _tmp276_;
	if (!_tmp277_) {
		ValaDataType* _tmp278_;
		ValaDataType* _tmp279_;
		ValaDataType* _tmp280_;
		ValaDataType* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		_tmp278_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_data_type_copy (_tmp279_);
		_tmp281_ = _tmp280_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp281_);
		_vala_code_node_unref0 (_tmp281_);
		_tmp282_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp283_ = _tmp282_;
		vala_data_type_set_nullable (_tmp283_, FALSE);
	}
	_tmp284_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp285_ = _tmp284_;
	if (_tmp285_ != NULL) {
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		_tmp286_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp287_ = _tmp286_;
		vala_code_node_check ((ValaCodeNode*) _tmp287_, context);
	}
	_tmp288_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp289_ = _tmp288_;
	result = !_tmp289_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		gint _expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_expr_list = _tmp0_;
		_tmp1_ = _expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_expr_size = _tmp3_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			_tmp4_ = _expr_index;
			_tmp5_ = _expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaExpression*) _tmp7_;
			_tmp8_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		gint _expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_expr_list = _tmp0_;
		_tmp1_ = _expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_expr_size = _tmp3_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			_tmp4_ = _expr_index;
			_tmp5_ = _expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaExpression*) _tmp7_;
			_tmp8_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
static GType
vala_initializer_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
	GType vala_initializer_list_type_id;
	vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
	ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
	return vala_initializer_list_type_id;
}

GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__once = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__once)) {
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = vala_initializer_list_get_type_once ();
		g_once_init_leave (&vala_initializer_list_type_id__once, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__once;
}

