/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.python;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonType;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleObjectsView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleSummaryView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleThreadsView;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

final class PythonViews {
    PythonViews() {
    }

    public static class ThreadsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (PythonHeapFragment.isPythonHeap(context)) {
                return new TruffleThreadsView(PythonLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class ObjectsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (PythonHeapFragment.isPythonHeap(context)) {
                return new TruffleObjectsView(PythonLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class SummaryObjectsProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (PythonHeapFragment.isPythonHeap(context)) {
                return new TruffleSummaryView.ObjectsSection(PythonLanguage.instance(), context, actions, actionProviders);
            }
            return null;
        }
    }

    private static class SummaryOverview
    extends TruffleSummaryView.OverviewSection {
        SummaryOverview(HeapContext context) {
            super(context, 3, 3);
        }

        @Override
        protected void computeEnvironmentData(Object[][] environmentData) {
            super.computeEnvironmentData(environmentData);
            environmentData[1][0] = Bundle.PythonViews_Version();
            environmentData[2][0] = Bundle.PythonViews_Platform();
            PythonHeapFragment fragment = (PythonHeapFragment)this.getContext().getFragment();
            PythonType moduleType = (PythonType)fragment.getType("module", null);
            if (moduleType != null) {
                PythonObject sysModule = null;
                Iterator objects = moduleType.getObjectsIterator();
                while (objects.hasNext()) {
                    PythonObject object = (PythonObject)objects.next();
                    if (!"sys".equals(DetailsSupport.getDetailsString((Instance)object.getInstance()))) continue;
                    sysModule = object;
                    break;
                }
                if (sysModule != null) {
                    PythonObject _ns_;
                    int graalInfoIdx;
                    String version = SummaryOverview.attributeValue(sysModule, "version");
                    int n = graalInfoIdx = version == null ? -1 : version.indexOf(91);
                    if (graalInfoIdx != -1) {
                        version = version.substring(0, graalInfoIdx);
                    }
                    environmentData[1][1] = version;
                    environmentData[2][1] = SummaryOverview.attributeValue(sysModule, "platform");
                    PythonObject implementation = SummaryOverview.attributeObject(sysModule, "implementation");
                    if (implementation != null && (_ns_ = SummaryOverview.attributeObject(implementation, "__ns__")) != null) {
                        environmentData[1][1] = SummaryOverview.attributeValue(_ns_, "name") + " " + version;
                        environmentData[2][1] = SummaryOverview.attributeValue(_ns_, "_multiarch");
                    }
                }
            }
            if (environmentData[1][1] == null) {
                environmentData[1][1] = Bundle.PythonViews_Unknown();
            }
            if (environmentData[2][1] == null) {
                environmentData[2][1] = Bundle.PythonViews_Unknown();
            }
        }

        private static PythonObject attributeObject(PythonObject object, String attribute) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attr : attributes) {
                if (!attribute.equals(attr.getField().getName())) continue;
                Instance instance = attr instanceof ObjectFieldValue ? ((ObjectFieldValue)attr).getInstance() : null;
                return PythonObject.isPythonObject(instance) ? new PythonObject(instance) : null;
            }
            return null;
        }

        private static String attributeValue(PythonObject object, String attribute) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attr : attributes) {
                if (!attribute.equals(attr.getField().getName())) continue;
                Instance instance = attr instanceof ObjectFieldValue ? ((ObjectFieldValue)attr).getInstance() : null;
                return instance == null ? null : DetailsSupport.getDetailsString((Instance)instance);
            }
            return null;
        }
    }

    public static class SummaryOverviewProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (PythonHeapFragment.isPythonHeap(context)) {
                return new SummaryOverview(context);
            }
            return null;
        }
    }

    public static class SummaryViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (PythonHeapFragment.isPythonHeap(context)) {
                return new TruffleSummaryView(PythonLanguage.instance(), context, actions);
            }
            return null;
        }
    }
}

