/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

public final class TerminalJavaNodes {
    public static InstanceReferenceNode outgoingReference(Value value) {
        return TerminalJavaNodes.reference(value, false);
    }

    public static InstanceReferenceNode incomingReference(Value value) {
        return TerminalJavaNodes.reference(value, true);
    }

    public static InstanceReferenceNode reference(Value value, boolean incoming) {
        if (value instanceof ObjectFieldValue) {
            return new Field((ObjectFieldValue)value, incoming);
        }
        if (value instanceof ArrayItemValue) {
            return new ArrayItem((ArrayItemValue)value, incoming);
        }
        return null;
    }

    private TerminalJavaNodes() {
    }

    public static class ArrayItem
    extends InstanceReferenceNode.ArrayItem {
        public ArrayItem(ArrayItemValue value, boolean incoming) {
            super(value, incoming);
            this.setChildren(NO_NODES);
        }

        public boolean isLeaf() {
            return true;
        }
    }

    public static class Field
    extends InstanceReferenceNode.Field {
        private final boolean isArray;

        public Field(ObjectFieldValue value, boolean incoming) {
            super(value, incoming);
            org.graalvm.visualvm.lib.jfluid.heap.Instance instance = this.getInstance();
            boolean bl = this.isArray = instance != null && instance.getJavaClass().isArray();
            if (!this.isArray) {
                this.setChildren(NO_NODES);
            }
        }

        public boolean isLeaf() {
            return this.isArray ? super.isLeaf() : true;
        }
    }

    public static class Instance
    extends InstanceNode {
        public Instance(org.graalvm.visualvm.lib.jfluid.heap.Instance instance) {
            super(instance);
            this.setChildren(NO_NODES);
        }

        public boolean isLeaf() {
            return true;
        }
    }
}

