/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import java.util.ArrayList;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleObjectView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.NodeObjectsView;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

public abstract class TruffleOpenNodeActionProvider<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>>
extends HeapViewerNodeAction.Provider {
    protected abstract boolean supportsNode(HeapViewerNode var1);

    protected abstract L getLanguage();

    public HeapViewerNodeAction[] getActions(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
        if (!this.supportsNode(node)) {
            return null;
        }
        Heap heap = context.getFragment().getHeap();
        ArrayList<Object> actionsList = new ArrayList<Object>(2);
        L language = this.getLanguage();
        actionsList.add(new NodeObjectsView.DefaultOpenAction(node.createCopy(), context, actions, (TruffleLanguage)((Object)language)){
            final /* synthetic */ TruffleLanguage val$language;
            {
                this.val$language = truffleLanguage;
                super(x0, x1, x2);
            }

            public NodeObjectsView createView(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
                return TruffleOpenNodeActionProvider.this.createView(this.val$language, node, context, actions);
            }
        });
        Instance instance = (Instance)HeapViewerNode.getValue((HeapViewerNode)node, (DataType)DataType.INSTANCE, (Heap)heap);
        if (instance != null && ((TruffleLanguage)((Object)language)).isLanguageObject(instance)) {
            Object object = ((TruffleLanguage)((Object)language)).createObject(instance);
            Object fragment = ((TruffleLanguage)((Object)language)).fragmentFromHeap(heap);
            Object type = ((TruffleLanguageHeapFragment)((Object)fragment)).getType(((TruffleObject)object).getType(), null);
            if (type != null) {
                TruffleTypeNode typeNode = ((TruffleLanguage)((Object)language)).createTypeNode(type, heap);
                actionsList.add(new NodeObjectsView.OpenAction(Bundle.TruffleOpenNodeActionProvider_OpenTypeTab(), 1, typeNode, context, actions, (TruffleLanguage)((Object)language)){
                    final /* synthetic */ TruffleLanguage val$language;
                    {
                        this.val$language = truffleLanguage;
                        super(x0, x1, x2, x3, x4);
                    }

                    public NodeObjectsView createView(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
                        return TruffleOpenNodeActionProvider.this.createView(this.val$language, node, context, actions);
                    }
                });
            }
        }
        return actionsList.toArray(new HeapViewerNodeAction[0]);
    }

    private NodeObjectsView createView(L language, HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
        return new TruffleObjectView((TruffleLanguage)((Object)language), node, context, actions);
    }
}

