/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsProvider;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.heapviewer.truffle.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.truffle.swing.Splitter;
import org.graalvm.visualvm.heapviewer.truffle.ui.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleObjectsView;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.uisupport.SeparatorLine;
import org.graalvm.visualvm.uisupport.VerticalLayout;
import org.openide.util.RequestProcessor;

public class TruffleSummaryView
extends HeapViewerFeature {
    private static final String FEATURE_ID = "summary";
    private final SummaryView summaryView;

    public TruffleSummaryView(TruffleLanguage language, HeapContext context, HeapViewerActions actions) {
        super(TruffleSummaryView.idFromLanguage(language), Bundle.TruffleSummaryView_Name(), Bundle.TruffleSummaryView_Description(), TruffleSummaryView.iconFromLanguage(language), 100);
        this.summaryView = new SummaryView(this.getID(), context, actions){

            protected void uiCreated(final List<HeapView> views) {
                if (!views.isEmpty()) {
                    new RequestProcessor("Truffle Summary Worker").post(new Runnable(){

                        @Override
                        public void run() {
                            for (HeapView view : views) {
                                if (!(view instanceof TruffleSummarySection)) continue;
                                ((TruffleSummarySection)view).computeData();
                            }
                        }
                    });
                }
            }
        };
    }

    static String idFromLanguage(TruffleLanguage language) {
        return language.getID() + "_" + FEATURE_ID;
    }

    static Icon iconFromLanguage(TruffleLanguage language) {
        return language.createLanguageIcon(Icons.getIcon((String)"HeapWalkerIcons.Properties"));
    }

    public boolean isDefault() {
        return true;
    }

    public JComponent getComponent() {
        return this.summaryView.getComponent();
    }

    public ProfilerToolbar getToolbar() {
        return this.summaryView.getToolbar();
    }

    public static class ObjectsSection<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>>
    extends TruffleSummarySection {
        private static final int PREVIEW_ITEMS = 5;
        private final L language;
        private final HeapContext context;
        private final HeapViewerActions actions;
        private final Collection<HeapViewerNodeAction.Provider> actionProviders;
        private JComponent component;
        private ResultsSnippet typesByCount;
        private ResultsSnippet typesBySize;
        private ResultsSnippet objectsBySize;
        private ResultsSnippet dominatorsByRetainedSize;
        private boolean retainedAvailable;

        public ObjectsSection(L language, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            super(Bundle.TruffleObjectsSection_Name(), Bundle.TruffleObjectsSection_Description());
            this.language = language;
            this.context = context;
            this.actions = actions;
            this.actionProviders = actionProviders;
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.init();
            }
            return this.component;
        }

        public ProfilerToolbar getToolbar() {
            return null;
        }

        @Override
        protected final void computeData() {
            TruffleLanguageHeapFragment fragment = (TruffleLanguageHeapFragment)this.context.getFragment();
            Heap heap = fragment.getHeap();
            ArrayList allTypes = new ArrayList(fragment.getTypes(null));
            Collections.sort(allTypes, new Comparator<TruffleType>(){

                @Override
                public int compare(TruffleType t1, TruffleType t2) {
                    return Integer.compare(t2.getObjectsCount(), t1.getObjectsCount());
                }
            });
            int items = Math.min(5, allTypes.size());
            TruffleType[] typesByCountArr = allTypes.subList(0, items).toArray(new TruffleType[0]);
            Object[][] typesByCountData = new Object[typesByCountArr.length][2];
            for (int i = 0; i < typesByCountData.length; ++i) {
                typesByCountData[i][0] = ((TruffleLanguage)((Object)this.language)).createTypeNode((TruffleType)typesByCountArr[i], heap);
                typesByCountData[i][1] = typesByCountArr[i].getObjectsCount();
            }
            this.configureSnippet(this.typesByCount, typesByCountData);
            Collections.sort(allTypes, new Comparator<TruffleType>(){

                @Override
                public int compare(TruffleType t1, TruffleType t2) {
                    return Long.compare(t2.getAllObjectsSize(), t1.getAllObjectsSize());
                }
            });
            TruffleType[] typesBySizeArr = allTypes.subList(0, items).toArray(new TruffleType[0]);
            Object[][] typesBySizeData = new Object[typesBySizeArr.length][2];
            for (int i = 0; i < typesBySizeData.length; ++i) {
                typesBySizeData[i][0] = ((TruffleLanguage)((Object)this.language)).createTypeNode((TruffleType)typesBySizeArr[i], heap);
                typesBySizeData[i][1] = typesBySizeArr[i].getAllObjectsSize();
            }
            this.configureSnippet(this.typesBySize, typesBySizeData);
            items = (int)Math.min(5L, heap.getSummary().getTotalLiveInstances());
            PriorityQueue<TruffleObject> pqBySize = new PriorityQueue<TruffleObject>(items, new Comparator<TruffleObject>(){

                @Override
                public int compare(TruffleObject o1, TruffleObject o2) {
                    return Long.compare(o1.getSize(), o2.getSize());
                }
            });
            Iterator allObjects = fragment.getObjectsIterator();
            while (allObjects.hasNext()) {
                TruffleObject in = (TruffleObject)allObjects.next();
                if (pqBySize.size() >= items && pqBySize.peek().getSize() >= in.getSize()) continue;
                if (pqBySize.size() == items) {
                    pqBySize.remove();
                }
                pqBySize.add(in);
            }
            TruffleObject[] objectsBySizeArr = new TruffleObject[pqBySize.size()];
            for (int i = objectsBySizeArr.length - 1; i >= 0; --i) {
                objectsBySizeArr[i] = pqBySize.poll();
            }
            Object[][] instancesBySizeData = new Object[objectsBySizeArr.length][2];
            for (int i = 0; i < instancesBySizeData.length; ++i) {
                TruffleObject object = objectsBySizeArr[i];
                instancesBySizeData[i][0] = ((TruffleLanguage)((Object)this.language)).createObjectNode((TruffleObject)object, object.getType());
                instancesBySizeData[i][1] = objectsBySizeArr[i].getSize();
            }
            this.configureSnippet(this.objectsBySize, instancesBySizeData);
            if (this.retainedAvailable) {
                this.computeDominators(this.dominatorsByRetainedSize);
            }
        }

        private void init() {
            final Heap heap = this.context.getFragment().getHeap();
            Icon typeIcon = ((TruffleLanguage)((Object)this.language)).createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Package"));
            TruffleTypeNode.Renderer typeRenderer = new TruffleTypeNode.Renderer(typeIcon);
            Icon instanceIcon = ((TruffleLanguage)((Object)this.language)).createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Instance"));
            TruffleObjectNode.Renderer objectRenderer = new TruffleObjectNode.Renderer(heap, instanceIcon);
            TreeTableViewColumn.OwnSize sizeColumn = new TreeTableViewColumn.OwnSize(heap);
            HideableBarRenderer sizeRenderer = (HideableBarRenderer)sizeColumn.getRenderer();
            TreeTableViewColumn.Count classesByCountColumn = new TreeTableViewColumn.Count(heap);
            HideableBarRenderer classesByCountRenderer = (HideableBarRenderer)classesByCountColumn.getRenderer();
            Runnable typesByCountDisplayer = new Runnable(){

                @Override
                public void run() {
                    TruffleObjectsView objectsView = (TruffleObjectsView)actions.findFeature(TruffleObjectsView.idFromLanguage(language));
                    if (objectsView != null) {
                        objectsView.configureTypesByObjectsCount();
                        actions.selectFeature((HeapViewerFeature)objectsView);
                    }
                }
            };
            this.typesByCount = new ResultsSnippet(Bundle.TruffleObjectsSection_ClassesInstancesCount(), typesByCountDisplayer, (ProfilerRenderer)typeRenderer, classesByCountRenderer){
                final /* synthetic */ ProfilerRenderer val$typeRenderer;
                final /* synthetic */ HideableBarRenderer val$classesByCountRenderer;
                {
                    this.val$typeRenderer = profilerRenderer;
                    this.val$classesByCountRenderer = hideableBarRenderer;
                    super(text, allDisplayer);
                }

                @Override
                protected void setupTable(ProfilerTable table) {
                    table.setColumnRenderer(0, this.val$typeRenderer);
                    table.setColumnRenderer(1, (ProfilerRenderer)this.val$classesByCountRenderer);
                    table.setDefaultColumnWidth(1, this.val$classesByCountRenderer.getNoBarWidth() + 10);
                }
            };
            Runnable typesBySizeDisplayer = new Runnable(){

                @Override
                public void run() {
                    TruffleObjectsView objectsView = (TruffleObjectsView)actions.findFeature(TruffleObjectsView.idFromLanguage(language));
                    if (objectsView != null) {
                        objectsView.configureTypesByObjectsSize();
                        actions.selectFeature((HeapViewerFeature)objectsView);
                    }
                }
            };
            this.typesBySize = new ResultsSnippet(Bundle.TruffleObjectsSection_ClassesInstancesSize(), typesBySizeDisplayer, (ProfilerRenderer)typeRenderer, sizeRenderer){
                final /* synthetic */ ProfilerRenderer val$typeRenderer;
                final /* synthetic */ HideableBarRenderer val$sizeRenderer;
                {
                    this.val$typeRenderer = profilerRenderer;
                    this.val$sizeRenderer = hideableBarRenderer;
                    super(text, allDisplayer);
                }

                @Override
                protected void setupTable(ProfilerTable table) {
                    table.setColumnRenderer(0, this.val$typeRenderer);
                    table.setColumnRenderer(1, (ProfilerRenderer)this.val$sizeRenderer);
                    table.setDefaultColumnWidth(1, this.val$sizeRenderer.getNoBarWidth() + 10);
                }
            };
            Splitter classesRow = new Splitter(1, this.typesByCount, this.typesBySize);
            Runnable objectsBySizeDisplayer = new Runnable(){

                @Override
                public void run() {
                    TruffleObjectsView objectsView = (TruffleObjectsView)actions.findFeature(TruffleObjectsView.idFromLanguage(language));
                    if (objectsView != null) {
                        objectsView.configureObjectsBySize();
                        actions.selectFeature((HeapViewerFeature)objectsView);
                    }
                }
            };
            this.objectsBySize = new ResultsSnippet(Bundle.TruffleObjectsSection_InstancesSize(), objectsBySizeDisplayer, (ProfilerRenderer)objectRenderer, sizeRenderer){
                final /* synthetic */ ProfilerRenderer val$objectRenderer;
                final /* synthetic */ HideableBarRenderer val$sizeRenderer;
                {
                    this.val$objectRenderer = profilerRenderer;
                    this.val$sizeRenderer = hideableBarRenderer;
                    super(text, allDisplayer);
                }

                @Override
                protected void setupTable(ProfilerTable table) {
                    table.setColumnRenderer(0, this.val$objectRenderer);
                    table.setColumnRenderer(1, (ProfilerRenderer)this.val$sizeRenderer);
                    table.setDefaultColumnWidth(1, this.val$sizeRenderer.getNoBarWidth() + 10);
                }
            };
            this.retainedAvailable = DataType.RETAINED_SIZE.valuesAvailable(heap);
            Runnable dominatorsByRetainedSizeDisplayer = new Runnable(){

                @Override
                public void run() {
                    TruffleObjectsView objectsView = (TruffleObjectsView)actions.findFeature(TruffleObjectsView.idFromLanguage(language));
                    if (objectsView != null) {
                        objectsView.configureDominatorsByRetainedSize();
                        actions.selectFeature((HeapViewerFeature)objectsView);
                    }
                }
            };
            this.dominatorsByRetainedSize = new ResultsSnippet(Bundle.TruffleObjectsSection_DominatorsRetainedSize(), dominatorsByRetainedSizeDisplayer, (ProfilerRenderer)objectRenderer){
                private Runnable retainedSizesUpdater;
                final /* synthetic */ ProfilerRenderer val$objectRenderer;
                {
                    this.val$objectRenderer = profilerRenderer;
                    super(text, allDisplayer);
                }

                @Override
                protected JComponent createComponent() {
                    if (retainedAvailable) {
                        return super.createComponent();
                    }
                    final JPanel p = new JPanel(new GridBagLayout());
                    p.setOpaque(false);
                    final JLabel l = new JLabel(Bundle.TruffleObjectsSection_ComputeRetainedSizesLbl(), 10);
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridy = 0;
                    c.fill = 0;
                    c.anchor = 18;
                    c.insets = new Insets(2, 2, 2, 2);
                    p.add((Component)l, c);
                    c = new GridBagConstraints();
                    c.gridx = 1;
                    c.gridy = 0;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 18;
                    c.insets = new Insets(0, 0, 0, 0);
                    p.add((Component)UIUtils.createFillerPanel(), c);
                    c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridy = 1;
                    c.fill = 0;
                    c.anchor = 18;
                    c.insets = new Insets(2, 2, 2, 2);
                    JButton lb = new JButton(Bundle.TruffleObjectsSection_ComputeRetainedSizesBtn()){

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            if (DataType.RETAINED_SIZE.computeValues(heap, null)) {
                                p.remove(this);
                                l.setText(Bundle.TruffleObjectsSection_ComputingRetainedSizes());
                                l.setIcon(Icons.getIcon((String)"HeapWalkerIcons.Progress"));
                                p.invalidate();
                                p.revalidate();
                                p.repaint();
                            }
                        }
                    };
                    final 11 rs = this;
                    this.retainedSizesUpdater = new Runnable(){

                        @Override
                        public void run() {
                            new RequestProcessor("Objects Summary Retained Sizes Worker").post(new Runnable(){

                                @Override
                                public void run() {
                                    this.computeDominators(rs);
                                    retainedAvailable = true;
                                    retainedSizesUpdater = null;
                                }
                            });
                        }
                    };
                    DataType.RETAINED_SIZE.notifyWhenAvailable(heap, this.retainedSizesUpdater);
                    p.add((Component)lb, c);
                    c = new GridBagConstraints();
                    c.gridx = 1;
                    c.gridy = 1;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 18;
                    c.insets = new Insets(0, 0, 0, 0);
                    p.add((Component)UIUtils.createFillerPanel(), c);
                    c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridy = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.fill = 1;
                    c.anchor = 18;
                    c.insets = new Insets(0, 0, 0, 0);
                    p.add((Component)UIUtils.createFillerPanel(), c);
                    return p;
                }

                @Override
                protected void setupTable(ProfilerTable table) {
                    table.setColumnRenderer(0, this.val$objectRenderer);
                    TreeTableViewColumn.RetainedSize dominatorsByRetainedSizeColumn = new TreeTableViewColumn.RetainedSize(heap);
                    HideableBarRenderer retainedRenderer = (HideableBarRenderer)dominatorsByRetainedSizeColumn.getRenderer();
                    table.setColumnRenderer(1, (ProfilerRenderer)retainedRenderer);
                    table.setDefaultColumnWidth(1, retainedRenderer.getNoBarWidth() + 10);
                }

                @Override
                void setRealModel(TableModel model) {
                    if (model.getRowCount() == 0) {
                        if (this.table == null) {
                            BorderLayout bl = (BorderLayout)this.getLayout();
                            Component c = bl.getLayoutComponent("Center");
                            if (c != null) {
                                this.remove(c);
                            }
                            DefaultTableModel _model = new DefaultTableModel(1, 1){
                                {
                                    super(x0, x1);
                                    this.setValueAt(Bundle.TruffleObjectsSection_NoDominators(), 0, 0);
                                }

                                @Override
                                public boolean isCellEditable(int row, int column) {
                                    return false;
                                }
                            };
                            this.table = this.createTable(_model);
                            this.table.setDefaultRenderer(Object.class, (ProfilerRenderer)new LabelRenderer());
                            this.add((Component)this.table, "Center");
                            Container parent = this.getParent();
                            if (parent != null) {
                                parent.invalidate();
                                parent.revalidate();
                                parent.repaint();
                            }
                        } else {
                            DefaultTableModel dmodel = (DefaultTableModel)this.table.getModel();
                            this.table.setDefaultRenderer(Object.class, (ProfilerRenderer)new LabelRenderer());
                            dmodel.setValueAt(Bundle.TruffleObjectsSection_NoDominators(), 0, 0);
                            dmodel.fireTableDataChanged();
                        }
                    } else {
                        super.setRealModel(model);
                    }
                }
            };
            Splitter instancesRow = new Splitter(1, this.objectsBySize, this.dominatorsByRetainedSize);
            this.component = new JPanel((LayoutManager)new VerticalLayout(false, 5)){

                @Override
                public Dimension getMinimumSize() {
                    Dimension dim = super.getMinimumSize();
                    dim.width = 0;
                    return dim;
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width = 100;
                    return dim;
                }
            };
            this.component.setOpaque(false);
            this.component.add(classesRow);
            this.component.add(instancesRow);
        }

        private void computeDominators(ResultsSnippet dominatorsByRetainedSize) {
            TruffleLanguageHeapFragment fragment = (TruffleLanguageHeapFragment)this.context.getFragment();
            Heap heap = fragment.getHeap();
            List<TruffleObject> dominators = this.dominators((TruffleLanguageHeapFragment)this.context.getFragment());
            Collections.sort(dominators, new Comparator<TruffleObject>(){

                @Override
                public int compare(TruffleObject o1, TruffleObject o2) {
                    return Long.compare(o2.getRetainedSize(), o1.getRetainedSize());
                }
            });
            int items = Math.min(5, dominators.size());
            TruffleObject[] dominatorsByRetainedSizeArr = dominators.subList(0, items).toArray(new TruffleObject[0]);
            Object[][] dominatorsByRetainedSizeData = new Object[dominatorsByRetainedSizeArr.length][2];
            for (int i = 0; i < dominatorsByRetainedSizeData.length; ++i) {
                TruffleObject object = dominatorsByRetainedSizeArr[i];
                dominatorsByRetainedSizeData[i][0] = ((TruffleLanguage)((Object)this.language)).createObjectNode((TruffleObject)object, object.getType());
                dominatorsByRetainedSizeData[i][1] = dominatorsByRetainedSizeArr[i].getRetainedSize();
            }
            this.configureSnippet(dominatorsByRetainedSize, dominatorsByRetainedSizeData);
        }

        private List<? extends TruffleObject> dominators(TruffleLanguageHeapFragment heapFragment) {
            int maxSearchInstances = 10000;
            List searchInstances = heapFragment.getHeap().getBiggestObjectsByRetainedSize(maxSearchInstances);
            Iterator searchInstancesI = searchInstances.iterator();
            while (searchInstancesI.hasNext()) {
                Instance instance = (Instance)searchInstancesI.next();
                if (((TruffleLanguage)((Object)this.language)).isLanguageObject(instance)) continue;
                searchInstancesI.remove();
            }
            Set<Instance> rootInstances = TruffleObjectsProvider.getDominatorRoots(searchInstances);
            ArrayList rootObjects = new ArrayList();
            for (Instance root : rootInstances) {
                rootObjects.add(((TruffleLanguage)((Object)this.language)).createObject(root));
            }
            return rootObjects;
        }

        private void configureSnippet(final ResultsSnippet snippet, Object[][] data) {
            final DefaultTableModel model = new DefaultTableModel(data, new Object[]{Bundle.TruffleObjectsSection_NameColumn(), Bundle.TruffleObjectsSection_ValueColumn()}){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    snippet.setRealModel(model);
                }
            });
        }

        private class ResultsSnippet
        extends JPanel {
            private final LinkButton link;
            protected ProfilerTable table;
            private boolean keepSelection;

            ResultsSnippet(String text, final Runnable allDisplayer) {
                super(new BorderLayout(0, 6));
                this.setOpaque(false);
                this.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
                JPanel sectionSeparator = new JPanel(new GridBagLayout());
                sectionSeparator.setOpaque(false);
                JLabel caption = new JLabel(text);
                caption.setFont(caption.getFont().deriveFont(1));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.weighty = 1.0;
                sectionSeparator.add((Component)caption, c);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(0, 5, 0, 0);
                sectionSeparator.add((Component)new JLabel("["), c);
                this.link = new LinkButton(Bundle.TruffleObjectsSection_ViewAll()){

                    @Override
                    protected void clicked() {
                        SwingUtilities.invokeLater(allDisplayer);
                    }
                };
                this.link.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 0;
                c.insets = new Insets(0, 0, 0, 0);
                sectionSeparator.add((Component)this.link, c);
                c = new GridBagConstraints();
                c.gridx = 3;
                c.gridy = 0;
                c.insets = new Insets(0, 0, 0, 0);
                sectionSeparator.add((Component)new JLabel("]"), c);
                c = new GridBagConstraints();
                c.gridx = 4;
                c.gridy = 0;
                c.weightx = 1.0;
                c.fill = 2;
                c.insets = new Insets(1, 4, 0, 0);
                sectionSeparator.add((Component)new SeparatorLine(), c);
                this.add((Component)sectionSeparator, "North");
                JComponent comp = this.createComponent();
                if (comp instanceof ProfilerTable) {
                    this.table = (ProfilerTable)comp;
                }
                if (comp != null) {
                    this.add((Component)comp, "Center");
                }
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 0;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }

            protected JComponent createComponent() {
                DefaultTableModel model = new DefaultTableModel(5, 1){
                    {
                        this.setValueAt(Bundle.TruffleObjectsSection_ComputingProgress(), 0, 0);
                    }

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                LabelRenderer renderer = new LabelRenderer(){

                    public void setValue(Object o, int i) {
                        super.setValue(o, i);
                        this.setIcon(o == null || o.toString().isEmpty() ? null : Icons.getIcon((String)"HeapWalkerIcons.Progress"));
                    }
                };
                ProfilerTable t = this.createTable(model);
                t.setDefaultRenderer(Object.class, (ProfilerRenderer)renderer);
                return t;
            }

            void setRealModel(TableModel model) {
                if (this.table == null) {
                    BorderLayout bl = (BorderLayout)this.getLayout();
                    Component c = bl.getLayoutComponent("Center");
                    if (c != null) {
                        this.remove(c);
                    }
                    this.table = this.createTable(model);
                    this.add((Component)this.table, "Center");
                    Container parent = this.getParent();
                    if (parent != null) {
                        parent.invalidate();
                        parent.revalidate();
                        parent.repaint();
                    }
                } else {
                    this.table.setModel(model);
                }
                this.setupTable(this.table);
                this.enableTableEvents(this.table);
                this.link.setEnabled(true);
            }

            protected void setupTable(ProfilerTable table) {
            }

            protected ProfilerTable createTable(TableModel model) {
                SummaryView.SimpleTable t = new SummaryView.SimpleTable(model, 0){

                    protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                        if (!(value instanceof HeapViewerNode)) {
                            return;
                        }
                        this.requestFocusInWindow();
                        HeapViewerNode node = (HeapViewerNode)value;
                        HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode((HeapViewerNode)node, (Collection)ObjectsSection.this.actionProviders, (HeapContext)ObjectsSection.this.context, (HeapViewerActions)ObjectsSection.this.actions, (HeapViewerNodeAction[])new HeapViewerNodeAction[0]);
                        nodeActions.populatePopup(popup);
                        if (popup.getComponentCount() > 0) {
                            popup.addSeparator();
                        }
                        popup.add(this.createCopyMenuItem());
                    }

                    public void performDefaultAction(ActionEvent e) {
                        if (!this.getRowSelectionAllowed()) {
                            return;
                        }
                        int row = this.getSelectedRow();
                        if (row == -1) {
                            return;
                        }
                        Object value = this.getValueForRow(row);
                        if (!(value instanceof HeapViewerNode)) {
                            return;
                        }
                        HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode((HeapViewerNode)((HeapViewerNode)value), (Collection)ObjectsSection.this.actionProviders, (HeapContext)ObjectsSection.this.context, (HeapViewerActions)ObjectsSection.this.actions, (HeapViewerNodeAction[])new HeapViewerNodeAction[0]);
                        nodeActions.performDefaultAction(e);
                    }

                    protected void popupShowing() {
                        ResultsSnippet.this.keepSelection = true;
                    }

                    protected void popupHidden() {
                        ResultsSnippet.this.keepSelection = false;
                        new Timer(100, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (!this.isFocusOwner()) {
                                    this.clearSelection();
                                }
                            }
                        }){
                            {
                                this.setRepeats(false);
                            }
                        }.start();
                    }
                };
                return t;
            }

            private void enableTableEvents(final ProfilerTable t) {
                t.setRowSelectionAllowed(true);
                t.addFocusListener((FocusListener)new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (!ResultsSnippet.this.keepSelection) {
                            t.clearSelection();
                        } else {
                            ResultsSnippet.this.keepSelection = false;
                        }
                    }
                });
                t.providePopupMenu(true);
                t.setSelectionOnMiddlePress(true);
                t.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isMiddleMouseButton(e)) {
                            int row = t.getSelectedRow();
                            if (row == -1) {
                                return;
                            }
                            Object value = t.getValueForRow(row);
                            if (!(value instanceof HeapViewerNode)) {
                                return;
                            }
                            HeapViewerNode node = (HeapViewerNode)value;
                            HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode((HeapViewerNode)node, (Collection)ObjectsSection.this.actionProviders, (HeapContext)ObjectsSection.this.context, (HeapViewerActions)ObjectsSection.this.actions, (HeapViewerNodeAction[])new HeapViewerNodeAction[0]);
                            ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
                            nodeActions.performMiddleButtonAction(ae);
                        }
                    }
                });
            }
        }
    }

    private static class TruffleOverviewSnippet
    extends JPanel {
        private final int fillerColumn;
        private final SummaryView.SimpleTable table;

        TruffleOverviewSnippet(String text, int itemsCount, int fillerColumn) {
            super(new BorderLayout(0, 6));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            this.add((Component)new SectionSeparator(text), "North");
            DefaultTableModel model = new DefaultTableModel(itemsCount, 2){
                {
                    super(x0, x1);
                    this.setValueAt(Bundle.TruffleSummaryView_ComputingProgress(), 0, 0);
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            LabelRenderer renderer = new LabelRenderer(){

                public void setValue(Object o, int i) {
                    super.setValue(o, i);
                    this.setIcon(o == null || o.toString().isEmpty() ? null : Icons.getIcon((String)"HeapWalkerIcons.Progress"));
                }
            };
            this.fillerColumn = fillerColumn;
            this.table = new SummaryView.SimpleTable((TableModel)model, fillerColumn);
            this.table.setColumnRenderer(0, (ProfilerRenderer)renderer, fillerColumn != 0);
            this.table.setColumnRenderer(1, (ProfilerRenderer)renderer, fillerColumn != 1);
            this.table.setFocusable(false);
            this.add((Component)this.table, "Center");
        }

        void setData(Object[][] data) {
            final DefaultTableModel model = new DefaultTableModel(data, new Object[]{Bundle.TruffleSummaryView_NameColumn(), Bundle.TruffleSummaryView_ValueColumn()}){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.setModel(model);
                    LabelRenderer r1 = new LabelRenderer();
                    r1.setFont(r1.getFont().deriveFont(1));
                    table.setColumnRenderer(0, (ProfilerRenderer)r1, fillerColumn != 0);
                    LabelRenderer r2 = new LabelRenderer();
                    r2.setHorizontalAlignment(4);
                    table.setColumnRenderer(1, (ProfilerRenderer)r2, fillerColumn != 1);
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            dim.width = 0;
            return dim;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 100;
            return dim;
        }
    }

    public static abstract class OverviewSection
    extends TruffleSummarySection {
        private final HeapContext context;
        private final int heapItemsCount;
        private final int environmentItemsCount;
        private JComponent component;
        private TruffleOverviewSnippet heapSnippet;
        private TruffleOverviewSnippet environmentSnippet;

        public OverviewSection(HeapContext context) {
            this(context, 3, 1);
        }

        public OverviewSection(HeapContext context, int heapItemsCount, int languageItemsCount) {
            super(Bundle.TruffleOverviewSection_Name(), Bundle.TruffleOverviewSection_Description());
            this.context = context;
            this.heapItemsCount = heapItemsCount;
            this.environmentItemsCount = languageItemsCount;
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.init();
            }
            return this.component;
        }

        public ProfilerToolbar getToolbar() {
            return null;
        }

        protected HeapContext getContext() {
            return this.context;
        }

        @Override
        protected final void computeData() {
            Object[][] heapData = new Object[this.heapItemsCount][2];
            this.computeHeapData(heapData);
            this.heapSnippet.setData(heapData);
            Object[][] environmentData = new Object[this.environmentItemsCount][2];
            this.computeEnvironmentData(environmentData);
            this.environmentSnippet.setData(environmentData);
        }

        protected void computeHeapData(Object[][] heapData) {
            TruffleLanguageHeapFragment fragment = (TruffleLanguageHeapFragment)this.context.getFragment();
            NumberFormat numberFormat = NumberFormat.getInstance();
            heapData[0][0] = Bundle.TruffleOverviewSection_SizeItem();
            heapData[0][1] = numberFormat.format(fragment.getHeapSize(null)) + " B";
            heapData[1][0] = Bundle.TruffleOverviewSection_TypesItem();
            heapData[1][1] = numberFormat.format(fragment.getTypes(null).size());
            heapData[2][0] = Bundle.TruffleOverviewSection_ObjectsItem();
            heapData[2][1] = numberFormat.format(fragment.getObjectsCount(null));
        }

        protected void computeEnvironmentData(Object[][] environmentData) {
            environmentData[0][0] = Bundle.TruffleOverviewSection_LanguageItem();
            environmentData[0][1] = this.getContext().getFragment().getDescription();
        }

        private void init() {
            this.heapSnippet = new TruffleOverviewSnippet(Bundle.TruffleOverviewSection_HeapSection(), this.heapItemsCount, 0);
            this.environmentSnippet = new TruffleOverviewSnippet(Bundle.TruffleOverviewSection_EnvironmentSection(), this.environmentItemsCount, 1);
            Splitter overviewRow = new Splitter(1, this.heapSnippet, this.environmentSnippet);
            this.component = new JPanel((LayoutManager)new VerticalLayout(false)){

                @Override
                public Dimension getMinimumSize() {
                    Dimension dim = super.getMinimumSize();
                    dim.width = 0;
                    return dim;
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width = 100;
                    return dim;
                }
            };
            this.component.setOpaque(false);
            this.component.add(overviewRow);
        }
    }

    public static abstract class TruffleSummarySection
    extends HeapView {
        public TruffleSummarySection(String name, String description) {
            super(name, description);
        }

        protected void computeData() {
        }
    }
}

