/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class AutoupdateCheckScheduler {
    private static RequestProcessor.Task regularlyCheck = null;
    private static final RequestProcessor REGULARLY_CHECK_TIMER = new RequestProcessor("auto-checker-reqularly-timer", 1, true);
    private static final Logger err = Logger.getLogger(AutoupdateCheckScheduler.class.getName());
    private static Notification updatesNotification = null;
    private static Runnable doCheckAvailableUpdates = new Runnable(){

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                Installer.RP.post(doCheckAvailableUpdates);
                return;
            }
            boolean bl = false;
            if (Utilities.shouldCheckAvailableUpdates()) {
                HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
                AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.UPDATE, null, false, hashSet);
                bl = hashSet != null && !hashSet.isEmpty();
                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.UPDATE, hashSet);
                Utilities.storeAcceptedLicenseIDs();
            }
            if (!bl && Utilities.shouldCheckAvailableNewPlugins()) {
                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.INSTALL, AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.INSTALL, null, false, null));
            }
            Installer.RP.post(doCheckLazyUpdates, 500);
        }
    };
    private static Runnable doCheck = new Runnable(){

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                Installer.RP.post(doCheck);
                return;
            }
            if (AutoupdateCheckScheduler.timeToCheck()) {
                AutoupdateCheckScheduler.scheduleRefreshProviders();
                if (AutoupdateCheckScheduler.getWaitPeriod() > 0 && regularlyCheck != null && regularlyCheck.getDelay() <= 0) {
                    regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, AutoupdateCheckScheduler.getWaitPeriod(), 1);
                }
            }
        }
    };
    private static Runnable doCheckLazyUpdates = new Runnable(){

        @Override
        public void run() {
            boolean bl;
            if (SwingUtilities.isEventDispatchThread()) {
                Installer.RP.post(doCheckLazyUpdates);
                return;
            }
            Collection<LazyInstallUnitWizardIterator.LazyUnit> collection = LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.UPDATE);
            boolean bl2 = bl = collection != null && !collection.isEmpty();
            if (Utilities.shouldCheckAvailableUpdates()) {
                AutoupdateCheckScheduler.notifyAvailable(collection, OperationWizardModel.OperationType.UPDATE);
            }
            if (!bl && Utilities.shouldCheckAvailableNewPlugins()) {
                Collection<LazyInstallUnitWizardIterator.LazyUnit> collection2 = LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.INSTALL);
                AutoupdateCheckScheduler.notifyAvailable(collection2, OperationWizardModel.OperationType.INSTALL);
            }
            for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                Utilities.showProviderNotification(updateUnitProvider);
            }
        }
    };

    private AutoupdateCheckScheduler() {
    }

    public static void signOn() {
        NotificationDisplayer.getDefault();
        AutoupdateSettings.generateIdentity();
        if (AutoupdateCheckScheduler.timeToCheck()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Installer.RP.post(doCheck, 5000);
                }
            });
        } else {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Installer.RP.post(doCheckLazyUpdates, 11000);
                }
            });
        }
    }

    private static void scheduleRefreshProviders() {
        AutoupdateCheckScheduler.refreshUpdateCenters(null);
        final long l = System.currentTimeMillis();
        RequestProcessor.Task task = Installer.RP.post(doCheckAvailableUpdates, 500);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                long l2 = (System.currentTimeMillis() - l - 500L) / 1000L;
                if (l2 > 0L) {
                    Utilities.putTimeOfInitialization(l2);
                }
            }
        });
    }

    private static Runnable getRefresher(final UpdateUnitProvider updateUnitProvider, final Collection<String> collection, final ProgressHandle progressHandle) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    err.log(Level.FINE, "Start refresh " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]");
                    updateUnitProvider.refresh(progressHandle, true);
                    PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                    if (pluginManagerUI != null && pluginManagerUI.initTask.isFinished()) {
                        pluginManagerUI.updateUnitsChanged();
                    }
                    Utilities.showProviderNotification(updateUnitProvider);
                }
                catch (IOException iOException) {
                    if (!(iOException instanceof UnknownHostException) && !(iOException.getCause() instanceof UnknownHostException)) {
                        err.log(Level.INFO, null, iOException);
                    }
                    if (collection != null) {
                        collection.add(iOException.getLocalizedMessage());
                    }
                }
                finally {
                    err.log(Level.FINEST, "Refresh of " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "] is finish.");
                }
            }
        };
    }

    public static void runCheckAvailableUpdates(int n) {
        Installer.RP.post(doCheckAvailableUpdates, n);
    }

    public static Collection<UpdateElement> checkUpdateElements(OperationWizardModel.OperationType operationType, Collection<String> collection, boolean bl, Collection<UpdateElement> collection2) {
        Object object;
        Object object2;
        List<UnitCategory> list;
        Object object5;
        err.log(Level.FINEST, "Check UpdateElements for " + (Object)((Object)operationType));
        if (bl) {
            object5 = ProgressHandleFactory.createHandle((String)"dummy-check-for-updates");
            ProgressHandleFactory.createProgressComponent((ProgressHandle)object5);
            object5.start();
            Collection<String> collection3 = AutoupdateCheckScheduler.refreshUpdateCenters(object5);
            if (collection != null && collection3 != null) {
                collection.addAll(collection3);
            }
        }
        object5 = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        boolean bl2 = OperationWizardModel.OperationType.UPDATE == operationType;
        List<UnitCategory> list2 = list = bl2 ? Utilities.makeUpdateCategories((List<UpdateUnit>)object5, false) : Utilities.makeAvailableCategories((List<UpdateUnit>)object5, false);
        if (list == null || list.isEmpty()) {
            err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") doesn't find any elements.");
            return null;
        }
        Set<Object> set = new HashSet<UpdateElement>();
        boolean bl3 = false;
        boolean bl4 = false;
        OperationContainer operationContainer = bl2 ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (UnitCategory unitCategory : list) {
            for (Unit unit : unitCategory.getUnits()) {
                if (unit instanceof Unit.Available) {
                    arrayList.add(((Unit.Available)unit).getRelevantElement());
                    continue;
                }
                if (unit instanceof Unit.CompoundUpdate) {
                    for (UpdateUnit updateUnit : ((Unit.CompoundUpdate)unit).getUpdateUnits()) {
                        arrayList.add(updateUnit.getAvailableUpdates().get(0));
                    }
                    if (((Unit.CompoundUpdate)unit).getRealUpdate() == null) continue;
                    arrayList.add(((Unit.CompoundUpdate)unit).getRealUpdate());
                    continue;
                }
                if (!(unit instanceof Unit.Update)) continue;
                arrayList.add(((Unit.Update)unit).getRelevantElement());
            }
        }
        for (UpdateElement updateElement : arrayList) {
            if (bl3 || !operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement)) continue;
            object2 = operationContainer.add(updateElement);
            if (object2 == null) {
                set.add(updateElement);
                continue;
            }
            HashSet hashSet = new HashSet(object2.getRequiredElements());
            object = object2.getBrokenDependencies();
            if (!object.isEmpty()) {
                err.log(Level.WARNING, "Plugin " + object2 + " cannot be installed because some dependencies cannot be satisfied: " + object);
                bl4 = true;
                break;
            }
            for (Object object3 : hashSet) {
                if (!object3.getUpdateUnit().isPending()) continue;
                err.log(Level.WARNING, "Plugin " + object2.getUpdateElement() + " depends on " + object3 + " in pending state.");
                bl3 = true;
                set = Collections.emptySet();
                break;
            }
            if (bl3) continue;
            operationContainer.add(hashSet);
            set.add(updateElement);
        }
        if (!bl3 && !operationContainer.listInvalid().isEmpty()) {
            err.log(Level.WARNING, "Plugins " + set + " cannot be installed, Install Container contains invalid elements " + operationContainer.listInvalid());
        }
        if (!bl3 && bl4) {
            set = new HashSet();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                UpdateElement updateElement;
                UpdateUnit updateUnit;
                Object object3;
                object2 = bl2 ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                if (!object2.canBeAdded(updateUnit = (updateElement = (UpdateElement)iterator.next()).getUpdateUnit(), updateElement)) continue;
                object = object2.add(updateElement);
                if (object == null) {
                    set.add(updateElement);
                    continue;
                }
                boolean bl5 = false;
                object3 = new HashSet(object.getRequiredElements());
                Object object4 = object3.iterator();
                while (object4.hasNext()) {
                    UpdateElement updateElement2 = (UpdateElement)object4.next();
                    if (!updateElement2.getUpdateUnit().isPending()) continue;
                    err.log(Level.WARNING, "Plugin " + updateElement + " depends on " + updateElement2 + " in pending state.");
                    bl5 = true;
                }
                if (bl5) continue;
                object2.add((Collection)object3);
                object4 = new HashSet();
                for (OperationContainer.OperationInfo operationInfo : object2.listAll()) {
                    object4.addAll(operationInfo.getBrokenDependencies());
                }
                if (object4.isEmpty() && object2.listInvalid().isEmpty()) {
                    set.add(updateElement);
                    continue;
                }
                object2.removeAll();
                if (!object4.isEmpty()) {
                    err.log(Level.WARNING, "Plugin " + updateElement + " cannot be installed because some dependencies cannot be satisfied: " + object4);
                    continue;
                }
                err.log(Level.WARNING, "Plugin " + updateElement + " cannot be installed, Install Container contains invalid elements " + object2.listInvalid());
            }
        }
        if (collection2 == null) {
            err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") returns " + set.size() + " elements.");
            return set;
        }
        for (UnitCategory unitCategory : list) {
            for (Unit unit : unitCategory.getUnits()) {
                assert (unit instanceof Unit.Update) : unit + " has to be instanceof Unit.Update";
                if (!(unit instanceof Unit.Update)) continue;
                collection2.add(((Unit.Update)unit).getRelevantElement());
            }
        }
        err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") returns " + collection2.size() + " visible elements (" + set.size() + " in all)");
        return set;
    }

    private static Collection<String> refreshUpdateCenters(ProgressHandle progressHandle) {
        long l = System.currentTimeMillis();
        HashSet<String> hashSet = new HashSet<String>();
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run refreshProviders in EQ!";
        HashSet<RequestProcessor.Task> hashSet2 = new HashSet<RequestProcessor.Task>();
        List list = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
        RequestProcessor requestProcessor = new RequestProcessor("autoupdate-refresh-providers", list.size(), false);
        for (UpdateUnitProvider updateUnitProvider : list) {
            RequestProcessor.Task task = requestProcessor.post(AutoupdateCheckScheduler.getRefresher(updateUnitProvider, hashSet, progressHandle));
            hashSet2.add(task);
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks...");
        for (RequestProcessor.Task task : hashSet2) {
            task.waitFinished();
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks is done.");
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (l2 > 0L) {
            Utilities.putTimeOfRefreshUpdateCenters(l2);
        }
        return hashSet;
    }

    private static boolean timeToCheck() {
        if (AutoupdateCheckScheduler.getReqularlyTimerTask() != null && AutoupdateCheckScheduler.getReqularlyTimerTask().getDelay() <= 0 && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            return true;
        }
        if (AutoupdateSettings.getLastCheck() == null) {
            return true;
        }
        switch (AutoupdateSettings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
            case 6: {
                return AutoupdateSettings.getLastCheck().getTime() + (long)AutoupdateSettings.getCheckInterval() < new Date().getTime();
            }
        }
        Date date = AutoupdateSettings.getLastCheck();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(9, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        switch (AutoupdateSettings.getPeriod()) {
            case 1: {
                gregorianCalendar.add(5, 1);
                break;
            }
            case 2: {
                gregorianCalendar.add(3, 1);
                break;
            }
            case 3: {
                gregorianCalendar.add(3, 2);
                break;
            }
            case 4: {
                gregorianCalendar.add(2, 1);
            }
        }
        return gregorianCalendar.getTime().before(new Date());
    }

    private static RequestProcessor.Task getReqularlyTimerTask() {
        if (regularlyCheck == null && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            int n;
            int n2 = n = AutoupdateCheckScheduler.getWaitPeriod();
            if (AutoupdateSettings.getLastCheck() != null) {
                n2 = n - (int)(System.currentTimeMillis() - AutoupdateSettings.getLastCheck().getTime());
            }
            if (n2 <= 0) {
                n2 = n;
            }
            regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, n2, 1);
        }
        return regularlyCheck;
    }

    private static int getWaitPeriod() {
        switch (AutoupdateSettings.getPeriod()) {
            case 5: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 86400000;
            }
            case 2: {
                return 604800000;
            }
            case 3: {
                return 1209600000;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 6: {
                return AutoupdateSettings.getCheckInterval();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAvailable(final Collection<LazyInstallUnitWizardIterator.LazyUnit> collection, final OperationWizardModel.OperationType operationType) {
        if (collection == null || collection.isEmpty()) {
            if (updatesNotification != null) {
                updatesNotification.clear();
                updatesNotification = null;
            }
            return;
        }
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                RequestProcessor.Task task = PluginManagerUI.getRunningTask();
                if (task != null && !task.isFinished()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_InstallInProgress"), 2));
                    return;
                }
                try {
                    bl = new InstallUnitWizard().invokeLazyWizard(collection, operationType, false);
                }
                finally {
                    if (bl) {
                        PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                        if (pluginManagerUI != null) {
                            pluginManagerUI.updateUnitsChanged();
                        }
                        Installer.RP.post(doCheckAvailableUpdates);
                    }
                }
            }
        };
        int n = collection.size();
        String string = n == 1 ? NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_ToolTip", (Object)n) : NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdatesFound_ToolTip", (Object)n);
        Class<AutoupdateCheckScheduler> clazz = AutoupdateCheckScheduler.class;
        synchronized (AutoupdateCheckScheduler.class) {
            if (updatesNotification != null) {
                updatesNotification.clear();
                updatesNotification = null;
            }
            updatesNotification = NotificationDisplayer.getDefault().notify(string, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/newUpdates.png", (boolean)false), NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_Hint"), actionListener, NotificationDisplayer.Priority.HIGH);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void notifyAvailableUpdates(Collection<UpdateElement> collection) {
        assert (collection != null && !collection.isEmpty()) : "Some updates found.";
        LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.UPDATE, collection);
        AutoupdateCheckScheduler.notifyAvailable(LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.UPDATE), OperationWizardModel.OperationType.UPDATE);
    }
}

