/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntime;
import org.graalvm.visualvm.lib.jfluid.server.system.Timers;

public class ProfilingPointServerHandler {
    private static ProfilingPointServerHandler[] profilingPointHandlers;
    private static int[] profilingPointIDs;
    private static ProfilingPointServerHandler instance;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ProfilingPointServerHandler getInstance(String clientInfo) {
        if (instance == null) {
            instance = new ProfilingPointServerHandler();
        }
        return instance;
    }

    public static synchronized void initInstances(int[] ppIDs, String[] handlerClassNames, String[] handlersInfo) {
        profilingPointIDs = ppIDs;
        profilingPointHandlers = ProfilingPointServerHandler.getInstances(handlerClassNames, handlersInfo);
    }

    public static ProfilingPointServerHandler getHandler(char handlerId) {
        int idx = Arrays.binarySearch(profilingPointIDs, (int)handlerId);
        if (idx >= 0) {
            return profilingPointHandlers[idx];
        }
        return null;
    }

    private static ProfilingPointServerHandler[] getInstances(String[] handlerClassNames, String[] handlersInfo) {
        ProfilingPointServerHandler[] handlers = new ProfilingPointServerHandler[handlerClassNames.length];
        for (int i = 0; i < handlerClassNames.length; ++i) {
            try {
                Method method = Class.forName(handlerClassNames[i]).getMethod("getInstance", class$java$lang$String == null ? ProfilingPointServerHandler.class$("java.lang.String") : class$java$lang$String);
                handlers[i] = (ProfilingPointServerHandler)method.invoke(null, handlersInfo[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return handlers;
    }

    public void profilingPointHit(int id) {
        long absTimeStamp = Timers.getCurrentTimeInCounts();
        this.profilingPointHit(id, absTimeStamp);
    }

    public void profilingPointHit(int id, long absTimeStamp) {
        ProfilerRuntime.writeProfilingPointHitEvent(id, absTimeStamp);
    }
}

