/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import org.netbeans.modules.autoupdate.services.MessageValidator;
import org.netbeans.modules.autoupdate.services.Utilities;

public class MessageDigestValidator
implements MessageValidator {
    private final MessageDigest messageDigest;
    private final byte[] expectedValue;
    private byte[] digestValue;

    public MessageDigestValidator(MessageDigest messageDigest, byte[] byArray) {
        Objects.requireNonNull(messageDigest, "messageDigenst must not be NULL");
        Objects.requireNonNull(byArray, "expectedValue must not be NULL");
        this.messageDigest = messageDigest;
        this.expectedValue = byArray;
    }

    @Override
    public void update(byte by) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.messageDigest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.messageDigest.update(byArray, n, n2);
    }

    @Override
    public void update(byte[] byArray) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.messageDigest.update(byArray);
    }

    @Override
    public void reset() {
        this.digestValue = null;
        this.messageDigest.reset();
    }

    @Override
    public boolean isValid() {
        return Arrays.equals(this.getDigestValue(), this.expectedValue);
    }

    private byte[] getDigestValue() {
        if (this.digestValue == null) {
            this.digestValue = this.messageDigest.digest();
        }
        return this.digestValue;
    }

    @Override
    public String getName() {
        return "Message Digest (" + this.messageDigest.getAlgorithm() + ")";
    }

    @Override
    public String getExpectedValueAsString() {
        if (this.expectedValue == null) {
            return "";
        }
        return Utilities.hexEncode(this.expectedValue);
    }

    @Override
    public String getRealValueAsString() {
        if (this.expectedValue == null) {
            return "";
        }
        return Utilities.hexEncode(this.getDigestValue());
    }
}

