/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.MessageDigestValidator;
import org.netbeans.modules.autoupdate.services.MessageMultiValidator;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.MessageDigestValue;

public interface MessageValidator {
    public static final Logger LOG = Logger.getLogger(MessageValidator.class.getName());

    public static MessageMultiValidator createFromMessageDigestValues(Collection<MessageDigestValue> collection) {
        ArrayList<MessageValidator> arrayList = new ArrayList<MessageValidator>();
        for (MessageDigestValue messageDigestValue : collection) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(messageDigestValue.getAlgorithm());
                arrayList.add(new MessageDigestValidator(messageDigest, Utilities.hexDecode(messageDigestValue.getValue())));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.log(Level.FINE, "Unsupported Hash Algorithm: {0}", messageDigestValue.getAlgorithm());
            }
        }
        return new MessageMultiValidator(arrayList);
    }

    public void update(byte[] var1, int var2, int var3);

    public void update(byte[] var1);

    public void update(byte var1);

    public void reset();

    public boolean isValid();

    public String getName();

    public String getExpectedValueAsString();

    public String getRealValueAsString();
}

