/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;

public class CustomUnitSelector
implements LinearKindOfQuantity.LinearUnitSelector {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final double[] unitMultiplierArr;
    protected final LinearUnit[] unitArr;
    protected final double[] tickMultiplierArr;
    protected final ArrayList<ITypedQuantity<LinearUnit>> tickList;
    protected final LinearKindOfQuantity.LinearUnitSelector smallSelector;
    protected final LinearKindOfQuantity.LinearUnitSelector bigSelector;

    public CustomUnitSelector(LinearKindOfQuantity kindOfQuantity, LinearKindOfQuantity.LinearUnitSelector smallSelector, Collection<LinearUnit> units, LinearKindOfQuantity.LinearUnitSelector bigSelector, SortedSet<ITypedQuantity<LinearUnit>> ticks) {
        int i;
        this.kindOfQuantity = kindOfQuantity;
        this.smallSelector = smallSelector;
        this.bigSelector = bigSelector;
        this.unitArr = units.toArray(new LinearUnit[units.size()]);
        Arrays.sort(this.unitArr);
        this.unitMultiplierArr = new double[this.unitArr.length];
        for (i = 0; i < this.unitArr.length; ++i) {
            this.unitMultiplierArr[i] = this.unitArr[i].valueTransformTo(kindOfQuantity.atomUnit).getMultiplier();
        }
        this.tickList = new ArrayList<ITypedQuantity<LinearUnit>>(ticks);
        this.tickMultiplierArr = new double[this.tickList.size()];
        for (i = 0; i < this.tickMultiplierArr.length; ++i) {
            this.tickMultiplierArr[i] = this.tickList.get(i).doubleValueIn(kindOfQuantity.atomUnit);
            if (i <= 0 || !(this.tickMultiplierArr[i] > this.tickMultiplierArr[i - 1] * 2.0)) continue;
            throw new IllegalArgumentException("Tick with growth factor > 2: " + this.tickList.get(i));
        }
        this.tickList.add(0, this.tickList.get(0));
    }

    @Override
    public LinearUnit getPreferredUnit(ITypedQuantity<LinearUnit> quantity, double minNumericalValue, double maxNumericalValue) {
        double scaledVal;
        LinearUnit atomUnit = this.kindOfQuantity.atomUnit;
        double absVal = Math.abs(quantity.doubleValueIn(atomUnit));
        double d = scaledVal = minNumericalValue > 1.0 ? absVal / minNumericalValue : absVal;
        if (scaledVal < this.unitMultiplierArr[0]) {
            return this.smallSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
        }
        if (absVal < this.unitMultiplierArr[this.unitArr.length - 1] * maxNumericalValue) {
            for (int i = 1; i < this.unitMultiplierArr.length; ++i) {
                if (!(scaledVal < this.unitMultiplierArr[i])) continue;
                return this.unitArr[i - 1];
            }
            return this.unitArr[this.unitArr.length - 1];
        }
        return this.bigSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
    }

    @Override
    public ITypedQuantity<LinearUnit> snapToBestBetweenHalfAndEqual(ITypedQuantity<LinearUnit> upperLimit) {
        assert (Math.abs(upperLimit.doubleValue()) > 0.0);
        double absVal = Math.abs(upperLimit.doubleValueIn(this.kindOfQuantity.atomUnit));
        if (absVal < this.tickMultiplierArr[0]) {
            return this.smallSelector.snapToBestBetweenHalfAndEqual(upperLimit);
        }
        if (absVal > this.tickMultiplierArr[this.tickMultiplierArr.length - 1]) {
            return this.bigSelector.snapToBestBetweenHalfAndEqual(upperLimit);
        }
        int pos = Arrays.binarySearch(this.tickMultiplierArr, absVal);
        if (pos < 0) {
            pos = -1 - pos;
        }
        return this.tickList.get(pos);
    }

    @Override
    public LinearUnit getLargestExactUnit(ITypedQuantity<LinearUnit> quantity) {
        int pos;
        if (quantity.doubleValue() == 0.0) {
            return (LinearUnit)quantity.getUnit();
        }
        double absVal = Math.abs(quantity.doubleValueIn(this.kindOfQuantity.atomUnit));
        if (absVal < this.unitMultiplierArr[0]) {
            return this.smallSelector.getLargestExactUnit(quantity);
        }
        if (absVal > this.unitMultiplierArr[this.unitMultiplierArr.length - 1]) {
            LinearUnit bigUnit = this.bigSelector.getLargestExactUnit(quantity);
            if (bigUnit != null) {
                return bigUnit;
            }
            pos = this.unitMultiplierArr.length - 1;
        } else {
            pos = Arrays.binarySearch(this.unitMultiplierArr, absVal);
            if (pos >= 0) {
                return this.unitArr[pos];
            }
            pos = -1 - pos;
        }
        while (pos >= 0) {
            if (absVal % this.unitMultiplierArr[pos] == 0.0) {
                return this.unitArr[pos];
            }
            --pos;
        }
        return this.smallSelector.getLargestExactUnit(quantity);
    }
}

