/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.lib.charts.ChartComponent;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartSelectionModel;
import org.graalvm.visualvm.lib.charts.ItemPainter;
import org.graalvm.visualvm.lib.charts.PaintersModel;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.axis.TimeAxisUtils;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.XYItemPainter;
import org.graalvm.visualvm.lib.charts.xy.XYItemSelection;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.ProbeItemDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbe;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbeDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.details.DetailsPanel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.details.DetailsTableModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.export.DataExport;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.options.TracerOptions;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.PointsComputer;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineChart;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineLegendOverlay;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelinePaintersFactory;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineSelectionManager;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineTooltipOverlay;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineTooltipPainter;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineUnitsOverlay;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineXYItem;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineXYPainter;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;

public final class TimelineSupport {
    public static final int[] EMPTY_TIMESTAMPS = new int[0];
    private final TimelineChart chart;
    private final TimelineModel model;
    private final SynchronousXYItemsModel itemsModel;
    private final PointsComputer pointsComputer;
    private final TimelineTooltipOverlay tooltips;
    private final TimelineLegendOverlay legend;
    private final TimelineUnitsOverlay units;
    private final List<TracerProbe> probes = new ArrayList<TracerProbe>();
    private final List<TimelineChart.Row> rows = new ArrayList<TimelineChart.Row>();
    private final DescriptorResolver descriptorResolver;
    private final Set<ValuesListener> valuesListeners = new HashSet<ValuesListener>();
    private final Set<Integer> selectedTimestamps = new HashSet<Integer>();
    private final List<Integer> selectedIntervals = new ArrayList<Integer>();
    private final Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();
    private final IdeSnapshot snapshot;
    private ComponentListener chartResizeHandler;
    private DetailsTableModel detailsModel;
    private static final int SCROLL_MARGIN_LEFT = 10;
    private static final int SCROLL_MARGIN_RIGHT = 50;
    private boolean hovering;
    private boolean hoveredSelected;
    private int startIndex = -1;
    private int endIndex = -1;

    public TimelineSupport(DescriptorResolver descriptorResolver, IdeSnapshot snapshot) {
        this.descriptorResolver = descriptorResolver;
        this.snapshot = snapshot;
        this.model = new TimelineModel();
        this.itemsModel = new SynchronousXYItemsModel((Timeline)this.model);
        this.chart = new TimelineChart(this.itemsModel);
        TimelineSelectionManager selectionManager = new TimelineSelectionManager();
        this.chart.setSelectionModel(selectionManager);
        selectionManager.registerChart((ChartComponent)this.chart);
        this.tooltips = new TimelineTooltipOverlay(this);
        this.chart.addOverlayComponent(this.tooltips);
        this.pointsComputer = new PointsComputer();
        this.legend = new TimelineLegendOverlay(this.chart);
        this.legend.setVisible(TracerOptions.getInstance().isShowLegendEnabled());
        this.chart.addOverlayComponent(this.legend);
        this.units = new TimelineUnitsOverlay(this.chart);
        this.units.setVisible(TracerOptions.getInstance().isShowValuesEnabled());
        this.chart.addOverlayComponent(this.units);
    }

    TimelineChart getChart() {
        return this.chart;
    }

    PointsComputer getPointsComputer() {
        return this.pointsComputer;
    }

    public void dataLoadingStarted(final long range) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.cleanResizeHandler();
                TimelineSupport.this.chartResizeHandler = new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        TimelineSupport.this.chart.setScale((double)TimelineSupport.this.chart.getWidth() / (double)range, 1.0);
                    }
                };
                TimelineSupport.this.chart.addComponentListener(TimelineSupport.this.chartResizeHandler);
                TimelineSupport.this.chart.setFitsWidth(false);
                TimelineSupport.this.chartResizeHandler.componentResized(null);
            }
        });
    }

    public void dataLoadingFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.cleanResizeHandler();
                TimelineSupport.this.chart.setFitsWidth(true);
                TimelineSupport.this.chart.invalidateRepaint();
            }
        });
    }

    private void cleanResizeHandler() {
        if (this.chartResizeHandler != null) {
            this.chart.removeComponentListener(this.chartResizeHandler);
            this.chartResizeHandler = null;
        }
    }

    public void setShowValuesEnabled(boolean enabled) {
        this.units.setVisible(enabled);
    }

    public boolean isShowValuesEnabled() {
        return this.units.isVisible();
    }

    public void setShowLegendEnabled(boolean enabled) {
        this.legend.setVisible(enabled);
    }

    public boolean isShowLegendEnabled() {
        return this.legend.isVisible();
    }

    public void addProbe(final TracerProbe probe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.resetValues();
                TimelineChart.Row row = TimelineSupport.this.chart.addRow();
                TimelineSupport.this.probes.add(probe);
                TimelineSupport.this.rows.add(row);
                ProbeItemDescriptor[] itemDescriptors = probe.getItemDescriptors();
                SynchronousXYItem[] items = TimelineSupport.this.model.createItems(itemDescriptors);
                XYItemPainter[] painters = new XYItemPainter[items.length];
                for (int i = 0; i < painters.length; ++i) {
                    painters[i] = TimelinePaintersFactory.createPainter(itemDescriptors[i], i, TimelineSupport.this.pointsComputer, TimelineSupport.this.snapshot);
                }
                row.addItems(items, (ItemPainter[])painters);
                TimelineSupport.this.setupOverlays();
            }
        });
    }

    public void removeProbe(final TracerProbe probe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSupport.this.resetValues();
                TimelineChart.Row row = TimelineSupport.this.getRow(probe);
                TimelineSupport.this.chart.removeRow(row);
                TimelineSupport.this.model.removeItems(row.getItems());
                TimelineSupport.this.rows.remove(row);
                TimelineSupport.this.probes.remove(probe);
                TimelineSupport.this.setupOverlays();
            }
        });
    }

    public List<TracerProbe> getProbes() {
        return this.probes;
    }

    public int getItemsCount() {
        return this.model.getItemsCount();
    }

    public boolean hasData() {
        return this.model.getTimestampsCount() > 0;
    }

    public long getTimestamp(int index) {
        return this.model.getTimestamp(index);
    }

    private void setupOverlays() {
        final int rowsCount = this.chart.getRowsCount();
        TimelineTooltipPainter.Model[] rowModels = new TimelineTooltipPainter.Model[rowsCount];
        for (int rowIndex = 0; rowIndex < rowModels.length; ++rowIndex) {
            TimelineChart.Row row = this.chart.getRow(rowIndex);
            TracerProbe probe = this.getProbe(row);
            final int itemsCount = row.getItemsCount();
            final String[] rowNames = new String[itemsCount];
            final ValueItemDescriptor[] viDescriptors = new ValueItemDescriptor[itemsCount];
            final String[] unitsStrings = new String[itemsCount];
            for (int itemIndex = 0; itemIndex < itemsCount; ++itemIndex) {
                rowNames[itemIndex] = ((TimelineXYItem)row.getItem(itemIndex)).getName();
                viDescriptors[itemIndex] = (ValueItemDescriptor)probe.getItemDescriptors()[itemIndex];
                unitsStrings[itemIndex] = viDescriptors[itemIndex].getUnitsString(0);
            }
            rowModels[rowIndex] = new TimelineTooltipPainter.Model(){

                @Override
                public int getRowsCount() {
                    return itemsCount;
                }

                @Override
                public String getRowName(int index) {
                    return rowNames[index];
                }

                @Override
                public String getRowValue(int index, long itemValue) {
                    return viDescriptors[index].getValueString(itemValue, 0);
                }

                @Override
                public String getRowUnits(int index) {
                    return unitsStrings[index];
                }
            };
        }
        this.tooltips.setupModel(rowModels);
        this.units.setupModel(new TimelineUnitsOverlay.Model(){
            private final String LAST_UNITS_STRING = "lastUnitsString";
            private Color[][] rowColors = new Color[rowsCount][];
            private String[][] rowMinValues = new String[rowsCount][];
            private String[][] rowMaxValues = new String[rowsCount][];
            private List<Color> visibleRowItemColors;
            private List<String> visibleRowItemMinValues;
            private List<String> visibleRowItemMaxValues;

            @Override
            public void prefetch() {
                PaintersModel paintersModel = TimelineSupport.this.chart.getPaintersModel();
                for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
                    TimelineChart.Row row = TimelineSupport.this.chart.getRow(rowIndex);
                    TracerProbe probe = TimelineSupport.this.getProbe(row);
                    int rowItemsCount = row.getItemsCount();
                    ChartContext rowContext = row.getContext();
                    long commonMinY = rowContext.getDataOffsetY();
                    long commonMaxY = commonMinY + rowContext.getDataHeight();
                    if (this.visibleRowItemColors != null) {
                        this.visibleRowItemColors.clear();
                        this.visibleRowItemMinValues.clear();
                        this.visibleRowItemMaxValues.clear();
                    } else {
                        this.visibleRowItemColors = new ArrayList<Color>(rowItemsCount);
                        this.visibleRowItemMinValues = new ArrayList<String>(rowItemsCount);
                        this.visibleRowItemMaxValues = new ArrayList<String>(rowItemsCount);
                    }
                    boolean sameFactorUnits = true;
                    double lastDataFactor = -1.0;
                    String lastUnitsString = "lastUnitsString";
                    for (int itemIndex = 0; itemIndex < rowItemsCount; ++itemIndex) {
                        TimelineXYItem item = (TimelineXYItem)row.getItem(itemIndex);
                        TimelineXYPainter painter = (TimelineXYPainter)paintersModel.getPainter((ChartItem)item);
                        if (!painter.isPainting()) continue;
                        this.visibleRowItemColors.add(painter.getDefiningColor());
                        ValueItemDescriptor descriptor = (ValueItemDescriptor)probe.getItemDescriptors()[itemIndex];
                        double dataFactor = descriptor.getDataFactor();
                        String unitsString = descriptor.getUnitsString(1);
                        if (sameFactorUnits) {
                            if (lastDataFactor == -1.0) {
                                lastDataFactor = dataFactor;
                            } else if (lastDataFactor != dataFactor) {
                                sameFactorUnits = false;
                            }
                            lastDataFactor = dataFactor;
                            if (lastUnitsString == "lastUnitsString") {
                                lastUnitsString = unitsString;
                            } else if (!this.equals(lastUnitsString, unitsString)) {
                                sameFactorUnits = false;
                            }
                            lastUnitsString = unitsString;
                        }
                        String minValueString = descriptor.getValueString((long)((double)commonMinY / painter.dataFactor), 1);
                        this.visibleRowItemMinValues.add(unitsString == null ? minValueString : minValueString + " " + unitsString);
                        String maxValueString = descriptor.getValueString((long)((double)commonMaxY / painter.dataFactor), 1);
                        this.visibleRowItemMaxValues.add(unitsString == null ? maxValueString : maxValueString + " " + unitsString);
                    }
                    if (sameFactorUnits) {
                        this.rowColors[rowIndex] = new Color[]{null};
                        this.rowMinValues[rowIndex] = new String[]{this.visibleRowItemMinValues.get(0)};
                        this.rowMaxValues[rowIndex] = new String[]{this.visibleRowItemMaxValues.get(0)};
                        continue;
                    }
                    this.rowColors[rowIndex] = this.visibleRowItemColors.toArray(new Color[0]);
                    this.rowMinValues[rowIndex] = this.visibleRowItemMinValues.toArray(new String[0]);
                    this.rowMaxValues[rowIndex] = this.visibleRowItemMaxValues.toArray(new String[0]);
                }
            }

            @Override
            public Color[] getColors(TimelineChart.Row row) {
                return this.rowColors[row.getIndex()];
            }

            @Override
            public String[] getMinUnits(TimelineChart.Row row) {
                return this.rowMinValues[row.getIndex()];
            }

            @Override
            public String[] getMaxUnits(TimelineChart.Row row) {
                return this.rowMaxValues[row.getIndex()];
            }

            private boolean equals(String s1, String s2) {
                if (s1 == null) {
                    return s2 == null;
                }
                return s1.equals(s2);
            }
        });
    }

    TimelineChart.Row getRow(TracerProbe probe) {
        return this.rows.get(this.probes.indexOf(probe));
    }

    TracerProbe getProbe(TimelineChart.Row row) {
        return this.probes.get(this.rows.indexOf(row));
    }

    TracerProbeDescriptor getDescriptor(TracerProbe p) {
        return this.descriptorResolver.getDescriptor(p);
    }

    public void addValues(long timestamp, long[] newValues) {
        int newRow = this.detailsModel == null ? -1 : this.detailsModel.getRowCount();
        this.model.addValues(timestamp, newValues);
        this.itemsModel.valuesAdded();
        if (newRow != -1) {
            this.detailsModel.fireTableRowsInserted(newRow, newRow);
        }
        this.fireValuesAdded();
    }

    public void resetValues() {
        this.model.reset();
        this.itemsModel.valuesReset();
        this.resetSelectedTimestamps();
        this.pointsComputer.reset();
        if (this.detailsModel != null) {
            this.detailsModel.fireTableStructureChanged();
        }
        this.fireValuesReset();
    }

    public void exportAllValues(String title) {
        final int rowsCount = this.model.getTimestampsCount();
        final int columnsCount = this.model.getItemsCount();
        final SimpleDateFormat timeFormatter = new SimpleDateFormat(MessageFormat.format("{0}, {1}", TimeAxisUtils.TIME_MSEC, TimeAxisUtils.DATE_YEAR));
        ArrayList<ProbeItemDescriptor> probeDescriptors = new ArrayList<ProbeItemDescriptor>(columnsCount);
        for (TracerProbe probe : this.probes) {
            probeDescriptors.addAll(Arrays.asList(probe.getItemDescriptors()));
        }
        final ValueItemDescriptor[] descriptors = new ValueItemDescriptor[columnsCount];
        for (int i = 0; i < columnsCount; ++i) {
            descriptors[i] = (ValueItemDescriptor)probeDescriptors.get(i);
        }
        AbstractTableModel exportModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return rowsCount;
            }

            @Override
            public int getColumnCount() {
                return columnsCount + 1;
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Time [ms]";
                }
                String unitsString = descriptors[columnIndex - 1].getUnitsString(3);
                unitsString = unitsString == null ? "" : " [" + unitsString + "]";
                return TimelineSupport.this.itemsModel.getItem(columnIndex - 1).getName() + unitsString;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return timeFormatter.format(TimelineSupport.this.model.getTimestamp(rowIndex));
                }
                long value = TimelineSupport.this.itemsModel.getItem(columnIndex - 1).getYValue(rowIndex);
                return descriptors[columnIndex - 1].getValueString(value, 3);
            }
        };
        DataExport.exportData(exportModel, title);
    }

    public void exportDetailsValues(String title) {
        if (this.detailsModel == null) {
            return;
        }
        final int rowsCount = this.detailsModel.getRowCount();
        final int columnsCount = this.detailsModel.getColumnCount();
        final SimpleDateFormat timeFormatter = new SimpleDateFormat(MessageFormat.format("{0}, {1}", TimeAxisUtils.TIME_MSEC, TimeAxisUtils.DATE_YEAR));
        AbstractTableModel exportModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return rowsCount;
            }

            @Override
            public int getColumnCount() {
                return columnsCount - 1;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return TimelineSupport.this.detailsModel.getColumnName(columnIndex + 1);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = TimelineSupport.this.detailsModel.getValueAt(rowIndex, columnIndex + 1);
                if (columnIndex == 0) {
                    return timeFormatter.format(value);
                }
                return TimelineSupport.this.detailsModel.getDescriptor(columnIndex + 1).getValueString((Long)value, 3);
            }
        };
        DataExport.exportData(exportModel, title);
    }

    public void addValuesListener(ValuesListener listener) {
        this.valuesListeners.add(listener);
    }

    public void removeValuesListener(ValuesListener listener) {
        this.valuesListeners.remove(listener);
    }

    private void fireValuesAdded() {
        for (ValuesListener listener : this.valuesListeners) {
            listener.valuesAdded();
        }
    }

    private void fireValuesReset() {
        for (ValuesListener listener : this.valuesListeners) {
            listener.valuesReset();
        }
    }

    public boolean isRowSelection() {
        return this.chart.isRowSelection();
    }

    public TableModel getDetailsModel() {
        this.detailsModel = !this.chart.isRowSelection() ? null : this.createSelectionModel();
        return this.detailsModel;
    }

    private DetailsTableModel createSelectionModel() {
        List<SynchronousXYItem> selectedItems = this.getSelectedItems();
        final List<ValueItemDescriptor> selectedDescriptors = this.getSelectedDescriptors();
        int selectedItemsCount = selectedItems.size();
        final int columnCount = selectedItemsCount + 2;
        final SynchronousXYItem[] selectedItemsArr = selectedItems.toArray(new SynchronousXYItem[0]);
        final String[] columnNames = new String[columnCount];
        columnNames[0] = "Mark";
        columnNames[1] = "Time [ms]";
        final String[] columnTooltips = new String[columnCount];
        columnTooltips[0] = "Mark a timestamp in Timeline view";
        columnTooltips[1] = "Timestamp of the data";
        for (int i = 2; i < columnCount; ++i) {
            String itemName = selectedItemsArr[i - 2].getName();
            String unitsString = selectedDescriptors.get(i - 2).getUnitsString(2);
            unitsString = unitsString == null ? "" : " [" + unitsString + "]";
            columnNames[i] = itemName + unitsString;
            columnTooltips[i] = selectedDescriptors.get(i - 2).getDescription();
        }
        return new DetailsTableModel(){

            @Override
            public int getRowCount() {
                return TimelineSupport.this.model.getTimestampsCount();
            }

            @Override
            public int getColumnCount() {
                return columnCount;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return columnNames[columnIndex];
            }

            @Override
            public String getColumnTooltip(int columnIndex) {
                return columnTooltips[columnIndex];
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return DetailsPanel.class;
                }
                return Long.class;
            }

            @Override
            public ValueItemDescriptor getDescriptor(int columnIndex) {
                if (columnIndex == 0) {
                    return null;
                }
                if (columnIndex == 1) {
                    return null;
                }
                return (ValueItemDescriptor)selectedDescriptors.get(columnIndex - 2);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return TimelineSupport.this.selectedTimestamps.contains(rowIndex);
                }
                if (columnIndex == 1) {
                    return TimelineSupport.this.model.getTimestamp(rowIndex);
                }
                return selectedItemsArr[columnIndex - 2].getYValue(rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (Boolean.TRUE.equals(aValue)) {
                    TimelineSupport.this.selectTimestamp(rowIndex, true, false);
                } else {
                    TimelineSupport.this.unselectTimestamp(rowIndex, false);
                }
            }
        };
    }

    void setTimestampHovering(boolean hovering, boolean hoveredSelected) {
        this.hovering = hovering;
        this.hoveredSelected = hoveredSelected;
        this.notifyTimeSelectionChanged();
    }

    public void selectTimestamp(int index, boolean scrollToVisible) {
        this.selectTimestamp(index, scrollToVisible, true);
    }

    private void selectTimestamp(int index, boolean scrollToVisible, boolean notifyTable) {
        boolean change = this.selectedTimestamps.add(index);
        if (notifyTable && this.detailsModel != null) {
            this.detailsModel.fireTableCellUpdated(index, 0);
        }
        if (change) {
            this.updateSelectedItems();
            this.notifyTimeSelectionChanged();
            if (scrollToVisible) {
                this.highlightTimestamp(index);
            }
        }
    }

    public void unselectTimestamp(int index) {
        this.unselectTimestamp(index, true);
    }

    public void toggleTimestampSelection(int index) {
        if (!this.selectedTimestamps.contains(index)) {
            this.selectTimestamp(index, false);
        } else {
            this.unselectTimestamp(index);
        }
    }

    public boolean isTimestampSelected(int index) {
        return this.selectedTimestamps.contains(index);
    }

    public boolean isTimestampSelection(boolean includeHover) {
        int selectedTimestampsCount = this.selectedTimestamps.size();
        if (selectedTimestampsCount == 0) {
            return false;
        }
        if (selectedTimestampsCount > 1) {
            return true;
        }
        return includeHover || !this.hovering || this.hoveredSelected;
    }

    private void unselectTimestamp(int index, boolean notifyTable) {
        boolean change = this.selectedTimestamps.remove(index);
        if (notifyTable && this.detailsModel != null) {
            this.detailsModel.fireTableCellUpdated(index, 0);
        }
        if (change) {
            this.updateSelectedItems();
            this.notifyTimeSelectionChanged();
        }
    }

    public void resetSelectedTimestamps() {
        if (this.selectedTimestamps.isEmpty()) {
            return;
        }
        this.selectedTimestamps.clear();
        if (this.detailsModel != null) {
            this.detailsModel.fireTableDataChanged();
        }
        this.updateSelectedItems();
        this.notifyTimeSelectionChanged();
    }

    private void updateSelectedItems() {
        List<SynchronousXYItem> selectedItems = this.getSelectedItems();
        ArrayList<XYItemSelection.Default> selections = new ArrayList<XYItemSelection.Default>(selectedItems.size() * this.selectedTimestamps.size());
        for (int selectedIndex : this.selectedTimestamps) {
            for (SynchronousXYItem selectedItem : selectedItems) {
                selections.add(new XYItemSelection.Default((XYItem)selectedItem, selectedIndex, Integer.MAX_VALUE));
            }
        }
        this.chart.getSelectionModel().setSelectedItems(selections);
    }

    public Set<Integer> getSelectedTimestamps() {
        return this.selectedTimestamps;
    }

    public void selectInterval(int index1, int index2) {
        this.selectedIntervals.add(index1);
        this.selectedIntervals.add(index2);
    }

    public List<Integer> getSelectedIntervals() {
        return this.selectedIntervals;
    }

    public void resetSelectedIntervals() {
        this.selectedIntervals.clear();
    }

    public void selectedIntervalsChanged() {
        this.notifyIntervalsSelectionChanged();
    }

    private void highlightTimestamp(int selectedIndex) {
        ChartSelectionModel selectionModel = this.chart.getSelectionModel();
        List oldSelection = selectionModel.getHighlightedItems();
        int oldSelectedIndex = -1;
        if (!oldSelection.isEmpty()) {
            XYItemSelection sel = (XYItemSelection)oldSelection.get(0);
            oldSelectedIndex = sel.getValueIndex();
        }
        if (selectedIndex != -1) {
            this.scrollChartToSelection(oldSelectedIndex, selectedIndex);
        }
    }

    public void scrollChartToIndex(int index) {
        this.scrollChartToSelection(-1, index);
    }

    private void scrollChartToSelection(int oldIndex, int newIndex) {
        long oldOffsetX;
        Timeline timeline = this.itemsModel.getTimeline();
        ChartContext context = this.chart.getChartContext();
        long dataOffsetX = context.getDataOffsetX();
        long newDataX = timeline.getTimestamp(newIndex);
        long newOffsetX = (long)context.getViewWidth((double)(newDataX - dataOffsetX));
        long offsetX = this.chart.getOffsetX();
        long viewWidth = context.getViewportWidth();
        if (newOffsetX >= offsetX + 10L && newOffsetX <= offsetX + viewWidth - 50L) {
            return;
        }
        long oldDataX = oldIndex == -1 ? -1L : timeline.getTimestamp(oldIndex);
        long l = oldOffsetX = oldIndex == -1 ? -1L : (long)context.getViewWidth((double)(oldDataX - dataOffsetX));
        if (oldIndex == -1) {
            this.chart.setOffset(newOffsetX - (long)(context.getViewportWidth() / 2), this.chart.getOffsetY());
        } else if (oldOffsetX > newOffsetX) {
            this.chart.setOffset(newOffsetX - 10L, this.chart.getOffsetY());
        } else {
            this.chart.setOffset(newOffsetX - (long)context.getViewportWidth() + 50L, this.chart.getOffsetY());
        }
        this.chart.repaintDirty();
    }

    private List<SynchronousXYItem> getSelectedItems() {
        List<TimelineChart.Row> selectedRows = this.chart.getSelectedRows();
        ArrayList<SynchronousXYItem> selectedItems = new ArrayList<SynchronousXYItem>();
        for (TimelineChart.Row selectedRow : selectedRows) {
            selectedItems.addAll(Arrays.asList(selectedRow.getItems()));
        }
        return selectedItems;
    }

    private List<ValueItemDescriptor> getSelectedDescriptors() {
        List<TimelineChart.Row> selectedRows = this.chart.getSelectedRows();
        ArrayList<ValueItemDescriptor> selectedDescriptors = new ArrayList<ValueItemDescriptor>();
        for (TimelineChart.Row selectedRow : selectedRows) {
            selectedDescriptors.addAll(Arrays.asList(this.getProbe(selectedRow).getItemDescriptors()));
        }
        return selectedDescriptors;
    }

    public void selectAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineSelectionManager selection = (TimelineSelectionManager)TimelineSupport.this.chart.getSelectionModel();
                selection.selectAll();
                TimelineSupport.this.startIndex = selection.getStartIndex();
                TimelineSupport.this.endIndex = selection.getEndIndex();
                TimelineSupport.this.notifyIndexSelectionChanged();
            }
        });
    }

    public boolean isSelectAll() {
        return this.endIndex - this.startIndex == this.model.getTimestampsCount() - 1;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    void indexSelectionChanged(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.notifyIndexSelectionChanged();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void notifyIntervalsSelectionChanged() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.intervalsSelectionChanged();
        }
    }

    private void notifyIndexSelectionChanged() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.indexSelectionChanged();
        }
    }

    private void notifyTimeSelectionChanged() {
        boolean sel = this.isTimestampSelection(true);
        boolean hov = sel && !this.isTimestampSelection(false);
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.timeSelectionChanged(sel, hov);
        }
    }

    public static interface DescriptorResolver {
        public TracerProbeDescriptor getDescriptor(TracerProbe var1);
    }

    public static interface SelectionListener {
        public void intervalsSelectionChanged();

        public void indexSelectionChanged();

        public void timeSelectionChanged(boolean var1, boolean var2);
    }

    public static interface ValuesListener {
        public void valuesAdded();

        public void valuesReset();
    }
}

