/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.progress.module.DefaultHandleFactory;
import org.netbeans.progress.module.ProgressApiAccessor;
import org.openide.modules.PatchedPublic;
import org.openide.util.Cancellable;

public final class ProgressHandle
implements AutoCloseable {
    public static final String ACTION_VIEW = "performView";
    private static final Logger LOG = Logger.getLogger(ProgressHandle.class.getName());
    private InternalHandle internal;

    public static ProgressHandle createHandle(String string) {
        return ProgressHandle.createHandle(string, null);
    }

    public static ProgressHandle createHandle(String string, Cancellable cancellable) {
        return DefaultHandleFactory.get().createHandle(string, cancellable, true);
    }

    public static ProgressHandle createSystemHandle(String string, Cancellable cancellable) {
        return DefaultHandleFactory.get().createHandle(string, cancellable, false);
    }

    public static ProgressHandle createHandle(String string, Cancellable cancellable, Action action) {
        ProgressHandle progressHandle = DefaultHandleFactory.get().createHandle(string, cancellable, true);
        if (action != null) {
            progressHandle.addDefaultAction(action);
        }
        return progressHandle;
    }

    public static ProgressHandle createSystemHandle(String string, Cancellable cancellable, Action action) {
        ProgressHandle progressHandle = DefaultHandleFactory.get().createHandle(string, cancellable, false);
        if (action != null) {
            progressHandle.addDefaultAction(action);
        }
        return progressHandle;
    }

    ProgressHandle(InternalHandle internalHandle) {
        LOG.fine(internalHandle.getDisplayName());
        this.internal = internalHandle;
    }

    public final void start() {
        this.start(0, -1L);
    }

    public final void start(int n) {
        this.start(n, -1L);
    }

    public final void start(int n, long l) {
        this.internal.start("", n, l);
    }

    public final void switchToIndeterminate() {
        this.internal.toIndeterminate();
    }

    public final void suspend(String string) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.internal.getDisplayName(), string});
        }
        this.internal.toSilent(string);
    }

    public final void switchToDeterminate(int n) {
        this.internal.toDeterminate(n, -1L);
    }

    public final void switchToDeterminate(int n, long l) {
        this.internal.toDeterminate(n, l);
    }

    @Override
    public final void close() {
        this.finish();
    }

    public final void finish() {
        this.internal.finish();
    }

    public final void progress(int n) {
        this.progress(null, n);
    }

    public final void progress(String string) {
        this.progress(string, -2);
    }

    public final void progress(String string, int n) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.internal.getDisplayName(), string});
        }
        this.internal.progress(string, n);
    }

    public final void setInitialDelay(int n) {
        this.internal.setInitialDelay(n);
    }

    public final void setDisplayName(String string) {
        LOG.fine(string);
        this.internal.requestDisplayNameChange(string);
    }

    public final boolean addDefaultAction(Action action) {
        return this.internal.requestAction(ACTION_VIEW, action);
    }

    @PatchedPublic
    final InternalHandle getInternalHandle() {
        return this.internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDisplayName() {
        InternalHandle internalHandle = this.internal;
        synchronized (internalHandle) {
            return this.internal.getDisplayName();
        }
    }

    static {
        ProgressApiAccessor.setInstance(new Accessor());
    }

    static class Accessor
    extends ProgressApiAccessor {
        Accessor() {
        }

        @Override
        public ProgressHandle create(InternalHandle internalHandle) {
            return new ProgressHandle(internalHandle);
        }

        @Override
        public InternalHandle getInternalHandle(ProgressHandle progressHandle) {
            return progressHandle.getInternalHandle();
        }
    }
}

