/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.lang.ref.ReferenceQueue;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import org.openide.util.Lookup;
import org.openide.util.RE13;
import org.openide.util.TopologicalSortException;
import org.openide.util.lookup.implspi.ActiveQueue;

public abstract class BaseUtilities {
    private static final Logger LOG = Logger.getLogger(BaseUtilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    private static int operatingSystem = -1;
    private static final Object TRANS_LOCK = new Object();
    private static Object transLoader;
    private static RE transExp;
    private static volatile Boolean pathURIConsistent;

    private BaseUtilities() {
    }

    public static ReferenceQueue<Object> activeReferenceQueue() {
        return ActiveQueue.queue();
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(string) ? 1 : ("Windows 95".equals(string) ? 2 : ("Windows 98".equals(string) ? 4 : ("Windows 2000".equals(string) ? 8192 : ("Windows Vista".equals(string) ? 262144 : (string.startsWith("Windows ") ? 32768 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : (string.endsWith("Linux") ? 16 : ("HP-UX".equals(string) ? 32 : ("AIX".equals(string) ? 64 : ("Irix".equals(string) ? 128 : ("SunOS".equals(string) ? 256 : ("Digital UNIX".equals(string) ? 512 : ("OS/2".equals(string) ? 2048 : ("OpenVMS".equals(string) ? 16384 : (string.equals("Mac OS X") ? 4096 : (string.startsWith("Darwin") ? 4096 : (string.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : ("OpenBSD".equals(string) ? 0x100000 : (File.pathSeparatorChar == ':' ? 524288 : 65536))))))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (BaseUtilities.getOperatingSystem() & 0x4A007) != 0;
    }

    public static boolean isMac() {
        return (BaseUtilities.getOperatingSystem() & 0x1000) != 0;
    }

    public static boolean isUnix() {
        return (BaseUtilities.getOperatingSystem() & 0x1A13F8) != 0;
    }

    static void resetOperatingSystem() {
        operatingSystem = -1;
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        return SourceVersion.isIdentifier(string) && !SourceVersion.isKeyword(string);
    }

    public static String[] wrapStringToArray(String string, int n, BreakIterator breakIterator, boolean bl) {
        int n2;
        int n3;
        String[] stringArray;
        block14: {
            if (string.length() == 0) {
                return new String[]{string};
            }
            if (bl) {
                string = BaseUtilities.trimString(string);
                string = string.replace('\n', ' ');
                stringArray = new String[]{string};
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                n3 = stringTokenizer.countTokens();
                stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    stringArray[n2] = stringTokenizer.nextToken();
                }
            }
            if (n < 1) {
                n = 1;
            }
            if (string.length() <= n) {
                return stringArray;
            }
            boolean bl2 = true;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                boolean bl3 = bl2 = bl2 && stringArray[n3].length() < n;
                if (bl2) {
                    continue;
                }
                break block14;
            }
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].length() < n) {
                arrayList.add(stringArray[n2]);
                continue;
            }
            breakIterator.setText(stringArray[n2]);
            int n4 = breakIterator.next();
            int n5 = 0;
            while (true) {
                if (n4 - n3 < n && n4 != -1) {
                    n5 = n4;
                    n4 = breakIterator.next();
                    continue;
                }
                if (n4 == -1) {
                    n4 = n5 = stringArray[n2].length();
                }
                if (n5 == 0) {
                    n5 = n4;
                }
                arrayList.add(stringArray[n2].substring(n3, n5));
                n3 = n5;
                n5 = 0;
                if (n3 >= stringArray[n2].length()) break;
            }
            n3 = 0;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    public static String wrapString(String string, int n, BreakIterator breakIterator, boolean bl) {
        String[] stringArray = BaseUtilities.wrapStringToArray(string, n, breakIterator, bl);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String pureClassName(String string) {
        int n = string.indexOf(36);
        if (n >= 0 && n < string.length()) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static boolean compareObjects(Object object, Object object2) {
        return BaseUtilities.compareObjectsImpl(object, object2, 1);
    }

    public static boolean compareObjectsImpl(Object object, Object object2, int n) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (n > 0) {
            if (object instanceof Object[] && object2 instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = objectArray.length;
                Object[] objectArray2 = (Object[])object2;
                int n3 = objectArray2.length;
                if (n2 != n3) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    if (BaseUtilities.compareObjectsImpl(objectArray[i], objectArray2[i], n - 1)) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof byte[] && object2 instanceof byte[]) {
                byte[] byArray = (byte[])object;
                int n4 = byArray.length;
                byte[] byArray2 = (byte[])object2;
                int n5 = byArray2.length;
                if (n4 != n5) {
                    return false;
                }
                for (int i = 0; i < n4; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof short[] && object2 instanceof short[]) {
                short[] sArray = (short[])object;
                int n6 = sArray.length;
                short[] sArray2 = (short[])object2;
                int n7 = sArray2.length;
                if (n6 != n7) {
                    return false;
                }
                for (int i = 0; i < n6; ++i) {
                    if (sArray[i] == sArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof int[] && object2 instanceof int[]) {
                int[] nArray = (int[])object;
                int n8 = nArray.length;
                int[] nArray2 = (int[])object2;
                int n9 = nArray2.length;
                if (n8 != n9) {
                    return false;
                }
                for (int i = 0; i < n8; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof long[] && object2 instanceof long[]) {
                long[] lArray = (long[])object;
                int n10 = lArray.length;
                long[] lArray2 = (long[])object2;
                int n11 = lArray2.length;
                if (n10 != n11) {
                    return false;
                }
                for (int i = 0; i < n10; ++i) {
                    if (lArray[i] == lArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof float[] && object2 instanceof float[]) {
                float[] fArray = (float[])object;
                int n12 = fArray.length;
                float[] fArray2 = (float[])object2;
                int n13 = fArray2.length;
                if (n12 != n13) {
                    return false;
                }
                for (int i = 0; i < n12; ++i) {
                    if (fArray[i] == fArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof double[] && object2 instanceof double[]) {
                double[] dArray = (double[])object;
                int n14 = dArray.length;
                double[] dArray2 = (double[])object2;
                int n15 = dArray2.length;
                if (n14 != n15) {
                    return false;
                }
                for (int i = 0; i < n14; ++i) {
                    if (dArray[i] == dArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof char[] && object2 instanceof char[]) {
                char[] cArray = (char[])object;
                int n16 = cArray.length;
                char[] cArray2 = (char[])object2;
                int n17 = cArray2.length;
                if (n16 != n17) {
                    return false;
                }
                for (int i = 0; i < n16; ++i) {
                    if (cArray[i] == cArray2[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof boolean[] && object2 instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n18 = blArray.length;
                boolean[] blArray2 = (boolean[])object2;
                int n19 = blArray2.length;
                if (n18 != n19) {
                    return false;
                }
                for (int i = 0; i < n18; ++i) {
                    if (blArray[i] == blArray2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return object.equals(object2);
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return BaseUtilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return BaseUtilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName().replace('$', '.');
        return string.substring(string.lastIndexOf(46) + 1, string.length());
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        if (objectArray instanceof Integer[]) {
            int[] nArray = new int[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                nArray[i] = (Integer)objectArray[i] == null ? 0 : (Integer)objectArray[i];
            }
            return nArray;
        }
        if (objectArray instanceof Boolean[]) {
            boolean[] blArray = new boolean[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                blArray[i] = (Boolean)objectArray[i] == null ? false : (Boolean)objectArray[i];
            }
            return blArray;
        }
        if (objectArray instanceof Byte[]) {
            byte[] byArray = new byte[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                byArray[i] = (Byte)objectArray[i] == null ? (byte)0 : (Byte)objectArray[i];
            }
            return byArray;
        }
        if (objectArray instanceof Character[]) {
            char[] cArray = new char[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                cArray[i] = (Character)objectArray[i] == null ? (char)'\u0000' : ((Character)objectArray[i]).charValue();
            }
            return cArray;
        }
        if (objectArray instanceof Double[]) {
            double[] dArray = new double[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                dArray[i] = (Double)objectArray[i] == null ? 0.0 : (Double)objectArray[i];
            }
            return dArray;
        }
        if (objectArray instanceof Float[]) {
            float[] fArray = new float[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                fArray[i] = (Float)objectArray[i] == null ? 0.0f : ((Float)objectArray[i]).floatValue();
            }
            return fArray;
        }
        if (objectArray instanceof Long[]) {
            long[] lArray = new long[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                lArray[i] = (Long)objectArray[i] == null ? 0L : (Long)objectArray[i];
            }
            return lArray;
        }
        if (objectArray instanceof Short[]) {
            short[] sArray = new short[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                sArray[i] = (Short)objectArray[i] == null ? (short)0 : (Short)objectArray[i];
            }
            return sArray;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof int[]) {
            int n = ((int[])object).length;
            Object[] objectArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((int[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof boolean[]) {
            int n = ((boolean[])object).length;
            Object[] objectArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((boolean[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof byte[]) {
            int n = ((byte[])object).length;
            Object[] objectArray = new Byte[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((byte[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof char[]) {
            int n = ((char[])object).length;
            Object[] objectArray = new Character[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Character.valueOf(((char[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof double[]) {
            int n = ((double[])object).length;
            Object[] objectArray = new Double[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((double[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof float[]) {
            int n = ((float[])object).length;
            Object[] objectArray = new Float[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Float.valueOf(((float[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof long[]) {
            int n = ((long[])object).length;
            Object[] objectArray = new Long[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((long[])object)[i];
            }
            return objectArray;
        }
        if (object instanceof short[]) {
            int n = ((short[])object).length;
            Object[] objectArray = new Short[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((short[])object)[i];
            }
            return objectArray;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getObjectType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getPrimitiveType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static String[] parseParameters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n2 = string.length();
        block18: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            n = 3;
                            continue block18;
                        }
                        case '\"': {
                            n = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c)) continue block18;
                    stringBuilder.append(c);
                    n = 1;
                    continue block18;
                }
                case 3: {
                    if (c != '\'') {
                        stringBuilder.append(c);
                        continue block18;
                    }
                    n = 1;
                    continue block18;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            char c2;
                            char c3 = c2 = i < n2 - 1 ? string.charAt(i + 1) : (char)'\u0000';
                            if (c2 == '\"' || c2 == '\\') {
                                stringBuilder.append(c2);
                                ++i;
                                continue block18;
                            }
                            stringBuilder.append(c);
                            continue block18;
                        }
                        case '\"': {
                            n = 1;
                            continue block18;
                        }
                    }
                    stringBuilder.append(c);
                    continue block18;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            n = 3;
                            continue block18;
                        }
                        case '\"': {
                            n = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        n = 0;
                        continue block18;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String escapeParameters(String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            BaseUtilities.escapeString(stringArray[n], stringBuffer);
            stringBuffer.append(' ');
        }
        n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString().trim();
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        if (string.length() == 0) {
            stringBuffer.append("\"\"");
            return;
        }
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                bl = true;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\') {
                stringBuffer.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.insert(n, '\"');
            stringBuffer.append('\"');
        }
    }

    public static <T> List<T> topologicalSort(Collection<? extends T> collection, Map<? super T, ? extends Collection<? extends T>> map) throws TopologicalSortException {
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList(Math.max(collection.size(), 1));
        ArrayList<T> arrayList2 = new ArrayList<T>(collection);
        Collections.reverse(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            List<? super T> list = BaseUtilities.visit(iterator.next(), map, hashMap, arrayList);
            if (list == null) continue;
            throw new TopologicalSortException(arrayList2, map);
        }
        Collections.reverse(arrayList);
        if (arrayList.size() != collection.size()) {
            arrayList.retainAll(collection);
        }
        return arrayList;
    }

    static <T> List<T> visit(T t, Map<? super T, ? extends Collection<? extends T>> map, Map<T, Boolean> map2, List<T> list) {
        Boolean bl = map2.get(t);
        if (bl != null) {
            if (bl.booleanValue()) {
                return null;
            }
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(t);
            map2.put(t, null);
            return arrayList;
        }
        Collection<T> collection = map.get(t);
        if (collection != null) {
            map2.put(t, Boolean.FALSE);
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                List<T> list2 = BaseUtilities.visit(iterator.next(), map, map2, list);
                if (list2 == null) continue;
                if (list2 instanceof ArrayList) {
                    if (Boolean.FALSE == map2.get(t)) {
                        list2.add(t);
                    } else {
                        Collections.reverse(list2);
                        list2 = Collections.unmodifiableList(list2);
                    }
                }
                map2.put(t, Boolean.TRUE);
                return list2;
            }
        }
        map2.put(t, Boolean.TRUE);
        list.add(t);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String string) {
        RE rE;
        BaseUtilities.checkMapping();
        Object object = TRANS_LOCK;
        synchronized (object) {
            rE = transExp;
        }
        if (rE == null) {
            return string;
        }
        object = rE;
        synchronized (object) {
            return rE.convert(string);
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == classLoader) {
            return;
        }
        BaseUtilities.initForLoader(classLoader, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initForLoader(ClassLoader classLoader, Object object) {
        Object object2;
        String[] stringArray;
        Enumeration<URL> enumeration;
        if (object == null) {
            object = TRANS_LOCK;
        }
        try {
            enumeration = classLoader.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            enumeration = null;
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            Object object3 = TRANS_LOCK;
            synchronized (object3) {
                transLoader = object;
                transExp = null;
            }
            return;
        }
        RE13 rE13 = null;
        rE13 = new RE13();
        TreeSet<String[]> treeSet = new TreeSet<String[]>(new Comparator<String[]>(){

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                int n;
                String string = stringArray[0];
                String string2 = stringArray2[0];
                int n2 = string.length();
                if (n2 != (n = string2.length())) {
                    return n - n2;
                }
                return string2.compareTo(string);
            }
        });
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            try {
                object2 = new BufferedReader(new InputStreamReader(stringArray.openStream(), "UTF8"));
                BaseUtilities.loadTranslationFile(rE13, (BufferedReader)object2, treeSet);
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Problematic file: {0}", (Object)stringArray);
                LOG.log(Level.WARNING, null, iOException);
            }
        }
        stringArray = new String[treeSet.size()];
        object2 = new String[stringArray.length];
        int n = 0;
        for (String[] stringArray2 : treeSet) {
            stringArray[n] = stringArray2[1].intern();
            object2[n] = stringArray2[0];
            ++n;
        }
        Object object4 = TRANS_LOCK;
        synchronized (object4) {
            if (stringArray.length == 0) {
                transExp = null;
            } else {
                transExp = rE13;
                transExp.init((String[])object2, stringArray);
            }
            transLoader = object;
        }
    }

    private static void loadTranslationFile(RE rE, BufferedReader bufferedReader, Set<String[]> set) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#")) continue;
            String[] stringArray = rE.readPair(string);
            if (stringArray == null) {
                throw new InvalidObjectException("Line is invalid: " + string);
            }
            set.add(stringArray);
        }
    }

    public static URI toURI(File file) {
        URI uRI;
        if (BaseUtilities.pathToURISupported()) {
            try {
                uRI = file.toPath().toUri();
            }
            catch (InvalidPathException invalidPathException) {
                uRI = file.toURI();
                LOG.log(Level.FINE, "can't convert " + file + " falling back to " + uRI, invalidPathException);
            }
        } else {
            uRI = file.toURI();
        }
        if (uRI.toString().startsWith("file:///")) {
            try {
                return new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.log(Level.FINE, "could not convert " + file + " to URI", uRISyntaxException);
            }
        }
        return uRI;
    }

    public static File toFile(URI uRI) throws IllegalArgumentException {
        try {
            return Paths.get(uRI).toFile();
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "could not convert " + uRI + " to File", exception);
            String string = uRI.getHost();
            if (string != null && !string.isEmpty() && "file".equals(uRI.getScheme())) {
                return new File("\\\\" + string + uRI.getPath().replace('/', '\\'));
            }
            return new File(uRI);
        }
    }

    private static boolean pathToURISupported() {
        Boolean bl = pathURIConsistent;
        if (bl == null) {
            boolean bl2;
            try {
                File file = new File("k\u00fc\u00f1");
                bl2 = file.toPath().toUri().equals(file.toURI());
            }
            catch (InvalidPathException invalidPathException) {
                bl2 = false;
            }
            if (!bl2) {
                LOG.fine("The java.nio.file.Path.toUri is inconsistent with java.io.File.toURI");
            }
            bl = pathURIConsistent = Boolean.valueOf(bl2);
        }
        return bl;
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }
}

