/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;

public final class DockModeAction
extends AbstractAction {
    private final ModeImpl mode;
    private ModeImpl slidingMode;

    public DockModeAction() {
        this.mode = null;
        this.putValue("Name", NbBundle.getMessage(DockModeAction.class, (String)"CTL_UndockModeAction_Dock"));
    }

    public DockModeAction(ModeImpl modeImpl, ModeImpl modeImpl2) {
        this.mode = modeImpl;
        this.slidingMode = modeImpl2;
        this.putValue("Name", NbBundle.getMessage(DockModeAction.class, (String)"CTL_UndockModeAction_Dock"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = this.getMode2WorkWith();
        if (null == modeImpl) {
            return;
        }
        if (null != this.slidingMode) {
            WindowManagerImpl.getInstance().userRestoredMode(this.slidingMode, modeImpl);
        } else {
            boolean bl;
            boolean bl2 = bl = modeImpl.getState() == 0;
            if (!bl) {
                windowManagerImpl.userDockedMode(modeImpl);
            }
        }
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("DockModeAction", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("DockModeAction");
        }
        return super.getValue(string);
    }

    @Override
    public boolean isEnabled() {
        boolean bl;
        ModeImpl modeImpl = this.getMode2WorkWith();
        if (null == modeImpl) {
            return false;
        }
        if (null != this.slidingMode) {
            return true;
        }
        boolean bl2 = bl = modeImpl.getState() == 0;
        if (bl) {
            return false;
        }
        if (modeImpl.getKind() == 1) {
            return Switches.isEditorModeUndockingEnabled();
        }
        return modeImpl.getKind() == 0 && Switches.isViewModeUndockingEnabled();
    }

    private ModeImpl getMode2WorkWith() {
        if (this.mode != null) {
            return this.mode;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        return (ModeImpl)windowManagerImpl.findMode(windowManagerImpl.getRegistry().getActivated());
    }
}

