/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiFileLoader;

@SupportedAnnotationTypes(value={"org.openide.loaders.DataObject.Registration", "org.openide.loaders.DataObject.Registrations"})
public class DataObjectFactoryProcessor
extends LayerGeneratingProcessor {
    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(DataObject.Registration.class)) {
            annotation = element.getAnnotation(DataObject.Registration.class);
            if (annotation == null) continue;
            this.process(element, (DataObject.Registration)annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(DataObject.Registrations.class)) {
            annotation = element.getAnnotation(DataObject.Registrations.class);
            if (annotation == null) continue;
            for (DataObject.Registration registration : annotation.value()) {
                this.process(element, registration);
            }
        }
        return true;
    }

    private void process(Element element, DataObject.Registration registration) throws LayerGenerationException {
        Object object;
        TypeMirror typeMirror = this.type(DataObject.class);
        TypeMirror typeMirror2 = this.type(FileObject.class);
        TypeMirror typeMirror3 = this.type(MultiFileLoader.class);
        TypeMirror typeMirror4 = this.type(DataObject.Factory.class);
        LayerBuilder layerBuilder = this.layer(new Element[]{element});
        String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
        String string2 = string.replace(".", "-");
        boolean bl = true;
        if (this.isAssignable(element.asType(), typeMirror)) {
            object = new LinkedList();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                if (executableElement.getKind() != ElementKind.CONSTRUCTOR || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getParameters().size() != 2 || !this.isAssignable(executableElement.getParameters().get(0).asType(), typeMirror2) || !this.isAssignable(executableElement.getParameters().get(1).asType(), typeMirror3)) continue;
                object.add(executableElement);
            }
            if (object.isEmpty()) {
                throw new LayerGenerationException("DataObject subclass with @DataObject.Registration needs a public constructor with FileObject and MultiFileLoader parameters", element, this.processingEnv, (Annotation)registration);
            }
            bl = true;
        } else if (this.isAssignable(element.asType(), typeMirror4)) {
            object = new LinkedList();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                if (executableElement.getKind() != ElementKind.CONSTRUCTOR || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty()) continue;
                object.add(executableElement);
            }
            if (object.isEmpty()) {
                throw new LayerGenerationException("DataObject.Factory subclass with @DataObject.Registration needs a public default constructor", element, this.processingEnv, (Annotation)registration);
            }
            bl = false;
            string2 = string.replace(".class", "").replace(".", "-");
        } else {
            throw new LayerGenerationException("Usage @DataObject.Registration only on DataObject.Factory subclass or DataObject subclass", element, this.processingEnv, (Annotation)registration);
        }
        if (registration.mimeType() == null) {
            throw new LayerGenerationException("@DataObject.Factory.Registration mimeType() cannot be null", element, this.processingEnv, (Annotation)registration, "mimeTypes");
        }
        object = registration.mimeType();
        LayerBuilder.File file = layerBuilder.file("Loaders/" + (String)object + "/Factories/" + string2 + ".instance");
        if (registration.iconBase().length() > 0) {
            layerBuilder.validateResource(registration.iconBase(), element.getEnclosingElement(), (Annotation)registration, "iconBase", true);
            file.stringvalue("iconBase", registration.iconBase());
        }
        file.position(registration.position());
        if (!registration.displayName().isEmpty()) {
            file.bundlevalue("displayName", registration.displayName(), (Annotation)registration, "displayName");
        }
        if (bl) {
            file.methodvalue("instanceCreate", "org.openide.loaders.DataLoaderPool", "factory");
            file.stringvalue("dataObjectClass", string);
            file.stringvalue("mimeType", (String)object);
        }
        file.write();
    }

    private TypeMirror type(Class<?> clazz) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(clazz.getCanonicalName());
        return typeElement == null ? null : typeElement.asType();
    }

    private boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror2 == null) {
            return false;
        }
        return this.processingEnv.getTypeUtils().isAssignable(typeMirror, typeMirror2);
    }
}

